/*  Higlight code	
*  Copyright (C) 1999 by:
* Mikael Hermansson <mikeh@bahnhof.se>
* some changes is written by Chris Phelps <reninet.com>
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef WIN32
#include <windows.h>
#endif
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextext.h>
#include "gtksourceeditor.h"

#define BUGGY_DELETE
#define EXTRA_PARSE 100
#define GENEROUS_PARSE 1
static GtkWidgetClass *parent_class = NULL;

static void property_mark(GtkExText *text,GtkExTextProperty *prop);
gint property_text_remove(GtkExText *text,GtkExTextProperty *prop,gint start,gint end);
gint property_text_insert(GtkExText *text,GtkExTextProperty *prop,gint start,gint end);

static void gtk_extext_highlight_class_init(GtkExTextHighlightClass *_class);
static void gtk_extext_highlight_init(GtkExTextHighlight *_class);

void check_pattern(GtkExText *text,gint start,gint end,GtkExTextProperty *prev);
gint get_syntax_end(GtkExText *text,gint pos,Regex *reg,GtkExTextMatch *m);
void check_syntax(GtkExText *text,gint i,gint end);
void check_brackets(GtkWidget *text,gint i);
gboolean find_bracket_match(GtkWidget *widget, gint *search);

gboolean gtk_extext_highlight_compile_regex (const gchar *pattern, Regex *regex)
{
  memset (&regex->buf, 0, sizeof(regex->buf));
  regex->buf.translate = NULL;
  regex->buf.fastmap = g_malloc (256);
  regex->buf.allocated = 0;
  regex->buf.buffer = NULL;
  regex->buf.can_be_null = 0;	/* so we wont allow that in patterns! */
  regex->buf.no_sub = 0;
  if (re_compile_pattern (pattern, strlen (pattern), &regex->buf) == 0) {
    /* success...now try to compile a fastmap */
    if ( re_compile_fastmap (&regex->buf) != 0 ) {
    g_warning("IMPORTANT REGEX FAILED TO CREASTE FASTMAP\n");
      /* error...no fastmap */
      g_free (regex->buf.fastmap);
      regex->buf.fastmap = NULL;
    }
    return TRUE;
  } else {
    g_warning("IMPORTANT REGEX FAILED TO COMPILE\n");
    return FALSE;
  }
}

void property_mark(GtkExText *text,GtkExTextProperty *prop)
{
  if(!prop)
    return ;

  /*g_print("property %s start %d end %d\n",prop->style->key,prop->startpos,prop->endpos);*/
}

gint property_text_remove(GtkExText *text,GtkExTextProperty *prop,gint start,gint end)
{
  GtkExTextProperty *propn;
   GtkExTextLineData *linedataptr;
   gint diff, e;
  g_return_val_if_fail (text != NULL,TRUE);
  g_return_val_if_fail (GTK_IS_EXTEXT_HIGHLIGHT (text),TRUE);
   if(!GTK_EXTEXT_HIGHLIGHT(text)->highlight) return FALSE;

  if(prop && prop->startpos > start)
    g_warning("[property_text_remove]BUGG in gtkextext property is bigger that it should\n");

   if(end > text->length)
   {
      gtk_extext_property_remove_all(text, text->length, end, NULL);
      end=text->length;
   }  
   diff = end - start;
   e = end;
   /* If the whole text chunk was inside a highlight, parse from prop->start to prop->end */
   if((propn = gtk_extext_property_get_at_pos(text, start, prop)) && ((gint)propn->startpos <= start) && ((gint)(propn->endpos-diff) > start))
   {
      start = propn->startpos;
      end = propn->endpos-diff > end ? propn->endpos-diff : end;
   }
   /* If the text chunk was after a SYNTAX_TABLE, parse from prop->start to line->end */
   else if((propn = gtk_extext_property_nearest_backward(text, start, prop)) && GPOINTER_TO_INT(propn->user_data) == SYNTAX_TABLE)
   {
      start = propn->startpos;
      linedataptr = gtk_extext_get_line_by_char_pos(text, end,NULL);
      end = linedataptr && linedataptr->endpos > end ? linedataptr->endpos : end;
      g_free(linedataptr);
   }
   /* Else, parse from line1->start to line2->end*/
   else
   {
      linedataptr = gtk_extext_get_line_by_char_pos(text, start,NULL);
      start = linedataptr && linedataptr->startpos < start ? linedataptr->startpos : start;
      linedataptr = gtk_extext_get_line_by_char_pos(text, end,linedataptr);
      end = linedataptr && linedataptr->endpos > end ? linedataptr->endpos : end;
      if(!linedataptr) g_warning("nolinedata found??\n"); else g_free(linedataptr);
   }
   gtk_extext_property_move_all(text, e, -diff, prop);
   gtk_extext_property_remove_all(text, start, end, prop);
   check_syntax(text, start, end);
   return(TRUE);
}

/* this new code is directly ported from Codecommander */

gint property_text_insert(GtkExText *text,GtkExTextProperty *prop,gint start,gint end)
{
  GtkExTextProperty *propn;
   gint diff, s;
   GtkExTextLineData *linedataptr;
   g_return_val_if_fail (text != NULL,TRUE);
   g_return_val_if_fail (GTK_IS_EXTEXT_HIGHLIGHT (text),TRUE);
   if(!GTK_EXTEXT_HIGHLIGHT(text)->highlight)    return FALSE;	


  if(prop && prop->startpos > start)
    g_warning("[property_text_insert]BUGG in gtkextext property is bigger that it should\n");

   s = start;
   diff = end - start;
   if((propn = gtk_extext_property_get_at_pos(text, start, prop)) && ((gint)propn->startpos < start) && ((gint)(propn->endpos+diff) >= end))
   {
      start = propn->startpos;
      end = propn->endpos+diff < text->length ? propn->endpos+diff : text->length;
   }
   else if((propn = gtk_extext_property_nearest_backward(text, start, prop)) && GPOINTER_TO_INT(propn->user_data) == SYNTAX_TABLE)
   {
      start = propn->startpos;
      linedataptr = gtk_extext_get_line_by_char_pos(text, end,NULL);
      end = linedataptr && linedataptr->endpos > end ? linedataptr->endpos : end;
       if(!linedataptr)
          g_warning("line not found3\n");
       else
         g_free(linedataptr);
   }
   else
   {
      linedataptr = gtk_extext_get_line_by_char_pos(text, start,NULL);
       if(!linedataptr)
          g_warning("line not found1\n");

      start = linedataptr && linedataptr->startpos < start ? linedataptr->startpos : start;
      if(gtk_extext_get_line_by_char_pos(text, end,linedataptr)!=linedataptr)
            g_warning("what??????????????");                

      end = linedataptr && linedataptr->endpos > end ? linedataptr->endpos : end;
       if(!linedataptr)
          g_warning("line not found2\n");
       else
         g_free(linedataptr);
   }
   gtk_extext_property_move_all(text, s, diff, prop);
   gtk_extext_property_remove_all(text, start, end, prop);
   check_syntax(text, start, end);
   return(TRUE);

}


/* we need to optimize this crap its very slow */
/* if the start and endpos is to big */

void 
check_syntax(GtkExText *text,gint start,gint end)
{
  gint s,i,z;
  gboolean found=FALSE;
  GList *list;
  GtkExTextMatch m;
  GtkExTextProperty *prev;
  GtkExTextHighlightTable *table;
  GtkExTextHighlightSyntaxEntry *sentry;

  table=GTK_EXTEXT_HIGHLIGHT(text)->syntax_table;
  if(!table)
    return;
  
  list=g_list_first(table->entries);
  i=start;
  prev=text->scroll_line_start->property_first;

  if(end>text->length)  {
    g_warning("THIS IS BUGGY check_syntax end [%d] is more than text->length [%d]\n",end,text->length);
    end=text->length;
  }

/*	g_print("rehiglight from %d to %d\n",start,end);*/
  while(i < end)
  {
    s=gtk_extext_regex_search(text,i,&table->regex_all,TRUE,&m);
    if(s < 0 ||  s > end)	break ;

    if(i < s )	check_pattern(text,i,s,prev);

    i=m.endpos;
    list=g_list_first(table->entries);
    while(list)
    {    
      sentry=(GtkExTextHighlightSyntaxEntry *)list->data;
//      if(gtk_extext_regex_match(text,s,&sentry->regex_start)  > 0 && GTK_EXTEXT_INDEX(text, s-1) != '\\')
      if(gtk_extext_regex_match(text,s,&sentry->regex_start)  > 0 && GTK_EXTEXT_INDEX(text, s) != '\\')
      {
	    if((z = get_syntax_end(text,i,&sentry->regex_end,&m)) >= 0 )
		  i=m.endpos;			
        else if(z == 0) continue;
        else  i=text->length;
			
        prev=gtk_extext_property_insert(text,sentry->key,s,i,GINT_TO_POINTER(SYNTAX_TABLE),PROPERTY_REMOVEALL,prev);
          
        found=TRUE;
        break;
      }
      else if(GTK_EXTEXT_INDEX(text, s-1) == '\\') found = TRUE;

      list=g_list_next(list);
    };
    if(!found)  i++;
  };
  if(i < end) check_pattern(text,i,end,prev);

}

void 
check_pattern(GtkExText *text,gint start,gint end,    GtkExTextProperty *prev)
{
  gint i;
  gint pos=0; /* to make sure it realy IS initiated */
  gboolean found=FALSE;
  GList *list;
  GtkExTextHighlightTable *table;
  GtkExTextHighlightPatternEntry *pentry;

  table=GTK_EXTEXT_HIGHLIGHT(text)->pattern_table;
  if(!table)
    return;
  
  list=g_list_first(table->entries);
  
  if(end>text->length)  {
    g_warning("THIS IS BUGGY end [%d] is more than text->length [%d]\n",end,text->length);
    end=text->length;
  }

  prev=NULL;
  i=start;
  while(i < end)
  {
    list=g_list_first(table->entries);
    found=FALSE;
    while(list) {
      pentry=(GtkExTextHighlightPatternEntry *)list->data;      
      if((pos=gtk_extext_regex_match(text,i,&pentry->regex) ) > 0 && end >= i + pos)
      {
        prev=gtk_extext_property_insert(text,pentry->key,
						i,pos+i,GINT_TO_POINTER(PATTERN_TABLE),PROPERTY_INSERT,prev);

   	i+=pos;
        found=TRUE;
        break;
      }
      list=g_list_next(list);
    };
    if(!found)
        i++;
  };  
  gtk_widget_queue_draw(GTK_WIDGET(text));
}

gint 
get_syntax_end(GtkExText *text,gint pos,Regex *reg,GtkExTextMatch *m)
{
  int ret;
  do  {
    ret=gtk_extext_regex_search(text,m->endpos,reg,TRUE,m);
    if(ret < 0)
      return -1;
    } while(m->endpos && GTK_EXTEXT_INDEX(text, m->endpos-2) == '\\' );

  return ret;
}

GtkWidget * gtk_extext_highlight_new()
{
	GtkWidget *text;

	  text = gtk_widget_new (GTK_TYPE_EXTEXT_HIGHLIGHT,NULL);


	return text;
}

static void 
gtk_extext_highlight_class_init(GtkExTextHighlightClass *_class)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkExTextClass *extext_class;
  
  object_class = (GtkObjectClass*) _class;
  widget_class = (GtkWidgetClass*) _class;
  extext_class = (GtkExTextClass*) _class;
  parent_class = gtk_type_class (GTK_TYPE_EXTEXT);
}

static void 
gtk_extext_highlight_init(GtkExTextHighlight *text)
{
  text->check_brackets=FALSE;
  text->highlight=FALSE;
  text->syntax_table=NULL;
  text->pattern_table=NULL;

  gtk_signal_connect(GTK_OBJECT(text),"move_to_column", 
      				GTK_SIGNAL_FUNC(check_brackets),NULL);	
  gtk_signal_connect(GTK_OBJECT(text),"move_to_row", 
      				GTK_SIGNAL_FUNC(check_brackets),NULL);	

  gtk_signal_connect(GTK_OBJECT(text),"property_text_remove", 
      				GTK_SIGNAL_FUNC(property_text_remove),NULL);	
  gtk_signal_connect(GTK_OBJECT(text),"property_text_insert",
						GTK_SIGNAL_FUNC(property_text_insert),NULL);	

  gtk_signal_connect(GTK_OBJECT(text),"property_mark",
						GTK_SIGNAL_FUNC(property_mark),NULL);	
}

void
gtk_extext_highlight_set_check_brackets(GtkExTextHighlight *text,gboolean set)
{
  g_return_if_fail (text != NULL);
  g_return_if_fail (GTK_IS_EXTEXT_HIGHLIGHT (text));

  text->check_brackets=set;
}

void
gtk_extext_highlight_set(GtkExTextHighlight *text,gboolean set)
{
  g_return_if_fail (text != NULL);
  g_return_if_fail (GTK_IS_EXTEXT_HIGHLIGHT (text));
  
  text->highlight=set;
  if(text->highlight)  {
    gtk_extext_property_remove_all(GTK_EXTEXT(text),0,GTK_EXTEXT(text)->length,NULL);
    property_text_insert(GTK_EXTEXT(text),NULL,0,GTK_EXTEXT(text)->length);
  }
  else
    gtk_extext_property_remove_all(GTK_EXTEXT(text),0,GTK_EXTEXT(text)->length,NULL);

  gtk_widget_queue_draw(GTK_WIDGET(text));
}

GtkType 
gtk_extext_highlight_get_type(void)
{
	static GtkType extext_highlight_type=0;

	if(!extext_highlight_type)
	{
		static const GtkTypeInfo extext_highlight_info=	
		{	
			"GtkExTextHighlight",
			sizeof(GtkExTextHighlight),
			sizeof(GtkExTextHighlightClass),
			(GtkClassInitFunc) gtk_extext_highlight_class_init,
			(GtkObjectInitFunc) gtk_extext_highlight_init,
			NULL,
			NULL,
			(GtkClassInitFunc)NULL,
		};
		extext_highlight_type=gtk_type_unique(GTK_TYPE_EXTEXT,&extext_highlight_info);
	}
	return extext_highlight_type;
}

void 
gtk_extext_highlight_install_table(GtkExTextHighlight *text,GtkExTextHighlightTable *table)
{
  GList *cur;
  GtkExTextHighlightPatternEntry *pentry;
  GtkExTextHighlightSyntaxEntry *sentry;

  g_return_if_fail(text!=NULL);
  g_return_if_fail(GTK_IS_EXTEXT_HIGHLIGHT(text));
  g_return_if_fail(table!=NULL);
  
  if(table->type==SYNTAX_TABLE)  {
    text->syntax_table=table;
    cur=g_list_first(table->entries);
    while(cur)  {
      sentry=(GtkExTextHighlightSyntaxEntry*)cur->data;
      gtk_extext_style_insert(GTK_EXTEXT(text),sentry->key,
                                                sentry->font,sentry->fg_color,
                                              sentry->bg_color,0);
      cur=g_list_next(cur);
    };
  }
  else if(table->type==PATTERN_TABLE)  {
    text->pattern_table=table;
    cur=g_list_first(table->entries);
    while(cur)  {
      pentry=(GtkExTextHighlightPatternEntry*)cur->data;
      gtk_extext_style_insert(GTK_EXTEXT(text),pentry->key,
                                                pentry->font,pentry->fg_color,
                                              pentry->bg_color,0);
      cur=g_list_next(cur);
    };
  }
  else
    g_warning("Table could not be inserted????\n");

      
}

GtkExTextHighlightTable *
gtk_extext_highlight_syntax_table_new(GList *entries)
{
  gchar *regs;
  GList *cur;
  GtkExTextHighlightTable *table;
  GtkExTextHighlightSyntaxEntry *syntax;

  g_return_val_if_fail(entries!=NULL,NULL);
  g_return_val_if_fail(g_list_length(entries),NULL);

  table=g_malloc0(sizeof(GtkExTextHighlightTable));  
  table->type=SYNTAX_TABLE;    
  table->entries=entries;

  /* initiate regex with valeu */ 

  regs=g_malloc0(1024);
  cur=g_list_first(entries);   
  while(cur)   {
    syntax=(GtkExTextHighlightSyntaxEntry *)cur->data;
    strcat(regs,syntax->start);
    
    cur=g_list_next(cur);
    if(cur)
      strcat(regs,"\\|");    
  };
        
  gtk_extext_highlight_compile_regex(regs,&table->regex_all);

  g_free(regs);

  return table;   
}

GtkExTextHighlightTable *
gtk_extext_highlight_pattern_table_new(GList *entries)
{
  GtkExTextHighlightTable *table;

  g_return_val_if_fail(entries!=NULL,NULL);
  g_return_val_if_fail(g_list_length(entries),NULL);

  table=g_malloc0(sizeof(GtkExTextHighlightTable));  
  table->type=PATTERN_TABLE;    
  table->entries=entries;

  /* initiate table->regex with valeu */    
  

  return table;   
}

GList *
gtk_extext_highlight_syntax_entry_new(GList *entries,gchar *name,gchar *start,gchar *end,GdkFont *font,GdkColor *fg,GdkColor*bg)
{
  GtkExTextHighlightSyntaxEntry *syntax;

  syntax=g_malloc0(sizeof(GtkExTextHighlightSyntaxEntry));
  syntax->start=g_strdup(start);
  strncpy(syntax->key,name,32);  
  syntax->font=font;
  syntax->bg_color=bg;
  syntax->fg_color=fg;

  gtk_extext_highlight_compile_regex(start,&syntax->regex_start);
  gtk_extext_highlight_compile_regex(end,&syntax->regex_end);

  return g_list_append(entries,syntax);   
}

GList *
gtk_extext_highlight_pattern_entry_new(GList *entries,gchar *name,gchar *start,GdkFont *font, GdkColor *fg,GdkColor*bg)
{
  GtkExTextHighlightPatternEntry *pattern;

  pattern=g_malloc0(sizeof(GtkExTextHighlightPatternEntry));
  strncpy(pattern->key,name,32);  
  pattern->font=font;
  pattern->bg_color=bg;
  pattern->fg_color=fg;

  gtk_extext_highlight_compile_regex(start,&pattern->regex);

  return g_list_append(entries,pattern);   
}

void
gtk_extext_highlight_table_free(GtkExTextHighlightTable *table)
{
  GtkExTextHighlightSyntaxEntry *syntax;
  GtkExTextHighlightPatternEntry *pattern;
  GList *cur;
  
  cur=g_list_first(table->entries);
  while(cur)
  {
    if(table->type==SYNTAX_TABLE)
    {
      syntax=(GtkExTextHighlightSyntaxEntry *)cur->data;

      g_free(syntax->regex_start.buf.fastmap);
      syntax->regex_start.buf.fastmap=NULL;
      regfree(&syntax->regex_start.buf);

      g_free(syntax->regex_end.buf.fastmap);
      syntax->regex_end.buf.fastmap=NULL;
      regfree(&syntax->regex_end.buf);
    }
    else    {
      pattern=(GtkExTextHighlightPatternEntry *)cur->data;
      g_free(pattern->regex.buf.fastmap);
      pattern->regex.buf.fastmap=NULL;
      regfree(&pattern->regex.buf);
    }
    g_free(cur->data);

    cur=g_list_next(cur);
  };  

  g_list_free(table->entries);
  g_free(table);
}

/* regex_match -- tries to match regex at the 'pos' position in the
 * text. It returns the number of chars matched, or -1 if no match.
 * Warning!  The number matched can be 0, if the regex matches the
 * empty string.  The reason for workin on GtkSCText is the same as in
 * regex_search. */
gint
gtk_extext_regex_match (GtkExText *text, gint pos, Regex *regex)
{
  g_return_val_if_fail (pos <= text->length, -1);
  g_return_val_if_fail (regex != NULL, -1);

  return re_match_2 (&regex->buf,
		     /* text before gap */
           text->text, text->part1len,
		     /* text after gap */
           &text->part2text[text->part1len],
		     text->length - text->part1len+1,
		     /* from pos and not after the end */
		     pos, &regex->reg, text->length);
}

/* below code is ported from glibber copyright Chris Phelps <chicane@reninet.com> */

void check_brackets(GtkWidget *widget, gint pos)
{
   GtkExText *text;
   GtkEditable *editable;
   gboolean found = FALSE;

   g_return_if_fail(widget != NULL);

   text = GTK_EXTEXT(widget);
   editable = GTK_EDITABLE(widget);

   gtk_extext_set_pseudo_select(text, -1, -1);

   pos = editable->current_pos-1;
   if(pos < 0) return;
   found = find_bracket_match(widget, &pos);

   if(found)
      gtk_extext_set_pseudo_select(text, pos, pos+1);
}

gboolean find_bracket_match(GtkWidget *widget, gint *search)
{
   GtkExText *text;
   GtkEditable *editable;
   gchar base_char = 0;
   gchar search_char = 0;
   gchar cur_char = 0;
   gint addition = -1;
   gint counter = 0;
   gboolean found = FALSE;
   gint pos = 0;

   g_return_val_if_fail(widget != NULL, FALSE);
   if(!search) return(FALSE);

   text = GTK_EXTEXT(widget);
   editable = GTK_EDITABLE(widget);
   pos = *search;
   cur_char = GTK_EXTEXT_INDEX(text, pos);

   if(text->property_current && text->property_current->user_data == GINT_TO_POINTER(SYNTAX_TABLE))
      return(FALSE);

   base_char = cur_char;
   switch((int)base_char)
   {
      case '{': addition = 1;
                search_char = '}';
                break;
      case '(': addition = 1;
                search_char = ')';
                break;
      case '[': addition = 1;
                search_char = ']';
                break;
      case '<': addition = 1;
                search_char = '>';
                break;
      case '}': addition = -1;
                search_char = '{';
                break;
      case ')': addition = -1;
                search_char = '(';
                break;
      case ']': addition = -1;
                search_char = '[';
                break;
      case '>': addition = -1;
                search_char = '<';
                break;
      default : addition = 0;
                break;
   }
   if(!addition) return(FALSE);
   while(pos >= 0 && pos <= text->length)
   {
      pos += addition;
      cur_char = GTK_EXTEXT_INDEX(text, pos);
      if(cur_char == search_char && !counter)
      {
         found = TRUE;
         break;
      }
      if(cur_char == base_char)
         counter++;
      else if(cur_char == search_char)
         counter--;
   }
   if(found) *search = pos;
   return(found);
}
