/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "main.h"

int
main (int argc, char *argv[],char *envp[])
{
	gint estado;

	estado=0;
	pro_forzando_librerias=FALSE;
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);

	gnome_init ("diasce", VERSION, argc, argv);
	
	signal(SIGCHLD,(void *)gen_hijo_muerto);

	ventana_inicio=create_autodetect_ventana();
	gtk_widget_show(ventana_inicio);
	gtk_idle_add(david_init,&estado);

	gtk_main ();
	return 0;
}

gboolean david_init(gpointer estado)
{
	GtkWidget *scrolledwindow;

	if ((*(guint*)estado)==0) {
		autoconfiguracion=0;
		pro_inicializar();
		edit_inicializar();
		edit_inicializar_coloreado();
		buscar_inicializar();
	}
	
	pref_abrir((*(guint*)estado));

	if ((*(guint*)estado)==ULTIMA_FASE_AUTODETECCION) {
		david_ventana = create_david_ventana ();

		g_set_printerr_handler((GPrintFunc) gen_mensajes_stderr);
		g_set_print_handler((GPrintFunc) gen_mensajes_stdout);

		pix_inicializar();
		cefv_inicializar();

		edit_editor=GTK_EXTEXT(lookup_widget(david_ventana,"editor_texto"));
		edit_funciones=GTK_EXTEXT(lookup_widget(david_ventana,"funciones_texto"));
		gtk_editable_set_editable(GTK_EDITABLE(edit_editor),FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(edit_funciones),FALSE);
		scrolledwindow=lookup_widget(david_ventana,"scrolledwindow5");
		edit_editor->vadj=GTK_VSCROLLBAR(GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar)->scrollbar.range.adjustment;
		edit_editor->hadj=GTK_HSCROLLBAR(GTK_SCROLLED_WINDOW(scrolledwindow)->hscrollbar)->scrollbar.range.adjustment;
		pref_aplicar();
		gen_anular_funciones();
          /*Aadimos a los menus los ultimos proyectos abiertos*/
          gen_ultimos_proyectos();

		gen_localizar_automake();

		gtk_widget_show (david_ventana);
		
		return FALSE;
	}
	
	(*(guint*)estado)++;
	return TRUE;
}
