/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

struct s_lista_archivos {
	gchar *nombre;
	gchar *datos;
	guint size;
	gboolean modificado;
	gboolean analizado;
	gfloat ajuste;
	gfloat limite_ajuste;
	guint filas;
	guint posicion;
	GtkCTreeNode *nodo_arbol;
	struct s_lista_archivos *anterior;
	struct s_lista_archivos *siguiente;
	GtkExText *editor; // un puntero al widget en el que se esta mostrando el archivo.
	gint pestana; // nos indica en que pestaa del notebook se esta mostrando el archivo. -1 si no esta en ninguna.
};


//*******************************************************************

struct s_lista_archivos *raiz_lista_archivos;
struct s_lista_archivos *edit_actual;
guint edit_posicion;
gboolean edit_abriendo_llave;
GtkExText *edit_editor;
GtkExText *edit_funciones;
GtkExTextHighlightTable *edit_tabla_pattern;
GtkExTextHighlightTable *edit_tabla_syntax;
GdkColor c_fondo,c_nada,c_comentario,c_directiva,c_cadena_cs,c_cadena_cd,c_etiqueta,c_entero,c_real,c_hexadecimal,c_octal,c_prelight;
GtkStyle *edit_estilo;
gint edit_total_pestanas;
GList *edit_historico_funciones;
gboolean edit_congelar_historico;

//*******************************************************************
void edit_inicializar(void);

void edit_inicializar_coloreado(void);

void edit_cerrar(void);

void edit_anadir(gchar *nombre,GtkCTreeNode *nodo_arbol);

void edit_guardar_todo(void);

void edit_ver(gchar *nombre);

void edit_borrar_seleccion(void);

void edit_copiar_seleccion(void);

void edit_cortar_seleccion(void);

void edit_pegar_seleccion(void);

void edit_guardar(void);

void edit_eliminar(gchar *nombre);

void edit_actualizar(void);

void edit_actualizar_fila(void);

void edit_auto_formato(GtkEditable *editor,gchar *texto,guint longitud,guint *posicion);

gboolean edit_comprobar_perdida_datos(void);

void edit_mensaje(gchar *mensaje);

void edit_ir_a_posicion(guint posicion,guint filas);

gboolean edit_repetido(gchar *nombre);

void edit_anadir_tabulacion(void);

void edit_eliminar_tabulacion(void);

gchar *edit_tabulacion(gint *posicion);

//Funcion que se posiciona en la fila indicada y devuelve el numero de caracteres que ha tenido 
//avanzar desde el inicio del fichero para llegar a esa fila
guint edit_ir_a_fila(guint fila,guint filas);

void edit_colorear(struct s_lista_archivos *nodo);

struct s_lista_archivos *edit_conseguir_nodo(gchar *nombre);

void edit_cambiar_reglas_coloreado(void);

void edit_aplicar_reglas_coloreado(GtkExText *editor);

void edit_recargar_archivo(gchar *nombre);

void edit_ver_funcion(gchar *funcion, gboolean actualizar_historico);
