#!/bin/bash
# Author:	Ola Lundqvist	<opal@lysator.liu.se>
# License:	GPL (as the rest)
# Description:	Automates the translation process of new words.
# Depends:	translate-common.sh
#		Needs to be run in the language directory.
#		common.data (data of commmon words to translate).

# The format of the common.data file is:
# english_word=other_word
# Note that spaces are NOT allowed. To make spaced you have to use underscore '_'
# That will be converted to spaces. Words with underscore have to be translated by hand.

if [ ! -f common.data ] ; then
    echo "File common.data not found, exiting."
else
    DATA=$(cat common.data | grep -v -e "^[[:space:]]*#")
    for A in $DATA ; do
	FROM=${A//=*/}
	FROM=${FROM//_/ }
	TO=${A//*=/}
	TO=${TO//_/ }
	echo "Translating $FROM => $TO"
	perl -pi -e "s/\"$FROM\"/\"$TO\"/g;" *.str
	perl -pi -e "s/'$FROM'/'$TO'/g;" *.str
    done
fi