#!/bin/bash
# Author:	Ola Lundqvist <opal@lysator.liu.se>
# License:	GPL (as the rest)
# Description:	Automates the translation process of new words.
#		See translate-common.sh for more information.
#		Right now it simply run translate-common.sh in all str/lang directories.
# Depends:	translate-common.sh
# 		Have to be run in the root of dcl or in the str directory.

TMP=${PWD//*\/str/}
if [ ! -z "$TMP" ] ; then
    if [ -d str ] ; then
	echo "Not in str catalog but str catalog found, chdir to str."
	cd str
    fi
fi
TMP=${PWD//*\/str/}
if [ ! -z "$TMP" ] ; then
    echo "You have to be located in the str catalog of dcl to make this script work."
else
    echo "You are in the str directory. Good."
    for LDIR in *; do
	if [ "$LDIR" = "." -o "$LDIR" = ".." ] ; then
	    echo "Skipping directory $LDIR."
	elif [ -d "$LDIR" ] ; then
	    if [ -f $LDIR/common.data ] ; then
		echo "File common.data found in $LDIR, autotranslating."
		cd $LDIR
		../../scripts/translate/translate-common.sh
		cd ..
	    else
		echo "File common.data not found in $LDIR, skipping."
	    fi
	else
	    echo "$LDIR is not a directory, skipping."
	fi
    done
fi
