<?php
/*
 * $Id: class.boTicketresolutions.inc.php,v 1.3.2.1.2.6 2004/01/01 18:16:44 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');

class boTicketresolutions
{
	var $oDB;
	
	function boTicketresolutions()
	{
		$this->oDB = CreateObject('dcl.dbTicketresolutions');
		$this->oDB->Connect();
	}

	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTicketresolutions');
		$obj->DisplayForm($GLOBALS['ticketid']);

		$objHT = CreateObject('dcl.htmlTicketDetail');
		$objHT->Show($objTicket);
	}

	function dbadd()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$this->oDB->InitFromGlobals();
		$this->oDB->loggedby = $GLOBALS['DCLID'];
		$this->oDB->loggedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect($this->oDB->conn);
		$obj->Load($this->oDB->ticketid);
		$obj->lastactionon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);

		$notify = '4';
		if ($this->oDB->status != $obj->status)
		{
			$oStatus = CreateObject('dcl.dbStatuses');
			$notify .= ',3';
			$obj->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			if ($oStatus->GetStatusType($this->oDB->status) == 2)
			{
				$notify .= ',2';
				$obj->closedby = $GLOBALS['DCLID'];
				$obj->closedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			}
			if ($oStatus->GetStatusType($this->oDB->status) == 1)
				$notify .= ',1';

			$obj->status = $this->oDB->status;
		}

		if (IsSet($GLOBALS['escalate']) && $GLOBALS['escalate'] == '1')
		{
			$objP = CreateObject('dcl.dbProducts');
			$objP->Connect($obj->conn);
			$objP->Load($obj->product);
			if ($obj->responsible != $objP->ticketsto)
			{
				$obj->responsible = $objP->ticketsto;
				$objDP = CreateObject('dcl.dbPersonnel');
				$objDP->Connect($obj->conn);
				$objDP->Load($obj->responsible);
				$this->oDB->resolution = '*** ' . STR_BO_ESCALATEDTO . ': ' . $objDP->short . ' ***' . phpCrLf . phpCrLf . $this->oDB->resolution;
			}
		}

		$this->oDB->BeginTransaction();
		$this->oDB->Add();

		$start = new DCLTimestamp;
		$start->SetFromDisplay($this->oDB->startedon);

		$end = new DCLTimestamp;
		$end->SetFromDisplay($this->oDB->loggedon);

		$obj->seconds += ($end->time - $start->time);

		$obj->Edit();
		$this->oDB->EndTransaction();

		$objWtch = CreateObject('dcl.boWatches');
		$objWtch->sendTicketNotification($obj, $notify);

		$this->sendCustomerResponseEmail($obj);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function modify(&$aSource)
	{
		$this->oDB->InitFromArray($aSource);

		$this->oDB->BeginTransaction();
		$this->oDB->Edit();
		$this->oDB->EndTransaction();
	}

	function delete(&$aSource)
	{
		$this->oDB->InitFromArray($aSource);

		$this->oDB->BeginTransaction();
		$this->oDB->Delete();
		$this->oDB->EndTransaction();
	}

	function sendCustomerResponseEmail(&$obj)
	{
		global $dcl_info;

		if (!is_object($obj) || $dcl_info['DCL_CQQ_PERCENT'] == 0)
			return;

		$oStatus = CreateObject('dcl.dbStatuses');
		if ($obj->contactemail == '' || $oStatus->GetStatusType($obj->status) != 2)
			return;

		srand((double)microtime() * 1000000);
		$pct = rand(1, 100);
		if ($pct <= $dcl_info['DCL_CQQ_PERCENT'])
		{
			$Template = CreateObject('dcl.DCLTemplate');
			$Template->set_file(array('hForm' => 'templates/custom/' . $dcl_info['DCL_CQQ_TEMPLATE']));
			$Template->set_var('VAL_TICKETID', $obj->ticketid);
			$Template->set_var('VAL_CLOSEDON', htmlspecialchars($obj->closedon));

			$oMail = CreateObject('dcl.boSMTP');
			$oMail->to = $obj->contactemail;
			$oMail->from = $dcl_info['DCL_CQQ_FROM'];
			$oMail->subject = $dcl_info['DCL_CQQ_SUBJECT'];
			$oMail->body = $Template->parse('out', 'hForm');
			$oMail->Send();
		}
	}
}
?>
