/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * userinfo.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: userinfo.h,v 1.5 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __USERINFO_H__
#define __USERINFO_H__

#include "userinfoT.h"
#include "lmp.h"

/********************************************************/
/* retrieve the user information for the given nickname */
/********************************************************/
/* input: lmp=user_info_lmp to use      */
/*        nickname= nick to find        */
/*        uinfo= array filled on succes */
/********************************************************/
/* output: 0=ok, (*uinfo) contains the user information */
/*         1=not found or error.                        */
/********************************************************/
int get_user_info(LMP_ENTRY *lmp, char *nickname,LMP_UINFO *uinfo);

/********************************/
/* get a copy of user info LMPs */
/*******************************************************/
/* output: 0=ok, else error                            */
/* on ok, *addr is the address of the allocated buffer */
/*        *nb_records is the number of records         */
/*******************************************************/
int get_user_info_lmp_copy(LMP_ENTRY *lmp, LMP_UINFO **addr, int *nb_records);

#endif
