/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * userinfo.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: userinfo.c,v 1.6 2004/01/02 15:49:07 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "userinfo.h"
#include "lmp.h"
#include "misc.h"

/**********************************************/
/* find the array index of the given nickname */
/**********************************************/
/* output: idx or -1 if not found */
/**********************************/
static int uinfo_idx(LMP_ENTRY *lmp,char *nickname)
{
	int i;
	LMP_UINFO *lu=lmp->mapped_addr;

	for(i=1;i<lmp->nb_records;i++)
	{
		if(lu[i].entry_is_busy)
		{
			if(!strcmp(lu[i].nickname,nickname))
				return i;
		}
	}
	return -1;
}

/********************************************************/
/* retrieve the user information for the given nickname */
/********************************************************/
/* input: lmp=user_info_lmp to use      */
/*        nickname= nick to find        */
/*        uinfo= array filled on succes */
/********************************************************/
/* output: 0=ok, (*uinfo) contains the user information */
/*         1=not found or error.                        */
/********************************************************/
int get_user_info(LMP_ENTRY *lmp, char *nickname,LMP_UINFO *uinfo)
{
	int idx;
	int ret=1;

	if(lmp==NULL)
		return ret;	/* no lmp */

	if(lmp_lock_and_map(lmp))
		return ret;	/* fail to lock */

	idx=uinfo_idx(lmp,nickname);
	if(idx!=-1)
	{
		memcpy(uinfo,&(((LMP_UINFO *)(lmp->mapped_addr))[idx]),sizeof(LMP_UINFO));
		ret=0;
	}

	lmp_unmap_and_unlock(lmp);
	return ret;
}

/********************************/
/* get a copy of user info LMPs */
/*******************************************************/
/* output: 0=ok, else error                            */
/* on ok, *addr is the address of the allocated buffer */
/*        *nb_records is the number of records         */
/*******************************************************/
int get_user_info_lmp_copy(LMP_ENTRY *lmp, LMP_UINFO **addr, int *nb_records)
{
	if(lmp==NULL)
		return -1;	/* no lmp */

	if(lmp_lock_and_map(lmp))
		return -1;	/* fail to lock */

	*nb_records=lmp->nb_records;

	*addr=calloc(lmp->nb_records,sizeof(LMP_UINFO));
	if(*addr==NULL)
		return -2;

	memcpy(*addr,lmp->mapped_addr,lmp->nb_records*sizeof(LMP_UINFO));

	lmp_unmap_and_unlock(lmp);
	return 0;
}

