/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * mini_db.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: mini_db.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __MINI_DB_H__
#define __MINI_DB_H__

/************************************************************/
/* the following function provides a mini database function */
/************************************************************/

/***********************************/
/* CREATE, LOAD and SAVE functions */
/***********************************/

/**********************************************************************/
/* create a new "database" having the given number of entries per row */
/**********************************************************************/
struct minidb *db_new(const char *db_name, int nb_fields);

/*****************************************************/
/* load the given "database" (gnome key) into memory */
/*****************************************************/
struct minidb *db_load_db(const char *db_name);

/****************************************************************************/
/* save the given allocated minidb (the minidb structure remains available) */
/****************************************************************************/
void db_save_db(struct minidb *mdb);

/***********************************/
/* free the given allocated minidb */
/***********************************/
void free_loaded_db(struct minidb *mdb);

/***********************************/
/* ADDING, REMOVING, UPDATING rows */
/***********************************/

/* add a new row to the database (without taking duplicate row into account) */
void db_add_row(struct minidb *mdb, const char *col[]);		/* col is an array of "nb_fields" string */

/* add a new row to the database (taking duplicate row into account) */
/* if with_overwrite is not set and a row with the same key exist, the row is not added */
/* if with_overwrite is set and a row with the same key exist, the row is updated */
void db_add_row_uniq(struct minidb *mdb, int with_overwrite,int which_uniq_column, const char *col[]);		/* col is an array of "nb_fields" string */

/* delete a row of the database using its "key" */
void db_del_row(struct minidb *mdb, int which_column, const char *value);

#endif
