/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * find_result_clist.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: find_result_clist.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __FIND_RESULT_CLIST_H__
#define __FIND_RESULT_CLIST_H__

/****************************************************************************************/
/* this function calls the given fnc for each selected entry of the "find_result" clist */
/****************************************************************************************/
void generic_selected_find_result_calls(GtkTreeSelectionForeachFunc fnc, void *data);

/********************************************************/
/* build modele and view for the cached user list clist */
/********************************************************/
void bmav4_find_result_clist(void);

/*************************************************/
/* copy the find_result list store into its copy */
/*************************************************/
void copy_find_result_store_into_the_copy(void);

/***************************************************************/
/* copy the copy of find_result list store into the list store */
/***************************************************************/
void copy_the_copy_into_find_result_store(void);

/* ID of the different filters */
typedef enum
{
   FI_UNKNOW=-1,
   FI_SIZE_BELOW,		/* param= gulong * */
   FI_SIZE_ABOVE,		/* param= gulong * */
   FI_FNAME_WITH,		/* param= const GString * */
   FI_FNAME_WITHOUT	/* param= const GString * */
} FILTER_ID;

/*************************************/
/* filter the find_result list store */
/*************************************/
void filter_find_result_store(FILTER_ID fi, const void *param);

#endif
