/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2003 Eric Prevoteau
 *
 * bt2dc_gui2_io.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bt2dc_gui2_io.h,v 1.1 2004/01/13 18:10:29 ericprev Exp $
*/

#ifndef __BT2DC_GUI2_IO_H__
#define __BT2DC_GUI2_IO_H__

#include <sys/param.h>

#define MAX_SOURCE_FILENAME_LEN	2048
#define MAX_ERROR_LEN	1024
#define MAX_STATUS_LEN	128
#define ORIGINAL_URL_LEN	4096

typedef struct
{
	time_t last_updated_time;			/* date when the structure is updated */
	gboolean done;
	time_t done_time;						/* only meaningful if done=TRUE */
	char file[MAX_SOURCE_FILENAME_LEN];		/* currently downloaded file name */
	guint64 filesize;
	gfloat percentDone;				/* download %age */
	char status[MAX_STATUS_LEN];			/* status string */
	char downloadTo[MAXPATHLEN+1];		/* local path of the filename */
	gdouble downRate;					/* download speed (in byte/s) */
	gdouble upRate;						/* upload speed (in byte/s) */
	char error_string[MAX_ERROR_LEN];	/* latest error messages */
	gboolean client_is_running;				/* FALSE if no client uses this entry, TRUE means either a client uses it or a client has died without */
														/* changing the flag */
	/* the 2 following vars are command line arguments */
	char download_dir[MAXPATHLEN+1];		/* local path of the filename */
	char original_url[ORIGINAL_URL_LEN];	/* third command line argument */
} BT_DL_STRUCT;

#endif
