/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * timed_out_string.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: timed_out_string.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __TIMED_OUT_STRING_H__
#define __TIMED_OUT_STRING_H__

/****************************************************/
/* add a new timed_out entry to the timed_out array */
/********************************************************************************/
/* input: key= it is a non uniq value used to create group of timed_out entries */
/*        duration= number of seconds before the expiration of the entry.       */
/*        ptr1= pointer on an array of bytes to store.                          */
/*        len1= number of bytes inside ptr1                                     */
/*        ptr2, len2= same as ptr1,len1                                         */
/* ptr1 and/or ptr2 can be NULL.                                                */
/********************************************************************************/
void add_tos_entry(const unsigned long key, const time_t duration, const char *ptr1, const int len1, const char *ptr2, const int len2);

/*****************************************************************************************/
/* add a new timed_out entry to the timed_out array, 1st value will be uniq in the array */
/*****************************************************************************************/
/* input: key= it is a non uniq value used to create group of timed_out entries */
/*        duration= number of seconds before the expiration of the entry.       */
/*        ptr1= pointer on an array of bytes to store.                          */
/*        len1= number of bytes inside ptr1                                     */
/*        ptr2, len2= same as ptr1,len1                                         */
/* ptr1 and/or ptr2 can be NULL.                                                */
/********************************************************************************/
void add_tos_entry_v1_uniq(const unsigned long key, const time_t duration, const char *ptr1, const int len1, const char *ptr2, const int len2);

/************************/
/* get the wanted entry */
/************************************************************/
/* input: key= key to find                                  */
/*        ptr= array to find                                */
/*        len= ptr array length                             */
/*        *out_ptr, *out_len= copy of the returned address. */
/*        content of out_ptr must be freed using free()     */
/* each entry of the tos is a triplet (key,ptr1,ptr2)       */
/* if side==0, this function returns in *out_ptr the first x*/
/* matching (key,ptr,x). If side==1, it is for (key,x,ptr)  */
/************************************************************/
/* output: ==0 not found, ==1, ok                 */
/*   on success, *out_ptr and *out_len are filled */
/**************************************************/
int get_tos_entry(const unsigned long key, const char *ptr, const int len, int side, char **out_ptr, int *out_len);

/***************************/
/* delete the wanted entry */
/************************************************************/
/* input: key= key to find                                  */
/*        ptr= array to find                                */
/*        len= ptr array length                             */
/* each entry of the tos is a triplet (key,ptr1,ptr2)       */
/* if side==0, this function returns in *out_ptr the first x*/
/* matching (key,ptr,x). If side==1, it is for (key,x,ptr)  */
/************************************************************/
void delete_this_tos_entry(const unsigned long key, const char *ptr, const int len, int side);

/******************************************/
/* scan tos array to find expired entries */
/******************************************/
void timeout_tos(void);

#endif
