/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * dctc_com.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dctc_com.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __DCTC_COM_H__
#define __DCTC_COM_H__

#include "lmp.h"
#include "userinfoT.h"

typedef struct
{
	int dctc_fd;			/* socket to use to communicate with dctc */
	char *dctc_sock_path;/* full path to DCTC communication socket */
	gint tag_read; 		/* if dctc_fd!=-1 and this value !=-1, it is a tag to */
								/* use with gdk_input_* for GDK_INPUT_READ event */
	gint tag_write;		/* if dctc_fd!=-1 and this value !=-1, it is a tag to */
								/* use with gdk_input_* for GDK_INPUT_WRITE event */
	GPtrArray *write_q;  /* this array contains the list of all strings */
								/* to send to dctc */
	GString *incoming_data;	/* this string contains partially received data */

	LMP_ENTRY *user_info_lmp;
								/* LMP containing hub user information */

	int user_info_nb_records_sync_last_state;
	LMP_UINFO *user_info_lmp_sync_last_state;
								/* it is a copy of user LMP. It is the last values used to synchronize */
								/* the DCTC user list with dcgui displayed user list */
} DCTC_COM;

/**********************************************************/
/* allocate a new DCTC_COM structure for the given socket */
/**********************************************************/
/* running_base_path = "$HOME/.dctc/dctc-xxxxxxxx-ip" */
/******************************************************/
DCTC_COM *create_new_dctc_com(int sock_fd, const char *running_base_path);

/***************************************************/
/* close socket and free memory used by a DCTC_COM */
/***************************************************/
void close_and_free_dctc_com(DCTC_COM *cm);

/**********************************************************/
/* destroy the given DCTC_COM and set its pointer to NULL */
/**********************************************************/
void close_dctc_com(DCTC_COM **cm);

/*************************************************************************/
/* close the socket of a com_struct and reopenit on the same destination */
/*************************************************************************/
void reconnect_dctc_com(DCTC_COM *cm);

#endif
