/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * bt_support.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bt_support.c,v 1.9 2004/01/17 08:18:04 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gconf/gconf-client.h>
#include <gnome.h>

#include "main.h"
#include "misc_gtk.h"
#include "bt_support.h"

/***********************************/
/* start a new bittorrent download */
/***********************************/
void process_bittorrent_url(const char *url)
{
	gchar *dl_dir;

	dl_dir=gconf_client_get_string(engine,"/apps/Dc_gui2/Profile/default/dl_dir_entry_ent_cnt",NULL);
	if((dl_dir)&&(strlen(dl_dir)))
	{
		int son;
		gchar *done_dir;
		done_dir=g_strconcat(dl_dir,"/done",NULL);

		switch(son=fork())
		{
			case -1:
						gnome_app_error(GNOME_APP(main_window),_("Fork fails. Unable to start a new bittorrent client."));
						break;

			case 0:	/* the son */
						{
							chdir(dl_dir);		/* should not be necessary */
							execlp("bt2dc_gui2_prelaunch","bt2dc_gui2_prelaunch",dl_dir,done_dir,url,NULL);
						}
						_exit(1);
						break;
		}
			
		g_free(done_dir);
	}
	else
	{
		gnome_error_dialog(_("No download directory given"));
	}

	if(dl_dir)
		g_free(dl_dir);
}

