/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gui_layout.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gui_layout.h,v 1.1 2004/01/13 18:10:29 ericprev Exp $
*/

#ifndef __GUI_LAYOUT_H__
#define __GUI_LAYOUT_H__

#define PROGNAME "Dc_gui2_bt"

/*************************************************************************/
/* the following functions save/restore the geometry of the given widget */
/* and all its childs                                                    */
/*************************************************************************/
/* to be saved, a widget must:                          */
/* 1) have a name (set with gtk_widget_set_name)        */
/* 2) be one of the following widget                    */
/*    - paned (h or v): the separator position is saved */
/*    - window: x,y,width and height are saved.         */
/*    - clist: column width are saved.                  */
/********************************************************/
/* prefix is a string preprended to the widget name */
/* before loading/saving it.                        */
/****************************************************/

/************************************************************************************/
/* this function must be called after all child widgets of widget have been created */
/************************************************************************************/
void gui_full_restore(GtkWidget *widget, char *prefix);

/*************************************************************/
/* this function must be called when the delete_event occurs */
/*************************************************************/
void gui_full_save(GtkWidget *widget, char *prefix);

#endif

