#!/usr/bin/perl -w

use DBI;
$| = 1;

my $DSN=$ENV{DBI_DSN};
my $host=$ENV{DBI_HOST};
my $table=$ENV{DBI_TABLE};
my $dbuser = $ENV{DBI_USER};
my $dbpwd = $ENV{DBI_PWD};

sub ok ($$;$) {
    my($n, $ok, $warn) = @_;
    ++$t;
    die "sequence error, expected $n but actually $t"
    if $n and $n != $t;
    ($ok) ? print "ok $t\n"
          : print "# failed test $t at line ".(caller)[2]."\nnot ok $t\n";
        if (!$ok && $warn) {
                $warn = $DBI::errstr || "(DBI::errstr undefined)" if $warn eq '1';
                warn "$warn\n";
        }
}

my $dbh = DBI->connect("dbi:dbftp:DSN=$DSN;hostname=$host;", $dbuser, $dbpwd);

unless($dbh) {
	warn "Unable to connect to dbftp ($DBI::errstr)\nTests skipped.\n";
	exit 0;
}


my($sth);

$sth = $dbh->prepare("select * from $table");
if ($sth) {
        ok(0,$sth->execute(),1);

        # Describe result fields
        my ( $fieldnum, $idx, $first_data );
        $fieldnum=$sth->{NUM_OF_FIELDS};
        print "Result fields: $fieldnum\n";
        $idx=0;
        while ( $idx < $fieldnum )
        {
           print " $idx - name:$sth->{NAME}->[$idx] type:$sth->{TYPE}->[$idx] precision:$sth->{PRECISION}->[$idx]\n";
           $idx++;
        }

        print "FIELDS:\n";
        $first_data=-1;
        $sth->bind_col(1, \$first_data);
        while (@row = $sth->fetchrow())     {
        ++$rowcount;
        print "$rowcount - first='$first_data' - @row\n";
    }

    $sth->finish();

}
