
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#include "dns.h"
#include "host_db.h"
#include <netdb.h>
#include <netinet/in.h>
#include <assert.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/socket.h>

#define WAIT_BETWEEN_QUERIES 1 /* sec */
#define WAIT_BETWEEN_LOOPS 10 /* secs */

pthread_t dns_thread;
pthread_mutex_t db_mutex;
dns_status want_resolve = ON;



inline char *name_from_ip(dword ip_addr)
{
	struct hostent *hp;
	unsigned int ip;

	ip = htonl(ip_addr);
	hp = gethostbyaddr((char*)&ip, 4, AF_INET);

	if (hp)
		return strdup(hp->h_name);
	else
		return NULL;
}



inline void dns_sleep(int secs)
{
	int i;

	for (i=0; i<secs && !shutting_down; i++) usleep(1000*MSEC);
}



void dns_polldb(int a) /* class A address space */
{
	int i = 0;
	host_record *h;
	int db_used;
	
	while (!shutting_down)
	{
		pthread_mutex_lock(&db_mutex);
		db_used = host_db[a].used;

		if (i == db_used)
		{
			/* end of this table */
			pthread_mutex_unlock(&db_mutex);
			return;
		}

		h = (host_record*)db_get(host_db[a], i);
		pthread_mutex_unlock(&db_mutex);


		/* resolve if it's not already resolved */
		if (h->hostname == NULL)
		{
			h->hostname = name_from_ip(h->ip_addr);
			if (verbose)
			{
				if (h->hostname)
					printf("DNS: Resolved %s",
						h->hostname);
				else
					printf("DNS: Resolution failed");
				printf(" (%d/%d)\n", i+1, db_used);
			}

			if (want_resolve != IN_PROGRESS)
				dns_sleep(WAIT_BETWEEN_QUERIES);
		}

		i++;
	}
}



/* argument is ignored */
void dns_main(void *ignored unused)
{
	printf("DNS: Thread is awake.\n");
	up_dns = 1;

	while (!host_db_used() && !shutting_down)
	{
		if (verbose) printf("DNS: Waiting for host_db to fill up.\n");
		fflush(stdout);
		dns_sleep(WAIT_BETWEEN_QUERIES);
	}

	while (!shutting_down)
	{
		int a;

		while (want_resolve == OFF && !shutting_down)
		{
			if (verbose) printf("DNS: Disabled.\n");
			dns_sleep(WAIT_BETWEEN_LOOPS);
		}

		for (a=0; a<256 && !shutting_down; a++) dns_polldb(a);

		if (want_resolve == IN_PROGRESS)
			want_resolve = OFF;

		if (verbose) printf("DNS: Hit end of host_db\n");
		dns_sleep(WAIT_BETWEEN_LOOPS);
	}

	printf("DNS: Thread down.\n");
	up_dns = 0;

	pthread_exit(0);
}

