/***************************************************************************
                          sound.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SOUND_H
#define SOUND_H


#include <qtimer.h>
#include <qarray.h>

#include "inkompatibel.h"

/* Wichtig: include inkompatibel.h muss _vor_ dem nachfolgenden stehen. */
#ifdef CUYO_SOUND
#include <mikmod.h>
#endif

#define sample_nix -1
#define sample_links 0
#define sample_rechts 0
#define sample_dreh 1
#define sample_fall 2
#define sample_land 3
#define sample_explodier 4

#define sample_anz 5

#define sample_namen {\
  "leftright.wav",\
  "turn.wav",\
  "down.wav",\
  "land.wav",\
  "explode.wav"\
}

/**
   Kmmert sich um den Sound. Es gibt genau eine globale Instanz von diesem
   Objekt, nmlich gSound. Das wird vom Cuyo-Objekt erzeugt und zerstrt.
 */
class Sound: public QObject {
  Q_OBJECT

public:
  Sound();
  
  ~Sound();
  

public:
  /** Spielt die angegebene Mod-Datei immer wieder ab.
      Bei na = "" wird nix abgespielt. */
  void playMod(__String na);
  
  /** Ldt den angegebenen Sample und liefert eine Nummer zurck,
      mit dem man ihn abspielen kann. */
  int ladSample(__String na);
  
  /** Spielt das Sample mit der angegebenen Nummer (die entweder eine
      der obigen Konstanten ist oder von ladSample zurckgeliefert wurde).
      sp gibt an, fr welchen Spieler. (Wird fr Stereo-Effekte gebraucht.) */
  void playSample(int sp, int nr);


public slots:
  /* Muss immer wieder aufgerufen werden, damit der Sound funktioniert.
     (Etwa 30 mal pro Sekunde sollte's tun.)
     Das Sound-Objekt kmmert sich selbst drum, einen QT-Timer zu erzeugen,
     der schritt() aufruft. */
  void schritt();
  
  
private:
  bool mSoundGeht;
  
  QTimer * mTimer;
  
  #ifdef CUYO_SOUND
    MODULE * mAktMod;
    
    QArray<SAMPLE *> mSamples;
    
  #endif
  
};


/* Definition in sound.cpp */
extern Sound * gSound;

#endif
