/***************************************************************************
                          sorte.h  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SORTE_H
#define SORTE_H

#include "inkompatibel.h"

//#include "fehler.h"
//#include "bilddatei.h"
//#include "blopbesitzer.h" // Nur fr die Verbindungskonstanten

/* Zur bergabe an laden */
#define verbart_nein 0
#define verbart_selten 1
#define verbart_ja 2


/* Fr das verbindetMitRand-Array: */
#define rand_links 0
#define rand_rechts 1
#define rand_oben 2
#define rand_unten 3

/* Konstanten fr neighbours= */
#define nachbarschaft_normal 0
#define nachbarschaft_schraeg 1
#define nachbarschaft_6 2
#define nachbarschaft_6_schraeg 3
#define nachbarschaft_springer 4
#define nachbarschaft_dame 5
#define nachbarschaft_6_3d 6
#define nachbarschaft_letzte 6

/** Event-Nummern in mEventCode. Die entsprechenden Strings stehen
    in sorte.cpp. */
#define event_draw 0 // Haupt-Mal-Code; Sonderbehandlung; muss 0 bleiben
#define event_init 1 // einmal am Anfang
#define event_turn 2 // bei jedem drehen
#define event_land 3 // kommt auf dem Boden auf (nur bei Fall)
#define event_changeside 4 // wechselt zum anderen Spieler
#define event_anz 5


/* Blop-Arten / -Sortennummern. Die Nummern >= 0 sind die normalen
   Farbsorten. */
#define blopart_gras -1
#define blopart_grau -2
#define blopart_keins -3
/* Letzte Art, auf die man ein Blop von cual aus noch setzen darf */
#define blopart_min_cual -3
/* Blop, der nicht wirklich zu sehen ist, sondern nur die globale
   Animation ausfhrt */
#define blopart_global -4
/* Letzte Art, von der es noch wirklich eine Sorte und Blops gibt. Alles
   andere sind nur Rckgabewerte oder so was. */
#define blopart_min_sorte -4
/* Rckgabewert, falls Koordinaten nach auerhalb vom Spielfeld zeigen. */
#define blopart_ausserhalb -6
/* Rckgabewert von getArt(), wenn es sich um einen Farbblop handelt.
   Und Wert, den man an Sorte::laden() bergeben kann. */
#define blopart_farbe -7





/* Event-Namen werden in sorte.cpp definiert. */
extern const char cEventNamen[event_anz][33];


class Bilddatei;
class Blop;
class Code;





/** Enthlt alle Informationen ber eine Blopsorte; kann solche Blops malen
  *@author Immi
  */

class Sorte {
	

 public: 
  Sorte();
  ~Sorte();
	
  /** Ldt die Sorte mit dem angegebenen Namen. Schaut auch in der
      entsprechenden Gruppe von mLevelConf nach, setzt die Gruppe
      aber danach zurck. blopart muss nur angegeben werden, damit ein
      paar Art-abhngige Defaults richtig gesetzt werden knnen.
      Throwt Fehler, wenn erfolglos. */
  void laden(__String name, int blopart);
  
  
  
  
	
 protected:
  /** lscht die ganzen Bilder aus dem bilddateien-Array */
  void loeschBilder();



 public:
 
  /***** Getter-Methoden, mit denen man auf die ganzen Informationen
         zugreifen kann. *****/
  
  
  __String getName() const;
  
  bool getVerbindetMitRand(int r) const;
  
  bool getKetteZaehltNurInnen() const;
  
  int getNachbarschaft() const;
  
  Code * getEventCode(int evt) const;
  
  Bilddatei * getBilddatei(int nr) const;


	
  
  /* ACHTUNG! Beim Neueinfgen von Variablen, die aus der
   * level.descr gelesen werden, nicht vergessen, am Anfang
   * von Sorte::laden() defaults zu setzen! */
  
 protected:			
  /** Der Name, unter dem in Code-Programmen auf die Sorte
      zugegriffen wird. */
  __String mName;
  /** Verbinden sich diese Blops auch zum Rand hin? Aufgeschlsselt
      nach den Rndern. (Konstanten rand_...) */
  bool mVerbindetMitRand[4];
  /** Zhlen nur innere Steine zur Kettengre? */
  bool mKetteZaehltNurInnen;
  /** Was zhlt als Nachbarn im Sinne einer Kette? */
  int mNachbarschaft;

  /** Alle Bildchen zu diesem Blop */
  QArray<Bilddatei *> mBilddateien;

  /** Code, der zu bestimmten Events aufgerufen wird (bzw. 0). */
  Code * mEventCode[event_anz];
  
};

#endif
