/***************************************************************************
                          fall.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FALL_H
#define FALL_H

#include "inkompatibel.h"

#include "blop.h"



// wie das Fallende sein kann
#define richtung_keins 0
#define richtung_einzel 1
#define richtung_waag 2
#define richtung_senk 3




struct FallPos {
  /** x-Koord vom Fall in Feldern */
  int x;
  /** y-Koord vom Fall in Pixeln (absolut, und nicht relativ zum ggf.
      wegen Rberreihen verschobenen Spielfeld) */
  int yy;
  /** Richtung und Anzahl der Blops. Siehe Konstanten. */
  int r;
	
  /** Liefert die Anzahl der Blops vom Fall zurck. */
  int getAnz() const {
    if (r == richtung_keins)
      return 0;
    else if (r == richtung_einzel)
      return 1;
    else
      return 2;
  }
	
  int getX(int a) const {
    return x + a * (r == richtung_waag);
  }

  /** ... hv = aktuelle Hochverschiebung... */
  int getY(int a, int hv) const {
    int y0 = yy + gric - 1 + hv;
    /* Korrektur bei ungeraden Spalten im Sechseck-Modus... */
    if (ld->mSechseck && (getX(a) & 1))
      y0 += gric / 2;
			
    return y0 / gric + a * (r == richtung_senk);
  }

};


class Spielfeld;

/** Enthlt alle Informationen ber das Fall: Existenz, Position
		(inkl. genaue Drehpos), Farben, ...
  *@author Immi
  */

class Fall: public BlopBesitzer {
 public:

  /** Konstruktor... */
  Fall(Spielfeld * sp, bool re);


  /** Position vom Fall. */
  FallPos mPos;

 private:
  /** True, wenn rechter Spieler (fr Sound ntig) */
  bool mRechterSpieler;
  /** Schnell fallen? */
  bool mSchnell;
  /** Ist es noch nicht ganz fertiggedreht? */
  int mExtraDreh;
  /** Ist es noch nicht ganz fertig waagrecht verschoben? */
  int mExtraX;
  /** Das zu diesem Fall gehrende Spielfeld */
  Spielfeld * mSp;
  /** Die Blops */
  Blop mBlop[2];

	
  /** kopiert einen fallenden Blop nach mDaten. Und sendet
      ein land-event. Muss innerhalb einer Gleichzeit aufgerufen
      werden. */
  void festige(int n);
	
  /** Liefert true, wenn das Fall grade auf Tastendrcke reagiert */
  bool steuerbar() {
    return mPos.r == richtung_waag || mPos.r == richtung_senk;
  }
	
  /** Setzt die Grafik vom Fall auf upzudaten */
  void setUpdate();

  /** Prueft, ob an Position p schon was im Weg ist oder nicht.
      Wenn irgendwo drber in der Spalte was ist, zhlt das auch
      als im Weg.
      @return eine Konstante belegt_... */
  int testBelegt(FallPos p) const;

  /** Liefert die Anzahl der Bklops vom Fall zurck. */
  int getAnz() const {
    return mPos.getAnz();
  }
	
  /** Liefert true, wenn das Fallende senkrecht ist */
  bool istSenkrecht() const;
	
  /** Lsst nur noch Blop a brig */
  void halbiere(int a);
	
  int getX(int a) const;
  int getY(int a) const;
	
  int getXX(int a) const;
  int getYY(int a) const;
		
 public:

  /** Erzeugt ein neues Fall. Liefert false, wenn dafr kein Platz ist */
  bool erzeug();
  /** Entfernt das Fall ganz */
  void zerstoere();

	
  /** Liefert ein Rechteck zurck, dass das Fallende berdeckt */
  QRect getRect() const {
    /* Faule Variante... ohne Beachtung der Drehposition und der genauen
       y-Position */
    int li = mPos.x;
    int re = mPos.x + 2;
    if (mExtraX < 0) li--;
    if (mExtraX > 0) re++;
    return QRect(li * gric, mPos.yy, (re - li) * gric, 3 * gric);
    /*return QRect(x * gric, y * gric,
      (1 + (r == richtung_waag)) * gric,
      (1 + (r == richtung_senk)) * gric);
    */
  }
	
  /** Bewegt das Fall ggf. nach unten und kmmert sich ggf. um
      Verwandlungen. */
  void spielSchritt();
  
  /** Fhrt die Animationen durch. Innerhalb einer Gleichzeit aufrufen. */
  void  animiere();

  /** Bewegt das Fall eins nach links */
  void tasteLinks();
  /** Bewegt das Fall eins nach rechts */
  void tasteRechts();
  /** Dreht das Fall */
  void tasteDreh();
  /** ndert die Fallgeschwindigkeit vom Fall */
  void tasteFall();

  /** Liefert true, wenn das Fall (noch) am Platzen ist
      (wg. Spielende) */
  bool getAmPlatzen() const;
  /** Liefert einen Pointer auf die Blops zurck. Wird vom
      KIPlayer bentigt. */
  const Blop * getBlopPtr() const;
  /** Lsst alle Blops vom Fall platzen (Spielende). */
  void lassPlatzen();
  /** Malt das Fall. */
  void malen(QPainter & p) const;
  /** Liefert true, wenn das Fall existiert. */
  bool existiert() const;
  /** Liefert true, wenn das Fall aus grade am zerfallen ist
      (d. h. existiert, aber aus nur noch einem Blop besteht).
      In dieser Zeit darf nmlich keine Explosion gezndet
      werden. (Erst warten, bis der andere Blop auch angekommen
      ist.) */
  bool istEinzel();

  virtual int getSpezConst(int vnr) const;

};

#endif

