//  crm114_expr_classify.c  - Controllable Regex Mutilator,  version v1.0
//  Copyright 2001-2004  William S. Yerazunis, all rights reserved.
//  
//  This software is licensed to the public under the Free Software
//  Foundation's GNU GPL, version 2.  You may obtain a copy of the
//  GPL by visiting the Free Software Foundations web site at
//  www.fsf.org, and a copy is included in this distribution.  
//
//  Other licenses may be negotiated; contact the 
//  author for details.  
//
//  include some standard files
#include "crm114_sysincludes.h"

//  include any local crm114 configuration file
#include "crm114_config.h"

//  include the crm114 data structures file
#include "crm114_structs.h"

//  include the routine declarations file
#include "crm114.h"

//  OSBF declarations
#include "crm114_osbf.h"

//    the command line argc, argv
extern int prog_argc;
extern char **prog_argv;

//    the auxilliary input buffer (for WINDOW input)
extern char *newinputbuf;

//    the globals used when we need a big buffer  - allocated once, used 
//    wherever needed.  These are sized to the same size as the data window.
extern char *inbuf;
extern char *outbuf;
extern char *tempbuf;

//
//     These two are placeholders for the real OSBF routines
//

int crm_expr_osbf_learn (CSL_CELL *csl, ARGPARSE_BLOCK *apb)
{ return (0); };
int crm_expr_osbf_classify (CSL_CELL *csl, ARGPARSE_BLOCK *apb)
{ return (0); };

//     Dispatch a LEARN statement
//
int crm_expr_learn (CSL_CELL *csl, ARGPARSE_BLOCK *apb)
{
  //            get our flags... the only ones we're interested in here
  //            are the ones that specify _which_ algorithm to use.

  if (apb->sflags & CRM_OSB_BAYES) 
    {
      return (crm_expr_osb_bayes_learn (csl, apb)); 
    }
  else
    if (apb->sflags & CRM_CORRELATE)
      {
	return (crm_expr_correlate_learn (csl, apb));
      }
    else
      if (apb->sflags & CRM_OSB_WINNOW)
	{
	  return (crm_expr_osb_winnow_learn (csl, apb));
	}
      else
	if (apb->sflags & CRM_OSBF )
	  {
	    return (crm_expr_osbf_bayes_learn (csl, apb));
	  }
	else
	  {
	    return (crm_expr_markov_learn (csl, apb));
	  };
  return (0);
}

//      Dispatch a CLASSIFY statement
//
int crm_expr_classify (CSL_CELL *csl, ARGPARSE_BLOCK *apb)
{
  //            get our flags... the only ones we're interested in here
  //            are the ones that specify _which_ algorithm to use.

  if (apb->sflags & CRM_OSB_BAYES) 
    {
      return (crm_expr_osb_bayes_classify (csl, apb));
    }
  else
    if (apb->sflags & CRM_CORRELATE)
      {
	return (crm_expr_correlate_classify (csl, apb));
      }
    else
      if (apb->sflags & CRM_OSB_WINNOW)
	{
	  return (crm_expr_osb_winnow_classify (csl, apb));
	}
      else
	if (apb->sflags & CRM_OSBF )
	  {
	    return (crm_expr_osbf_bayes_classify (csl, apb));
	  }
	else
	  {
	    return (crm_expr_markov_classify (csl, apb));
	  };
  return (0);
}


