/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      DialingView : NSObject <PrefsViewProtocol>
 *
 *  Description:  This view contains chat strings
 */

#import <AppKit/NSView.h>
#import <AppKit/NSBox.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSColor.h>

#import "Dialing.h"

@implementation DialingView

- (id) initWithPrefs: (NSMutableDictionary *) sessionPrefs
{
  NSView *initFrameView;
  NSView *responsesFrameView;

  [super init];
  
  if ((prefs = [sessionPrefs objectForKey: @"Dialing"]) == nil)
  {
    [sessionPrefs 
      setObject: [NSMutableDictionary dictionary] forKey: @"Dialing"];
    prefs = [sessionPrefs objectForKey: @"Dialing"];
  }

  view = [[NSView alloc] initWithFrame: NSMakeRect (10, 44, 280, 393)];

  // Init and dialing -------------------------------------------- 
  initFrame = [[NSBox alloc] initWithFrame:
    NSMakeRect (0, 265, 280, 125)];
  [initFrame setTitle: @"Init and dialing"];
  [view addSubview: initFrame];
  initFrameView = [initFrame contentView];

  // Init string
  initLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 78, 99, 21)];
  [initLabel setAlignment: NSRightTextAlignment];
  [initLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [initLabel setSelectable: NO];
  [initLabel setEditable: NO];
  [initLabel setBezeled: NO];
  [initLabel setBordered: NO];
  [initLabel setStringValue: @"Init string"];
  [initFrameView addSubview: initLabel];

  initTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 78, 130, 21)];
  [initFrameView addSubview: initTF];

  // Wait init response
  waitInitLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 52, 99, 21)];
  [waitInitLabel setAlignment: NSRightTextAlignment];
  [waitInitLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [waitInitLabel setSelectable: NO];
  [waitInitLabel setEditable: NO];
  [waitInitLabel setBezeled: NO];
  [waitInitLabel setBordered: NO];
  [waitInitLabel setStringValue: @"Wait init response"];
  [initFrameView addSubview: waitInitLabel];

  waitInitTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 52, 38, 21)];
  [initFrameView addSubview: waitInitTF];

  waitInitSecsLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (147, 52, 48, 21)];
  [waitInitSecsLabel setAlignment: NSRightTextAlignment];
  [waitInitSecsLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [waitInitSecsLabel setSelectable: NO];
  [waitInitSecsLabel setEditable: NO];
  [waitInitSecsLabel setBezeled: NO];
  [waitInitSecsLabel setBordered: NO];
  [waitInitSecsLabel setStringValue: @"seconds"];
  [initFrameView addSubview: waitInitSecsLabel];
  
  // Dial prefix
  dialLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 26, 99, 21)];
  [dialLabel setAlignment: NSRightTextAlignment];
  [dialLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [dialLabel setSelectable: NO];
  [dialLabel setEditable: NO];
  [dialLabel setBezeled: NO];
  [dialLabel setBordered: NO];
  [dialLabel setStringValue: @"Dial prefix"];
  [initFrameView addSubview: dialLabel];

  dialTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 26, 130, 21)];
  [initFrameView addSubview: dialTF];

  // Wait for connect
  waitDialLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 0, 99, 21)];
  [waitDialLabel setAlignment: NSRightTextAlignment];
  [waitDialLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [waitDialLabel setSelectable: NO];
  [waitDialLabel setEditable: NO];
  [waitDialLabel setBezeled: NO];
  [waitDialLabel setBordered: NO];
  [waitDialLabel setStringValue: @"Wait for connect"];
  [initFrameView addSubview: waitDialLabel];

  waitDialTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 0, 38, 21)];
  [initFrameView addSubview: waitDialTF];

  waitDialSecsLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (147, 0, 48, 21)];
  [waitDialSecsLabel setAlignment: NSRightTextAlignment];
  [waitDialSecsLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [waitDialSecsLabel setSelectable: NO];
  [waitDialSecsLabel setEditable: NO];
  [waitDialSecsLabel setBezeled: NO];
  [waitDialSecsLabel setBordered: NO];
  [waitDialSecsLabel setStringValue: @"seconds"];
  [initFrameView addSubview: waitDialSecsLabel];
  
  // Modem responses --------------------------------------------- 
  responsesFrame = [[NSBox alloc] initWithFrame:
    NSMakeRect (0, 31, 280, 229)];
  [responsesFrame setTitle: @"Modem repsponses"];
  [view addSubview: responsesFrame];
  responsesFrameView = [responsesFrame contentView];

  // OK
  okLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 182, 99, 21)];
  [okLabel setAlignment: NSRightTextAlignment];
  [okLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [okLabel setSelectable: NO];
  [okLabel setEditable: NO];
  [okLabel setBezeled: NO];
  [okLabel setBordered: NO];
  [okLabel setStringValue: @"OK"];
  [responsesFrameView addSubview: okLabel];

  okTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 182, 130, 21)];
  [responsesFrameView addSubview: okTF];
  
  // Connect
  connectLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 156, 99, 21)];
  [connectLabel setAlignment: NSRightTextAlignment];
  [connectLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [connectLabel setSelectable: NO];
  [connectLabel setEditable: NO];
  [connectLabel setBezeled: NO];
  [connectLabel setBordered: NO];
  [connectLabel setStringValue: @"Connect"];
  [responsesFrameView addSubview: connectLabel];

  connectTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 156, 130, 21)];
  [responsesFrameView addSubview: connectTF];
  
  // Error
  errorLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 130, 99, 21)];
  [errorLabel setAlignment: NSRightTextAlignment];
  [errorLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [errorLabel setSelectable: NO];
  [errorLabel setEditable: NO];
  [errorLabel setBezeled: NO];
  [errorLabel setBordered: NO];
  [errorLabel setStringValue: @"Error"];
  [responsesFrameView addSubview: errorLabel];

  errorTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 130, 130, 21)];
  [responsesFrameView addSubview: errorTF];

  // Busy
  busyLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 104, 99, 21)];
  [busyLabel setAlignment: NSRightTextAlignment];
  [busyLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [busyLabel setSelectable: NO];
  [busyLabel setEditable: NO];
  [busyLabel setBezeled: NO];
  [busyLabel setBordered: NO];
  [busyLabel setStringValue: @"Busy"];
  [responsesFrameView addSubview: busyLabel];

  busyTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 104, 130, 21)];
  [responsesFrameView addSubview: busyTF];
  
  // Voice
  voiceLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 78, 99, 21)];
  [voiceLabel setAlignment: NSRightTextAlignment];
  [voiceLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [voiceLabel setSelectable: NO];
  [voiceLabel setEditable: NO];
  [voiceLabel setBezeled: NO];
  [voiceLabel setBordered: NO];
  [voiceLabel setStringValue: @"Voice"];
  [responsesFrameView addSubview: voiceLabel];

  voiceTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 78, 130, 21)];
  [responsesFrameView addSubview: voiceTF];

  // No Answer
  noAnswerLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 52, 99, 21)];
  [noAnswerLabel setAlignment: NSRightTextAlignment];
  [noAnswerLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [noAnswerLabel setSelectable: NO];
  [noAnswerLabel setEditable: NO];
  [noAnswerLabel setBezeled: NO];
  [noAnswerLabel setBordered: NO];
  [noAnswerLabel setStringValue: @"No Answer"];
  [responsesFrameView addSubview: noAnswerLabel];

  noAnswerTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 52, 130, 21)];
  [responsesFrameView addSubview: noAnswerTF];
  
  // No carrier
  noCarrierLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 26, 99, 21)];
  [noCarrierLabel setAlignment: NSRightTextAlignment];
  [noCarrierLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [noCarrierLabel setSelectable: NO];
  [noCarrierLabel setEditable: NO];
  [noCarrierLabel setBezeled: NO];
  [noCarrierLabel setBordered: NO];
  [noCarrierLabel setStringValue: @"No Carrier"];
  [responsesFrameView addSubview: noCarrierLabel];

  noCarrierTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 26, 130, 21)];
  [responsesFrameView addSubview: noCarrierTF];
  
  // No Dialtone
  noDialtoneLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 0, 99, 21)];
  [noDialtoneLabel setAlignment: NSRightTextAlignment];
  [noDialtoneLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [noDialtoneLabel setSelectable: NO];
  [noDialtoneLabel setEditable: NO];
  [noDialtoneLabel setBezeled: NO];
  [noDialtoneLabel setBordered: NO];
  [noDialtoneLabel setStringValue: @"No Dialtone"];
  [responsesFrameView addSubview: noDialtoneLabel];

  noDialtoneTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (104, 0, 130, 21)];
  [responsesFrameView addSubview: noDialtoneTF];
  
  RELEASE (initLabel);
  RELEASE (initTF);
  RELEASE (waitInitLabel);
  RELEASE (waitInitTF);
  RELEASE (waitInitSecsLabel);
  RELEASE (dialLabel);
  RELEASE (dialTF);
  RELEASE (waitDialLabel);
  RELEASE (waitDialTF);
  RELEASE (waitDialSecsLabel);
  RELEASE (initFrame);

  RELEASE (okLabel);
  RELEASE (okTF);
  RELEASE (connectLabel);
  RELEASE (connectTF);
  RELEASE (errorLabel);
  RELEASE (errorTF);
  RELEASE (busyLabel);
  RELEASE (busyTF);
  RELEASE (voiceLabel);
  RELEASE (voiceTF);
  RELEASE (noAnswerLabel);
  RELEASE (noAnswerTF);
  RELEASE (noCarrierLabel);
  RELEASE (noCarrierTF);
  RELEASE (noDialtoneLabel);
  RELEASE (noDialtoneTF);
  RELEASE (responsesFrame);

  // load settings or set defaults
  [self setDefaults];

  return self;
}

// dealloc never called for array memebers
- (void) release
{
  NSLog (@"DialingView: release (%i)", [view retainCount]);
  if ([view superview])
  {
    [view removeFromSuperview];
  }
  else
  {
    RELEASE (view);
  }

  [super dealloc];
}

/*-------------------------------------------------------------------------*
 *  Protocol methods
 *-------------------------------------------------------------------------*/
- (id) show: (id)superView
{
  [superView addSubview: view];
  RELEASE (view);

  return nil;
}

- (void) hide 
{
  RETAIN (view);
  [view removeFromSuperview];
}

- (void) setDefaults
{
  if ([prefs count] > 0)
  {
    [initTF setStringValue: [prefs objectForKey: @"InitString"]];
    [waitInitTF setStringValue: [prefs objectForKey: @"InitTimeout"]];
    [dialTF setStringValue: [prefs objectForKey: @"DialPrefix"]];
    [waitDialTF setStringValue: [prefs objectForKey: @"DialTimeout"]];

    [okTF setStringValue: [prefs objectForKey: @"OKString"]];
    [connectTF setStringValue: [prefs objectForKey: @"ConnectString"]];
    [errorTF setStringValue: [prefs objectForKey: @"ErrorString"]];
    [busyTF setStringValue: [prefs objectForKey: @"BusyString"]];
    [voiceTF setStringValue: [prefs objectForKey: @"VoiceString"]];
    [noAnswerTF setStringValue: [prefs objectForKey: @"NoAnswerString"]];
    [noCarrierTF setStringValue: [prefs objectForKey: @"NoCarrierString"]];
    [noDialtoneTF setStringValue: [prefs objectForKey: @"NoDialtoneString"]];
  }
  else
  {
    [initTF setStringValue: @"ATZ"];
    [waitInitTF setStringValue: @"3"];
    [dialTF setStringValue: @"ATDP"];
    [waitDialTF setStringValue: @"45"];

    [okTF setStringValue: @"OK"];
    [connectTF setStringValue: @"CONNECT"];
    [errorTF setStringValue: @"ERROR"];
    [busyTF setStringValue: @"BUSY"];
    [voiceTF setStringValue: @"VOICE"];
    [noCarrierTF setStringValue: @"NO CARRIER"];
    [noDialtoneTF setStringValue: @"NO DIALTONE"];
    [noAnswerTF setStringValue: @"NO ANSWER"];
  }
}

- (NSMutableDictionary *) prefsDict
{
  [prefs setObject: [initTF stringValue] forKey: @"InitString"];
  [prefs setObject: [waitInitTF stringValue] forKey: @"InitTimeout"];
  [prefs setObject: [dialTF stringValue] forKey: @"DialPrefix"];
  [prefs setObject: [waitDialTF stringValue] forKey: @"DialTimeout"];

  [prefs setObject: [okTF stringValue] forKey: @"OKString"];
  [prefs setObject: [connectTF stringValue] forKey: @"ConnectString"];
  [prefs setObject: [errorTF stringValue] forKey: @"ErrorString"];
  [prefs setObject: [busyTF stringValue] forKey: @"BusyString"];
  [prefs setObject: [voiceTF stringValue] forKey: @"VoiceString"];
  [prefs setObject: [noAnswerTF stringValue] forKey: @"NoAnswerString"];
  [prefs setObject: [noCarrierTF stringValue] forKey: @"NoCarrierString"];
  [prefs setObject: [noDialtoneTF stringValue] forKey: @"NoDialtoneString"];

  return prefs;
}

/*-------------------------------------------------------------------------*
 *  Controls' action methods
 *-------------------------------------------------------------------------*/

@end
