/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: fd65883c-807a-4ae7-8981-ec1e60b8e13b
 * 
 */

#include <iostream>
#include "ConfigSource.h"
#include "ConfigArchSource.h"
#include "ConfigCVSSource.h"
#include "ConfigSVNSource.h"
#include "ConfigWGetSource.h"
#include "FileSystemVisitor.h"

ConfigSource *
ConfigSource::Create(string const &url) throw(exception *)
{
    /* TODO: Registry */

    if (url.find(":") == string::npos) {
        return new ConfigArchSource(url);
    }

    if (url.find("arch://") == 0)
      return new ConfigArchSource(url.substr(7));

    if (url.find("pserver://") == 0)
        return new ConfigCVSSource(url);

    if (url.find ("ext://") == 0)
      return new ConfigCVSSource(url);

    if (url.find ("http://") == 0)
      return new ConfigWGetSource(url);

    if (url.find ("ftp://") == 0)
      return new ConfigWGetSource(url);

    if (url.find ("svn") == 0)
      return new ConfigSVNSource(url);

    throw new runtime_error("Unknown RCS URL scheme.");
}

/* identify the rcs system used at a specific directory.
 * basic algorithm:
 * if the dir has explicit markers for any given RCS system, use that.
 * if the dir doesn't, and there is a parent RCS source, use that.
 *
 */
ConfigSource *
ConfigSource::Create(Path const &location, ConfigSource const *parent) throw (exception *)
{
    ConfigSource *result = NULL;
    /* Try each known type */
    result = ConfigArchSource::Create(location);
    if (result)
	return result;
    result = ConfigCVSSource::Create(location, parent);
    if (result)
      {
	if (result != parent)
	    return result;
	return NULL;
      }
    /* other module tests go here */

    return NULL;
}

int
ConfigSource::run_query (string const &command, string const &type) const
{
    if (Verbose())
        cout << "Executing '" << command << "'" << endl;

    int result = system(command.c_str());

    if (result == -1)
        throw new runtime_error(type + " command execution failed");

    return WEXITSTATUS(result);
}
 
void
ConfigSource::run (string const &command, string const &type) const
{
    if (run_query(command, type) != 0)
        throw new runtime_error("Error returned by " + type + " command");
}

void
ConfigSource::Verbose(bool const &aBool)
{
  Verbose_ = aBool;
}

bool
ConfigSource::Verbose()
{
  return Verbose_;
}

bool ConfigSource::Verbose_ = false;
