/*
 * Simple partition table active-flag/type modification utility.
 *
 * Copyright (c) Tuomo Valkonen 1997.
 */
 
#include<stdio.h>
#include<fcntl.h>
//#include<chos/chos.h>
#include"../include/chos.h"
#include"types.h"

// stolen from /usr/include/linux/genhd.h
typedef struct partition {
	unsigned char boot_ind;		/* 0x80 - active */
	unsigned char head;		/* starting head */
	unsigned char sector;		/* starting sector */
	unsigned char cyl;		/* starting cylinder */
	unsigned char sys_ind;		/* What partition type */
	unsigned char end_head;		/* end head */
	unsigned char end_sector;	/* end sector */
	unsigned char end_cyl;		/* end cylinder */
	unsigned int start_sect;	/* starting sector counting from 0 */
	unsigned int nr_sects;		/* nr of sectors in partition */
} Partition;

static Partition	table[4];

enum{SHOW,SET_ACTIVE,RESET_ACTIVE,SET_TYPE};

static int function=SHOW;
static int partition;
static int value;
static char*file=NULL;
static int fd;

static void usage()
{
	fprintf(stderr,
		"ModPart v0.0000001\n"
		"Usage: modpart [-s] <file>\n"
		"	modpart -p\n"
		"	modpart -a <partnr> <file>\n"
		"	modpart -i <partnr> <file>\n"
		"	modpart -t <type> <partnr> <file>\n\n");
		
	exit(0);
}

static void process_args(int argc,char*argv[])
{
	char*	tmp;
	
	if(argc==0)
		usage();
		
	if(!strcmp(*argv,"-p")){
		print_types();
		exit(0);
	}
	
	if(!strcmp(*argv,"-a"))
		function=SET_ACTIVE;
		
	else if(!strcmp(*argv,"-i"))
		function=RESET_ACTIVE;
		
	else if(!strcmp(*argv,"-t")){
		function=SET_TYPE;
		argv++;
		if(!--argc)
			usage();
		value=strtoul(*argv,&tmp,0);
		if(*tmp)
			usage();
	}else{
		if(!strcmp(*argv,"-s"))
			argv++,argc--;
		function=SHOW;
		goto get_file;
	}
	argv++;
	if(!--argc)
		usage();
	partition=strtoul(*argv,&tmp,0);
	if(*tmp)
		usage();
	argv++;
	--argc;
get_file:
	if(argc!=1)
		usage();
	file=*argv;
	return;
}

static void die()
{
	perror(file);
	exit(0);
}



static void rewrite()
{
	if(lseek(fd,PARTTABLE_OFF,SEEK_SET)!=PARTTABLE_OFF)
		die();
		
	if(write(fd,&table,sizeof(Partition)*4)!=sizeof(Partition)*4)
		die();
}

void main(int argc,char*argv[])
{
	int	i;
	
	process_args(argc-1,argv+1);
	
	if(!file)
		usage();
		
	if((fd=open(file,((function==SHOW)?O_RDONLY:O_RDWR)))<0)
		die();

	if(lseek(fd,PARTTABLE_OFF,SEEK_SET)!=PARTTABLE_OFF)
		die();
		
	if(read(fd,&table,sizeof(Partition)*4)!=sizeof(Partition)*4)
		die();

	switch(function){
	case SHOW:
		for(i=0;i<4;i++){
			printf("%1d: 0x%02x (%s)\t\t",i,
				table[i].sys_ind,parttype(table[i].sys_ind));
			if(table[i].boot_ind==0x80)
				printf("active");
			printf("\n");
		}break;
	case SET_ACTIVE:
		table[partition].boot_ind=0x80;
		rewrite();
		printf("Partition %d set active\n",partition);
		break;
	case RESET_ACTIVE:
		table[partition].boot_ind=0;
		rewrite();
		printf("Partition %d set inactive\n",partition);
		break;
	case SET_TYPE:
		table[partition].sys_ind=value;
		rewrite();
		printf("Partition %d set to type %d (%s)\n",partition,value,parttype(value));
		break;
	}
}