
##################################################################
# This file was generated by CherryPy-0.10-rc1
# For more information about CherryPy, see http://www.cherrypy.org
##################################################################

# As a special exception, the CherryPy team gives unlimited permission to 
# copy, distribute and modify the CherryPy scripts that are the 
# output of CherryPy.  You need not follow the terms of the GNU 
# General Public License when using or distributing such scripts, even 
# though portions of the text of CherryPy appear in them.  The GNU 
# General Public License (GPL) does govern all other use of the 
# material that constitutes the CherryPy program. 
# 
# Certain portions of the CherryPy source text are designed to be 
# copied (in certain cases, depending on the input) into the output of 
# CherryPy.  We call these the "data" portions.  The rest of the 
# CherryPY source text consists of comments plus executable code that 
# decides which of the data portions to output in any given case.  We 
# call these comments and executable code the "non-data" portions. 
# CherryPy never copies any of the non-data portions into its output. 
# 
# This special exception to the GPL applies to versions of CherryPy 
# released by the CherryPy team.  When you make and distribute a modified 
# version of CherryPy, you may extend this special exception to the 
# GPL to apply to your modified version as well, *unless* your 
# modified version has the potential to copy into its output some of 
# the text that was the non-data portion of the version that you 
# started with.  (In other words, unless your change moves or copies 
# text from the non-data portions to the data portions.)  If your 
# modification has such potential, you must delete any notice of this 
# special exception to the GPL from your modified version. 

import sys, os
global CherryObjects
sys.path.append(os.path.join('..', 'lib'))
import CherryObjectsZODB as CherryObjects

import base64
import types, smtplib, time
import md5
import smtplib, time
import types, smtplib
import time, cPickle
import types
import cPickle, sha, time, os, traceback
_debugFile='CherryPyServer.dbg'
configFileName='CherryPyServer.cfg'
_debug=1
_outputFile="CherryPyServer.py"
_outputFile="CherryPyServer.py"
_cacheMap={}
global HttpAuthenticate
class HttpAuthenticate:
    domain = 'Domain'
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/httpAuthenticate"
        else:
            return "/httpAuthenticate"
    def getPasswordListForLogin(self, login):
        if login=='login': return ['password']
        return []
    def unauthorized(self):
        _page=[]
        _page.append("""<html><body>Unauthorized</body></html>
""")
        return "".join(_page)
global Tools
class Tools:
    quote="'"
    doubleQuote="'"
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/tools"
        else:
            return "/tools"
    def compressHtml(self, body):
        i=body.find('<script')
        if i!=-1:
            j=body.find('</script>', i)
            return self.compressHtml(body[:i])+'\n'+body[i:j+9]+'\n'+self.compressHtml(body[j+9:])
        i=body.find('<SCRIPT')
        if i!=-1:
            j=body.find('</SCRIPT>', i)
            return self.compressHtml(body[:i])+'\n'+body[i:j+9]+'\n'+self.compressHtml(body[j+9:])
        i=body.find('<textarea')
        if i!=-1:
            j=body.find('</textarea>', i)
            return self.compressHtml(body[:i])+'\n'+body[i:j+11]+'\n'+self.compressHtml(body[j+11:])
        i=body.find('<TEXTAREA')
        if i!=-1:
            j=body.find('</TEXTAREA>', i)
            return self.compressHtml(body[:i])+'\n'+body[i:j+11]+'\n'+self.compressHtml(body[j+11:])
        return string.join(body.split())
    def getAttribute(self, attributeName, attributeValue):
        if attributeValue: return attributeName+'='+`attributeValue`
        return ""
    def validateEmail(self, email):
        try:
            before, after=email.split('@')
            if not before or after.find('.')==-1: raise 'Error'
        except: return "Wrong email"
    def getLabelWithCount(self, count, label, pluralLabel):
        if count<=1: return "%s %s"%(count, label)
        else: return "%s %s"%(count, pluralLabel)
    def getNow(self):
        tuple=time.gmtime(time.time()) # Local time
        return time.strftime('%Y-%m-%d %H:%M:%S', tuple)
    def escapeHtml(self, data, newlineToBr=1, whitespaceToNbsp=1, tabTo4ws=1):
        entityMap=[
            ('&','&amp;'),
            ('<','&lt;'),
            ('>','&gt;'),
            ('"','&quot;')]
        for k,v in entityMap: data=data.replace(k,v)
        if newlineToBr: data=data.replace('\n','<br>')
        if whitespaceToNbsp: data=data.replace('  ','&nbsp;&nbsp;')
        if tabTo4ws: data=data.replace('\t', '&nbsp;'*4)
        return data
global CookieAuthenticate
class CookieAuthenticate:
    timeoutMessage="Session timed out"
    wrongLoginPasswordMessage="Wrong login/password"
    noCookieMessage="No cookie"
    loginCookieName="CherryLogin"
    dateCookieName="CherryDate"
    passwordCookieName="CherryPassword"
    timeout=60 # in minutes
    login = ""
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cookieAuthenticate"
        else:
            return "/cookieAuthenticate"
    def getPasswordListForLogin(self, login):
        if login=='login': return ['password']
        return []
    def whoIsLoggedIn(self):
        print 'CherryWarning: whoIsLoggedIn is deprecated: use "self.login" instead'
        return self.login
    def doLogin(self, login, password, fromPage):
        realPasswordList=self.getPasswordListForLogin(login)
        if password not in realPasswordList:
            self.login=""
            return self.loginScreen(self.wrongLoginPasswordMessage, fromPage, login)
        self.login=login
        date=str(int(time.time()))
        clearPassword=login+date+password
        password=md5.new(clearPassword).hexdigest()
        response.simpleCookie[self.loginCookieName]=login
        response.simpleCookie[self.loginCookieName]['path']='/'
        response.simpleCookie[self.loginCookieName]['max-age']=31536000
        response.simpleCookie[self.loginCookieName]['version']=1
        response.simpleCookie[self.dateCookieName]=date
        response.simpleCookie[self.dateCookieName]['path']='/'
        response.simpleCookie[self.dateCookieName]['max-age']=31536000
        response.simpleCookie[self.dateCookieName]['version']=1
        response.simpleCookie[self.passwordCookieName]=password
        response.simpleCookie[self.passwordCookieName]['path']='/'
        response.simpleCookie[self.passwordCookieName]['max-age']=31536000
        response.simpleCookie[self.passwordCookieName]['version']=1
        response.headerMap['location']=fromPage
        response.headerMap['status']=302
        return "<html><body>Nobody should see that</body></html>"
    def doLogout(self):
        response.simpleCookie[self.passwordCookieName]=""
        response.simpleCookie[self.passwordCookieName]['path']='/'
        response.simpleCookie[self.passwordCookieName]['max-age']=0
        response.simpleCookie[self.passwordCookieName]['version']=1
        response.headerMap['location']=self.getPath()+'/logoutScreen'
        response.headerMap['status']=302
        self.login=""
        return ""
    def logoutScreen(self):
        return self.loginScreen("You have been logged out", self.getPath()+'/index')
    def loginScreen(self, message, fromPage, login=''):
        _page=[]
        _page.append("""<html><body>
    Message: """)
        _page.append(str(message))
        _page.append("""
    <form method="post" action=\"""")
        _page.append(str(self.getPath()+'/doLogin'))
        _page.append("""\">
        Login: <input type=text name=login value=\"""")
        _page.append(str(login))
        _page.append("""\" length=10><br>
        Password: <input type=password name=password length=10><br>
        <input type=hidden name=fromPage value=\"""")
        _page.append(str(fromPage))
        _page.append("""\"><br>
        <input type=submit>
    </form>
</body></html>
""")
        return "".join(_page)
global CookieSessionAuthenticate
class CookieSessionAuthenticate:
    timeoutMessage="Session timed out"
    wrongLoginPasswordMessage="Wrong login/password"
    noCookieMessage="No cookie"
    logoutMessage="You have been logged out"
    sessionIdCookieName="CherrySessionId"
    timeout=60 # in minutes
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cookieSessionAuthenticate"
        else:
            return "/cookieSessionAuthenticate"
    def checkLoginAndPassword(self, login, password):
        if (login,password)==('login','password'): return ''
        return 'Wrong login/password'
    def whoIsLoggedIn(self):
        print 'CherryWarning: whoIsLoggedIn is deprecated: use "request.login" instead'
        return request.login
    def _generateSessionId(self, sessionIdList):
        choice="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
        while 1:
            _sessionId=""
            for dummy in range(20): _sessionId+=whrandom.choice(choice)
            if _sessionId not in sessionIdList: return _sessionId
    def doLogin(self, login, password, fromPage):
        errorMsg = self.checkLoginAndPassword(login, password)
        if errorMsg:
            request.login = ''
            return self.loginScreen(errorMsg, fromPage, login)
        request.login = login
        _newSessionId=self._generateSessionId(request.sessionMap.keys())
        request.sessionMap[_newSessionId]=login,time.time()+self.timeout*60
        response.simpleCookie[self.sessionIdCookieName]=_newSessionId
        response.simpleCookie[self.sessionIdCookieName]['path']='/'
        response.simpleCookie[self.sessionIdCookieName]['max-age']=31536000
        response.simpleCookie[self.sessionIdCookieName]['version']=1
        response.headerMap['location']=fromPage
        response.headerMap['status']=302
        return "<html><body>Nobody should see that</body></html>"
    def doLogout(self):
        try:
            _sessionId=request.simpleCookie[self.sessionIdCookieName].value
            del request.sessionMap[_sessionId]
        except: pass
        response.simpleCookie[self.sessionIdCookieName]=""
        response.simpleCookie[self.sessionIdCookieName]['path']='/'
        response.simpleCookie[self.sessionIdCookieName]['max-age']=0
        response.simpleCookie[self.sessionIdCookieName]['version']=1
        response.headerMap['location']=self.getPath().replace('/root','')+'/logoutScreen'
        response.headerMap['status']=302
        request.login = ''
        return ""
    def logoutScreen(self):
        return self.loginScreen(self.logoutMessage, self.getPath()+'/index')
    def loginScreen(self, message, fromPage, login=''):
        _page=[]
        _page.append("""<html><body>
    Message: """)
        _page.append(str(message))
        _page.append("""
    <form method="post" action="doLogin">
        Login: <input type=text name=login value=\"""")
        _page.append(str(login))
        _page.append("""\" length=10><br>
        Password: <input type=password name=password length=10><br>
        <input type=hidden name=fromPage value=\"""")
        _page.append(str(fromPage))
        _page.append("""\"><br>
        <input type=submit>
    </form>
</body></html>
""")
        return "".join(_page)
global Mail
class Mail:
    smtpPort = ''
    smtpServer = 'localhost'
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/mail"
        else:
            return "/mail"
    def sendMail(self, sender, receiver, bcc, contentType, subject, msg):
        if self.smtpPort:
            server = smtplib.SMTP(self.smtpServer, self.smtpPort)
        else:
            server = smtplib.SMTP(self.smtpServer)
        server.set_debuglevel(0)
        date=time.strftime('%a, %d %b %Y %H:%M:%S', time.localtime())
        msg="To: %s\r\nFrom: %s\r\nSubject: %s\r\nContent-type: %s\r\nDate: %s\r\n\r\n"%(receiver, sender, subject, contentType, date)+msg
        if bcc: receiver=(receiver, bcc)
        server.sendmail(sender, receiver, msg)
        server.quit()
    def sendHtmlMail(self, sender, receiver, bcc, subject, txtmsg, htmlmsg):
        if self.smtpPort:
            server = smtplib.SMTP(self.smtpServer, self.smtpPort)
        else:
            server = smtplib.SMTP(self.smtpServer)
        server.set_debuglevel(0)
        newmsg = self.createhtmlmail(htmlmsg, txtmsg, subject, receiver, sender)
        if bcc: receiver=(receiver, bcc)
        server.sendmail(sender, receiver, newmsg)
        server.quit()
    def createhtmlmail(self, html, text, subject, sender, submit_by):
        import MimeWriter
        import mimetools
        import cStringIO
        import time
        Date=time.strftime('%a, %d %b %Y %H:%M:%S', time.localtime())
        out = cStringIO.StringIO() # output buffer for our message
        htmlin = cStringIO.StringIO(html)
        txtin = cStringIO.StringIO(text)
        writer = MimeWriter.MimeWriter(out)
        writer.addheader("Subject", subject)
        writer.addheader("Date", Date)
        writer.addheader("From", sender)
        writer.addheader("To", submit_by)
        writer.addheader("MIME-Version", "1.0")
        writer.startmultipartbody("alternative")
        writer.flushheaders()
        subpart = writer.nextpart()
        subpart.addheader("Content-Transfer-Encoding", "quoted-printable")
        pout = subpart.startbody("text/html", [("charset", 'us-ascii')])
        mimetools.encode(htmlin, pout, 'quoted-printable')
        htmlin.close()
        subpart = writer.nextpart()
        subpart.addheader("Content-Transfer-Encoding", "quoted-printable")
        pout = subpart.startbody("text/plain", [("charset", 'us-ascii')])
        mimetools.encode(txtin, pout, 'quoted-printable')
        txtin.close()
        writer.lastpart()
        msg = out.getvalue()
        out.close()
        return msg
global CherryObjectsWeb
class CherryObjectsWeb(HttpAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryObjectsWeb"
        else:
            return "/cherryObjectsWeb"
    def getPasswordListForLogin(self, login):
        return 1
    def action(self, objectType, action, **kw):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        ot=globals()[objectType]
        return getattr(ot, action)(**kw)
    def index(self):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        request.sessionMap['index']=self.getPath()
        _page.append("""
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(CherryObjects.objectsTypeMap.keys())-1
        except TypeError: _end=-1
        for objectType in CherryObjects.objectsTypeMap.keys():
            _index+=1
            _page.append("""
    <b>""")
            _page.append(str(objectType))
            _page.append("""</b>:
    <a href=\"""")
            _page.append(str('%s/viewAllObjects'%objectType))
            _page.append("""\">View/Update</a>&nbsp;&nbsp;
    <a href=\"""")
            _page.append(str('%s/addObject'%objectType))
            _page.append("""\">Add</a><br>
""")
        _index=_index8
        _end=_end8
        _page.append("""
""")
        return "".join(_page)
global CherryObjectTypeWeb
class CherryObjectTypeWeb(CherryObjects.CherryObjectType,HttpAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryObjectTypeWeb"
        else:
            return "/cherryObjectTypeWeb"
    def getPasswordListForLogin(self, login):
        return 1
    def setTuneMapItem(self, tuneMap, fieldName, propertyName, propertyValue):
        if not tuneMap.has_key(fieldName): tuneMap[fieldName]={}
        tuneMap[fieldName][propertyName]=propertyValue
    def getTuneMapItem(self, tuneMap, fieldName, propertyName, default=None):
        try: return tuneMap[fieldName][propertyName]
        except KeyError:
            try: return self.tuneMap[fieldName][propertyName]
            except KeyError: return default
    def renderFields(self, object, formTuneMap):
        fieldOrder=self.getTuneMapItem(formTuneMap, "global", "fieldOrder", [])
        for fieldName, fieldType in self.fieldMap.items()+[("submit","submit")]:
            if "field "+fieldName not in fieldOrder:
                fieldOrder.append("field "+fieldName)
        res=""
        for fieldName in fieldOrder:
            if fieldName[:6]=="field ": res+=self.renderField(object, fieldName[6:], formTuneMap)
            else: res+=fieldName
        return res
    def renderField(self, object, fieldName, formTuneMap):
        if fieldName=="submit":
            label=self.getTuneMapItem(formTuneMap, fieldName, "label", fieldName)
            mask=self.getTuneMapItem(formTuneMap, fieldName, "mask", self.defaultFieldMask)
            extraArgMap=self.getTuneMapItem(formTuneMap, fieldName, "extraArgMap", {})
            return mask(*(label, "submit", "", "submit", "", "", extraArgMap))
        fieldType=self.fieldMap[fieldName]
        hidden=0
        if fieldType[-9:]==" linkBack":
            fieldType=fieldType[:-9]
            hidden=1
        if hasattr(object, fieldName): fieldValue=getattr(object, fieldName)
        else: fieldValue=None
        fieldValue=CherryObjects.encodeValue(fieldType, fieldValue)
        label=self.getTuneMapItem(formTuneMap, fieldName, "label", fieldName)
        error=self.getTuneMapItem(formTuneMap, fieldName, "error", "")
        mask=self.getTuneMapItem(formTuneMap, fieldName, "mask", self.defaultFieldMask)
        optionList=[]
        if fieldType in ("string", "float"):
            typ="text"
        elif fieldType=="text":
            typ="textarea"
        elif fieldType=="boolean":
            typ="checkbox"
            optionList=[('1', '')]
        elif fieldType.find("link to ")==0:
            typ="select"
            objectName=fieldType.split()[-1].split('.')[0]
            optionList=globals()[objectName].getAllObjectsIdsAndLabels()
        elif fieldType.find("list of links to ")==0:
            typ="checkbox"
            objectName=fieldType.split()[-1].split('.')[0]
            optionList=globals()[objectName].getAllObjectsIdsAndLabels()
        else: raise "ERROR: fieldType not implemented: %s"%fieldType
        newOptionList=self.getTuneMapItem(formTuneMap, fieldName, "optionList", None)
        if newOptionList!=None:
            newOptionList=CherryObjects.encodeValue(fieldType, newOptionList)
            optionList=newOptionList
        extraArgMap=self.getTuneMapItem(formTuneMap, fieldName, "extraArgMap", {})
        if hidden: return self.hiddenMask('', fieldName, fieldValue, '', '', '', '')
        return mask(*(label, fieldName, fieldValue, typ, error, optionList, extraArgMap))
    def hiddenMask(self, label, name, fieldValue, typ, error, optionList, extraArgMap):
        if type(fieldValue)!=type([]): fieldValue=[fieldValue]
        res=""
        for fv in fieldValue:
            res+='<input type=hidden name="%s" value="%s">'%(name, fv)
        return res
    def displayMask(self, label, name, fieldValue, typ, error, optionList, extraArgMap):
        return '<input type=hidden name="%s" value="%s">%s %s<br>'%(name, fieldValue, label, fieldValue)
    def defaultFieldMask(self, label, name, fieldValue, typ, error, optionList, extraArgMap):
        res=label+' '
        if typ=='text':
            res+='<input name="%s" type=text value="%s">'%(name, fieldValue)
        if typ=='textarea':
            res+='<textarea name="%s" rows=10 cols=80>%s</textarea>'%(name, fieldValue)
        elif typ=='select':
            res+='<select name="%s">'%name
            for optionId, optionLabel in optionList:
                if optionId==fieldValue: res+="<option selected value=%s>%s</option>"%(optionId, optionLabel)
                else: res+="<option value=%s>%s</option>"%(optionId, optionLabel)
            res+='</select>'
        elif typ in ('checkbox','radio'):
            for optionId, optionLabel in optionList:
                res+='<input type="%s" name="%s" value="%s"'%(typ, name, optionId)
                if type(fieldValue)==type([]):
                    if optionId in fieldValue: res+=' checked'
                else:
                    if optionId==fieldValue: res+=' checked'
                res+='>&nbsp;&nbsp;%s<br>'%optionLabel
        elif typ=="submit":
            return "<input type=submit value='%s'>"%label
        if error:
            res+="&nbsp;<font color=red>"+error+"</font>"
        return res+"<br>"
    def displayValue(self, fieldType, value):
        i=fieldType.find(" linkBack")
        if i!=-1: fieldType=fieldType[:i]
        if fieldType in ("string", "text", "float"):
            if not value: return ''
            return tools.escapeHtml(str(value))
        elif fieldType=="boolean":
            if not value: return "False"
            return "True"
        elif fieldType.find("link to ")==0:
            if not value: return ""
            objectName=fieldType.split()[-1].split('.')[0]
            object=value
            try: evalLabel=globals()[objectName].tuneMap["global"]["label"]
            except KeyError: evalLabel="object.name"
            return "->"+eval(evalLabel)
        elif fieldType.find("list of links to ")==0:
            if not value: return []
            objectName=fieldType.split()[-1].split('.')[0]
            if type(value)!=type([]): value=[value]
            res=[]
            for item in value: res.append(self.displayValue("link to "+objectName, item))
            return res
        else: raise "ERROR: fieldType not implemented: %s"%fieldType
    def editObjectFormAction(self, **kw):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        object=CherryObjects.CherryObject()
        formTuneMap=request.sessionMap['formTuneMap']
        globalError, hasError=0,0
        for fieldName, fieldType in self.fieldMap.items():
            fieldValue=kw.get(fieldName, None)
            fieldValue=CherryObjects.decodeValue(fieldType, fieldValue)
            setattr(object, fieldName, fieldValue)
        if kw.has_key('id'): object.id=int(kw['id'])
        validateFuncList=self.getTuneMapItem(formTuneMap, "global", "validate")
        if validateFuncList:
            if type(validateFuncList)!=type([]): validateFuncList=[validateFuncList]
            for validateFunc in validateFuncList:
                globalError=validateFunc(object)
                if globalError: hasError=1
        for fieldName in self.fieldMap.keys():
            fieldValue=kw.get(fieldName, None)
            validateFuncList=self.getTuneMapItem(formTuneMap, fieldName, "validate")
            error=""
            if validateFuncList:
                if type(validateFuncList)!=type([]): validateFuncList=[validateFuncList]
                for validateFunc in validateFuncList:
                    error=validateFunc(*(object, fieldName, formTuneMap))
            self.setTuneMapItem(formTuneMap, fieldName, "error", error)
            if error: hasError=1
        self.setTuneMapItem(formTuneMap, "global", "error", globalError)
        self.setTuneMapItem(formTuneMap, "global", "hasError", hasError)
        self.setTuneMapItem(formTuneMap, "global", "object", object)
        if hasError: url=CherryObjects.addToUrl(formTuneMap['global']['errorUrl'], 'hasError', '1')
        else:
            print "self:", self, self == message
            self.saveObject(object)
            url=formTuneMap['global']['okUrl']
        response.headerMap['status']=302
        response.headerMap['location']=url
        return ""
    def viewAllObjects(self):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        objectList=self.getObjects()
        return self.viewObjectList(objectList)
    def editObject(self, objectId=0, hasError=0):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        res=""
        if not hasError:
            object=self.getObjectById(objectId)
        else:
            error=self.getTuneMapItem(request.sessionMap['formTuneMap'], "global", "error")
            res="<font color=red><b>Please correct the errors</b></font><br><br>"
            if error: res+="<font color=red>%s</font><br><br>"%error
            object=None
        return res+self.editObjectForm(object, hasError, request.sessionMap['index'], 'editObject')
    def addObject(self, hasError=0):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        res=""
        if not hasError:
            object=CherryObjects.CherryObject()
        else:
            error=self.getTuneMapItem(request.sessionMap['formTuneMap'], "global", "error")
            res="<font color=red><b>Please correct the errors</b></font><br><br>"
            if error: res+="<font color=red>%s</font><br><br>"%error
            object=None
        return res+self.editObjectForm(object, hasError, request.sessionMap['index'], 'addObject')
    def deleteObject(self, objectId):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        object=self.getObjectById(objectId)
        self.removeObject(object)
        response.headerMap['status']=302
        response.headerMap['location']=request.sessionMap['index']
        return ""
    def viewObjectList(self, objectList, mask=None):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        if not mask: mask=self.defaultListMask
        _page.append("""
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(objectList)-1
        except TypeError: _end=-1
        for object in objectList:
            _index+=1
            _page.append("""
    """)
            _page.append(str(apply(mask, (object, _index, _end))))
            _page.append("""
""")
        _index=_index8
        _end=_end8
        _page.append("""
""")
        return "".join(_page)
    def defaultListMask(self, object, index, end):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        if index==0:
            _page.append("""
    <table border=1><tr>
    <th>id</th>
    """)
            _index12=locals().get("_index", -1)
            _end12=locals().get("_end", -1)
            _index=-1
            try: _end=len(self.fieldMap.items())-1
            except TypeError: _end=-1
            for fieldName, fieldType in self.fieldMap.items():
                _index+=1
                _page.append("""
        <th>""")
                _page.append(str(fieldName))
                _page.append("""</th>
    """)
            _index=_index12
            _end=_end12
            _page.append("""
    <th>Edit</th>
    <th>Delete</th>
    </tr>
""")
        _page.append("""
<tr>
<td>""")
        _page.append(str(object.id))
        _page.append("""</td>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(self.fieldMap.items())-1
        except TypeError: _end=-1
        for fieldName, fieldType in self.fieldMap.items():
            _index+=1
            _page.append("""
    """)
            print 'getattr(%s, %s)'%(object,fieldName), ':', getattr(object, fieldName)
            _page.append("""
    <td>""")
            _page.append(str(self.displayValue(fieldType, getattr(object,fieldName))))
            _page.append("""</td>
""")
        _index=_index8
        _end=_end8
        _page.append("""
<td><a href=\"""")
        _page.append(str('editObject?objectId=%s'%object.id))
        _page.append("""\">Edit</td>
<td><a href=\"""")
        _page.append(str('deleteObject?objectId=%s'%object.id))
        _page.append("""\">Delete</td>
</tr>
""")
        if index==end:
            _page.append("""
    </table>
""")
        _page.append("""
""")
        return "".join(_page)
    def editObjectForm(self, _object, hasError, okUrl, errorUrl, formTuneMap={}):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        if not hasError:
            request.sessionMap['formTuneMap']=formTuneMap
            self.setTuneMapItem(formTuneMap, "global", "hasError", 0)
            self.setTuneMapItem(formTuneMap, "global", "okUrl", okUrl)
            self.setTuneMapItem(formTuneMap, "global", "errorUrl", errorUrl)
            object=_object
        else:
            formTuneMap=request.sessionMap['formTuneMap']
            object=formTuneMap['global']['object']
        _page.append("""
<form method="post" name="cherryForm" action=\"""")
        _page.append(str(request.base+'/'+self.objectType+'/editObjectFormAction'))
        _page.append("""\">
""")
        if hasattr(object, 'id'):
            _page.append("""
    <input type=hidden name=id value=\"""")
            _page.append(str(object.id))
            _page.append("""\">
""")
        _page.append("""
""")
        _page.append(str(self.renderFields(object, formTuneMap)))
        _page.append("""
</form>
""")
        return "".join(_page)
global FormField
class FormField:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/formField"
        else:
            return "/formField"
    def __init__(self, label, name, typ, mask=None, mandatory=0, size=15, optionList=[], defaultValue='', defaultMessage='', validate=None):
        self.isField=1
        self.label=label
        self.name=name
        self.typ=typ
        if not mask: self.mask=defaultFormMask.defaultMask
        else: self.mask=mask
        self.mandatory=mandatory
        self.size=size
        self.optionList=optionList
        self.defaultValue=defaultValue
        self.defaultMessage=defaultMessage
        self.validate=validate
        self.errorMessage=""
    def render(self, leaveValues):
        if leaveValues:
            if self.typ!='submit':
                if request.paramMap.has_key(self.name): self.currentValue=request.paramMap[self.name]
                else: self.currentValue=""
            else: self.currentValue=self.defaultValue
        else:
            self.currentValue=self.defaultValue
            self.errorMessage=self.defaultMessage
        return self.mask(self)
global DefaultFormMask
class DefaultFormMask:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/defaultFormMask"
        else:
            return "/defaultFormMask"
    def defaultMask(self, field):
        res="<tr><td valign=top>%s</td>"%field.label
        if field.typ=='text':
            res+='<td><input name="%s" type=text value="%s" size=%s></td>'%(field.name, field.currentValue, field.size)
        elif field.typ=='forced':
            res+='<td><input name="%s" type=hidden value="%s">%s</td>'%(field.name, field.currentValue, field.currentValue)
        elif field.typ=='password':
            res+='<td><input name="%s" type=password value="%s"></td>'%(field.name, field.currentValue)
        elif field.typ=='select':
            res+='<td><select name="%s">'%field.name
            for option in field.optionList:
                if type(option)==type(()):
                    optionId, optionLabel=option
                    if optionId==field.currentValue or str(optionId)==field.currentValue: res+="<option selected value=%s>%s</option>"%(optionId, optionLabel)
                    else: res+="<option value=%s>%s</option>"%(optionId, optionLabel)
                else:
                    if option==field.currentValue: res+="<option selected>%s</option>"%option
                    else: res+="<option>%s</option>"%option
            res+='</select></td>'
        elif field.typ=='textarea':
            if field.size==15: size="15x15"
            else: size=field.size
            cols, rows=size.split('x')
            res+='<td><textarea name="%s" rows="%s" cols="%s">%s</textarea></td>'%(field.name, rows, cols, field.currentValue)
        elif field.typ=='submit':
            res+='<td><input type=submit value="%s"></td>'%field.name
        elif field.typ=='hidden':
            if type(field.currentValue)==type([]): currentValue=field.currentValue
            else: currentValue=[field.currentValue]
            res=""
            for value in currentValue:
                res+='<input name="%s" type=hidden value="%s">'%(field.name, value)
            return res
        elif field.typ=='checkbox' or field.typ=='radio':
            res+='<td>'
            for option in field.optionList:
                if type(option)==type(()): optionValue, optionLabel=option
                else: optionValue, optionLabel=option, option
                res+='<input type="%s" name="%s" value="%s"'%(field.typ, field.name, optionValue)
                if type(field.currentValue)==type([]):
                    if optionValue in field.currentValue: res+=' checked'
                else:
                    if optionValue==field.currentValue: res+=' checked'
                res+='>&nbsp;&nbsp;%s<br>'%optionLabel
            res+='</td>'
        if field.errorMessage:
            res+="<td><font color=red>%s</font></td>"%field.errorMessage
        else:
            res+="<td>&nbsp;</td>"
        return res+"</tr>"
    def hiddenMask(self, field):
            if type(field.currentValue)==type([]): currentValue=field.currentValue
            else: currentValue=[field.currentValue]
            res=""
            for value in currentValue:
                res+='<input name="%s" type=hidden value="%s">'%(field.name, value)
            return res
    def defaultHeader(self, label):
        return "<table>"
    def defaultFooter(self, label):
        return "</table>"
    def echoMask(self, label):
        return label
global FormSeparator
class FormSeparator:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/formSeparator"
        else:
            return "/formSeparator"
    def __init__(self, label, mask):
        self.isField=0
        self.label=label
        self.mask=mask
    def render(self, dummy):
        return self.mask(self.label)
global Form
class Form:
    method="post"
    enctype=""
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/form"
        else:
            return "/form"
    def formView(self, leaveValues=0):
        if self.enctype: enctypeTag='enctype="%s"'%self.enctype
        else: enctypeTag=""
        res='<form method="%s" %s action="%s/postForm">'%(self.method, enctypeTag, self.getPath())
        for field in self.fieldList:
            res+=field.render(leaveValues)
        return res+"</form>"
    def validateFields(self):
        pass
    def validateForm(self):
        for field in self.fieldList:
            if field.isField: field.errorMessage=""
        for field in self.fieldList:
            if field.isField and field.mandatory and (not request.paramMap.has_key(field.name) or not request.paramMap[field.name]): field.errorMessage="Missing"
        for field in self.fieldList:
            if field.isField and field.validate and not field.errorMessage:
                if request.paramMap.has_key(field.name): value=request.paramMap[field.name]
                else: value=""
                field.errorMessage=field.validate(value)
        self.validateFields()
        for field in self.fieldList:
            if field.isField and field.errorMessage: return 0
        return 1
    def setFieldErrorMessage(self, fieldName, errorMessage):
        for field in self.fieldList:
            if field.isField and field.name==fieldName: field.errorMessage=errorMessage
    def getFieldOptionList(self, fieldName):
        for field in self.fieldList:
            if field.isField and field.name==fieldName: return field.optionList
    def getFieldDefaultValue(self, fieldName):
        for field in self.fieldList:
            if field.isField and field.name==fieldName: return field.defaultValue
    def setFieldDefaultValue(self, fieldName, defaultValue):
        for field in self.fieldList:
            if field.isField and field.name==fieldName: field.defaultValue=defaultValue
    def getFieldNameList(self, exceptList=[]):
        fieldNameList=[]
        for field in self.fieldList:
            if field.isField and field.name and field.name not in exceptList: fieldNameList.append(field.name)
        return fieldNameList
global MaskTools
class MaskTools:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/maskTools"
        else:
            return "/maskTools"
    def x(self):
        return '<img src="%s/xData" width=1 height=1>'%self.getPath()
    def displayByColumn(self, dataList, numberOfColumns=2, columnWidth=0, gapWidth=50, tdClass=''):
        numberOfItems=len(dataList)
        itemsPerColumn=numberOfItems/numberOfColumns
        if numberOfColumns*itemsPerColumn<numberOfItems: itemsPerColumn+=1
        res="<table border=0 cellspacing=0 cellpadding=0><tr>"
        for i in range(numberOfColumns):
            res+="<td valign=top %s %s>"%(tools.getAttribute('width', columnWidth), tools.getAttribute('class', tdClass))
            for data in dataList[i*itemsPerColumn:(i+1)*itemsPerColumn]:
                res+=data+'<br>'
            res+="</td>"
            if gapWidth and i!=numberOfColumns-1: res+="<td width=%s>%s</td>"%(gapWidth, self.x())
        res+="</tr></table>"
        return res
    def displayByLine(self, dataList, numberOfLines=2, lineHeight=0, gapHeight=50, tdClass=''):
        numberOfItems=len(dataList)
        itemsPerLine=numberOfItems/numberOfLines
        if numberOfLines*itemsPerLine<numberOfItems: itemsPerLine+=1
        res="<table border=0 cellspacing=0 cellpadding=0>"
        for i in range(numberOfLines):
            res+="<tr><td align=left %s %s>"%(tools.getAttribute('height', lineHeight), tools.getAttribute('class', tdClass))
            for data in dataList[i*itemsPerLine:(i+1)*itemsPerLine]:
                res+=data+' '
            res+="</td></tr>"
            if gapHeight and i!=numberOfLines-1: res+="<tr><td height=%s>%s</td></tr>"%(gapHeight, self.x())
        res+="</table>"
        return res
    def sortedKeys(self,map):
        keys = map.keys()
        keys.sort()
        return keys
    def xData(self):
        response.headerMap['content-type']='image/gif'
        return 'GIF89a\x01\x00\x01\x00\x80\x00\x00\xff\xff\xff\x00\x00\x00!\xf9\x04\x01\x00\x00\x00\x00,\x00\x00\x00\x00\x01\x00\x01\x00\x00\x02\x02D\x01\x00;'
    def textInBox(self, text, boxColor="black", insideColor="white"):
        _page=[]
        _page.append("""<table border=0 cellspacing=0 cellpadding=1><tr><td bgColor=\"""")
        _page.append(str(boxColor))
        _page.append("""\">
    <table border=0 cellspacing=0 cellpadding=5><tr><td bgColor=\"""")
        _page.append(str(insideColor))
        _page.append("""\">""")
        _page.append(str(text))
        _page.append("""</td></tr></table>
</td></tr></table>
""")
        return "".join(_page)
    def prettyMap(self, aMap, label=None, isRecursiveCall=0):
        _page=[]
        _page.append(""" """)
        if not isRecursiveCall:
            _page.append("""
 <style>
 .prettyMap { background-color:#ccc; }
 .prettyMapHead { background-color:#fcc; }
 .prettyMapKeys { background-color:#eee; }
 .prettyMapValues { background-color:#fff; }
 .prettyMapSubMap { background-color:#fcc; }
 </style>
 """)
        _page.append("""
 <table width="100%" border="0" cellspacing="1" cellpadding="3" class="prettyMap">
     """)
        if label is not None:
            _page.append("""
    <tr width="100%" valign="top" align="left">
        <th align="left" colspan="2" width="100%" class="prettyMapHead">
            """)
            _page.append(str(label))
            _page.append("""
        </th>
    </tr>
    """)
        _page.append("""
    """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(self.sortedKeys(aMap))-1
        except TypeError: _end=-1
        for key in self.sortedKeys(aMap):
            _index+=1
            _page.append("""
    <tr width="100%" valign="top" align="left" class="prettyMapValues">
        <td width="20%" class="prettyMapKeys">""")
            _page.append(str(key))
            _page.append("""</td>
        """)
            if type(aMap[key])==types.DictType:
                _page.append("""
        <td width="80%" class="prettyMapSubMap">
            """)
                _page.append(str(self.prettyMap(aMap[key],isRecursiveCall=1)))
                _page.append("""
        </td>
        """)
            else:
                _page.append("""
        <td width="80%">""")
                _page.append(str(aMap[key]))
                _page.append("""</td>
        """)
            _page.append("""
    </tr>
    """)
        _index=_index8
        _end=_end8
        _page.append("""
</table>
""")
        return "".join(_page)
global CherryForumAdmin
class CherryForumAdmin(CherryObjectsWeb):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryForumAdmin"
        else:
            return "/cherryForumAdmin"
global CherryForum
class CherryForum:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryForum"
        else:
            return "/cherryForum"
    def normalize(self, s):
        newS=""
        for c in s.lower():
            if '0'<=c<='9' or 'a'<=c<='z': newS+=c
            else: newS+=" "
        return newS
    def isKeywordListInString(self, keywordList, str_):
        str_=self.normalize(str_)
        for keyword in keywordList:
            if str_.find(keyword)==-1: return 0
        return 1
    def searchKeywordList(self, keywordList):
        res=[]
        for threadObj in thread.getObjects():
            if self.isKeywordListInString(keywordList, threadObj.subject):
                res.append(threadObj)
        for messageObj in message.getObjects():
            if self.isKeywordListInString(keywordList, messageObj.text):
                res.append(messageObj.thread)
        return res
    def checkEmailAndNotice(self, object, *kw):
        if object.sendNotice and not object.email: return "Missing"
        if object.email:
            try:
                a,b=object.email.split('@')
                if b.find('.') == -1: raise "error"
            except: return "Wrong email"
    def index(self):
        _page=[]
        _page.append(str(self.template.header()))
        _page.append("""
    """)
        objectList=forum.getObjects()
        CherryObjects.sortOnAttribute(objectList, 'order')
        _page.append("""
    """)
        _page.append(str(forum.viewObjectList(objectList, self.forumListMask)))
        _page.append("""
""")
        _page.append(str(self.template.footer()))
        _page.append("""
""")
        return "".join(_page)
    def search(self, keywordList=""):
        _page=[]
        _page.append(str(self.template.header()))
        _page.append("""
""")
        _page.append(str(self.template.navigationBar('search')))
        _page.append("""
<br>
""")
        _page.append(str(self.template.title('Search:')))
        _page.append("""
<form action=\"""")
        _page.append(str(self.getPath()+'/search'))
        _page.append("""\">
<center>
Keyword(s): <input type=text name=keywordList value=\"""")
        _page.append(str(keywordList))
        _page.append("""\">
<input type=submit value=OK>
</center>
</form>
""")
        _keywordList=self.normalize(keywordList).split()
        _page.append("""
""")
        if _keywordList:
            _page.append("""
    """)
            threadList=self.searchKeywordList(_keywordList)
            _page.append("""
    """)
            _page.append(str(self.template.title('%s thread(s) found for keyword(s) %s%s%s:'%(len(threadList), chr(34), keywordList, chr(34)))))
            _page.append("""
    """)
            _page.append(str(self.template.searchResultHeader()))
            _page.append("""
    """)
            _index12=locals().get("_index", -1)
            _end12=locals().get("_end", -1)
            _index=-1
            try: _end=len(threadList)-1
            except TypeError: _end=-1
            for threadObj in threadList:
                _index+=1
                _page.append("""
        """)
                _page.append(str(self.template.searchResultObject(threadObj)))
                _page.append("""
    """)
            _index=_index12
            _end=_end12
            _page.append("""
    """)
            _page.append(str(self.template.searchResultFooter()))
            _page.append("""
""")
        _page.append("""
""")
        _page.append(str(self.template.footer()))
        _page.append("""
""")
        return "".join(_page)
    def viewForum(self, forumId, msg="", page=0):
        _page=[]
        _page.append(str(self.template.header()))
        _page.append("""
""")
        pageSize = 30
        forumObj=forum.getObjectById(forumId)
        threadList=forumObj.threadList
        CherryObjects.sortOnAttribute(threadList, 'creationDate', reverse=1)
        pageThreadList = threadList[pageSize * int(page):pageSize * (int(page) + 1)]
        _page.append("""
""")
        _page.append(str(self.template.navigationBar('viewForum', forumObj)))
        _page.append("""
""")
        _page.append(str(self.template.forumHeader(forumObj)))
        _page.append("""
""")
        if msg:
            _page.append("""
    <center><font color="red"><b>""")
            _page.append(str(msg))
            _page.append("""</b></center></font><br><br>
""")
        _page.append("""
""")
        _page.append(str(message.viewObjectList(pageThreadList, self.threadListMask)))
        _page.append("""
""")
        _page.append(str(self.template.previousNextPage(int(page), pageSize, len(threadList), forumId)))
        _page.append("""
""")
        _page.append(str(self.template.footer()))
        _page.append("""
""")
        return "".join(_page)
    def newThread(self, forumId, hasError=0, validate=0):
        _page=[]
        forumObj=forum.getObjectById(forumId)
        if validate:
            formTuneMap=request.sessionMap['formTuneMap']
            messageObj=formTuneMap['global']['object']
            threadList=forumObj.threadList
            CherryObjects.sortOnAttribute(threadList, 'creationDate', reverse=1)
            lastThread = threadList[0]
            if lastThread.subject == messageObj.dummySubject:
                return self.viewForum(forumId=forumId, msg="The thread had already been added")
            threadObj=thread.newObject(subject=messageObj.dummySubject, forum=forumObj, views=0, creationDate=tools.getNow())
            messageObj.thread=threadObj
            message.saveObject(messageObj)
            mailSubject='Someone started a new thread "%s"'%threadObj.subject
            mailBody='Hello,\n\n'
            mailBody+='someone started a new thread "%s"\n'%threadObj.subject
            mailBody+='To view this thread, click on the following link:\n'
            mailBody+='%s/viewThread?threadId=%s\n\n'%(self.getPath(), threadObj.id)
            mailBody+='PS: You are receiving this message because you asked to be notified whenever someone posted a reply to this thread'
            if configFile.get("forum", "sendAdminNotice")=="1":
                myMail.sendMail("forumAdmin@cherrypy.org", "remi@cherrypy.org", "", "text/plain", mailSubject, mailBody)
            return self.viewForum(forumId=forumId, msg="The new thread has been added")
        _page.append("""
""")
        _page.append(str(self.template.header()))
        _page.append("""
""")
        _page.append(str(self.template.navigationBar('newThread')))
        _page.append("""
""")
        _page.append(str(self.template.forumHeader(forumObj)))
        _page.append("""
""")
        _page.append(str(self.template.title('Start a new thread:')))
        _page.append("""
""")
        messageObj=CherryObjects.CherryObject()
        messageObj.date=tools.getNow()
        tuneMap={
            "thread": {"mask": thread.hiddenMask},
            "date": {"mask": thread.hiddenMask},
            "dummySubject": {
                "mask": self.template.fieldMask,
                "label": "Subject:",
                "validate": CherryObjects.notEmpty},
            "name": {
                "mask": self.template.fieldMask,
                "label": "Your name:"
            },
            "email": {
                "mask": self.template.fieldMask,
                "label": "Your email (optional):",
                "validate": self.checkEmailAndNotice
            },
            "sendNotice": {
                "mask": self.template.fieldMask,
                "label": "Notify me by e-mail when<br>someone posts a reply:"
            },
            "text": {"mask": self.template.textareaMask},
            "submit": {"mask": self.template.submitMask},
            "global": {"fieldOrder": [
                self.template.formHeader(),
                "field name", "field email", "field sendNotice", "field dummySubject",
                self.template.formSeparator(),
                "field text", "field submit",
                self.template.formFooter()]}
        }
        _page.append("""
""")
        if hasError:
            _page.append("""
    <center><font color=red><b>Please correct the errors below</b></font></center><br><br>
""")
        _page.append("""
""")
        _page.append(str(message.editObjectForm(messageObj, hasError, self.getPath()+'/newThread?forumId='+forumId+'&validate=1', self.getPath()+'/newThread?forumId='+forumId, tuneMap)))
        _page.append("""
""")
        _page.append(str(self.template.footer()))
        _page.append("""
""")
        return "".join(_page)
    def viewThread(self, threadId, hasError=0, validate=0):
        _page=[]
        _page.append(str(self.template.header()))
        _page.append("""
""")
        threadObj=thread.getObjectById(threadId)
        threadObj.views+=1
        thread.saveObject(threadObj)
        messageList=threadObj.messageList
        CherryObjects.sortOnAttribute(messageList, 'date')
        _page.append("""
""")
        _page.append(str(self.template.navigationBar('viewThread', threadObj.forum)))
        _page.append("""
""")
        _page.append(str(self.template.forumHeader(threadObj.forum)))
        _page.append("""
""")
        if hasError:
            _page.append("""
    <center><font color=red><b>Please correct the errors below</b></font></center><br><br>
""")
        _page.append("""
""")
        if validate:
            _page.append("""
    <center><font color=red><b>Your comment has been added</b></font></center><br><br>
    """)
            mailSubject='Someone posted a reply to the thread "%s"'%threadObj.subject
            mailBody='Hello,\n\n'
            mailBody+='someone posted a reply to the thread "%s"\n'%threadObj.subject
            mailBody+='To view this thread, click on the following link:\n'
            mailBody+='%s/viewThread?threadId=%s\n\n'%(self.getPath(), threadId)
            mailBody+='PS: You are receiving this message because you asked to be notified whenever someone posted a reply to this thread'
            if configFile.get("forum", "sendAdminNotice")=="1":
                myMail.sendMail("forumAdmin@cherrypy.org", "remi@cherrypy.org", "", "text/plain", mailSubject, mailBody)
            if configFile.get("forum", "sendNotice")=="1":
                sendEmailList=[] # To avoid sending 2 e-mails to someone
                messageObj=request.sessionMap['formTuneMap']['global']['object']
                myEmail=messageObj.email.lower()
                for messageObj in threadObj.messageList:
                    if messageObj.sendNotice==1 and messageObj.email.lower()!=myEmail and messageObj.email.lower() not in sendEmailList:
                        try: myMail.sendMail("forumAdmin@cherrypy.org", messageObj.email, "remi@cherrypy.org", "text/plain", mailSubject, mailBody)
                        except: pass
                        sendEmailList.append(messageObj.email.lower())
            _page.append("""
""")
        _page.append("""
""")
        _page.append(str(message.viewObjectList(messageList, self.messageListMask)))
        _page.append("""
<br>
""")
        _page.append(str(self.template.title('Post a reply:')))
        _page.append("""
""")
        messageObj=CherryObjects.CherryObject()
        messageObj.date=tools.getNow()
        messageObj.thread=threadObj
        subject=self.template.fieldMask("Subject:", "dummy", "Re: "+messageObj.thread.subject, "display", "", "", "")
        tuneMap={
            "thread": {"mask": thread.hiddenMask},
            "date": {"mask": thread.hiddenMask},
            "dummySubject": {"mask": thread.hiddenMask},
            "name": {
                "mask": self.template.fieldMask,
                "label": "Your name:"
            },
            "email": {
                "mask": self.template.fieldMask,
                "label": "Your email (optional):",
                "validate": self.checkEmailAndNotice
            },
            "sendNotice": {
                "mask": self.template.fieldMask,
                "label": "Notify me by e-mail when<br>someone posts a reply:"
            },
            "text": {"mask": self.template.textareaMask},
            "submit": {"mask": self.template.submitMask},
            "global": {"fieldOrder": [
                self.template.formHeader(),
                "field name", "field email", "field sendNotice",
                subject, self.template.formSeparator(),
                "field text", "field submit",
                self.template.formFooter()]}
        }
        _page.append("""
""")
        _page.append(str(message.editObjectForm(messageObj, hasError, self.getPath()+'/viewThread?threadId='+threadId+'&validate=1', self.getPath()+'/viewThread?threadId='+threadId, tuneMap)))
        _page.append("""
""")
        _page.append(str(self.template.footer()))
        _page.append("""
""")
        return "".join(_page)
    def messageListMask(self, object, index, end):
        _page=[]
        if index==0:
            _page.append("""
    """)
            _page.append(str(self.template.messageListHeader(object)))
            _page.append("""
""")
        _page.append("""
""")
        _page.append(str(self.template.messageListObject(object, index)))
        _page.append("""
""")
        if index==end:
            _page.append("""
    """)
            _page.append(str(self.template.messageListFooter()))
            _page.append("""
""")
        _page.append("""
""")
        return "".join(_page)
    def forumListMask(self, object, index, end):
        _page=[]
        if index==0:
            _page.append("""
    """)
            _page.append(str(self.template.forumListHeader()))
            _page.append("""
""")
        _page.append("""
""")
        threadList=object.threadList
        if not threadList:
            lastPost="&nbsp;"
            messageList=[]
        else:
            messageList=[]
            for thread in threadList: messageList+=thread.messageList
            CherryObjects.sortOnAttribute(messageList, 'date')
            if not messageList: lastPost="&nbsp;"
            else: lastPost=messageList[-1].date
        _page.append("""
""")
        _page.append(str(self.template.forumListObject(object, messageList, threadList, lastPost)))
        _page.append("""
""")
        if index==end:
            _page.append("""
    """)
            _page.append(str(self.template.forumListFooter()))
            _page.append("""
""")
        _page.append("""
""")
        return "".join(_page)
    def threadListMask(self, object, index, end):
        _page=[]
        if index==0:
            _page.append("""
    """)
            _page.append(str(self.template.threadListHeader(object)))
            _page.append("""
""")
        _page.append("""
""")
        messageList=object.messageList
        CherryObjects.sortOnAttribute(messageList, 'date')
        lastPost=messageList[-1].date
        _page.append("""
""")
        _page.append(str(self.template.threadListObject(object, lastPost)))
        _page.append("""
""")
        if index==end:
            _page.append("""
    """)
            _page.append(str(self.template.threadListFooter()))
            _page.append("""
""")
        _page.append("""
""")
        return "".join(_page)
global MyMail
class MyMail(Mail):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/myMail"
        else:
            return "/myMail"
    def __init__(self):
        self.smtpServer=configFile.get("mail","smtpServer")
global CherryPyForumDesign
class CherryPyForumDesign:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryPyForumDesign"
        else:
            return "/cherryPyForumDesign"
    def fieldMask(self, label, name, fieldValue, typ, error, optionList, extraArgMap):
        res='<tr><td class=moduleText>%s</td><td valign=top class=moduleText>'%label
        if typ=='text':
            res+='<input name="%s" type=text value="%s">'%(name, fieldValue)
        elif typ=='display':
            res+='<input name="%s" type=hidden value="%s">%s'%(name, fieldValue, fieldValue)
        elif typ=='select':
            res+='<select name="%s">'%name
            for optionId, optionLabel in optionList:
                if optionId==fieldValue: res+="<option selected value=%s>%s</option>"%(optionId, optionLabel)
                else: res+="<option value=%s>%s</option>"%(optionId, optionLabel)
            res+='</select>'
        elif typ in ('checkbox','radio'):
            for optionId, optionLabel in optionList:
                res+='<input type="%s" name="%s" value="%s"'%(typ, name, optionId)
                if type(fieldValue)==type([]):
                    if optionId in fieldValue: res+=' checked'
                else:
                    if optionId==fieldValue: res+=' checked'
                res+='>&nbsp;&nbsp;%s<br>'%optionLabel
        if error:
            res+="&nbsp;<font color=red>"+error+"</font>"
        return res+"</td></tr>"
    def cookText(self, text):
        text=text.replace('\r\n','\n')
        while text and text[-1] in ('\n', '\r'): text=text[:-1]
        text=tools.escapeHtml(text)
        i=0
        while 1:
            i=text.find('http://', i)
            if i==-1: break
            j=text.find('&nbsp;',i+1)
            k=text.find(' ', i+1)
            l=text.find('<br>', i+1)
            if j==-1: j=len(text)
            if k==-1: k=len(text)
            if l==-1: l=len(text)
            j=min([j,k,l])
            link=text[i:j]
            linkTag='<a class=moduleLink href="%s">%s</a>'%(link,link)
            text=text[:i]+linkTag+text[j:]
            i+=len(linkTag)
        return text
    def header(self):
        _page=[]
        _page.append("""<html><head><title>CherryPy Forum</title>
<style type="text/css">
<!--
.moduleTitle {font-size:14px; font-weight:bold; color:white; font-family:arial}
.moduleLink {font-size:12px; color:#BD1E26; font-family:arial}
.moduleLink:hover {font-size:12px; color:red; font-family:arial}
.moduleText {font-size:12px; color:black; font-family:arial}
-->
</style>
</head>
<body>
""")
        return "".join(_page)
    def footer(self):
        _page=[]
        _page.append("""</body></html>
""")
        return "".join(_page)
    def title(self, title):
        _page=[]
        _page.append("""<b>""")
        _page.append(str(title))
        _page.append("""</b><br><br>
""")
        return "".join(_page)
    def previousNextPage(self, page, pageSize, totalCount, forumId):
        _page=[]
        if totalCount <= pageSize: return ""
        pageCount = (totalCount - 1) / pageSize + 1
        _page.append("""
<br>
<table border=0 cellspacing=0 cellpadding=0 width=100%><tr>
<td align=left>
    &nbsp;
    """)
        if page != 0:
            _page.append("""
        <a class=moduleLink href=\"""")
            _page.append(str('viewForum?forumId=%s&page=%s' % (forumId, page-1)))
            _page.append("""\">&lt;&lt; Previous page</a>
    """)
        _page.append("""
</td>
<td align=right>
    """)
        if page < pageCount - 1:
            _page.append("""
        <a class=moduleLink href=\"""")
            _page.append(str('viewForum?forumId=%s&page=%s' % (forumId, page+1)))
            _page.append("""\">Next page &gt;&gt;</a>
    """)
        _page.append("""
    &nbsp;
</td>
</tr></table>
""")
        return "".join(_page)
    def navigationBar(self, page, forumObj=None):
        _page=[]
        _page.append("""<table border=0 cellspacing=0 cellpadding=1 width=100%><tr>
    <td width=20% bgcolor=#BD1E26 align=left class=moduleTitle>&nbsp;Goto:</td>
    <td width=80% bgcolor=#FFCCCC class=moduleText>&nbsp;&nbsp;&nbsp;&nbsp;
        <a class=moduleLink href="index">Forum List</a>
        """)
        if page=='viewForum':
            _page.append("""
            &nbsp;&nbsp;&bull;&nbsp;&nbsp;
            <a class=moduleLink href=\"""")
            _page.append(str('newThread?forumId=%s'%forumObj.id))
            _page.append("""\">New Thread</a>
        """)
        _page.append("""
        """)
        if page=='viewThread':
            _page.append("""
            &nbsp;&nbsp;&bull;&nbsp;&nbsp;
            <a class=moduleLink href=\"""")
            _page.append(str('viewForum?forumId=%s'%forumObj.id))
            _page.append("""\">Thread List</a>
        """)
        _page.append("""
    </td>
</tr></table>
""")
        return "".join(_page)
    def forumListHeader(self):
        _page=[]
        _page.append(str(self.navigationBar('index')))
        _page.append("""
<table border=0 cellspacing=1 cellpadding=3 width=100%>
<tr>
    <td bgcolor=#BD1E26 class=moduleTitle>Forum</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Posts</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Threads</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Last post</td>
</tr>
""")
        return "".join(_page)
    def forumListObject(self, object, messageList, threadList, lastPost):
        _page=[]
        _page.append("""<tr>
    <td class=moduleText><a class=moduleLink href=\"""")
        _page.append(str('viewForum?forumId=%s'%object.id))
        _page.append("""\">""")
        _page.append(str(object.name))
        _page.append("""</a><br>
        """)
        _page.append(str(object.description))
        _page.append("""</td>
    <td class=moduleText>""")
        _page.append(str(len(messageList)))
        _page.append("""</td>
    <td class=moduleText>""")
        _page.append(str(len(threadList)))
        _page.append("""</td>
    <td class=moduleText>""")
        _page.append(str(lastPost))
        _page.append("""</td>
</tr>
""")
        return "".join(_page)
    def forumListFooter(self):
        _page=[]
        _page.append("""</table>
""")
        return "".join(_page)
    def forumHeader(self, forumObj):
        _page=[]
        _page.append("""<a class=moduleLink href=\"""")
        _page.append(str('viewForum?forumId=%s'%forumObj.id))
        _page.append("""\">""")
        _page.append(str(forumObj.name))
        _page.append("""</a><br>
""")
        _page.append(str(tools.escapeHtml(forumObj.description)))
        _page.append("""<br><br>
""")
        return "".join(_page)
    def threadListHeader(self, object):
        _page=[]
        _page.append("""<table border=0 cellspacing=1 cellpadding=3 width=100%>
<tr>
    <td bgcolor=#BD1E26 class=moduleTitle>Subject</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Posts</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Views</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Started By</td>
    <td bgcolor=#BD1E26 class=moduleTitle>Last post</td>
</tr>
""")
        return "".join(_page)
    def threadListObject(self, object, lastPost):
        _page=[]
        _page.append("""<tr>
    <td class=moduleText><a class=moduleLink href=\"""")
        _page.append(str('viewThread?threadId=%s'%object.id))
        _page.append("""\">""")
        _page.append(str(tools.escapeHtml(object.subject)))
        _page.append("""</a></td>
    <td class=moduleText>""")
        _page.append(str(len(object.messageList)))
        _page.append("""</td>
    <td class=moduleText>""")
        _page.append(str(int(object.views)))
        _page.append("""</td>
    <td class=moduleText>
        """)
        _page.append(str(object.messageList[0].name))
        _page.append("""
    </td>
    <td class=moduleText>""")
        _page.append(str(lastPost))
        _page.append("""</td>
</tr>
""")
        return "".join(_page)
    def threadListFooter(self):
        _page=[]
        _page.append("""</table>
""")
        return "".join(_page)
    def messageListHeader(self, object):
        _page=[]
        return "".join(_page)
    def messageListObject(self, object, index):
        _page=[]
        _page.append("""<hr width=100% size=1>
<b>
    """)
        if index!=0:
            _page.append("""Re: """)
        _page.append("""
    """)
        _page.append(str(tools.escapeHtml(object.thread.subject)))
        _page.append("""
</b><br>
<i>Posted by
    """)
        _page.append(str(object.name))
        _page.append("""
    """)
        if object.email:
            _page.append("""
        (""")
            _page.append(str(object.email.replace('@', ' at ')))
            _page.append(""")
    """)
        _page.append("""
on """)
        _page.append(str(object.date))
        _page.append("""</i><br><br>
""")
        _page.append(str(self.cookText(object.text)))
        _page.append("""
<br><br>
""")
        return "".join(_page)
    def messageListFooter(self):
        _page=[]
        _page.append("""<hr width=100% size=1>
""")
        return "".join(_page)
    def searchResultHeader(self):
        _page=[]
        _page.append("""<center>
<br>
<table>
""")
        return "".join(_page)
    def searchResultObject(self, threadObj):
        _page=[]
        _page.append("""<tr>
    <td class=moduleText>Thread:</td>
    <td><a class=moduleLink href=\"""")
        _page.append(str('viewThread?threadId=%s'%threadObj.id))
        _page.append("""\">""")
        _page.append(str(tools.escapeHtml(threadObj.subject)))
        _page.append("""</a></td>
    <td width=50>&nbsp;</td>
    <td class=moduleText>in Forum:</td>
    <td><a class=moduleLink href=\"""")
        _page.append(str('viewForum?forumId=%s'%threadObj.forum.id))
        _page.append("""\">""")
        _page.append(str(threadObj.forum.name))
        _page.append("""</a></td>
</tr>
""")
        return "".join(_page)
    def searchResultFooter(self):
        _page=[]
        _page.append("""</table>
</center>
""")
        return "".join(_page)
    def formHeader(self):
        _page=[]
        _page.append("""<table border=0 cellspacing=0 cellpadding=1><tr><td bgcolor=#000000>
    <table border=0 cellspacing=0 cellpadding=3 bgcolor=#fcfcfc>
""")
        return "".join(_page)
    def formFooter(self):
        _page=[]
        _page.append("""    </table></td></tr>
</table>
""")
        return "".join(_page)
    def formSeparator(self):
        _page=[]
        _page.append("""<tr><td colspan=2><hr width=100% size=1></td></tr>
""")
        return "".join(_page)
    def textareaMask(self, label, name, fieldValue, typ, error, optionList, extraArgMap):
        _page=[]
        if error:
            _page.append("""
    <tr><td colspan=2 class=moduleText><font color=red>""")
            _page.append(str(error))
            _page.append("""</font></td></tr>
""")
        _page.append("""
<tr><td colspan=2>
    <textarea name=\"""")
        _page.append(str(name))
        _page.append("""\" rows="20" cols="60">""")
        _page.append(str(fieldValue))
        _page.append("""</textarea>
</td></tr>
""")
        return "".join(_page)
    def submitMask(self, label, name, fieldValue, typ, error, optionList, extraArgMap):
        _page=[]
        _page.append("""<tr><td colspan=2 align=right>
    <input type="submit" onClick="document.cherryForm.target='_new'; document.cherryForm.action='/previewMessage';" value=" Preview ">
    &nbsp;&nbsp;&nbsp;&nbsp;
    <input type="submit" onClick="document.cherryForm.target=''; document.cherryForm.action='/message/editObjectFormAction';" value=" Post ">
</td></tr>
""")
        return "".join(_page)
global FrenchTools
class FrenchTools:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/frenchTools"
        else:
            return "/frenchTools"
    def getDate(self, withYear=0, withBr=0):
        dayMap={
            '0': 'dimanche',
            '1': 'lundi',
            '2': 'mardi',
            '3': 'mercredi',
            '4': 'jeudi',
            '5': 'vendredi',
            '6': 'samedi'
        }
        monthMap={
            '01': 'janvier',
            '02': 'fevrier',
            '03': 'mars',
            '04': 'avril',
            '05': 'mai',
            '06': 'juin',
            '07': 'juillet',
            '08': 'aout',
            '09': 'septembre',
            '10': 'octobre',
            '11': 'novembre',
            '12': 'decembre'
        }
        tuple=time.gmtime(time.time()+3600) # Local time in France
        dayOfWeekNb=time.strftime("%w", tuple)
        monthNb=time.strftime("%m", tuple)
        dayNb=int(time.strftime("%d", tuple))
        if withBr: br="<br>"
        else: br=" "
        res="%s%s%s %s"%(dayMap[dayOfWeekNb], br, dayNb, monthMap[monthNb])
        if withYear: res+="%s2002"%br
        return res
    def formatDateForDay(self, date):
        year=date[:4]
        month=date[5:7]
        day=date[8:10]
        return day+'/'+month+'/'+year
    def getNow(self):
        tuple=time.gmtime(time.time()+3600) # Local time in France
        return time.strftime('%Y-%m-%d %H:%M:%S', tuple)
    def getNowMinus(self, day):
        tuple=time.gmtime(time.time()+3600-(3600*24*day)) # Local time in France minus n days
        return time.strftime('%Y-%m-%d %H:%M:%S', tuple)
    def validateBirthDate(self, birthDate, sep='/'):
        try:
            day, month, year=birthDate.split('/')
            if int(day)<1 or int(day)>31: raise "Error"
            if int(month)<1 or int(month)>12: raise "Error"
            if int(year)<1890 or int(year)>2000: raise "Error"
        except: return "Wrong birthDate"
    def validateZipCode(self, zipCode):
        try:
            if int(zipCode)<01000 or int(zipCode)>98999: raise 'Error'
        except: return "Wrong zipCode"
    def strToFloat(self, num):
        if not num: return 0
        if type(num)==type(''): num=num.replace(',','.')
        return float(num)
    def floatToStr(self, num):
        if not num: return ''
        return str(num).replace('.',',')
global CherryPyMail
class CherryPyMail(Mail):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryPyMail"
        else:
            return "/cherryPyMail"
    def __init__(self):
        self.smtpServer=configFile.get("mail","smtpServer")
global Root
class Root:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/root"
        else:
            return "/root"
    def getSearchResult(self, keyWord):
        for i in range(len(keyWord)):
            c=keyWord[i]
            if (not 'a'<=c<='z') and (not 'A'<=c<='Z') and (not '0'<=c<='9'):
                keyWord=keyWord[:i]+' '+keyWord[i+1:]
        keyWordList=keyWord.split()
        result=keyWordMap.get(keyWordList[0], [])
        for keyWord in keyWordList[1:]:
            currentResult=keyWordMap.get(keyWord, [])
            newResult=[]
            for url, title, score in result:
                for url2, title2, score2 in currentResult:
                    if url==url2: newResult.append((url, title, score+score2))
            result=newResult
        if len(keyWordList)>1:
            newResult=[]
            for (url, title, score) in result:
                score=float(score)/len(keyWordList)
                score=int(score*10)/10.0
                newResult.append((url, title, score))
            result=newResult
        result.sort(self.sortOnThirdCriteria)
        return result
    def sortOnThirdCriteria(self, tuple1, tuple2):
        if tuple1[2]<tuple2[2]: return 1
        return -1
    def leftColumn(self):
        l='''
            <a class=moduleLinkB href="/">Home</a><br>
            <a class=moduleLinkB href="/download">Download</a><br>
            <span class=moduleTextB>Documentation:</span><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/static/html/tut/index.html">Tutorial</a> <small>(start here)</small><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/static/html/howto/index.html">HowTo</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/static/html/lib/index.html">Standard library</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/downloadableDoc">Downloadable/printable format</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/articles">Articles about CherryPy</a><br>
            <span class=moduleTextB>Showcase:</span><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/demo/index">Online demo</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/talk">Testimonials</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/aboutSite">About this site</a><br>
            <span class=moduleTextB>About CherryPy:</span><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/license">License</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/people">People behind CherryPy</a><br>
            <span class=moduleTextB>Getting help:</span><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/mailingLists">Mailing lists</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/myForum/index">Forum</a><br>
            <span class=moduleTextB>Developers:</span><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/cvs">CVS</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="http://sourceforge.net/tracker/?atid=479346&group_id=56099&func=browse">Bug tracker</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="http://sourceforge.net/tracker/?atid=479349&group_id=56099&func=browse">Feature requests</a><br>
            <span class=moduleTextB>Resources:</span><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="/thirdParty">Bakery</a> <small>(third-party modules)</small><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="http://wiki.cherrypy.org/cgi-bin/moin.cgi">Wiki</a> <small>(contributed by users)</small><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="http://wiki.cherrypy.org/cgi-bin/moin.cgi/HostingProviders">CherryPy hosting providers</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="http://wiki.cherrypy.org/cgi-bin/moin.cgi/TipsAndHowTos">User-contributed HowTos</a><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=moduleLink href="http://wiki.cherrypy.org/cgi-bin/moin.cgi/OtherLanguages">Non-english resources</a><br>
        '''
        return self.leftSquare("CherryPy", l)
    def latestReleaseContent(self):
        _page=[]
        _page.append("""<a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.9.tar.gz?download">cherrypy-0.9.tar.gz</a> (1981K)
""")
        return "".join(_page)
    def newsContent(self):
        _page=[]
        _page.append("""<b>04/12 - Gmane interface to mailing list archives</b><br>
Thanks to Hendrik Mans for pointing out that the CherryPy mailing archive is also available through Gmane. The web interface is at <a class=moduleLink href="http://news.gmane.org/gmane.comp.python.cherrypy">http://news.gmane.org/gmane.comp.python.cherrypy</a> and the NNTP interface is at nntp://news.gmane.org/gmane.comp.python.cherrypy.
<br><br>
<b>03/07 - CherryPy-0.10-rc1 released</b><br>
There are many small improvements in this release. One of the main ones is that expired sessions are
now automatically cleaned-up.<br>
There are a couple of backward incompatibilities that affect custom sessions and the CookieSessionAuthenticate
module.<br>
You can download the release from the <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/download'))
        _page.append("""\">download area</a>
<br><br>
<b>02/22 - Wiki available</b><br>
CherryPy now has a wiki where users can find extra informations and
contribute their own content to share it with other people.<br>
The wiki is available <a class=moduleLink href="http://wiki.cherrypy.org/cgi-bin/moin.cgi">here</a>.
<br><br>
<b>02/20 - New module in the bakery</b><br>
Jeff Clement added a new module in the bakery: <b>jTime</b> is a multi-user web-based timesheet package.
<br><br>
<b>02/19 - Italian translation of the docs</b><br>
Many thanks to Enrico Morelli who translated the tutorial and the HowTos into italian and put everything
online on the italian Gentoo site: <a class=moduleLink href="http://www.gentoo.it">www.gentoo.it</a>
<br><br>
<b>01/20 - Nice little icon for the site :-)</b><br>
As you will notice, the site now uses a nice little cherry as a favicon.ico
<br><br>
<b>01/18 - Bakery available</b><br>
A new section called the "Bakery" has been added to this website. It will serve as a repository for
third-party modules written CherryPy. Many thanks to Damien Boucard who developed this section.
<br><br>
<b>01/06 - CherryPy-0.10-beta released</b><br>
The main change in this beta release is that you now have to use "request.sessionMap" instead of "sessionMap" in
your code. This makes sessions completely thread-safe.<br>
Another noticable change is that CherryPy now longer uses tabs: it uses 4 whitespaces everywhere instead.<br>
This release also restores Jython compatibility, which had been broken in previous releases.<br>
You can download the release from the <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/download'))
        _page.append("""\">download area</a>
<br><br>
<b>01/04 - Two new demos</b><br>
There are two new entries in the <a class=moduleLink href="/demo/index">online demo</a>: a demo about SSL and a demo about streaming.
<br><br>
<b>12/15 - Improved Forum</b><br>
A nasty bug that caused some messages in the Forum to sometimes get lost has been fixed.<br>
Also, the ability to preview messages before you post them has been added.
<br><br>
<b>12/07 - Website update</b><br>
The home page of this site has been changed to better explain what CherryPy is about and why it is good :-)<br>
The left menu has also been reorganized and a couple of new sections have been added.<br><br>
""")
        return "".join(_page)
    def downloadContent(self):
        _page=[]
        _page.append("""<b>Latest non-stable release: CherryPy-0.10-rc1</b><br>
There are many small improvements in this release. One of the main ones is that expired sessions are
now automatically cleaned-up.<br>
There are a couple of backward incompatibilities that affect custom sessions and the CookieSessionAuthenticate
module:<br>
"isGoodLoginAndPassword" has been replaced with "checkLoginAndPassword" and can now return several error
messages (or None if everything is OK).<br>
The login is no longer stored in "self.login" but in "request.login" for thread-safety.<br>
Check out the HowTo about sessions (from the documentation that comes with the release) to learn how the new custom
sessions work and how expired sessions are cleaned up.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.10-rc1.tar.gz?download">cherrypy-0.10-rc1.tar.gz</a> (2133 KB) (courtesy of sourceforge)<br>
The detailed ChangeLog can be viewed
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older non-stable release: CherryPy-0.10-beta</b><br>
The main change in this beta release is that you now have to use "request.sessionMap" instead
of "sessionMap" in your code. This makes sessions completely thread-safe.<br>
Another noticable change is that CherryPy now longer uses tabs: it uses 4 whitespaces everywhere instead.<br>
This release also restores Jython compatibility, which had been broken in previous releases.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.10-beta.tar.gz?download">cherrypy-0.10-beta.tar.gz</a> (2001 KB) (courtesy of sourceforge)<br>
The detailed ChangeLog can be viewed
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Latest stable release: CherryPy-0.9</b><br>
This is the first stable release in a long time and the list of changes since the last stable release is huge. So if you're still using
CherryPy-0.8, you're <b>strongly</b> encouraged to upgrade ...<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.9.tar.gz?download">cherrypy-0.9.tar.gz</a> (1981 KB) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older non-stable release: CherryPy-0.9-rc1</b><br>
Many many improvements in this release.
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.9-rc1.tar.gz?download">cherrypy-0.9-rc1.tar.gz</a> (1996 KB) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older non-stable release: CherryPy-0.9-gamma</b><br>
The highlights of this release are: a new thread-pool server, sessions that work and many bugfixes.<br>
We've put together a page explaining what's new
in this release <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/cherrypy_0_9_gamma'))
        _page.append("""\">here</a>.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.9-gamma.tar.gz?download">cherrypy-0.9-gamma.tar.gz</a> (1903K) (courtesy of sourceforge)<br>
<br>
<b>Older non-stable release: CherryPy-0.9-beta</b><br>
This release includes a lot of improvements and new features. We've put together a page explaining what's new
in this release <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/cherrypy_0_9_beta'))
        _page.append("""\">here</a>.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.9-beta.tar.gz?download">cherrypy-0.9-beta.tar.gz</a> (1931K) (courtesy of sourceforge)<br>
<br>
<b>Older stable release: CherryPy-0.8</b><br>
This release includes all the improvements from the 0.8-beta release and it fixes a few bugs. It also adds a new way
to control CherryPy logging. A HowTo has been added to the documentation about that.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.8.tar.gz?download">cherrypy-0.8.tar.gz</a> (1359K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.8-beta</b><br>
Lots of changes in this release:
<ul>
<li>First of all, a brand new HTTP server: it is based on BaseHTTPServer, but it has been heavily
customized to support AF_UNIX sockets and SSL. The new server supports threading and forking. It doesn't support
asyncore service yet (maybe in the next release). A new chapter called "Deploying your website for production"
has been added to the tutorial and it explains how to use these new features.</li>
<li>XML-RPC support: CherryPy is the perfect tool to develop XML-RPC services.
A new HowTo in the documentation explains how to develop an XML-RPC server with CherryPy.</li>
<li>Hidden views and masks: A new HowTo in the documentation explains what this is</li>
</ul>
<b>The new documentation is not available on the website yet. It is included when you download the beta release</b><br>
This is the first time we're making a beta release. The reason is that it has lots of major changes (especially
the HTTP server) and the community is getting big enough so we can hope to get some feedback. So please play with
this release and let us know if you find any bugs.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.8-beta.tar.gz?download">cherrypy-0.8-beta.tar.gz</a> (1369K) (courtesy of sourceforge)<br>
<br>
<b>Older release: CherryPy-0.7</b><br>
Minor bugs have been fixed and error reporting has been improved.<br>
The much awaited HowTo that explains how to use AOP (Aspect Oriented Programming) with CherryPy has been added
to the documentation (note that the examples in the HowTo will only work with CherryPy-0.7 or later).<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.7.tar.gz?download">cherrypy-0.7.tar.gz</a> (1200K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.6</b><br>
This release adds SSL support to CherryPy.<br>
One HowTo has been added to the documentation to explain how to use SSL.<br>
This release also removes the copyright and the GPL license from Httpd.py and from the executable generated by CherryPy.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.6.tar.gz?download">cherrypy-0.6.tar.gz</a> (1200K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.5</b><br>
This release adds FastCGI support as well as a new """)
        _page.append(str('&ltpy'+'-include&gt;'))
        _page.append(""" tag to include external templates
(to allow webdesigners to work on separate files).<br>
Two HowTos have been added to the documentation to explain how to use these new features.<br>
It also improves the way filename extensions are recognized when serving static content.
The content-type is now correctly set for most common extensions.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.5.tar.gz?download">cherrypy-0.5.tar.gz</a> (1200K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.4</b><br>
This release adds a new caching capability to CherryPy.<br>
It also includes some compiler optimization, which brings a minor backward incompatibility:<br>
When you want to append some data to the <i>_page</i> variable in a mask, you now have to use: <i>_page.append("text")</i>
instead of <i>_page+="text"</i>.<br>
A new HowTo has been added to the documentation to explain how to use the caching capability.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.4.tar.gz?download">cherrypy-0.4.tar.gz</a> (1200K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.3</b><br>
This release includes a new demo entry (OOP) as well as some new documentation (Standard Library)<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.3.tar.gz?download">cherrypy-0.3.tar.gz</a> (992K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.2</b><br>
This release fixes a small bug that prevented non-Unix users from using the CookieAuthenticate module. Other
minor improvements have been made.<br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.2.tar.gz?download">cherrypy-0.2.tar.gz</a> (618K) (courtesy of sourceforge)<br>
The ChangeLog can be viewed <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/ChangeLog.txt'))
        _page.append("""\">here</a><br>
<br>
<b>Older release: CherryPy-0.1</b><br>
We're pleased to announce the first public release of CherryPy. Even though the
release number is low (0.1), CherryPy has already been used in production for 6 months
and has proven fast and stable.<br>
The release comes with the documentation and a demo web site<br><br>
Get the release here: <a class=moduleLink href="http://prdownloads.sourceforge.net/cherrypy/cherrypy-0.1.tar.gz?download">cherrypy-0.1.tar.gz</a> (354K) (courtesy of sourceforge)
""")
        return "".join(_page)
    def square(self, title, body):
        _page=[]
        _page.append("""<table border=0 cellspacing=0 cellpadding=0 width=100%>
    <tr>
        <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleHeaderLeft.gif'))
        _page.append("""\" width=10 height=25></td>
        <td background=\"""")
        _page.append(str(request.base+'/static/moduleHeaderMiddle.gif'))
        _page.append("""\" height=25 valign=top align=left class=moduleTitle>""")
        _page.append(str(title))
        _page.append("""</td>
        <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleHeaderRight.gif'))
        _page.append("""\" width=10 height=25></td>
    </tr><tr>
        <td width=10 background=\"""")
        _page.append(str(request.base+'/static/moduleBodyLeft.gif'))
        _page.append("""\">&nbsp;</td>
        <td class=moduleText>""")
        _page.append(str(body))
        _page.append("""</td>
        <td width=10 background=\"""")
        _page.append(str(request.base+'/static/moduleBodyRight.gif'))
        _page.append("""\">&nbsp;</td>
    </tr><tr>
        <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleFooterLeft.gif'))
        _page.append("""\" width=10 height=15></td>
        <td background=\"""")
        _page.append(str(request.base+'/static/moduleFooterMiddle.gif'))
        _page.append("""\" height=15>""")
        _page.append(str(maskTools.x()))
        _page.append("""</td>
        <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleFooterRight.gif'))
        _page.append("""\" width=10 height=15></td>
    </tr>
</table>
""")
        return "".join(_page)
    def leftSquare(self, title, body):
        _page=[]
        _page.append("""<table border=0 cellspacing=0 cellpadding=5 width=100%>
    <tr><td align=left bgColor=#BD1E26 class=moduleTitle>""")
        _page.append(str(title))
        _page.append("""</td></tr>
    <tr><td align=left class=moduleText>""")
        _page.append(str(body))
        _page.append("""</td></tr>
</table>
""")
        return "".join(_page)
    def header(self, title, robots='all'):
        _page=[]
        _page.append("""<html>
<head>
    <meta name="robots" content=\"""")
        _page.append(str(robots))
        _page.append("""\">
    <title>CherryPy : """)
        _page.append(str(title))
        _page.append("""</title>
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <style type="text/css">
    <!--
    .moduleTitle {font-size:14px; font-weight:bold; color:white; font-family:arial}
    .moduleLink {font-size:12px; color:#BD1E26; font-family:arial}
    .moduleLink:hover {font-size:12px; color:red; font-family:arial}
    .moduleLinkB {font-size:12px; font-weight:bold; color:#BD1E26; font-family:arial}
    .moduleLinkB:hover {font-size:12px; font-weight:bold; color:red; font-family:arial}
    .moduleText {font-size:12px; color:black; font-family:arial}
    .moduleTextB {font-size:12px; font-weight:bold; color:#BD1E26; font-family:arial}
    -->
    </style>
</head>
<body bgcolor=white topmargin="0" marginheight="0">
    <table width=100% cellspacing=20><tr>
        <td width=20% valign=top align=center class=moduleText>
            <a href=\"""")
        _page.append(str(request.base))
        _page.append("""\"><img src=\"""")
        _page.append(str(request.base+'/static/cherryPyLogo.gif'))
        _page.append("""\" width=200 height=82 border=0 alt="CherryPy: A tasty toolkit for pythonic web development"></a><br>
            <span style="font-size:5px;"><br></span>
            <form target="_new" action="http://www.google.com/search" method="get" style="margin-top: 0; margin-bottom: 0" name="searchForm">
                <b>Search:</b> <input type=text name=as_q size=10>&nbsp;&nbsp;
                <input type=hidden name="as_sitesearch" value="cherrypy.org">
                <input type=submit value=OK>
            </form>
            <span style="font-size:5px;"><br></span>
            <table border=0 cellspacing=0 cellpadding=0 width=100%><tr><td bgColor=#FFCCCC>
                """)
        _page.append(str(self.leftColumn()))
        _page.append("""
                <br>
                """)
        _page.append(str(self.leftSquare('Latest stable release', self.latestReleaseContent())))
        _page.append("""
            </td></tr></table>
            <br>
            <a href="http://sourceforge.net"><img src=\"""")
        _page.append(str(request.base+'/static/sourceForgeLogo.gif'))
        _page.append("""\" width="88" height="31" border="0" alt="Many thanks to SourceForge"></a><br>
            <br>
            <a href="http://www.python.org"><img src=\"""")
        _page.append(str(request.base+'/static/PythonPoweredSmall.gif'))
        _page.append("""\" border=0 alt="Powered by Python"></a><br>
            <br>
            <a href="http://www.cherrypy.org"><img src=\"""")
        _page.append(str(request.base+'/static/poweredByCherryPy.gif'))
        _page.append("""\" border=0 alt="Powered by CherryPy"></a><br>
        </td>
""")
        return "".join(_page)
    def footer(self):
        _page=[]
        _page.append("""    </tr></table>
    <center><small><small><font color=gray>
        Copyright &copy; 2002-2004 by Remi Delon. All Rights Reserved.<br>
        Comments and questions to <font color=gray>"remi at cherrypy.org"</font>
    </font></small></small></center>
</body>
</html>
""")
        return "".join(_page)
    def index(self):
        _page=[]
        _page.append(str(self.header('A tasty toolkit for pythonic web development')))
        _page.append("""
    <td width=40% valign=top align=center>
        """)
        _page.append(str(self.square('What is CherryPy ?', self.welcome())))
        _page.append("""
        <br>
        """)
        _page.append(str(self.square('Compiler approach', self.compiler())))
        _page.append("""
        <br>
        """)
        _page.append(str(self.square('Main features', self.mainFeatures())))
        _page.append("""
    </td>
    <td width=40% valign=top>
        """)
        _page.append(str(self.square('News', self.newsContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def hostContent(self):
        _page=[]
        _page.append("""Looking for a place to host your CherryPy web site ?<br>
Below is a list of "CherryPy-friendly" hosting service providers:<br><br>
<a class=moduleLink href="http://www.freecherrypy.org"><b>FreeCherryPy</b></a> (<b>FREE, non commercial only)</b><br>
<a class=moduleLink href="http://www.python-hosting.com">Python-hosting.com</a> (specialized python hosting)<br>
<a class=moduleLink href="http://www.hurrah.com">Hurrah</a><br>
<a class=moduleLink href="http://hostandpost.cognizor.com">Cognizor's Host and Post</a><br>
<br>
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/hosting'))
        _page.append("""\"><small>Your name here</small></a>
""")
        return "".join(_page)
    def feedback(self):
        _page=[]
        _page.append("""We love receiving e-mails from users.<br>
You like CherryPy ? You hate it ?<br>
You're doing something cool with it ?<br>
Let us know about it !<br>
You can reach us at "remi at cherrypy.org".
""")
        return "".join(_page)
    def showMe(self):
        _page=[]
        _page.append("""CherryPy can do everything other famous application servers can do. But by using CherryPy and Python's power
you might be able to save a lot of time and lines of code.<br><br>
CherryPy was used to develop a major commercial web site called Urbishop.com (the website is no longer on-line).
We wrote a first version of the web site with a "famous" application server, but we got a little frustrated with it.
So we decided to rewrite everything with CherryPy. The result was much smaller code, developed in less time. And
most importantly, we had FUN doing it !<br><br>
Since then, we've used it to develop many other web sites, and the more we use it, the more we love it !<br><br>
We've also put together a small demo that demonstrates a few of CherryPy capabilities. Check it out
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/demo/index'))
        _page.append("""\">here</a>
""")
        return "".join(_page)
    def welcome(self):
        _page=[]
        _page.append("""CherryPy is a Python based web development toolkit. It provides all the features of an enterprise-class application server while remaining
light, fast and easy to learn.<br><br>
CherryPy allows developers to build web applications in much the same way they would build any other object-oriented Python program. This usually results in smaller source code developed in less time.<br><br>
It runs on most platforms (everywhere Python runs) and it is available under the <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/license'))
        _page.append("""\">GPL license</a>.<br><br>
CherryPy is now nearly two years old and it is has proven very fast and stable. It is being used in production by many sites, from the simplest ones to the most demanding ones.<br><br>
Oh, and most importantly: CherryPy is <b>fun</b> to work with :-)<br>
""")
        return "".join(_page)
    def compiler(self):
        _page=[]
        _page.append("""One of the main characteristics of CherryPy is that it works like a compiler:<br>
You write source files, compile them with CherryPy and
CherryPy generates an executable containing everything to run the web site (including an HTTP server).<br><br>
This results in a very fast website that can be easily deployed (just by copying one file), either on its own or
behind another webserver like Apache.<br>
The built-in HTTP server is fast and robust. It supports SSL, XML-RPC and it can be deployed in many different
ways: threading, forking, thread-pooling or process-pooling.
""")
        return "".join(_page)
    def mainFeatures(self):
        _page=[]
        _page.append("""Here are some the main features of CherryPy:
<ul>
<li>Encourages you to think of your website in an object-oriented way</li>
<li>Supports some <a class=moduleLink href="/static/html/howto/node12.html">AOP</a> concepts as well</li>
<li>Comes with a templating language but you can use other ones (like Cheetah) or use XML/XSL to generate your pages</li>
<li>Can be easily connected to most databases</li>
<li>Provides sessions out of the box (session data can be saved to RAM, disk, database, ...)</li>
<li>Supports streaming in both directions</li>
<li>Has a built-in cacheing mechanism</li>
<li>Comes with a convenient standard library for things like Forms or Authentication</li>
<li>All these features (especially sessions, database connections, cacheing, ...) work just as well in a threading or thread-pooling environment for production websites</li>
</ul>
""")
        return "".join(_page)
    def download(self):
        _page=[]
        _page.append(str(self.header('Download')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Download', self.downloadContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def people(self):
        _page=[]
        _page.append(str(self.header('People behind CherryPy')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('People behind CherryPy', self.peopleContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def peopleContent(self):
        _page=[]
        _page.append("""CherryPy was originally written by Remi Delon back in May 2002.<br><br>
Since then, many people have helped and contributed to CherryPy one way or another.<br><br>
Currently, the following people have write access to the CVS tree: Chema Cortes, Damien Boucard,
Jeffrey Clement, Raphael Goulais, Steven Nieker and Ulf Bartelt.<br><br>
The following people have also helped CherryPy one way or another: Brian Meagher, Bruce McTigue, Chris Foote,
Cristian Echeverria, Darryl Caldwell, Enrico Morelli, Eric S. Johansson, Frederic Faure, John Cherry,
John Platten, Kevin Manley, Lukasz Pankowski, Magnus Lycka, Mario Ruggier, Philippe Bouige,
Salvatore Didio, Scott Luck, Tim Jarman.<br><br>
A big thanks to everybody !
""")
        return "".join(_page)
    def hosting(self):
        _page=[]
        _page.append(str(self.header('CherryPy hosting providers')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('CherryPy hosting providers', self.hostingContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def hostingContent(self):
        _page=[]
        _page.append("""Looking for a place to host your CherryPy site ?<br>
Here is a list of CherryPy-friendly hosting providers:<br>
<ul>
<li><a class=moduleLink href="http://www.freecherrypy.org">FreeCherryPy.org</a>: Free CherryPy hosting (non commercial sites only and no database available)<br><br></li>
<li><a class=moduleLink href="http://www.python-hosting.com">Python-Hosting.com</a>: Hosting provider specialized in Python<br><br></li>
<li><a class=moduleLink href="http://www.hurrah.com">Hurrah.com</a><br><br></li>
<li><a class=moduleLink href="http://hostandpost.cognizor.com/">Cognizor's Host and Post</a><br><br></li>
</ul>
""")
        return "".join(_page)
    def license(self):
        _page=[]
        _page.append(str(self.header('License')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('License', self.licenseContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def licenseContent(self):
        _page=[]
        _page.append("""<ul>
<li><b>License</b><br>
CherryPy is released under the <b>GPL license</b>.<br>
However, since CherryPy works like a compiler and copies parts of itself into the generated script, the license includes a special clause that
specifies that the GPL license doesn't apply to the code that's being copied into the executable.<br>
Therefore, the websites generated by CherryPy are not affected by the GPL license.<br><br></li>
<li><b>Copyright</b><br>
Since the CherryPy-0.9 release, the copyright is owned by the "CherryPy Team" (see the file "CherryPyTeam.txt" included in each
release for the list of people who make up this team).</li>
</ul>
""")
        return "".join(_page)
    def mailingLists(self):
        _page=[]
        _page.append(str(self.header('Mailing lists')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Mailing lists', self.mailingListsContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def mailingListsContent(self):
        _page=[]
        _page.append("""CherryPy has three mailing lists hosted by sourceforge:
<ul>
<li><b>cherrypy-users</b> is the general list for all questions regarding the use of CherryPy.
    The list can be found <a class=moduleLink href="http://lists.sourceforge.net/lists/listinfo/cherrypy-users">here</a><br><br></li>
<li><b>cherrypy-devel</b> is the list dedicated to the development (new features, bug fixes, design choices, ...) of CherryPy itself.
    The list can be found <a class=moduleLink href="http://lists.sourceforge.net/lists/listinfo/cherrypy-devel">here</a><br><br></li>
<li><b>cherrypy-announce</b> is a very low-traffic list where all new releases and major events are announced.
    You don't need to subscribe to this list if you've subscribed to cherrypy-users or cherrypy-devel.
    The list can be found <a class=moduleLink href="http://lists.sourceforge.net/lists/listinfo/cherrypy-announce">here<br><br></a></li>
</ul>
Note that the CherryPy mailing archive is also available through Gmane. The web interface is at <a class=moduleLink href="http://news.gmane.org/gmane.comp.python.cherrypy">http://news.gmane.org/gmane.comp.python.cherrypy</a> and the NNTP interface is at nntp://news.gmane.org/gmane.comp.python.cherrypy.
""")
        return "".join(_page)
    def articles(self):
        _page=[]
        _page.append(str(self.header('Articles about CherryPy')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Articles about CherryPy', self.articlesContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def articlesContent(self):
        _page=[]
        _page.append("""Here is a list of articles/presentations that have been written about CherryPy:
<ul>
<li>
    <b>Web development with CherryPy</b> by Jeffrey Clement, August 2003.<br>
    Very good slides from a presentation given by Jeffrey Clement to the Calgary Linux Users Group.<br>
    Available in <a class=moduleLink href="/static/cherrypy-clug.pdf">PDF format</a> and
    <a class=moduleLink href="/static/cherrypy-clug-handout.pdf">PDF handout format</a><br><br>
</li>
<li>
    <b>Introduction to CherryPy</b> by Remi Delon, June 2003.<br>
    Slides from a small presentation given by Remi Delon at Europython 2003.<br>
    Available in <a class=moduleLink href="/static/CherryPy-EuroPython2003.pdf">PDF format</a> and
    <a class=moduleLink href="/static/CherryPy-EuroPython2003.ppt">PowerPoint format</a><br>
    As a bonus, a photo of the talk is available <a class=moduleLink href="/static/Cherrypy-EuroPython.jpg">here</a> :-)<br><br>
</li>
<li>
    <b>Smart Websites with CherryPy</b> by Remi Delon, November 2002.<br>
    Article written by Remi Delon for the PythonJournal. Explains the background of CherryPy and the concepts
    behind it. The last paragraph about deployment is outdated because the HTTP server is now much better.<br>
    The article is available
    <a class=moduleLink href="http://pythonjournal.cognizor.com/pyj3.1/cherrypy/CherryPy2.html">here</a><br><br>
</li>
</ul>
""")
        return "".join(_page)
    def downloadableDoc(self):
        _page=[]
        _page.append(str(self.header('Downloadable/printable docs')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Downloadable/printable docs', self.downloadableDocContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def downloadableDocContent(self):
        _page=[]
        _page.append("""The tutorial is available in <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/tut.pdf'))
        _page.append("""\">PDF format</a> (124K)
and in <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/tut.ps'))
        _page.append("""\">Postscript format</a> (129K).<br><br>
The HowTos are available in <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/howto.pdf'))
        _page.append("""\">PDF format</a> (98K)
and in <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/howto.ps'))
        _page.append("""\">Postscript format</a> (100K).<br><br>
The standard library documentation is available in <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/lib.pdf'))
        _page.append("""\">PDF format</a> (47K)
and in <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/lib.ps'))
        _page.append("""\">Postscript format</a> (59K).<br><br>
All of these (plus the HTML format) are included when you download CherryPy.
""")
        return "".join(_page)
    def cvs(self):
        _page=[]
        _page.append(str(self.header('CVS')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('CVS', self.cvsContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def cvsContent(self):
        _page=[]
        _page.append("""CherryPy has a CVS repository hosted by sourceforge.<br>
You can check out the modules through anonymous (pserver) CVS. Just use the following commands:<br>
<br>
cvs -d:pserver:anonymous@cvs.cherrypy.sourceforge.net:/cvsroot/cherrypy login<br>
cvs -z3 -d:pserver:anonymous@cvs.cherrypy.sourceforge.net:/cvsroot/cherrypy co cherrypy<br>
<br>
Simply press enter when prompted for a password.<br><br>
The CVS repository can also be viewed online <a class=moduleLink href="http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/cherrypy/">here</a>
""")
        return "".join(_page)
    def documentation(self):
        _page=[]
        _page.append(str(self.header('Documentation')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Introduction', self.introductionContent())))
        _page.append("""
        <br>
        """)
        _page.append(str(self.square('Tutorial', self.tutorialContent())))
        _page.append("""
        <br>
        """)
        _page.append(str(self.square('HowTo', self.howToContent())))
        _page.append("""
        <br>
        """)
        _page.append(str(self.square('CherryPy Standard Library', self.libContent())))
        _page.append("""
        <br>
        """)
        _page.append(str(self.square('Mailing lists', self.mailingListsContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def introductionContent(self):
        _page=[]
        _page.append("""To learn more about the concepts and the story behind CherryPy, check out the
<a class=moduleLink href="http://pythonjournal.cognizor.com/pyj3.1/cherrypy/CherryPy2.html">article</a> about
it in the PythonJournal. (note that chapter 3 "Deploying with CherryPy" is deprecated because CherryPy's HTTP
server now supports threading, forking, process pooling, ...)
""")
        return "".join(_page)
    def tutorialContent(self):
        _page=[]
        _page.append("""The best way to learn about CherryPy is to follow the tutorial.<br>
You can browse it online <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/html/tut/index.html'))
        _page.append("""\">here</a>.<br>
It is also available in pdf format <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/tut.pdf'))
        _page.append("""\">here</a> (124K)
and in postscript format <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/tut.ps'))
        _page.append("""\">here</a> (129K).
""")
        return "".join(_page)
    def howToContent(self):
        _page=[]
        _page.append("""For a more advanced use of CherryPy, check out the HowTo list.<br>
You can browse it online <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/html/howto/index.html'))
        _page.append("""\">here</a>.<br>
It is also available in pdf format <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/howto.pdf'))
        _page.append("""\">here</a> (98K)
and in postscript format <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/howto.ps'))
        _page.append("""\">here</a> (100K).
""")
        return "".join(_page)
    def libContent(self):
        _page=[]
        _page.append("""CherryPy comes with a set of useful CherryClasses. These CherryClasses make the CherryPy Standard Library.<br>
You can browse the documentation online <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/html/lib/index.html'))
        _page.append("""\">here</a>.<br>
It is also available in pdf format <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/lib.pdf'))
        _page.append("""\">here</a> (47K)
and in postscript format <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/pdf/lib.ps'))
        _page.append("""\">here</a> (59K).
""")
        return "".join(_page)
    def comingSoonContent(self):
        _page=[]
        _page.append("""- CHTL and CGTL reference<br>
- CherryPy source files syntax reference<br>
- More HowTo's<br>
- FAQ<br>
- ...
""")
        return "".join(_page)
    def currentDevelopment(self):
        _page=[]
        _page.append(str(self.header('Current development')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Current development', self.currentDevelopmentContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def currentDevelopmentContent(self):
        _page=[]
        _page.append("""Here are the things we're working on at the moment:
<ul>
<li>
    <b>Low priority</b>:
    <ul>
    <li><b>SSL demo</b>: CherryPy already supports SSL, so we're working on putting together a demo to prove it :-)</li>
    <li><b>More HowTos</b>: The tutorial is a good starting point for learning to develop a website, but we're working on
    writing more HowTos that will explain how to do more advanced things...</li>
    </lu>
</li>
</ul>
""")
        return "".join(_page)
    def aboutSite(self):
        _page=[]
        _page.append(str(self.header('About CherryPy.org')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('About CherryPy.org', self.aboutSiteContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def aboutSiteContent(self):
        _page=[]
        _page.append("""This site itself is a nice example of a setup that can be used for most production websites.<br>
There is a HowTo that describes exactly how this site is set up. It can be found
<a class=moduleLink href="/static/html/howto/node22.html">here</a>.<br><br>
In short:
<ul>
<li>The site runs on Python-2.3 and it uses the latest CherryPy version</li>
<li>The HTTP server runs a pool of threads and it runs exposed (no Apache)</li>
<li>Each thread has its own connection to a MySql database</li>
<li>The site uses sessions. Session data is stored in RAM and all threads have access to it (so it doesn't matter if two requests from the same client are handled by two different threads)</li>
<li><b>The site runs for weeks without having to be restarted or leaking memory</b></li>
</ul>
""")
        return "".join(_page)
    def talk(self):
        _page=[]
        _page.append(str(self.header('They talk about CherryPy')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('They talk about CherryPy', self.talkContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def talkContent(self):
        _page=[]
        _page.append("""Here is what users say about CherryPy:<br><br>
<i>
"Just wanted to give another huge thank you for a wonderful tool.  I built a
auction catalog service for a client using CherryPy 0.9 and it handled like
a charm.  The site was basically a large searchable catalog and coincides with
a satellite TV auction (meaning that everyone is hitting the server all at once
as a new lot comes up).  During the sale the site was easily 5 or 10 requests
per second and it barely made a blip on the server it was running on.  My setup
was two separate instances of CP running in ThreadPool mode behind balance
behind Apache.  I wanted a couple separate servers in case one died but neither
of them did.  Everything worked flawlessly and the client was very happy.
<br>
A year before I had built a version using webware and it brought the server
down under the load.  I decided to move to CP because it was easier and simpler
to follow what was happening.  I'm really happy with it."
</i><br>
<a class=moduleLink href="http://sourceforge.net/mailarchive/forum.php?thread_id=3547475&forum_id=9986">Jeff Clement on Dec 1, 2003</a>
<br><br>
<i>
"CherryPy is such an intuitive way to produce dynamic web pages. Remi has
provided a first rate package that does everything I need. The excellent
documentation makes it easy to learn CherryPy. The templating languages,
standard libraries and examples are great building blocks that allow a
relative Python newbie like me to create a very functional Intranet site."
</i><br>
<a class=moduleLink href="http://sourceforge.net/mailarchive/forum.php?thread_id=2603446&forum_id=9986">Scott Luck on Jun 17, 2003</a>
<br><br>
<i>
"I am a ex-zope user and I love cherrypy. [...]
CherryPy not only lets me develop in python, but bypasses zope's
problem with regular files altogether. I told a friend of mine that he ought to
drop 6 months of zope work and go with cherrypy. ;-)"
</i><br>
<a class=moduleLink href="http://sourceforge.net/mailarchive/forum.php?thread_id=2580389&forum_id=9986">Darryl Caldwell on Jun 13, 2003</a>
<br><br>
<i>
"We've chosen to deploy with CherryPy, a fantastic open-source tool. [...] It makes putting together a
dynamic, object oriented site a quick and painless proposition. It's extremely flexible and offers a fresh way
to approach site design without all the overhead of a big CMS. [...] Every time I thought I'd have to write a
utility class from scratch, I've discovered that the functionality was already built in"
</i><br>
Steve Nieker from the Waypath project on Mar 17, 2003
<br><br>
<i>
"What's so exciting about CherryPy is that is lowers the floor for web programming while raising the power. [...]
It also unifies a collection of often difficult tools into a coherent methodology without sacrificing power. [...]
Perhaps most exciting, CherryPy's approach means that the kind of quick hacks that programmers do for fun
or curiosity can now include complete web-served applications. That's just the kind of ease-of-creation that
will foster the exploration of distributed, edge computing."
</i><br>
<a class=moduleLink href="http://garyboone.com/categories/theUniversalMachine/2003/03/09.html">Gary Boone on Mar 09, 2003</a>
<br><br>
<i>
"Finally something in this field that seems
clean, simple and effective! I've looked at a number of
systems like ZOPE, Quixhote, Webware etc, and this is
the first that that made me feel that it's just what
I wanted."
</i><br>
Magnus Lycka on Aug 08, 2002
<br><br>
<i>
"I like the ideas behind CherryPy immensely."
</i><br>
Tim Jarman on Jul 17, 2002
<br><br>
<i>
"I have to say cherrypy is really quite interesting. Rather different from a
lot of things out there."
</i><br>
Mukhsein Johari on Jul 28, 2002
<br><br>
<i>
"CherryPy is simple, beautiful, elegant and awesome. I've always wanted something like this, but I was technically not capable of pulling it off myself. But now my seach is over.
Thank you for making available and sharing just a wonderful piece of creation."
</i><br>
Sammy from Vancouver on Aug 05, 2002
<br><br>
<i>
"I'am just starting with CherryPy and I like it to much, it work much at the style of my
brain than zope. [...] Thanks for this great tool."
</i><br>
<a class=moduleLink href="http://sourceforge.net/mailarchive/forum.php?thread_id=944866&forum_id=9986">Cristian Echeverria on Aug 01, 2002</a>
""")
        return "".join(_page)
    def search(self, keyWord=''):
        _page=[]
        _page.append(str(self.header('Search result')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Search result', self.searchResultContent(keyWord))))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def searchResultContent(self, keyWord):
        _page=[]
        if not keyWord.split():
            _page.append("""
    <b>You must specify a keyWord</b>
""")
        else:
            _page.append("""
    """)
            searchResult=self.getSearchResult(keyWord)
            _page.append("""
    """)
            if not searchResult:
                _page.append("""<b>Sorry, no result found for \"""")
                _page.append(str(keyWord))
                _page.append("""\".</b>""")
            _page.append("""
    """)
            _index12=locals().get("_index", -1)
            _end12=locals().get("_end", -1)
            _index=-1
            try: _end=len(searchResult)-1
            except TypeError: _end=-1
            for url, title, score in searchResult:
                _index+=1
                _page.append("""
        """)
                if _index==0:
                    _page.append("""
            <b>""")
                    _page.append(str(_end+1))
                    _page.append(""" result""")
                    if _end>0:
                        _page.append("""s""")
                    _page.append(""" found for \"""")
                    _page.append(str(keyWord))
                    _page.append("""\":</b><br><br>
            <table>
                <tr>
                    <td class=moduleText><b>Title</b></td>
                    <td width=40 class=moduleText>&nbsp;</td>
                    <td class=moduleText><b>Score</b></td>
                </tr>
        """)
                _page.append("""
        <tr>
            <td><a class=moduleLink href=\"""")
                _page.append(str(url))
                _page.append("""\">""")
                _page.append(str(title))
                _page.append("""</a></td>
            <td width=40 class=moduleText>&nbsp;</td>
            <td class=moduleText>""")
                _page.append(str(score))
                _page.append("""</td>
        </tr>
        """)
                if _index==_end:
                    _page.append("""
            </table>
        """)
                _page.append("""
    """)
            _index=_index12
            _end=_end12
            _page.append("""
""")
        _page.append("""
""")
        return "".join(_page)
    def cherryForum(self):
        _page=[]
        _page.append(str(self.header('CherryForum')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('CherryForum', self.cherryForumContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def cherryForumContent(self):
        _page=[]
        _page.append("""<b>CherryForum</b> is a web forum written using <b>CherryPy</b> as well as the new framework
I'm working on: <b>CherryObjects</b>.<br>
The source code for CherryObjects and CherryForum will be released when it's stabilized a bit (it is evolving
quite rapidly at the moment), and when I find the time to do it ...<br>
In the mean time, I've put online an instance of CherryForum that will be used as:
<ul>
<li>A web forum for the CherryPy community, where people can ask questions about CherryPy</li>
<li>A web forum for CherryForum itself, where people can ask questions about CherryForum and ask for new features</li>
<li>A testbed for CherryForum (as it is still in alpha stage)</li>
<li>A web forum for CherryObjects (when I make a first release)</li>
</ul>
This web forum can be found <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/myForum/index'))
        _page.append("""\">here</a>
<br><br>
<b>CherryForum documentation</b>:<br>
CherryForum is still in beta stage and the number of features is limited.<br>
Here are a few tips that you can use when typing your posts:<br>
<ul>
<li><b>HTML code</b>: you can safely type HTML code (special characters will be escaped when the post is rendered)</li>
<li><b>Links</b>: when you want to put a link in your post, just type the url, starting with "http://" and CherryForum
will automatically recognize this as a link</li>
</li>
""")
        return "".join(_page)
    def europython2003(self):
        _page=[]
        _page.append(str(self.header('CherryPy at EuroPython 2003')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('CherryPy at EuroPython 2003', self.europython2003Content())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def europython2003Content(self):
        _page=[]
        _page.append("""The slides I used to give a CherryPy presentation at EuroPython 2003 are available in a PowerPoint format
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/CherryPy-EuroPython2003.ppt'))
        _page.append("""\">here</a> and in a PDF format
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/static/CherryPy-EuroPython2003.pdf'))
        _page.append("""\">here</a><br>
Don't expect too much from these slides, as I only had 30 minutes to make them and the presentation could only last
10 minutes at most ...<br><br>
As a special bonus, here is a picture of me doing the presentation :-):<br><br>
<center>
<img src=\"""")
        _page.append(str(request.base+'/static/Cherrypy-EuroPython.jpg'))
        _page.append("""\">
</center>
""")
        return "".join(_page)
    def cherrypy_0_9_beta(self):
        _page=[]
        _page.append(str(self.header('Improvements in CherryPy-0.9-beta')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('Improvements in CherryPy-0.9-beta', self.cherrypy_0_9_betaContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def cherrypy_0_9_betaContent(self):
        _page=[]
        _page.append("""This beta release includes a lot of improvements.<br>
The new documentation (updated tutorial and HowTos) is included
when you download the file.<br>
To download this release, just go to the <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/download'))
        _page.append("""\">download area</a>.<br>
This is a beta release, so don't expect it to be bug-free. We count on you to test it and give us some feedback.<br>
<br>
<b>Main improvements:</b>
<ul>
<li><b>Session handling</b>: This release of CherryPy is the first one to handle sessions. A new HowTo called "How to
use sessions with CherryPy" explains how it works. A new entry has also been added to the demo to demonstrate this
new feature. Note that the options for session data storage are restricted for now, but we hope to make more options
available soon (for instance, the ability to store session data in a database).
</li>
<li><b>Python2.3 and Jython compatibility</b>: CherryPy now works with Python2.3 and Jython
<li><b>Regression test suite</b>: CherryPy now comes with a regression test suite. Please run it on your machine
and let us know if some tests fail on your machine. Just read "README.TXT" to see how to run the test suite.
</li>
<li><b>Default to /index for CherryClasses</b>: If someone types the URL http://domain/dir1/dir2, then CherryPy will
convert it first to dir1.dir2(), but if there is no such method, it will convert it to dir1_dir2.index(). The tutorial
has been updated to explain this. (Many thanks to Nolan J. Darilek for this improvement)
</li>
<li><b>XML-RPC</b>: The XML-RPC engine has been improved and is now more powerful and robust. The HowTo about XML-RPC
has been updated to explain how XML-RPC now works. (Many thanks to Steven Nieker for this improvement)
</li>
<li><b>Filename extension for """)
        _page.append(str('py-'+'include'))
        _page.append("""</b>: An annoying bug was forcing users to call their template files "*.cpyt"
when using them in a \"""")
        _page.append(str('py-'+'include'))
        _page.append("""\". This has been fixed and you can now use any extension you want.
</li>
<li><b>Better cookie support</b>: CherryPy now uses the standard "Cookie" module from python (in particular, the
"SimpleCookie" object type) to handle cookies. A new HowTo called "HowTo use cookies with CherryPy" has been added
to the documentation.
</li>
<li><b>Easier way to run cherrypy.org on your machine</b>: The tar file comes with the source code for the
cherrypy.org website. Everyone can now easily run this site on their local machine (even if they don't have a
database installed). Just read "README.TXT" to see how to compile it and run it.
</li>
<li><b>Easier way to get logged in user in HttpAuthenticate and CookieAuthenticate</b>: It is now easier to find
out which user is logged in when using these 2 modules. The documentation and the demo for these modules has been
updated to show how it is done.
</li>
<li><b>"hidden" property now inherited</b>: If you declare a hidden CherryClass or a hidden mask and view and
then you declare a CherryClass that inherits from the first one, then the "hidden" property is now inherited as
well by default. The HowTo about hidden masks and views has been updated to explain how it works. Many thanks
to Scott Luck for this improvement.
</li>
</ul>
For a complete list of improvements, please refer to the ChangeLog.txt file included in the release.<br>
<br>
<b>Backward incompatibilities:</b>
<ul>
<li><b>XML-RPC</b>: If you were using XML-RPC with cherrypy-0.8, chances are your code won't work anymore with this
release. So you should read the updated HowTo about XML-RPC to learn how XML-RPC now works.
</li>
<li><b>New cookie handling</b>: "cookieMap" is no longer available. You should now use "simpleCookie". Check out the
new HowTo about how to use cookies with CherryPy to learn how it works.
</li>
<li><b>Default to /index for CherryClasses</b>: A few sites might be affected by this change (but only if you were
doing something very unusual with URLs).
</li>
</ul>
<br>
<b>Future improvements:</b><br>
Here is a list of improvements I hope to be able to include in the final 0.9 release:
<ul>
<li><b>More options for sessions</b>: I hope to be able to implement a lot more options for handling sessions (the
ability to store session data to a database, the ability to specify when session data should be saved, ...)
</li>
<li><b>Centralized documentation</b>: I'd like to merge all documentation (tutorial, HowTos, lib) into
a single documentation with a common master page.
</li>
</ul>
""")
        return "".join(_page)
    def cherrypy_0_9_gamma(self):
        _page=[]
        _page.append(str(self.header('What\'s new in CherryPy-0.9-gamma')))
        _page.append("""
    <td width=80% valign=top align=center>
        """)
        _page.append(str(self.square('What\'s new in CherryPy-0.9-gamma', self.cherrypy_0_9_gammaContent())))
        _page.append("""
    </td>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def cherrypy_0_9_gammaContent(self):
        _page=[]
        _page.append("""This gamma release includes a lot of improvements/bug fixes.<br>
The new documentation (updated tutorial and HowTos) is included
when you download the file.<br>
To download this release, just go to the <a class=moduleLink href=\"""")
        _page.append(str(request.base+'/download'))
        _page.append("""\">download area</a>.<br>
To find out what was new in the previous beta release, check out this page
<a class=moduleLink href=\"""")
        _page.append(str(request.base+'/cherrypy_0_9_beta'))
        _page.append("""\">this page</a><br>
This is a gamma release, so don't expect it to be bug-free. We count on you to test it and give us some feedback.<br>
<br>
<b>New features:</b>
<ul>
<li><b>Thread-pool server</b>: This release allows you to run the HTTP server in a thread-pool mode: a fixed
number of threads is created at start-up and these threads handle the requests. To find out about the
new configuration options, check out the chapter "Deploying your website for production" of the tutorial.
</li>
<li><b>Sessions fixed</b>: A bug that caused session data to disappear unexpectedly has been fixed</li>
<li><b>Ability to store session data in a database</b>: Check out the HowTo about sessions to learn how
to do that.
</li>
<li><b>New HowTo about using Cheetah templates</b></li>
<li><b>DCOracleFull.cpy</b>: New library module for accessing an Oracle database (thanks to Brent Fentem)</li>
<li><b>socketQueueSize in config file</b>: New configuration option called "socketQueueSize" to control
the size of the socket queue (default is 5)</li>
<li><b>reverseDNS in config file</b>: New configuration option to enable/disable reverse DNS (default is disabled)</li>
<li><b>Handling of "Last-Modified" and "If-Modified-Since" for static content</b>: This allows the browser
to cache static data like images</li>
</ul>
For a complete list of improvements, please refer to the ChangeLog.txt file included in the release.<br>
<br>
<b>Backward incompatibilities:</b>
<ul>
<li><b>Aspects</b>: In aspect headers, the keyword "function" has been replaced with the more generic keyword
"method". So instead of writing "function.name=='...'", you now have to write "method.name='...'".<br>
A new attribute called "className" has been added as well.
</li>
<li><b>fixedNumberOfProcesses</b>: The configuration file option "fixedNumberOfProcesses" is now
called "processPool".
</li>
</ul>
""")
        return "".join(_page)
    def previewMessage(self, text, **kw):
        _page=[]
        _page.append("""<html>
<head>
    <title>CherryPy : Message preview</title>
    <style type="text/css">
    <!--
    .moduleTitle {font-size:14px; font-weight:bold; color:white; font-family:arial}
    .moduleLink {font-size:12px; color:#BD1E26; font-family:arial}
    .moduleLink:hover {font-size:12px; color:red; font-family:arial}
    .moduleLinkB {font-size:12px; font-weight:bold; color:#BD1E26; font-family:arial}
    .moduleLinkB:hover {font-size:12px; font-weight:bold; color:red; font-family:arial}
    .moduleText {font-size:12px; color:black; font-family:arial}
    .moduleTextB {font-size:12px; font-weight:bold; color:#BD1E26; font-family:arial}
    -->
    </style>
</head>
<body bgcolor=white topmargin="0" marginheight="0">
    <center>
    <table border=0 cellspacing=0 cellpadding=0 width=60%><tr><td align=center>
        <br>
        """)
        _page.append(str(self.square('Message preview', cherryPyForumDesign.cookText(text))))
        _page.append("""
        <br>
        <form action="">
        <input type=submit value="Close this window" onClick="window.close();">
        </form>
    </td></tr></table>
    </center>
</body>
""")
        return "".join(_page)
global Sql
class Sql:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/sql"
        else:
            return "/sql"
    def query(self, query):
        if not request.hasDatabase: return
        c=request.connection.cursor()
        c.execute(query)
        res=c.fetchall()
        c.close()
        print "query:", query, "res:", res
        return res
    def logPageStat(self):
        if not request.hasDatabase: return
        ip=request.headerMap.get('remote-addr', '')
        server=request.headerMap.get('remote-host', '')
        previousPage=request.headerMap.get('referer', '')
        self.query('insert into cherrypy_stat values ("%s", "%s", "%s", "%s",     "%s")'%(
            ip, server, previousPage, request.browserUrl, frenchTools.getNow()))
global ViewStat
class ViewStat(HttpAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/viewStat"
        else:
            return "/viewStat"
    def getPasswordListForLogin(self, login):
        if login==configFile.get('restrictedArea', 'login'): return [configFile.get('restrictedArea', 'password')]
        return []
    def viewPage(self, start=0, end=100):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        start=int(start)
        end=int(end)
        res=sql.query('select * from cherrypy_stat order by creationTime desc limit 500')
        page="<table border=1><tr><th>Ip</th><th>Host</th><th>Referrer</th><th>Url</th><th>Time</th></tr>"
        for ip, host, referrer, url, time in res[start:end]:
            page+="<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>"%(
                ip, host, referrer, url, time)
        link='<a href="%s/viewPage?start=%s&end=%s">See next 100 pages</a>'%(self.getPath(), start+100, end+100)
        return "<html><body>"+page+"</table>%s</body></html>"%link
    def viewStat(self, day):
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        if day=='today':
            date=frenchTools.getNow()
            year, month, myDay=int(date[:4]), int(date[5:7]), int(date[8:10])
        else:
            date=frenchTools.getNowMinus(1)
            year, month, myDay=int(date[:4]), int(date[5:7]), int(date[8:10])
        res=sql.query('select count(distinct(ip)) from cherrypy_stat where creationTime between "%s/%s/%s 00:00:00" and "%s/%s/%s 23:59:59"'%(
            year, month, myDay, year, month, myDay))
        user=res[0][0]
        res=sql.query('select count(*) from cherrypy_stat where creationTime between "%s/%s/%s 00:00:00" and "%s/%s/%s 23:59:59"'%(
            year, month, myDay, year, month, myDay))
        page=res[0][0]
        return "<html><body>Visiteurs:%s<br>Pages vues:%s</body></html>"%(user, page)
    def index(self):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        _page.append("""<html><body>
    <a href="viewPage">Voir les pages</a><br>
    <a href="viewStat?day=today">Voir les stats pour aujourd'hui</a><br>
    <a href="viewStat?day=yesterday">Voir les stats pour hier</a><br>
</body></html>
""")
        return "".join(_page)
global XslTransform
class XslTransform:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/xslTransform"
        else:
            return "/xslTransform"
    def transform(self, xslStylesheet, xmlInput):
        processor=Processor.Processor()
        sheet=InputSource.DefaultFactory.fromString(xslStylesheet, "")
        source=InputSource.DefaultFactory.fromString(xmlInput, "")
        processor.appendStylesheet(sheet)
        return processor.run(source)
global Demo
class Demo:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/demo"
        else:
            return "/demo"
    def htmlQuote(self, data):
        entityMap=[
            ('&','&amp;'),
            ('<','&lt;'),
            ('>','&gt;'),
            ('"','&quot;')]
        for k,v in entityMap: data=data.replace(k,v)
        return data
    def streamingResult(self):
        import time
        response.wfile.write("HTTP/1.0 200\r\n")
        response.wfile.write("Content-Type: text/html\r\n\r\n")
        response.wfile.write("<html><body>\n")
        response.wfile.write("First line. Sleeping 2 seconds ...<br>")
        response.wfile.write("<!-- " + "X"* 200 + "-->") # To force IE to display beginning of page
        time.sleep(2)
        response.wfile.write("Second line. Sleeping 2 seconds ...<br>")
        time.sleep(2)
        response.wfile.write("Third and last line")
        response.wfile.write("</body></html>")
        response.sendResponse = 0
        return "" # The view still needs to return a string
    def viewCode(self, code):
        code=code.replace('&','&amp;')
        code=code.replace('>','&gt;').replace('<','&lt;').replace('\t','&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;').replace(' ','&nbsp;').replace('\n','<br>')
        code=code.replace('$#', '#')
        for tag in ['py-eval', 'py-exec', 'py-code', 'py-attr', 'py-if', 'py-else', 'py-for', 'py-debug']:
            i=-20
            while 1:
                i=code.find(tag, i+20)
                if i==-1: break
                if code[i+len(tag)]=='=':
                    if tag=="py-exec": j=code.find('"&gt;', i+len(tag)+2)
                    else: j=code.find('"', i+len(tag)+2)
                    code=code[:i]+'<font color=red>'+tag+'</font>=<font color=green>'+code[i+len(tag)+1:j+1]+'</font>'+code[j+1:]
                else:
                    code=code[:i]+'<font color=red>'+tag+'</font>'+code[i+len(tag):]
        code='<font face=arial size=2 color=navy>'+code+'</font>'
        code=code.replace('$$','')
        return code
    def streamingCode(self):
        return '''
        CherryClass Root:
        view:
            def index(self):
                import time
                response.wfile.write("HTTP/1.0 200\\r\\n")
                response.wfile.write("Content-Type: text/html\\r\\n\\r\\n")
                response.wfile.write("<html><body>\\n")
                response.wfile.write("First line. Sleeping 2 seconds ...<br>")
                response.wfile.write("<!-- " + "X"* 200 + "-->") # To force IE to display beginning of page
                time.sleep(2)
                response.wfile.write("Second line. Sleeping 2 seconds ...<br>")
                time.sleep(2)
                response.wfile.write("Third and last line")
                response.wfile.write("</body></html>")
                response.sendResponse = 0
                return "" # The view still needs to return a string
        '''
    def headerTemplateCode(self):
        return """
        <html><body>
            Hi, I'm the header. I'll be almost the same for all pages of the site. This will provide a constant look for the site.<br>
            By the way, the time on the server is: <b py-eval="time.time()">time</b><br><br>
        """
    def footerTemplateCode(self):
        return """
            <br><br>Hi, I'm the footer
        </body></html>
        """
    def indexTemplateCode(self):
        return """
        <div py-include="header.html">Header</div>
            Hello, <b py-eval="name">name</b> !<br>
            Do you like cherry pie ?
        <div py-include="header.html">Footer</div>
        """
    def indexCherryTemplateCode(self):
        return """
        CherryClass Root:
        mask:
            def index(self, name='John'):
                <py-include="index.html">
        """
    def oopCode(self):
        return """
        def initServer():
            genericStore.itemList=[bookStore, dvdStore, videoGameStore]
        $$
        $########################
        CherryClass GenericStore:
        $########################
        mask:
            $# Home page: display the list of item types and let the user choose one
            def index(self):
                <html><body><center><br><br><br>
                    Welcome to the store. Choose what you want to buy:<br><br>
                    <table cellspacing=10><tr>
                    <py-for="itemType in self.itemList">
                        <td py-attr="itemType.color" bgcolor="">
                            <a py-attr="itemType.getPath()+'/viewList'" href="" py-eval="itemType.label+'s'"></a>
                        </td>
                    </py-for>
                    </tr></table>
                </center></body></html>
            def viewList(self):
                <html><body><center><br><br><br>
                <b py-eval="self.label.upper()+'S'"></b><br><br>
                Click on a <py-eval="self.label"> title to view it:<br><br>
                <table py-attr="self.color" bgcolor="" cellpadding=5>
                    <py-for="item in self.itemList">
                        <tr><td><a py-attr="self.getPath()+'/viewItem?itemIndex=%s'%_index" href="" py-eval="item[0]"></a></td></tr>
                    </py-for>
                </table>
                </center></body></html>
            $# Default viewItem mask (used for DVDs and Video games). Will be overwritten for books
            def viewItem(self, itemIndex):
                <py-exec="title, price=self.itemList[int(itemIndex)]">
                <html><body><center><br><br><br>
                    <table py-attr="self.color" bgcolor="" cellpadding=5>
                        <tr><td>Title: <py-eval="title"></td></tr>
                        <tr><td>Price: <py-eval="price">$</td></tr>
                    </table>
                </center></body></html>
        $$
        $########################
        CherryClass BookStore(GenericStore):
        $########################
        variable:
            label='book'
            color='pink'
            itemList=[('Harry Potter and the Goblet of Fire', '18', 'J. K. Rowling'), ('I love CherryPy', '5', 'Remi Delon')]
        mask:
            $# We have to overwrite viewItem for books, because we have to display the author too
            def viewItem(self, itemIndex):
                <py-exec="title, price, author=self.itemList[int(itemIndex)]">
                <html><body><center><br><br><br>
                    <table py-attr="self.color" bgcolor="" cellpadding=5>
                        <tr><td>Title: <py-eval="title"></td></tr>
                        <tr><td>Price: <py-eval="price">$</td></tr>
                        <tr><td>Author: <py-eval="author"></td></tr>
                    </table>
                </center></body></html>
        $$
        $########################
        CherryClass DvdStore(GenericStore):
        $########################
        variable:
            label='DVD'
            color='red'
            itemList=[('Star Wars Episode 1', '25'), ('The Legend of CherryPy', '4')]
        $$
        $########################
        CherryClass VideoGameStore(GenericStore):
        $########################
        variable:
            label='video game'
            color='yellow'
            itemList=[('Cool Rider 3', '29'), ('CherryPy Eating Contest', '7')]
        """
    def httpAuthenticateCode(self):
        return """
        CherryClass HttpProtected(HttpAuthenticate):
        function:
            def getPasswordListForLogin(self, login):
                if login=="login": return ["password"]
                return []
        mask:
            def index(self):
                <html><body>You're in, your login is: <py-eval="self.login"></body></html>
        """
    def cookieAuthenticateCode(self):
        return """
        CherryClass CookieProtected(CookieAuthenticate):
        function:
            def getPasswordListForLogin(self, login):
                if login=="login": return ["password"]
                return []
        mask:
            def index(self):
                <html><body>You're in, your login is: <py-eval="self.login"></body></html>
        """
    def sessionsCode(self):
        return """
        <py-code="
            count=request.sessionMap.get('pageViews', 0)+1
            request.sessionMap['pageViews']=count
        ">
        Hello, you've been here <py-eval="count"> time(s).<br>
        Refresh this page to increment the counter.<br>
        If you close your browser or stop accessing this site for an hour, your session data will expire and the counter
        will be reset.<br>
        Your session ID is: <py-eval="request.sessionMap['_sessionId']">
        """
    def cookieCode(self):
        return """
        def cookie(self, addOrRemove=''):
            Value of simpleCookie: <py-eval="request.simpleCookie"><br>
            Click <a href="cookie?addOrRemove=add">here</a> once to set the cookies and twice to see them in <i>simpleCookie</i><br>
            Click <a href="cookie?addOrRemove=remove">here</a> once to remove the cookies and twice to see it in <i>simpleCookie</i>
            </body></html>
        <py-if="addOrRemove=='add'">
            <py-code="
                response.simpleCookie['cookieName']='cookieValue'
                response.simpleCookie['cookieName']['path']='/'
                response.simpleCookie['cookieName']['max-age']=3600
                response.simpleCookie['cookieName']['version']=1
            ">
            <py-code="
                response.simpleCookie['cookieName2']='cookieValue2'
                response.simpleCookie['cookieName2']['path']='/'
                response.simpleCookie['cookieName2']['max-age']=3600
                response.simpleCookie['cookieName2']['version']=1
            ">
        </py-if>
        <py-if="addOrRemove=='remove'">
            <py-code="
                response.simpleCookie['cookieName']=''
                response.simpleCookie['cookieName']['path']='/'
                response.simpleCookie['cookieName']['max-age']=0
                response.simpleCookie['cookieName']['version']=1
            ">
            <py-code="
                response.simpleCookie['cookieName2']=''
                response.simpleCookie['cookieName2']['path']='/'
                response.simpleCookie['cookieName2']['max-age']=0
                response.simpleCookie['cookieName2']['version']=1
            ">
        </py-if>
        """
    def formCode(self):
        return """
        CherryClass TestForm(Form):
        function:
            def __init__(self):
                headerSep=FormSeparator('', defaultFormMask.defaultHeader)
                textField=FormField(label='Text field:', name='textField', mandatory=1, typ='text')
                textareaField=FormField(label='Textarea field:', name='textareaField', mandatory=1, typ='textarea', size='30x5')
                selectField=FormField(label='Select field:', name='selectField', mandatory=1, typ='select', optionList=['Option 1', 'Option 2', 'Option 3'])
                radioField=FormField(label='Radio field:', name='radioField', mandatory=1, typ='radio', optionList=['Option 1', 'Option 2', 'Option 3'])
                checkboxField=FormField(label='Checkbox field:', name='checkField', mandatory=0, typ='checkbox', optionList=['Option 1', 'Option 2', 'Option 3'])
                submitField=FormField(label='', name='Submit', typ='submit')
                footerSep=FormSeparator('', defaultFormMask.defaultFooter)
                self.fieldList=[headerSep, textField, textareaField, selectField, radioField, checkboxField, submitField, footerSep]
        mask:
            def index(self, **kw):
                <html><body>
                    Fill out the form and hit "Submit". If you forget any mandatory fields, the form will
                    be displayed again, and the errors will be indicated:<br>
                    <py-eval="self.formView(0)">
                </html><body>
        view:
            def postForm(self, **kw):
                if self.validateForm():
                    res="<html><body>"
                    for key, value in kw.items():
                        res+="%s : %s <br>"%(key, value)
                    return res+"</body></html>"
                else:
                    return "<html><body><font color=red>Fill out missing fields</font>"+self.formView(1)+"</body></html>"
        """
    def postFormCode(self):
        return """
        Enter your name and a photo:
        <form method=post action=postFile enctype="multipart/form-data">
            Name: <input name=name><br>
            Photo: <input type=file name=photo><br>
            <input type=submit>
        </form>
        """
    def postFormActionCode(self):
        return """
        def postFile(self, name, photo):
            <html><body>
                Name: <py-eval="name"><br>
                Size of the photo: <py-eval="len(photo)"> bytes<br>
                Filename of the photo: <py-eval="request.filenameMap['photo']"><br>
                Mime type of the photo: <py-eval="request.fileTypeMap['photo']">
            </body></html>
        """
    def webColorCode(self):
        return """
        <py-exec="codeList=['00', '33', '66', '99', 'CC', 'FF']">
        <table border=1>
        <py-for="r in codeList">
            <py-for="g in codeList">
                <tr>
                    <py-for="b in codeList">
                        <py-exec="color='#%s%s%s'%(r,g,b)">
                        <td py-attr="color" bgColor="" py-eval="'&nbsp;&nbsp;'+color+'&nbsp;'"></td>
                    </py-for>
                </tr>
            </py-for>
        </py-for>
        </table>
        """
    def maskToolsCode(self):
        return """
        <py-eval="maskTools.textInBox('This is some text displayed in a red box filled with yellow', boxColor='red', insideColor='yellow')">
        <br>
        Display integers from 1 to 102 in 7 columns with 20 pixels between each column:
        <py-eval="maskTools.displayByColumn(map(str,range(1,103)), 7, 0, 20)">
        <br>
        Display integers from 1 to 102 in 7 lines with 5 pixels between each line:
        <py-eval="maskTools.displayByLine(map(str,range(1,103)), 7, 0, 5)">
        """
    def xmlXslSampleCode(self):
        return """
        from Ft.Xml.Xslt.Processor import Processor
        $$
        CherryClass XslTransform:
        function:
            def transform(self, xslStylesheet, xmlInput):
                processor = Processor()
                processor.appendStylesheetString(xslStylesheet)
                return processor.runString(xmlInput, 0, {})
        $$
        CherryClass Root:
        view:
            def index(self):
                return xslTransform.transform(self.xslStylesheet(), self.xmlInput())
        mask:
            def xslStylesheet(self):
                <?xml version="1.0" encoding="ISO-8859-1"?>
                <xsl:stylesheet version="1.0"
                    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
                <xsl:template match="/">
                    <html><body>
                        <h2>My CD Collection</h2>
                        <table border="1">
                            <tr bgcolor="#9acd32">
                                <th align="left">Title</th>
                                <th align="left">Artist</th>
                            </tr>
                            <xsl:for-each select="catalog/cd">
                                <tr>
                                    <td><xsl:value-of select="title"/></td>
                                    <td><xsl:value-of select="artist"/></td>
                                </tr>
                            </xsl:for-each>
                        </table>
                    </body></html>
                </xsl:template>
                </xsl:stylesheet>
            def xmlInput(self):
                <?xml version="1.0" encoding="ISO-8859-1"?>
                <catalog>
                    <cd>
                        <title>Empire Burlesque</title>
                        <artist>Bob Dylan</artist>
                    </cd>
                    <cd>
                        <title>Hide your heart</title>
                        <artist>Bonnie Tyler</artist>
                    </cd>
                </catalog>
        """
    def xmlXslOnlineCode(self):
        return """
        from Ft.Xml.Xslt.Processor import Processor
        $$
        CherryClass Root:
        function:
            $$
            $#################################################
            $# Function to escape special characters in textareas
            $#################################################
            def htmlQuote(self, data):
                entityMap={
                    '&':'&amp;',
                    '<':'&lt;',
                    '>':'&gt;',
                    '"':'&quot;'}
                for k,v in entityMap.items(): data=data.replace(k,v)
                return data
            $$
            $#################################################
            $# Function to perform transformation: only 3 lines of code !
            $#################################################
            def transform(self, xslStylesheet, xmlInput):
                processor = Processor()
                processor.appendStylesheetString(xslStylesheet)
                return processor.runString(xmlInput, 0, {})
        $$
        mask:
            $$
            $#################################################
            $# Main function: display textareas and result
            $#################################################
            def xmlXslOnline(self, xmlDocument="", xslStylesheet=""):
                <html><head><title>Online XML/XSL transformation tool</title></head><body>
                <h2>Online XML/XSL transformation tool</h2>
                <table border=0><tr>
                <td>
                    The following tool lets you enter an XML document, an XSL stylesheet, and it shows the result of the transformation.<br>
                    This tool has been written with only a few lines of <a py-attr="request.base" href="">CherryPy</a> code
                    and it uses the <a href="http://4suite.org">4Suite module</a>.<br>
                    The source code is available <a py-attr="self.getPath()+'/xmlXslOnlineSourceCode'" href="">here</a><br><br>
                </td>
                <td width=50>&nbsp;</td>
                <td valign=middle>
                    <a py-attr="request.base" href=""><img py-attr="request.base+'/static/poweredByCherryPy.gif'" src="" border=0 alt="Powered by CherryPy"></a>
                </td>
                </table>
                <form action="xmlXslOnline" method="post" style="margin-top: 0; margin-bottom: 0">
                <table border=0>
                <tr>
                    <td align=center><b>XML document:</b>
                    <td width=50>&nbsp;</td>
                    <td align=center><b>XSL stylesheet:</b>
                </tr>
                <tr>
                    <td align=center>
                        <textarea name=xmlDocument rows=15 cols=55><py-code="
                            if xmlDocument: _page.append(self.htmlQuote(xmlDocument))
                            else: _page.append(self.htmlQuote(self.xmlInput().replace('\\t','  ')))
                        "></textarea>
                    </td>
                    <td width=50>&nbsp;</td>
                    <td align=center>
                        <textarea name=xslStylesheet rows=15 cols=55><py-code="
                            if xmlDocument: _page.append(self.htmlQuote(xslStylesheet))
                            else: _page.append(self.htmlQuote(self.xslStylesheet().replace('\\t','  ')))
                        "></textarea>
                    </td>
                </tr>
                <tr><td colspan=3 align=center><br><input type=submit value="Run transformation"></td></tr>
                </table>
                </form>
                <py-if="xmlDocument and xslStylesheet">
                    <py-code="
                        error=0
                        try: result=self.transform(xslStylesheet, xmlDocument)
                        except: error=1
                    ">
                    <py-if="error==1">
                        <font color=red>An error occured during the transformation:<br>
                        <py-code="
                            import traceback, StringIO
                            bodyFile=StringIO.StringIO()
                            traceback.print_exc(file=bodyFile)
                            errorBody=bodyFile.getvalue()
                            bodyFile.close()
                            _page.append(errorBody.replace('\\n','<br>').replace(' ','&nbsp;&nbsp;'))
                        ">
                        </font>
                    </py-if><py-else>
                        <b>Html result:</b><br><br>
                            <font face=arial size=2 color=navy>
                            <py-eval="self.htmlQuote(result).replace('\\n','<br>').replace(' ','&nbsp;&nbsp;')">
                            </font>
                        <br><br><b>Rendered html result:</b><br><br>
                            <py-eval="result">
                    </py-else>
                </py-if>
                </body></body>
            $$
            $$
            $#################################################
            $# Sample XML document and XSL stylesheet
            $#################################################
            def xslStylesheet(self):
                <?xml version="1.0" encoding="ISO-8859-1"?>
                <xsl:stylesheet version="1.0"
                    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
                <xsl:template match="/">
                    <html><body>
                        <h2>My CD Collection</h2>
                        <table border="1">
                            <tr bgcolor="#9acd32">
                                <th align="left">Title</th>
                                <th align="left">Artist</th>
                            </tr>
                            <xsl:for-each select="catalog/cd">
                                <tr>
                                    <td><xsl:value-of select="title"/></td>
                                    <td><xsl:value-of select="artist"/></td>
                                </tr>
                            </xsl:for-each>
                        </table>
                    </body></html>
                </xsl:template>
                </xsl:stylesheet>
            def xmlInput(self):
                <?xml version="1.0" encoding="ISO-8859-1"?>
                <catalog>
                    <cd>
                        <title>Empire Burlesque</title>
                        <artist>Bob Dylan</artist>
                    </cd>
                    <cd>
                        <title>Hide your heart</title>
                        <artist>Bonnie Tyler</artist>
                    </cd>
                </catalog>
            """
    def index(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy : Demo</title></head>
<body>
<a href="http://www.cherrypy.org"><img src=\"""")
        _page.append(str(request.base+'/static/cherryPyLogo.gif'))
        _page.append("""\" border=0></a>
<br><br>
<b>Welcome to the CherryPy demo</b><br><br>
<b>Below are a few examples to demonstrate a few of CherryPy's capabilities</b><br><br>
<b>Demo: Prestation</b><br>
Prestation is a sample site developed with CherryPy.<br>
To demonstrate how easy it is to develop multi-skin websites with CherryPy (by deriving classes), the
site comes in two flavours: French and English. Both use different colors and layout<br>
The source code is provided with CherryPy.<br>
<a href=\"""")
        _page.append(str(request.base+'/prestationEnglish/index'))
        _page.append("""\">Check it out</a>
<br><br>
<b>Demo: CherryPy basic functionnalities</b><br>
<a href="template">Templating language</a><br>
<a href="oop">Using OOP to develop a web site</a><br>
<a href="include">Using an HTML editor to edit templates</a><br>
<a href="post">File upload</a><br>
<a href="cookie">Cookie handling</a><br>
<a href="sessions">Using sessions</a><br>
<br>
<b>Demo: CherryPy more advanced features</b><br>
<a href="xmlXsl">Using XML/XSL</a> (based on the 4Suite module)<br>
<a href="ssl">SSL/HTTPS support</a> (based on the PyOpenSSL module)<br>
<a href="streaming">Using streaming</a><br>
<br>
<b>Demo: CherryPy standard library modules</b><br>
<a href="testHttpAuthenticate">HTTP-based authentication</a><br>
<a href="testCookieAuthenticate">Cookie-based Authentication</a><br>
<a href="/testForm/index">Form handling</a><br>
<a href="maskTools">HTML patterns</a><br>
</body></html>
""")
        return "".join(_page)
    def ssl(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : SSL/HTTPS support</title></head>
<body>
<h2>SSL/HTTPS support</h2><br>
The built-in HTTP server supports SSL (based on the PyOpenSSL module).<br>
Check out <a href="http://www.cherrypy.org/static/html/howto/node10.html">this HowTo</a>
to learn how to configure the HTTP server to run in SSL mode.<br><br>
Click on the following link to browse the CherryPy.org website in SSL mode:
<a href="https://www.cherrypy.org">https://www.cherrypy.org</a>.<br>
PS: Since the certificate we're using
is not signed, your browser will open a window to ask you if you want to proceed... Just say yes
""")
        return "".join(_page)
    def streaming(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Using streaming</title></head>
<body>
<h2>Using streaming</h2><br>
If one of your page is really big or if it takes a long time to build, then it might be a good option to use
streaming, which means that the page will be returned to the browser in chunks.<br>
The following code shows how to use streaming.<br>
""")
        _page.append(str(self.viewCode(self.streamingCode())))
        _page.append("""
<br>
Click <a href="streamingResult">here</a> to see the result.
</body></html>
""")
        return "".join(_page)
    def template(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Templating language</title></head>
<body>
<h2>Templating language</h2><br>
CHTL and CGTL are CherryPy's templating languages. They're very easy to learn and easy to use (they're only
composed of a few tags), and yet they're very powerful.<br>
Moreover, CHTL is HTML-editor-safe, which means that pages can go back and forth between developers and designers !
<br>The following code is an example that displays a table with all web colors:<br>
""")
        _page.append(str(self.viewCode(self.webColorCode())))
        _page.append("""
<br>
Result:<br><br>
""")
        codeList=['00', '33', '66', '99', 'CC', 'FF']
        _page.append("""
<table border=1>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(codeList)-1
        except TypeError: _end=-1
        for r in codeList:
            _index+=1
            _page.append("""
    """)
            _index12=locals().get("_index", -1)
            _end12=locals().get("_end", -1)
            _index=-1
            try: _end=len(codeList)-1
            except TypeError: _end=-1
            for g in codeList:
                _index+=1
                _page.append("""
        <tr>
            """)
                _index16=locals().get("_index", -1)
                _end16=locals().get("_end", -1)
                _index=-1
                try: _end=len(codeList)-1
                except TypeError: _end=-1
                for b in codeList:
                    _index+=1
                    _page.append("""
                """)
                    color='#%s%s%s'%(r,g,b)
                    _page.append("""
                <td bgColor=\"""")
                    _page.append(str(color))
                    _page.append("""\">""")
                    _page.append(str('&nbsp;&nbsp;'+color+'&nbsp;'))
                    _page.append("""</td>
            """)
                _index=_index16
                _end=_end16
                _page.append("""
        </tr>
    """)
            _index=_index12
            _end=_end12
            _page.append("""
""")
        _index=_index8
        _end=_end8
        _page.append("""
</table>
</body></html>
""")
        return "".join(_page)
    def include(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Using an HTML editor to edit templates</title></head>
<body>
<h2>Using an HTML editor to edit templates</h2><br>
CHTL (one of the 2 templating languages) is HTML-editor-safe. This means that webdesigners can use their favorite
HTML editor (Dreamweaver, Amaya, ...) to edit the files.<br>
Normally, templates (or "masks") are stored in CherryPy source files, with the rest of the code. But we know that
webdesigners like to work on their own files, so CherryPy provides a way to do that, using the <i>""")
        _page.append(str('&lt;py-'+'include&gt;'))
        _page.append("""</i> tag.<br>
Example:<br><br>
<b>header.html: (can be edited by webdesigners with an HTML editor)</b>
""")
        _page.append(str(self.viewCode(self.headerTemplateCode())))
        _page.append("""
<br>
<b>footer.html: (can be edited by webdesigners with an HTML editor)</b>
""")
        _page.append(str(self.viewCode(self.footerTemplateCode())))
        _page.append("""
<br>
<b>index.html: (can be edited by webdesigners with an HTML editor)</b>
""")
        _page.append(str(self.viewCode(self.indexTemplateCode())))
        _page.append("""
<br>
<b>Hello.cpy: (only edited by developers)</b>
""")
        _page.append(str(self.viewCode(self.indexCherryTemplateCode())))
        _page.append("""
<br>
Result:<br><br>
Hi, I'm the header. I'll be almost the same for all pages of the site. This will provide a constant look for the site.<br>
By the way, the time on the server is: <b>""")
        _page.append(str(time.time()))
        _page.append("""</b><br><br>
Hello, <b>John</b> !<br>
Do you like cherry pie ?
<br><br>Hi, I'm the footer
</body></html>
""")
        return "".join(_page)
    def oop(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Using OOP to develop a web site</title></head>
<body>
<h2>Using OOP to develop a web site:</h2><br>
Using Object Oriented Programming for your web site works very well in the following cases:
<ul>
<li>You have different parts of your web site that use the same functionality but applied to a different kind of data</li>
<li>You need to display the same things on several pages, but you have to change the design or the order of the modules</li>
</ul>
Let's take an example: you want to build a web site where you sell books, DVDs and video games. You'll have
3 different modules in your site, but they'll all use the same functionalities: search an item, view it, buy it, ...<br>
In this case, all you have to do is declare a generic class that implements the common features, and then sub-class
it for each item type. Each of the sub-classes will only implement what is really specific to that item type.<br>
<br><br>
Here is what the hierarchy will look like:<br><br>
<center>
<table border=0><tr><td colspan=5 align=center>
<b>GenericStore</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>
(parent class for all item types)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
</td></tr>
<tr><td align=center>|<br>|<br><b>BookStore</b>
</td><td width=10>&nbsp;</td><td align=center>|<br>|<br><b>DvdStore</b>
</td><td width=10>&nbsp;</td><td align=center>|<br>|<br><b>VideoGameStore</b>
</td></tr></table>
</center>
<br><br>
Here is how it's done with CherryPy:<br>
""")
        _page.append(str(self.viewCode(self.oopCode())))
        _page.append("""
<br><br>
Click <a href="/genericStore/index">here</a> to see the result
</body></html>
""")
        return "".join(_page)
    def cookie(self, addOrRemove=''):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Cookie handling</title></head>
<body>
<h2>Cookie handling:</h2><br>
Handling cookies is a very easy task with CherryPy.<br>
When a browser sends a cookie, CherryPy automatically builds a SimpleCookie object containing the cookie
information. That object is called <i>request.simpleCookie</i>.<br>
If you want to send back a cookie to the browser, all you have to do is use <i>response.simpleCookie</i>.<br>
The following code allows you to display the cookies that are sent by the browser and to send back some cookies:<br>
""")
        _page.append(str(self.viewCode(self.cookieCode())))
        _page.append("""
<br><br>
Result:<br><br>
Value of simpleCookie: """)
        _page.append(str(request.simpleCookie))
        _page.append("""<br>
Click <a href="cookie?addOrRemove=add">here</a> once to set the cookies and twice to see them in <i>simpleCookie</i><br>
Click <a href="cookie?addOrRemove=remove">here</a> once to remove the cookies and twice to see it in <i>simpleCookie</i>
</body></html>
""")
        if addOrRemove=='add':
            _page.append("""
    """)
            response.simpleCookie['cookieName']='cookieValue'
            response.simpleCookie['cookieName']['path']='/'
            response.simpleCookie['cookieName']['max-age']=3600
            response.simpleCookie['cookieName']['version']=1
            _page.append("""
    """)
            response.simpleCookie['cookieName2']='cookieValue2'
            response.simpleCookie['cookieName2']['path']='/'
            response.simpleCookie['cookieName2']['max-age']=3600
            response.simpleCookie['cookieName2']['version']=1
            _page.append("""
""")
        _page.append("""
""")
        if addOrRemove=='remove':
            _page.append("""
    """)
            response.simpleCookie['cookieName']=''
            response.simpleCookie['cookieName']['path']='/'
            response.simpleCookie['cookieName']['max-age']=0
            response.simpleCookie['cookieName']['version']=1
            _page.append("""
    """)
            response.simpleCookie['cookieName2']=''
            response.simpleCookie['cookieName2']['path']='/'
            response.simpleCookie['cookieName2']['max-age']=0
            response.simpleCookie['cookieName2']['version']=1
            _page.append("""
""")
        _page.append("""
""")
        return "".join(_page)
    def sessions(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Using sessions</title></head>
<body>
<h2>Using sessions:</h2><br>
Sessions are now a built-in feature of CherryPy. You can store session data to RAM, to disk, to a database or anywhere you want (CherryPy allows you to write your own custom methods to store session data if you want).<br>
The way it works is very easy: CherryPy just makes a dictionary available in your code were you can store/retrieve
session data. This dictionary is called <b>request.sessionMap</b>.<br><br>
The following code implements a trivial page counter:<br>
""")
        _page.append(str(self.viewCode(self.sessionsCode())))
        _page.append("""
<br><br>
Result:<br><br>
""")
        count=request.sessionMap.get('pageViews', 0)+1
        request.sessionMap['pageViews']=count
        _page.append("""
Hello, you've been here """)
        _page.append(str(count))
        _page.append(""" time(s).<br>
Refresh this page to increment the counter.<br>
If you close your browser or stop accessing this site for an hour, your session data will expire and the counter
will be reset.<br>
Your session ID is: """)
        _page.append(str(request.sessionMap['_sessionId']))
        _page.append("""
""")
        return "".join(_page)
    def post(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : File upload</title></head>
<body>
<h2>File upload:</h2><br>
With CherryPy, all values entered in a form are converted to a Python string and passed to a method as
regular arguments. It doesn't matter if it's a GET or a POST, or if the values are a short string or a
big file that's being uploaded. It's all transparent to the developer.<br>
The following code shows how a text string and a file upload are handled:<br>
<br>Form code:
""")
        _page.append(str(self.viewCode(self.postFormCode())))
        _page.append("""
<br>Action method code:
""")
        _page.append(str(self.viewCode(self.postFormActionCode())))
        _page.append("""
<br>
Result:<br><br>
    Enter your name and a photo:
    <form method=post action=postFile enctype="multipart/form-data">
        Name: <input name=name><br>
        Photo: <input type=file name=photo><br>
        <input type=submit>
    </form>
</body></html>
""")
        return "".join(_page)
    def postFile(self, name, photo):
        _page=[]
        _page.append("""<html><body>
    Name: """)
        _page.append(str(name))
        _page.append("""<br>
    Size of the photo: """)
        _page.append(str(len(photo)))
        _page.append(""" bytes<br>
    Filename of the photo: """)
        _page.append(str(request.filenameMap['photo']))
        _page.append("""<br>
    Mime type of the photo: """)
        _page.append(str(request.fileTypeMap['photo']))
        _page.append("""
</body></html>
""")
        return "".join(_page)
    def testHttpAuthenticate(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : HTTP-based authentication</title></head>
<body>
<h2>HTTP-based authentication:</h2><br>
CherryPy comes with a standard module for HTTP-based authentication.<br>
It is very easy to use. All you have to do is create a CherryClass that inherits from that module, and implement
the <i>getPasswordListForLogin</i> method to specify what allowed logins/passwords are:<br>
""")
        _page.append(str(self.viewCode(self.httpAuthenticateCode())))
        _page.append("""
<br><br>
Result:<br><br>
Click <a href="/httpProtected/index">here</a> and you will be prompted for a login and a password. Enter "login" and "password" to view the next screen.
</body></body>
""")
        return "".join(_page)
    def testCookieAuthenticate(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : Cookie-based authentication</title></head>
<body>
<h2>Cookie-based authentication:</h2><br>
CherryPy comes with a standard module for Cookie-based authentication.<br>
It is very easy to use. All you have to do is create a CherryClass that inherits from that module, and implement
the <i>getPasswordListForLogin</i> method to specify what allowed logins/passwords are. Unlike many
Cookie-based authentication schemes, it doesn't require any database to store the session informations. These
informations are encrypted and then stored in a cookie:<br>
""")
        _page.append(str(self.viewCode(self.cookieAuthenticateCode())))
        _page.append("""
<br><br>
Result:<br><br>
Click <a href="/cookieProtected/index">here</a> and you will be prompted for a login and a password. Enter "login" and "password" to view the next screen.
</body></body>
""")
        return "".join(_page)
    def maskTools(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : HTML patterns</title></head>
<body>
<h2>HTML patterns</h2><br>
With CherryPy, it is easy to create masks that are used to render commonly used patterns on HTML pages. For instance:
text inside a box, list displayed on several columns or lines, ...<br>
CherryPy comes with a module called <i>MaskTools</i> that contains a few of those, but you can also easily create
your own masks.<br>
The following code uses the <i>MaskTools</i> module:<br>
""")
        _page.append(str(self.viewCode(self.maskToolsCode())))
        _page.append("""
<br>Result:<br><br>
""")
        _page.append(str(maskTools.textInBox('This is some text displayed in a red box filled with yellow', boxColor='red', insideColor='yellow')))
        _page.append("""
<br>
Display integers from 1 to 102 in 7 columns with 20 pixels between each column:
""")
        _page.append(str(maskTools.displayByColumn(map(str,range(1,103)), 7, 0, 20)))
        _page.append("""
<br>
Display integers from 1 to 102 in 7 lines with 5 pixels between each line:
""")
        _page.append(str(maskTools.displayByLine(map(str,range(1,103)), 7, 0, 5)))
        _page.append("""
</body></body>
""")
        return "".join(_page)
    def xmlXsl(self):
        _page=[]
        if not hasXslt:
            return """
                <html><body>
                <h2>Using XML/XSL</h2><br>
                <b>This demo requires the 4Suite package to be installed on your machine !</b><br>
                It looks like this package is not installed.<br>
                Check out the CherryPy "HowTo" documentation for information about using XML/XSL with CherryPy.<br>
                This documentation is available at <a href='http://www.cherrypy.org/static/html/howto/index.html'>http://www.cherrypy.org/static/html/howto/index.html</a>
                </body></html>
            """
        _page.append("""
<html>
<head><title>CherryPy Demo : Using XML/XSL</title></head>
<body>
<h2>Using XML/XSL</h2><br>
With CherryPy, it is very easy to use XML/XSL to develop you website.<br><br>
<a href="xmlXslSample">Click here</a> to see some sample code that demonstrates how to do it, or<br>
<a href="xmlXslOnline">Click here</a> to use an online tool that lets you input an XML document and
an XSL stylesheet and then displays the result of the transformation.<br>
This online tool has been written with only a few lines of codes of CherryPy ...
</body></html>
""")
        return "".join(_page)
    def xmlXslSample(self):
        _page=[]
        _page.append("""<html>
<head><title>CherryPy Demo : XML/XSL example</title></head>
<body>
<h2>XML/XSL example</h2><br>
The following demonstrates how to use XML/XSL in CherryPy. In real life, the XML document would probably be generated
by a function or a view, based on some data coming from a database or some other ressource:<br>
(Note that it seems that the 4Suite API has changed again in the latest releases, so you might have to tweak this code if you're using a recent release).<br>
""")
        _page.append(str(self.viewCode(self.xmlXslSampleCode())))
        _page.append("""
<br>Result:<br><br>
""")
        _page.append(str(xslTransform.transform(self.xslStylesheet(), self.xmlInput())))
        _page.append("""
</body></body>
""")
        return "".join(_page)
    def xslStylesheet(self):
        _page=[]
        _page.append("""<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
    <html><body>
        <h2>My CD Collection</h2>
        <table border="1">
            <tr bgcolor="#9acd32">
                <th align="left">Title</th>
                <th align="left">Artist</th>
            </tr>
            <xsl:for-each select="catalog/cd">
                <tr>
                    <td><xsl:value-of select="title"/></td>
                    <td><xsl:value-of select="artist"/></td>
                </tr>
            </xsl:for-each>
        </table>
    </body></html>
</xsl:template>
</xsl:stylesheet>
""")
        return "".join(_page)
    def xmlInput(self):
        _page=[]
        _page.append("""<?xml version="1.0" encoding="ISO-8859-1"?>
<catalog>
    <cd>
        <title>Empire Burlesque</title>
        <artist>Bob Dylan</artist>
    </cd>
    <cd>
        <title>Hide your heart</title>
        <artist>Bonnie Tyler</artist>
    </cd>
</catalog>
""")
        return "".join(_page)
    def xmlXslOnline(self, xmlDocument="", xslStylesheet="", width=55, changeWidth=0):
        _page=[]
        _page.append("""<html><head><title>CherryPy Demo : Online XML/XSL transformation tool</title></head><body>
<h2>Online XML/XSL transformation tool</h2>
<table border=0><tr>
<td>
    The following tool lets you enter an XML document, an XSL stylesheet, and it shows the result of the transformation.<br>
    This tool has been written with only a few lines of <a href=\"""")
        _page.append(str(request.base))
        _page.append("""\">CherryPy</a> code and it uses the <a href="http://4suite.org">4Suite module</a>.<br>
    Source code is available <a href=\"""")
        _page.append(str(self.getPath()+'/xmlXslOnlineViewCode'))
        _page.append("""\">here</a>.<br><br>
</td>
<td width=50>&nbsp;</td>
<td valign=middle>
    <a href=\"""")
        _page.append(str(request.base))
        _page.append("""\"><img src=\"""")
        _page.append(str(request.base+'/static/poweredByCherryPy.gif'))
        _page.append("""\" border=0 alt="Powered by CherryPy"></a>
</td>
</table>
<form name="xmlForm" action="xmlXslOnline" method="post" style="margin-top: 0; margin-bottom: 0">
<table border=0 width="100%">
    """)
        if int(width)<=55:
            _page.append("""
        <tr>
            <td align=center><b>XML document:</b>
            <td width=50>&nbsp;</td>
            <td align=center><b>XSL stylesheet:</b>
        </tr>
        <tr>
            <td align=center>
                <textarea name=xmlDocument rows=15 cols=\"""")
            _page.append(str(width))
            _page.append("""\">""")
            if xmlDocument: _page.append(self.htmlQuote(xmlDocument))
            else: _page.append(self.htmlQuote(self.xmlInput().replace('\t','  ')))
            _page.append("""</textarea>
            </td>
            <td width=50>&nbsp;</td>
            <td align=center>
                <textarea name=xslStylesheet rows=15 cols=\"""")
            _page.append(str(width))
            _page.append("""\">""")
            if xmlDocument: _page.append(self.htmlQuote(xslStylesheet))
            else: _page.append(self.htmlQuote(self.xslStylesheet().replace('\t','  ')))
            _page.append("""</textarea>
            </td>
        </tr>
        <tr><td colspan=3 align=center><br>
            <input type=submit value="Narrower textareas" onClick="document.xmlForm.width.value='""")
            _page.append(str(int(width)-20))
            _page.append("""';document.xmlForm.changeWidth.value='1';return true;">
            <input type=submit value="Run transformation">
            <input type=submit value="Wider textareas" onClick="document.xmlForm.width.value='""")
            _page.append(str(int(width)+20))
            _page.append("""';document.xmlForm.changeWidth.value='1';return true;">
        </td></tr>
    """)
        else:
            _page.append("""
        <tr><td align=center>
            <b>XML document:</b><br>
            <textarea name=xmlDocument rows=15 cols=\"""")
            _page.append(str(width))
            _page.append("""\">""")
            if xmlDocument: _page.append(self.htmlQuote(xmlDocument))
            else: _page.append(self.htmlQuote(self.xmlInput().replace('\t','  ')))
            _page.append("""</textarea>
            <br><br>
            <b>XSL stylesheet:</b><br>
            <textarea name=xslStylesheet rows=15 cols=\"""")
            _page.append(str(width))
            _page.append("""\">""")
            if xmlDocument: _page.append(self.htmlQuote(xslStylesheet))
            else: _page.append(self.htmlQuote(self.xslStylesheet().replace('\t','  ')))
            _page.append("""</textarea>
        </td></tr>
        <tr><td align=center><br>
            <input type=submit value="Narrower textareas" onClick="document.xmlForm.width.value='""")
            _page.append(str(int(width)-20))
            _page.append("""';document.xmlForm.changeWidth.value='1';return true;">
            <input type=submit value="Run transformation">
            <input type=submit value="Wider textareas" onClick="document.xmlForm.width.value='""")
            _page.append(str(int(width)+20))
            _page.append("""';document.xmlForm.changeWidth.value='1';return true;">
        </td></tr>
    """)
        _page.append("""
</table>
<input type=hidden name=width value=\"""")
        _page.append(str(width))
        _page.append("""\">
<input type=hidden name=changeWidth value="0">
</form>
""")
        if xmlDocument and xslStylesheet and int(changeWidth)==0:
            _page.append("""
    """)
            try:
                result=xslTransform.transform(xslStylesheet, xmlDocument)
            except:
                import traceback, StringIO
                _page.append("<font color=red>An error occured during the transformation:<br>")
                bodyFile=StringIO.StringIO()
                traceback.print_exc(file=bodyFile)
                errorBody=bodyFile.getvalue()
                bodyFile.close()
                _page.append(errorBody.replace('\n','<br>').replace(' ','&nbsp;&nbsp;'))
                _page.append("</font></body></html>")
                return "".join(_page)
            _page.append("""
    <b>Html result:</b><br><br>
        <font face=arial size=2 color=navy>
        """)
            _page.append(str(self.htmlQuote(result).replace('\n','<br>').replace(' ','&nbsp;&nbsp;')))
            _page.append("""
        </font>
    <br><br><b>Rendered html result:</b><br><br>
        """)
            _page.append(str(result))
            _page.append("""
""")
        _page.append("""
</body></body>
""")
        return "".join(_page)
    def xmlXslOnlineViewCode(self):
        _page=[]
        _page.append("""Here is the source code for the online XML/XSL transformation tool. This code must be compiled with <a href=\"""")
        _page.append(str(request.base))
        _page.append("""\">CherryPy</a>.<br>
""")
        _page.append(str(self.viewCode(self.xmlXslOnlineCode())))
        _page.append("""
""")
        return "".join(_page)
global GenericStore
class GenericStore:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/genericStore"
        else:
            return "/genericStore"
    def index(self):
        _page=[]
        _page.append("""<html><body><center><br><br><br>
    Welcome to the store. Choose what you want to buy:<br><br>
    <table cellspacing=10><tr>
    """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(self.itemList)-1
        except TypeError: _end=-1
        for itemType in self.itemList:
            _index+=1
            _page.append("""
        <td bgcolor=\"""")
            _page.append(str(itemType.color))
            _page.append("""\">
            <a href=\"""")
            _page.append(str(itemType.getPath()+'/viewList'))
            _page.append("""\">""")
            _page.append(str(itemType.label+'s'))
            _page.append("""</a>
        </td>
    """)
        _index=_index8
        _end=_end8
        _page.append("""
    </tr></table>
</center></body></html>
""")
        return "".join(_page)
    def viewList(self):
        _page=[]
        _page.append("""<html><body><center><br><br><br>
<b>""")
        _page.append(str(self.label.upper()+'S'))
        _page.append("""</b><br><br>
Click on a """)
        _page.append(str(self.label))
        _page.append(""" title to view it:<br><br>
<table bgcolor=\"""")
        _page.append(str(self.color))
        _page.append("""\" cellpadding=5>
    """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(self.itemList)-1
        except TypeError: _end=-1
        for item in self.itemList:
            _index+=1
            _page.append("""
        <tr><td><a href=\"""")
            _page.append(str(self.getPath()+'/viewItem?itemIndex=%s'%_index))
            _page.append("""\">""")
            _page.append(str(item[0]))
            _page.append("""</a></td></tr>
    """)
        _index=_index8
        _end=_end8
        _page.append("""
</table>
</center></body></html>
""")
        return "".join(_page)
    def viewItem(self, itemIndex):
        _page=[]
        title, price=self.itemList[int(itemIndex)]
        _page.append("""
<html><body><center><br><br><br>
    <table bgcolor=\"""")
        _page.append(str(self.color))
        _page.append("""\" cellpadding=5>
        <tr><td>Title: """)
        _page.append(str(title))
        _page.append("""</td></tr>
        <tr><td>Price: """)
        _page.append(str(price))
        _page.append("""$</td></tr>
    </table>
</center></body></html>
""")
        return "".join(_page)
global BookStore
class BookStore(GenericStore):
    label='book'
    color='pink'
    itemList=[('Harry Potter and the Goblet of Fire', '18', 'J. K. Rowling'), ('I love CherryPy', '5', 'Remi Delon')]
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/bookStore"
        else:
            return "/bookStore"
    def viewItem(self, itemIndex):
        _page=[]
        title, price, author=self.itemList[int(itemIndex)]
        _page.append("""
<html><body><center><br><br><br>
    <table bgcolor=\"""")
        _page.append(str(self.color))
        _page.append("""\" cellpadding=5>
        <tr><td>Title: """)
        _page.append(str(title))
        _page.append("""</td></tr>
        <tr><td>Price: """)
        _page.append(str(price))
        _page.append("""$</td></tr>
        <tr><td>Author: """)
        _page.append(str(author))
        _page.append("""</td></tr>
    </table>
</center></body></html>
""")
        return "".join(_page)
global DvdStore
class DvdStore(GenericStore):
    label='DVD'
    color='red'
    itemList=[('Star Wars Episode 1', '25'), ('The Legend of CherryPy', '4')]
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/dvdStore"
        else:
            return "/dvdStore"
global VideoGameStore
class VideoGameStore(GenericStore):
    label='video game'
    color='yellow'
    itemList=[('Cool Rider 3', '29'), ('CherryPy Eating Contest', '7')]
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/videoGameStore"
        else:
            return "/videoGameStore"
global HttpProtected
class HttpProtected(HttpAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/httpProtected"
        else:
            return "/httpProtected"
    def getPasswordListForLogin(self, login):
        if login=="login": return ["password"]
        return []
    def index(self):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        _page.append("""<html><body>You're in, your login is:""")
        _page.append(str(self.login))
        _page.append("""</body></html>
""")
        return "".join(_page)
global CookieProtected
class CookieProtected(CookieAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cookieProtected"
        else:
            return "/cookieProtected"
    def getPasswordListForLogin(self, login):
        if login=="login": return ["password"]
        return []
    def index(self):
        _page=[]
        if not request.simpleCookie.has_key(self.loginCookieName) or not request.simpleCookie.has_key(self.dateCookieName) or not request.simpleCookie.has_key(self.passwordCookieName):
            return self.loginScreen(self.noCookieMessage, request.browserUrl)
        _login=request.simpleCookie[self.loginCookieName].value
        _date=request.simpleCookie[self.dateCookieName].value
        _password=request.simpleCookie[self.passwordCookieName].value
        _realPasswordList=self.getPasswordListForLogin(_login)
        _now=int(time.time())
        try: _nowCookie=int(_date)
        except: _nowCookie=0
        if not _nowCookie<=_now<=_nowCookie+self.timeout*60: return self.loginScreen(self.timeoutMessage, request.browserUrl, _login)
        _goodPassword=0
        for _realPassword in _realPasswordList:
            _clearPassword=_login+_date+_realPassword
            if md5.new(_clearPassword).hexdigest()==_password:
                _goodPassword=1
                self.login=_login
                break
        if not _goodPassword:
            self.login=""
            return self.loginScreen(self.noCookieMessage, request.browserUrl, _login)
        _newDate=str(_now)
        _newClearPassword=_login+_newDate+_realPassword
        _newPassword=md5.new(_newClearPassword).hexdigest()
        response.simpleCookie[self.dateCookieName]=_newDate
        response.simpleCookie[self.dateCookieName]['path']='/'
        response.simpleCookie[self.dateCookieName]['max-age']=31536000
        response.simpleCookie[self.dateCookieName]['version']=1
        response.simpleCookie[self.passwordCookieName]=_newPassword
        response.simpleCookie[self.passwordCookieName]['path']='/'
        response.simpleCookie[self.passwordCookieName]['max-age']=31536000
        response.simpleCookie[self.passwordCookieName]['version']=1
        
        _page.append("""<html><body>
    You're in, your login is: """)
        _page.append(str(self.login))
        _page.append("""<br>
    Click <a href="doLogout">here</a> to log out.
</body></html>
""")
        return "".join(_page)
global TestForm
class TestForm(Form):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/testForm"
        else:
            return "/testForm"
    def __init__(self):
        headerSep=FormSeparator('', defaultFormMask.defaultHeader)
        textField=FormField(label='Text field:', name='textField', mandatory=1, typ='text')
        textareaField=FormField(label='Textarea field:', name='textareaField', mandatory=1, typ='textarea', size='30x5')
        selectField=FormField(label='Select field:', name='selectField', mandatory=1, typ='select', optionList=['Option 1', 'Option 2', 'Option 3'])
        radioField=FormField(label='Radio field:', name='radioField', mandatory=1, typ='radio', optionList=['Option 1', 'Option 2', 'Option 3'])
        checkboxField=FormField(label='Checkbox field:', name='checkField', mandatory=0, typ='checkbox', optionList=['Option 1', 'Option 2', 'Option 3'])
        submitField=FormField(label='', name='Submit', typ='submit')
        footerSep=FormSeparator('', defaultFormMask.defaultFooter)
        self.fieldList=[headerSep, textField, textareaField, selectField, radioField, checkboxField, submitField, footerSep]
    def postForm(self, **kw):
        if self.validateForm():
            res="<html><body>"
            for key, value in kw.items():
                res+="%s : %s <br>"%(key, value)
            return res+"</body></html>"
        else:
            return "<html><body><font color=red>Fill out missing fields</font>"+self.formView(1)+"</body></html>"
    def index(self, **kw):
        _page=[]
        _page.append("""<html><body>
<h2>Form handling:</h2><br>
Handling forms can really be pain, especially if you want to handle user errors (missing field, incorrect values, ...).<br>
CherryPy provides a <i>Form</i> standard module to make that task easier. The module is able to validate the
fields, and to redisplay the form with some error messages if some fields were incorrect. You can also
customize it to change the design of the form.<br>
Below is a sample code that uses the form module:<br>
""")
        _page.append(str(demo.viewCode(demo.formCode())))
        _page.append("""
<br>Result:<br><br>
    Fill out the form and hit "Submit". If you forget any mandatory fields, the form will
    be displayed again, and the errors will be indicated:<br>
    """)
        _page.append(str(self.formView(0)))
        _page.append("""
</body></html>
""")
        return "".join(_page)
global CherryPyOrgForumDesign
class CherryPyOrgForumDesign(CherryPyForumDesign):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryPyOrgForumDesign"
        else:
            return "/cherryPyOrgForumDesign"
    def header(self, **kw):
        _page=[]
        _page.append(str(root.header('CherryPy Forum')))
        _page.append("""
    <td width=80% valign=top align=center>
        <table border=0 cellspacing=0 cellpadding=0 width=100%>
            <tr>
                <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleHeaderLeft.gif'))
        _page.append("""\" width=10 height=25></td>
                <td background=\"""")
        _page.append(str(request.base+'/static/moduleHeaderMiddle.gif'))
        _page.append("""\" height=25 valign=top align=left class=moduleTitle>CherryPy Forum</td>
                <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleHeaderRight.gif'))
        _page.append("""\" width=10 height=25></td>
            </tr><tr>
                <td width=10 background=\"""")
        _page.append(str(request.base+'/static/moduleBodyLeft.gif'))
        _page.append("""\">&nbsp;</td>
                <td class=moduleText>
""")
        return "".join(_page)
    def footer(self):
        _page=[]
        _page.append("""                    <br><br>
                    <table width=100%><tr><td width=100% align=right>
                        <a href=\"""")
        _page.append(str(request.base+'/cherryForum'))
        _page.append("""\"><img src=\"""")
        _page.append(str(request.base+'/static/poweredByCherryForum.gif'))
        _page.append("""\" border=0></a>
                    </td></tr></table>
                </td>
                <td width=10 background=\"""")
        _page.append(str(request.base+'/static/moduleBodyRight.gif'))
        _page.append("""\">&nbsp;</td>
            </tr><tr>
                <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleFooterLeft.gif'))
        _page.append("""\" width=10 height=15></td>
                <td background=\"""")
        _page.append(str(request.base+'/static/moduleFooterMiddle.gif'))
        _page.append("""\" height=15>""")
        _page.append(str(maskTools.x()))
        _page.append("""</td>
                <td width=10><img src=\"""")
        _page.append(str(request.base+'/static/moduleFooterRight.gif'))
        _page.append("""\" width=10 height=15></td>
            </tr>
        </table>
    </td>
""")
        _page.append(str(root.footer()))
        _page.append("""
""")
        return "".join(_page)
global MyForum
class MyForum(CherryForum):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/myForum"
        else:
            return "/myForum"
    def __init__(self):
        self.template=cherryPyOrgForumDesign
global MyForumAdmin
class MyForumAdmin(CherryForumAdmin,HttpAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/myForumAdmin"
        else:
            return "/myForumAdmin"
    def getPasswordListForLogin(self, login):
        print "login:", login
        if login==configFile.get('restrictedArea', 'login'): return [configFile.get('restrictedArea', 'password')]
        return []
global CherryDb
class CherryDb:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryDb"
        else:
            return "/cherryDb"
    def databaseWrite(self, table, action, where, kw):
        f=open('database','a')
        param=","
        if where!=None: param+="%s,"%`where`
        for key, value in kw.items():
            if key!='_id': param+="%s=%s,"%(key, `value`)
        param+="_rd=1,"
        f.write('%s.%s(%s)\n'%(table, action, param[1:-1]))
        f.close()
    def databaseRead(self):
        try:
            f=open(configFile.get('prestationDatabase','file'),'r')
            logMessage("Reading gaz station database for the Prestation demo ...")
            data=f.read()
            f.close()
        except:
            logMessage("No database found")
            return
        data=data.replace('\r\n','\n')
        lines=data.split('\n')
        i=0
        while i<len(lines):
            cmd=lines[i]
            if not cmd: break
            if cmd[-1]!=')': logMessage("Warning, database file is corrupt line %s (last char:%s)"%(i,`cmd[-1]`))
            else: exec(cmd)
            i+=1
        logMessage("Done reading database")
    def getInstanceItem(self, instanceItem):
        i=instanceItem.rfind("_")
        table=instanceItem[10:i]
        id=instanceItem[i+1:]
        instanceList=eval(table+".getItem('item._id=='+id)")
        return instanceList[0]
    def getToken(self, str):
        if str[0]=='"':
            end=findClosingQuote(str, '"', 1)
            return str[:end+1]
        elif str[0]=='"':
            end=findClosingQuote(str, "'", 1)
            return str[:end+1]
        else:
            j=str.find(" ")
            if j==-1: j=len(str)
            k=str.find(")")
            if k==-1: k=len(str)
            i=min([j,k])
            return str[:i]
global CherryDbItem
class CherryDbItem:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryDbItem"
        else:
            return "/cherryDbItem"
    def __init__(self, _id, _tableName):
        self._id=_id
        self._tableName=_tableName
    def __repr__(self):
        return '"_instance_%s_%s"'%(self._tableName, self._id)
global CherryTable
class CherryTable:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/cherryTable"
        else:
            return "/cherryTable"
    def addItem(self, **kw):
        if kw.has_key("_id"):
            _id=kw["_id"]
            if _id>self._id: self._id=_id
        else:
            self._id+=1
            _id=self._id
        for _key, _value in kw.items():
            if type(_value)==types.StringType and _value[:10]=="_instance_":
                instance=cherryDb.getInstanceItem(_value)
                kw[_key]=instance
        item=CherryDbItem(self._id, self._tableName)
        if not kw.has_key("_rd"): cherryDb.databaseWrite(item._tableName, "addItem", None, kw)
        self._itemList.append(item)
        for column in self.column:
            if kw.has_key(column): exec("item.%s=kw[column]"%column)
            else: exec("item.%s=None"%column)
        for specialColumn in self.specialColumn:
            _valueStr, as=specialColumn.split(" as ")
            _value=eval(_valueStr)
            exec("item.%s=_value"%as)
        self._indexItem(item)
        return item
    def getItem(self, where="", sortBy="", order="asc", firstValueList=[], lastValueList=[None]):
        tmpInstanceList=[]
        tmpInstanceId=0
        while 1:
            i=where.find('"_instance_')
            if i==-1: break
            k=where.find('"', i+1)
            tmpInstance=cherryDb.getInstanceItem(where[i+1:k])
            tmpInstanceList.append(tmpInstance)
            where=where[:i]+"tmpInstanceList[%s]"%tmpInstanceId+where[k+1:]
            tmpInstanceId+=1
        itemLoopList=self._itemList
        if where.find(" or ")==-1 and where.find(" not ")==-1:
            for index in self.index+self.specialIndex:
                sp=index.split(" as ")
                if len(sp)==2: index=sp[1]
                i=where.find("item.%s=="%index)
                if i!=-1:
                    token=cherryDb.getToken(where[i+7+len(index):])
                    value=eval(token)
                    if not self._indexMap[index].has_key(value): return []
                    itemLoopList=self._indexMap[index][value]
                    where=where[:i]+where[i+7+len(index)+len(token):]
        if not where: return itemLoopList
        res=[]
        for item in itemLoopList:
            if eval(where): res.append(item)
        if sortBy:
            tmpRes, firstValueRes, lastValueRes=[], [], []
            for item in res:
                field=eval("item.%s"%sortBy)
                if field in firstValueList: firstValueRes.append(item)
                if field in lastValueList: lastValueRes.append(item)
                else: tmpRes.append((field, item))
                tmpRes.sort()
            if order=="desc": tmpRes.reverse()
            res=firstValueRes
            for field, item in tmpRes: res.append(item)
            res+=lastValueRes
        return res
    def _indexItem(self, item):
        for index in self.index:
            value=eval("item.%s"%index)
            if self._indexMap[index].has_key(value): self._indexMap[index][value].append(item)
            else: self._indexMap[index][value]=[item]
        for index in self.specialIndex:
            valueStr, as=index.split(" as ")
            value=eval(valueStr)
            if type(value)!=types.ListType: value=[value]
            for val in value:
                if self._indexMap[as].has_key(val): self._indexMap[as][val].append(item)
                else: self._indexMap[as][val]=[item]
    def _unIndexItem(self, item):
        for index in self.index:
            value=eval("item.%s"%index)
            self._indexMap[index][value].remove(item)
    def deleteItem(self, whereOrItemList="", **kw):
        itemList=self._getWhereOrItemList(whereOrItemList)[:]
        if itemList:
            for item in itemList:
                self._itemList.remove(item)
                self._unIndexItem(item)
            if not kw.has_key("_rd"): cherryDb.databaseWrite(itemList[0]._tableName, "deleteItem", itemList, kw)
    def updateItem(self, whereOrItemList="", **kw):
        itemList=self._getWhereOrItemList(whereOrItemList)[:]
        if itemList:
            for item in itemList:
                self._unIndexItem(item)
                for _key in kw.keys():
                    exec('item.%s=kw["%s"]'%(_key,_key))
                self._indexItem(item)
            if not kw.has_key("_rd"): cherryDb.databaseWrite(itemList[0]._tableName, "updateItem", itemList, kw)
    def _getWhereOrItemList(self, whereOrItemList):
        if type(whereOrItemList)==types.StringType: return self.getItem(whereOrItemList)
        else:
            itemList=[]
            for item in whereOrItemList:
                if type(item)==types.StringType and item[:10]=="_instance_":
                    item=cherryDb.getInstanceItem(item)
                    itemList.append(item)
                else: itemList.append(item)
            return itemList
global StationTable
class StationTable(CherryTable):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/stationTable"
        else:
            return "/stationTable"
    def __init__(self):
        self._id=0
        self._itemList=[]
        self._indexMap={}
        self.column=[]
        self.specialColumn=[]
        self.index=[]
        self.specialIndex=[]
        self._tableName=self.__class__.__name__
        self._tableName=self._tableName[0].lower()+self._tableName[1:]
        
        self.column=['name','zipCode','city','address','phone','open','type','super','sp95','sp98','gazole','gerant','lastUpdateTime']
        self.specialColumn=['item.zipCode[:2] as department', 'item.name.upper()+" "+item.city.upper()+" "+item.address.upper()+" "+item.open.upper() as keyWord']
        self.index.append('_id')
        for index in self.index:
            self._indexMap[index]={}
        for index in self.specialIndex:
            value, as=index.split(" as ")
            self._indexMap[as]={}
        
    def getAllTypes(self):
        typeList=[]
        stationList=self.getItem()
        for station in stationList:
            if station.type not in typeList: typeList.append(station.type)
        typeList.sort()
        return typeList
global NewInfoTable
class NewInfoTable(CherryTable):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/newInfoTable"
        else:
            return "/newInfoTable"
    def __init__(self):
        self._id=0
        self._itemList=[]
        self._indexMap={}
        self.column=[]
        self.specialColumn=[]
        self.index=[]
        self.specialIndex=[]
        self._tableName=self.__class__.__name__
        self._tableName=self._tableName[0].lower()+self._tableName[1:]
        
        self.column=['station','name','zipCode','city','address','phone','open','type','nameOrEmail','lastUpdateTime']
        self.index.append('_id')
        for index in self.index:
            self._indexMap[index]={}
        for index in self.specialIndex:
            value, as=index.split(" as ")
            self._indexMap[as]={}
        
global NewPriceTable
class NewPriceTable(CherryTable):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/newPriceTable"
        else:
            return "/newPriceTable"
    def __init__(self):
        self._id=0
        self._itemList=[]
        self._indexMap={}
        self.column=[]
        self.specialColumn=[]
        self.index=[]
        self.specialIndex=[]
        self._tableName=self.__class__.__name__
        self._tableName=self._tableName[0].lower()+self._tableName[1:]
        
        self.column=['station','super','sp95','sp98','gazole','nameOrEmail','lastUpdateTime']
        self.index.append('_id')
        for index in self.index:
            self._indexMap[index]={}
        for index in self.specialIndex:
            value, as=index.split(" as ")
            self._indexMap[as]={}
        
global CommentTable
class CommentTable(CherryTable):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/commentTable"
        else:
            return "/commentTable"
    def __init__(self):
        self._id=0
        self._itemList=[]
        self._indexMap={}
        self.column=[]
        self.specialColumn=[]
        self.index=[]
        self.specialIndex=[]
        self._tableName=self.__class__.__name__
        self._tableName=self._tableName[0].lower()+self._tableName[1:]
        
        self.column=['station','comment','nameOrEmail','checked','lastUpdateTime']
        self.index.append('_id')
        for index in self.index:
            self._indexMap[index]={}
        for index in self.specialIndex:
            value, as=index.split(" as ")
            self._indexMap[as]={}
        
global NewStationTable
class NewStationTable(CherryTable):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/newStationTable"
        else:
            return "/newStationTable"
    def __init__(self):
        self._id=0
        self._itemList=[]
        self._indexMap={}
        self.column=[]
        self.specialColumn=[]
        self.index=[]
        self.specialIndex=[]
        self._tableName=self.__class__.__name__
        self._tableName=self._tableName[0].lower()+self._tableName[1:]
        
        self.column=['name','zipCode','city','address','phone','open','type','super','sp95','sp98','gazole','gerant','nameOrEmail','lastUpdateTime']
        self.index.append('_id')
        for index in self.index:
            self._indexMap[index]={}
        for index in self.specialIndex:
            value, as=index.split(" as ")
            self._indexMap[as]={}
        
global RequestTable
class RequestTable(CherryTable):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/requestTable"
        else:
            return "/requestTable"
    def __init__(self):
        self._id=0
        self._itemList=[]
        self._indexMap={}
        self.column=[]
        self.specialColumn=[]
        self.index=[]
        self.specialIndex=[]
        self._tableName=self.__class__.__name__
        self._tableName=self._tableName[0].lower()+self._tableName[1:]
        
        self.column=['name','lastUpdateTime']
        self.index.append('_id')
        for index in self.index:
            self._indexMap[index]={}
        for index in self.specialIndex:
            value, as=index.split(" as ")
            self._indexMap[as]={}
        
global ViewTables
class ViewTables:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/viewTables"
        else:
            return "/viewTables"
    def getTableData(self, tableName):
        table=eval(tableName)
        columnList=table._column
        recordList=[]
        i=0
        for item in table.getItem():
            i+=1
            recordData=[]
            for column in columnList:
                columnValue=eval('item.%s'%column)
                recordData.append((columnValue, None))
            recordList.append(recordData)
        indexMap=eval('%s._indexMap'%tableName)
        return tableName, columnList, recordList, indexMap
    def viewTable(self, tableName):
        return apply(self.viewTableMask, self.getTableData(tableName))
    def viewTables(self):
        _page=[]
        _page.append("""<html><body>
    <table border=1><tr><th>Table</th></tr>
    """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(['station'])-1
        except TypeError: _end=-1
        for tableName in ['station']:
            _index+=1
            _page.append("""
        <tr><td><a href=\"""")
            _page.append(str(request.base+'/viewTables/viewTable?tableName='+tableName))
            _page.append("""\">""")
            _page.append(str(tableName))
            _page.append("""</a></td></tr>
    """)
        _index=_index8
        _end=_end8
        _page.append("""
    </table>
</body></html>
""")
        return "".join(_page)
    def viewTableMask(self, tableName, columnList, recordList, indexMap):
        _page=[]
        _page.append("""<html><body>
    <b>Data for table: """)
        _page.append(str(tableName))
        _page.append("""<br><br></b>
    <table border=1>
        <tr>""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(columnList)-1
        except TypeError: _end=-1
        for column in columnList:
            _index+=1
            _page.append("""<th>""")
            _page.append(str(column))
            _page.append("""</th>""")
        _index=_index8
        _end=_end8
        _page.append("""</tr>
        """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(recordList)-1
        except TypeError: _end=-1
        for recordData in recordList:
            _index+=1
            _page.append("""<tr>
            """)
            _index12=locals().get("_index", -1)
            _end12=locals().get("_end", -1)
            _index=-1
            try: _end=len(recordData)-1
            except TypeError: _end=-1
            for columnValue, columnLink in recordData:
                _index+=1
                _page.append("""
                <td>""")
                _page.append(str(columnValue))
                _page.append("""</td>
            """)
            _index=_index12
            _end=_end12
            _page.append("""
        </tr>""")
        _index=_index8
        _end=_end8
        _page.append("""
    </table>
    <br>
    <b>IndexMap:</b><br>
    """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(indexMap.items())-1
        except TypeError: _end=-1
        for key,value in indexMap.items():
            _index+=1
            _page.append("""
        """)
            _page.append(str('<b>%s'%key+':</b>'+'%s'%value+'<br>'))
            _page.append("""
    """)
        _index=_index8
        _end=_end8
        _page.append("""
</body></html>
""")
        return "".join(_page)
    def testForMask(self):
        _page=[]
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(range(10))-1
        except TypeError: _end=-1
        for i in range(10):
            _index+=1
            _page.append("""
    i:""")
            _page.append(str(i))
            _page.append("""
""")
        _index=_index8
        _end=_end8
        _page.append("""
""")
        return "".join(_page)
global Prestation
class Prestation:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/prestation"
        else:
            return "/prestation"
    def localString(self, stri):
        if self==prestationFrench: return stri
        return self.stringMap.get(stri, stri)
    def getNow(self):
        tuple=time.gmtime(time.time())
        return time.strftime('%Y-%m-%d %H:%M:%S', tuple)
    def x(self, width=0, height=0):
        if width: width='width=%s'%width
        else: width=''
        if height: height='height=%s'%height
        else: height=''
        if self==prestationFrench: img='xFrench'
        else: img='xEnglish'
        return '<img src="%s/static/%s.gif" %s %s>'%(request.base, img, width, height)
    def header(self):
        if request.path.find('disclaimer')!=-1:
            description=self.localString("Prestation.net - Mentions legales")
            keywords=self.localString("loi, essence")
        elif request.path.find('wapZone')!=-1:
            description=self.localString("Prestation.net - Wap")
            keywords=self.localString("wap, prix")
        elif request.path.find('contactUs')!=-1:
            description=self.localString("Prestation.net - Contactez nous")
            keywords=self.localString("contact, mail")
        elif request.path.find('manager')!=-1:
            description=self.localString("Prestation.net - Devenir gerant")
            keywords=self.localString("gerer, gerant")
        elif request.path.find('firstVisit')!=-1:
            description=self.localString("Prestation.net - Premiere visite")
            keywords=self.localString("premier, visite")
        elif request.path.find('manageStation')!=-1:
            description=self.localString("Prestation.net - Gerer une station")
            keywords=self.localString("gerer, station")
        elif request.path.find('addStation')!=-1:
            description=self.localString("Prestation.net - Ajouter une station")
            keywords=self.localString("ajouter, station")
        elif request.path.find('searchStation')!=-1:
            description=self.localString("Prestation.net - Chercher une station")
            keywords=self.localString("chercher, recherche")
        else:
            description=self.localString("Trouvez la station d'essence la moins chere pres de chez vous")
            keywords=self.localString("essence, super, gasole, gazoil, sans plomb, 95, 98, prix, carburant, pompe, station, pas cher, pas chere")
        return self.headerMask(description, keywords)
    def resultStation(self, zipCode='', city='', keyWord='', department='', type='', sortBy='super', order='asc', page='0'):
        requestTable.addItem(name='zipCode=%s city=%s keyWord=%s department=%s type=%s"'%(zipCode, city,keyWord, department, type), lastUpdateTime=self.getNow())
        param=""
        if zipCode: param+="item.zipCode=='%s' and "%zipCode
        if city: param+="item.city=='%s' and "%city
        if keyWord: param+="item.keyWord.find('%s')!=-1 and "%keyWord.upper()
        if department: param+="item.department=='%s' and "%department
        if type: param+="item.type=='%s' and "%type
        stationList=stationTable.getItem(param[:-5], sortBy, order, lastValueList=[None, 0])
        if not stationList: return self.noStation()
        if len(stationList)>50: return self.tooManyStation()
        else: return self.stationList(stationList, zipCode, city, keyWord, department, type, sortBy, order, int(page))
    def addStationAction(self, myName, zipCode, city, address, phone, open, type, mySupper, sp95, sp98, gazole, nameOrEmail):
        newStationTable.addItem(name=myName, zipCode=zipCode, city=city, address=address, phone=phone, open=open, type=type, super=float(mySupper), sp95=float(sp95), sp98=float(sp98), gazole=float(gazole), nameOrEmail=nameOrEmail, lastUpdateTime=self.getNow())
        return self.header()+"<center><b>Merci de votre contribution.</b><br><br>Les informations que vous avez entrees seront disponibles sur le site sous 24h.</center>"+self.footer()
    def updatePriceAction(self, password, station, mySupper, sp95, sp98, gazole, nameOrEmail):
        if station.gerant and station.gerant!=password:
            return self.header+()+"<center><b>Le mot de passe est incorrect</b><br><br><form><input type=button value='Retour' onClick='javascript:history.back()'></form></center>"+self.footer()
        newPriceTable.addItem(station=station, super=float(mySupper), sp95=float(sp95), sp98=float(sp98), gazole=float(gazole), nameOrEmail=nameOrEmail, lastUpdateTime=self.getNow())
        return self.header()+"<center><b>Merci de votre contribution.</b><br><br>Les informations que vous avez entrees seront disponibles sur le site sous 24h.</center>"+self.footer()
    def updateInfoAction(self, password, station, myName, zipCode, city, address, phone, open, type, nameOrEmail):
        if station.gerant and station.gerant!=password:
            return self.header+()+"<center><b>Le mot de passe est incorrect</b><br><br><form><input type=button value='Retour' onClick='javascript:history.back()'></form></center>"+self.footer()
        newInfoTable.addItem(station=station, name=myName, zipCode=zipCode, city=city, address=address, phone=phone, open=open, type=type, nameOrEmail=nameOrEmail, lastUpdateTime=self.getNow())
        return self.header()+"<center><b>Merci de votre contribution.</b><br><br>Les informations que vous avez entrees seront disponibles sur le site sous 24h.</center>"+self.footer()
    def addCommentAction(self, station, comment, nameOrEmail):
        commentTable.addItem(station=station, comment=comment, nameOrEmail=nameOrEmail, checked=0, lastUpdateTime=self.getNow())
        return self.header()+"<center><b>Merci de votre contribution.</b><br><br>Vos commentaires seront disponibles sur le site sous 24h.</center>"+self.footer()
    def manageStationAction(self, myName, eMail, station, reason, otherReason, password1, password2):
        body=self.localString("Nom")+": %s"%myName
        body+="\n"+self.localString("Email")+": %s"%eMail
        body+="\n"+self.localString("Station")+": %s"%station
        body+="\n"+self.localString("Raison")+": %s"%reason
        body+="\n"+self.localString("Autre raison")+": %s"%otherReason
        body+="\n"+self.localString("Mot de passe")+": %s"%password1
        prestationMail.sendMail('gerer@prestation.net', configFile.get('mail', 'recipient'), '', 'text/plain', 'manageStation', body)
        return (self.header()+
            "<center><b>%s</b><br><br>%s</center>"%(
                self.localString("Votre demande a ete envoyee"), self.localString("Nous vous contacterons d'ici 24 a 72 heures"))
            +self.footer())
    def addComment(self, station):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<script TYPE="text/javascript">
function checkValues(){
  f=document.commentForm;
  if (f.comment.value.length<3) {alert(\"""")
        _page.append(str(self.localString('Vous devez entrer vos commentaires')))
        _page.append("""\"); return false;}
  return true;
}
</script>
<center>
<b>""")
        _page.append(str(self.localString('Entrez vos commentaires sur la station')))
        _page.append("""</b><br><br><br>
</center>
<FORM name=commentForm method=get action=\"""")
        _page.append(str(self.getPath()+'/addCommentAction'))
        _page.append("""\" onSubmit="return checkValues();">
<input name=station type=hidden value='""")
        _page.append(str(station))
        _page.append("""'>
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<TR>
<TD align=left><B>""")
        _page.append(str('* '+self.localString('Commentaire')+':'))
        _page.append("""</B></TD>
<TD align=left><TEXTAREA NAME="comment" COLS=30 ROWS=6 wrap=soft>
</TEXTAREA></TD>
</TR>
<tr><td colspan=2><hr></td></tr>
<tr>
<td align=left><B>""")
        _page.append(str(self.localString('Votre nom ou e-mail (facultatif)')+':'))
        _page.append("""</b></td>
<TD align=left><INPUT TYPE="TEXT" NAME="nameOrEmail" maxlength=40></TD>
</TR>
</TABLE></td></tr></table>
<BR>
<center>
<INPUT TYPE=submit VALUE=\"""")
        _page.append(str(self.localString('Valider')))
        _page.append("""\">
&nbsp;&nbsp;
<input type=button VALUE=\"""")
        _page.append(str(self.localString('Annuler')))
        _page.append("""\" onclick="history.back();">
</center>
</form>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def viewComment(self, station):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
""")
        commentList=commentTable.getItem('item.station==%s and item.checked==1'%station)
        _page.append("""
    <center><h2>
      Il y a """)
        _page.append(str(len(commentList)))
        _page.append(""" commentaires sur cette station
    </h2></center>
    <br><hr size=4>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(commentList)-1
        except TypeError: _end=-1
        for comment in commentList:
            _index+=1
            _page.append("""
  """)
            _page.append(str(comment.comment))
            _page.append("""<br>
  <table width=100%><tr><td align=right>
  <small>
  """)
            if comment.nameOrEmail!='':
                _page.append("""
     Commentaire de <b>""")
                _page.append(str(comment.nameOrEmail))
                _page.append("""</b>
  """)
            else:
                _page.append("""
     Commentaire anonyme
  """)
            _page.append("""
     le """)
            _page.append(str(self.formatDateForDay(comment.lastUpdateTime)))
            _page.append("""
  </small>
  </td></tr></table>
  """)
            if _item_index==len(commentList)-1:
                _page.append("""<hr size=4>
  """)
            else:
                _page.append("""<hr>
  """)
            _page.append("""
""")
        _index=_index8
        _end=_end8
        _page.append("""
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def updateInfo(self, station):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<script TYPE="text/javascript">
function checkZipCode(zc){
   if (isNaN(zc) || zc.length!=5 || zc<'01000' || zc>'95999') {
      alert("Le code postal n'est pas valide")
      return false
   }
   return true
}
function checkValues(){
  f=document.infoForm;
  if (f.myName.value.length<3) {alert("Vous devez entrer le nom de la station"); return false;}
  if (!checkZipCode(f.zipCode.value)) return false
  if (f.city.value.length<3) {alert("Vous devez entrer une ville"); return false;}
  if (f.address.value.length<3) {alert("Vous devez entrer une adresse"); return false;}
  if (f.type.selectedIndex==0) {alert("Vous devez entrer le type de la station"); return false;}
  if (f.password.value.length<3) {alert("Vous devez entrer le mot de passe"); return false;}
  return true;
}
</script>
<center>
<B>Si les informations sur la station ne sont pas a jour, vous pouvez les
modifier grace a la forme ci-dessous</b><br><br>
Les autres utilisateurs vous en seront reconnaissant<br>
</center>
<FORM name=infoForm method=get action=\"""")
        _page.append(str(self.getPath()+'/updateInfoAction'))
        _page.append("""\" onSubmit="return checkValues();">
<input name=station type=hidden value='""")
        _page.append(str(station))
        _page.append("""'>
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<TR>
<TD align=left><B>* Nom de la station:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="myName" value=\"""")
        _page.append(str(station.name))
        _page.append("""\" size=35></TD>
</TR>
<TR>
<TD align=left><B>* Code postal:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="zipCode" value=\"""")
        _page.append(str(station.zipCode))
        _page.append("""\" maxlength=5></TD>
</TR>
<TR>
<TD align=left><B>* Ville:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="city" value=\"""")
        _page.append(str(station.city))
        _page.append("""\" ></TD>
</TR>
<TR>
<TD align=left><B>* Adresse:</B></TD>
<TD align=left><TEXTAREA NAME="address" COLS=30 ROWS=3 wrap=soft>""")
        _page.append(str(station.address))
        _page.append("""</TEXTAREA></TD>
</TR>
<TD align=left><B>Telephone:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="phone" value=\"""")
        _page.append(str(station.phone))
        _page.append("""\"  maxlength=14></TD>
</TR>
<TR>
<TD align=left><B>Horaires d'ouverture:</B></TD>
<TD align=left><TEXTAREA NAME="open" COLS=30 ROWS="2" wrap=soft>""")
        _page.append(str(station.open))
        _page.append("""</TEXTAREA></TD>
</TR>
<TR>
<TD align=left><B>* Type de station:</B></TD>
<TD align=left><SELECT name=type>
<OPTION></OPTION>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(stationTable.getAllTypes())-1
        except TypeError: _end=-1
        for type in stationTable.getAllTypes():
            _index+=1
            _page.append("""
  <OPTION
  """)
            if station.type==type:
                _page.append("""
    SELECTED
  """)
            _page.append("""
 >""")
            _page.append(str(type))
            _page.append("""</OPTION>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</SELECT></TD>
</TR>
<tr><td colspan=2><hr></td></tr>
""")
        if station.gerant=='':
            _page.append("""
  <tr>
  <td><B>Votre nom ou e-mail (facultatif):</b></td>
  <TD><INPUT TYPE="TEXT" NAME="nameOrEmail" maxlength=40>
    <input type="hidden" name="password" value="abcd"></TD>
  </tr>
""")
        else:
            _page.append("""
  <tr>
  <td><B>Mot de passe gerant:</b></td>
  <TD><INPUT TYPE="password" NAME="password" maxlength=40>
    <input type="hidden" name="nameOrEmail" value="gerant"></TD>
  </tr>
""")
        _page.append("""
</TABLE></td></tr></table>
<BR>
<center>
<INPUT TYPE=submit VALUE="Mettre a jour les informations">
&nbsp;&nbsp;
<input type=button value=Annuler onclick="history.back();">
</center>
</form>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def updatePrice(self, station):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<script TYPE="text/javascript">
function checkPrice(str, type) {
   if (str=='') return false
   if (isNaN(str)) return false
   nb=parseFloat(str)
   if (nb==0) return true
   if (nb<0.5 || nb>2) return false
   return true;
}
function checkValues(){
  f=document.priceForm;
  if (checkPrice(f.mySupper.value,'super')!=true) {alert("Le prix du super est invalide"); return false;}
  if (checkPrice(f.sp95.value,'sp95')!=true) {alert("Le prix du sans plomb 95 est invalide"); return false;}
  if (checkPrice(f.sp98.value,'sp98')!=true) {alert("Le prix du sans plomb 98 est invalide"); return false;}
  if (checkPrice(f.gazole.value,'gazole')!=true) {alert("Le prix du gazole est invalide"); return false;}
  if (f.password.value.length<3) {alert("Vous devez entrer le mot de passe"); return false;}
  return true;
}
</script>
<center>
<B>Si les prix du carburant pour cette station ne sont pas a jour, vous pouvez les
modifier grace a la forme ci-dessous</b><br><br>
Les autres utilisateurs vous en seront reconnaissant<br>
</center>
<FORM name=priceForm method=get action=\"""")
        _page.append(str(self.getPath()+'/updatePriceAction'))
        _page.append("""\" onSubmit="return checkValues();">
<input name=station type=hidden value='""")
        _page.append(str(station))
        _page.append("""'>
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<tr><td colspan=2><br></td></tr>
<TR>
<TD align=left><B>* Prix du super:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="mySupper" value=\"""")
        _page.append(str('%01.02f'%station.super))
        _page.append("""\" size=4 maxlength=4> EUR</TD>
</TR>
<TR>
<TD align=left><B>* Prix du sans plomb 95:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="sp95" value=\"""")
        _page.append(str('%01.02f'%station.sp95))
        _page.append("""\" size=4 maxlength=4> EUR</TD>
</TR>
<TR>
<TD align=left><B>* Prix du sans plomb 98:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="sp98" value=\"""")
        _page.append(str('%01.02f'%station.sp98))
        _page.append("""\" size=4 maxlength=4> EUR</TD>
</TR>
<TR>
<TD align=left><B>* Prix du gazole:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="gazole" value=\"""")
        _page.append(str('%01.02f'%station.gazole))
        _page.append("""\" size=4 maxlength=4> EUR</TD>
</TR>
<tr><td colspan=2><hr></td></tr>
""")
        if station.gerant=='':
            _page.append("""
  <tr>
  <td align=left><B>Votre nom ou e-mail (facultatif):</b></td>
  <TD align=left><INPUT TYPE="TEXT" NAME="nameOrEmail" maxlength=40>
    <input type="hidden" name="password" value="abcd"></TD>
  </tr>
""")
        else:
            _page.append("""
  <tr>
  <td align=left><B>Mot de passe gerant:</b></td>
  <TD align=left><INPUT TYPE="password" NAME="password" maxlength=40>
    <input type="hidden" name="nameOrEmail" value="gerant"></TD>
  </tr>
""")
        _page.append("""
</TABLE></td></tr></table>
<BR>
<center>
<INPUT TYPE=submit VALUE="Mettre a jour les prix">
&nbsp;&nbsp;
<input type=button value=Annuler onclick="history.back();">
</center>
</form>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def manageStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<script language="javascript">
function checkValues(){
  f=document.manageStationForm;
  if (f.myName.value.length<3) {alert("Vous devez entrer votre nom"); return false;}
  if (f.eMail.value.length<3) {alert("Vous devez entrer votre e-mail"); return false;}
  if (f.station.value.length<3) {alert("Vous devez entrer la station"); return false;}
  if (f.password1.value.length<3) {alert("Vous devez entrer un mot de passe"); return false;}
  if (f.password1.value!=f.password2.value) {alert("Les mots de passe ne sont pas les memes"); return false;}
  return true;
}
</script>
<center><small><b>
Si vous etes gerant d'une station dans la vie ou que vous voulez tout simplement
vous occuper d'une station sur notre site, vous pouvez "gerer la station" sur
le site. Cela signifie que vous seul pourrez mettre a jour les prix ou les
infos sur cette station (grace a un mot de passe).</b><br><br>
Il vous suffit de remplir la forme ci-dessous</small><br>
<FORM name=manageStationForm method=get action=\"""")
        _page.append(str(self.getPath()+'/manageStationAction'))
        _page.append("""\" onSubmit="return checkValues();">
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<TR>
<TD align=left><B>* Votre nom:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="myName" size=35></TD>
</TR>
<TR>
<TD align=left><B>* Votre e-mail:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="eMail" size=35></TD>
</TR>
<TR>
<TD align=left><B>* Quelle station:<br><small>(Nom, adresse, code postal, ville)</small></B></TD>
<TD align=left><TEXTAREA NAME="station" COLS=30 ROWS=3 wrap=soft>
</textarea></TD>
</TR>
<TR>
<TD align=left><B>* Raison pour gerer la<br>station sur le site:</B></TD>
<TD align=left>
<input type=radio checked name=reason value=manager>Je suis gerant dans la vie<br>
<input type=radio name=reason value=other>Autre:
<input type=text name="otherReason" size=25>
</TD>
</TR>
<TR>
<TD align=left><B>* Mot de passe:</B></TD>
<TD align=left><INPUT TYPE="password" NAME="password1"></TD>
</TR>
<TR>
<TD align=left><B>* Confirmation mot de passe:</B></TD>
<TD align=left><INPUT TYPE="password" NAME="password2"></TD>
</TR>
</TABLE></td></tr></table>
<BR><br>
<center>
<INPUT TYPE=submit VALUE="Gerer la station">
&nbsp;&nbsp;
<input type=button value=Annuler onclick="history.back();">
</center>
</form>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def stationList(self, stationList, zipCode, city, keyWord, department, type, sortBy, order, page):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
  <script>
  function openUrl(url) {
    window.open(url,'Plan','')
    return
  }
  </script>
  <center><h3>
  """)
        if len(stationList)==1:
            _page.append("""
    Une seule station a ete trouvee pour ces criteres</h3>
  """)
        else:
            _page.append("""
    """)
            _page.append(str(len(stationList)))
            _page.append(""" stations ont ete trouvees pour ces criteres</h3>
    <form name=sortForm action=\"""")
            _page.append(str(self.getPath()+'/resultStation'))
            _page.append("""\">
    <input type=hidden name=zipCode value=\"""")
            _page.append(str(zipCode))
            _page.append("""\">
    <input type=hidden name=city value=\"""")
            _page.append(str(city))
            _page.append("""\">
    <input type=hidden name=keyWord value=\"""")
            _page.append(str(keyWord))
            _page.append("""\">
    <input type=hidden name=department value=\"""")
            _page.append(str(department))
            _page.append("""\">
    <input type=hidden name=type value=\"""")
            _page.append(str(type))
            _page.append("""\">
    Classer les stations par
    <select name=sortBy>
    <option value=super
      """)
            if sortBy=='super':
                _page.append("""selected""")
            _page.append("""
    >Prix du super</option>
    <option value=sp95
      """)
            if sortBy=='sp95':
                _page.append("""selected""")
            _page.append("""
    >Prix du sp95</option>
    <option value=sp98
      """)
            if sortBy=='sp98':
                _page.append("""selected""")
            _page.append("""
    >Prix du sp98</option>
    <option value=gazole
      """)
            if sortBy=='gazole':
                _page.append("""selected""")
            _page.append("""
    >Prix du gazole</option>
    <option value=zipCode
      """)
            if sortBy=='zipCode':
                _page.append("""selected""")
            _page.append("""
    >Code postal</option>
    </select>
    dans l'ordre
    <select name=order>
    <option value=asc
      """)
            if order=='asc':
                _page.append("""selected""")
            _page.append("""
    >Croissant</option>
    <option value=desc
      """)
            if order=='desc':
                _page.append("""selected""")
            _page.append("""
    >Decroissant</option>
    </select>
    &nbsp;<input type=submit value=GO>
    </form>
  """)
        _page.append("""
  </center>
  <table width="100%"><tr><td align=right><small><small>Stations:&nbsp;
    """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(range(len(stationList)/5))-1
        except TypeError: _end=-1
        for i in range(len(stationList)/5):
            _index+=1
            _page.append("""
      """)
            request.paramMap['page']=str(i)
            _page.append("""
      """)
            if page!=i:
                _page.append("""<a href=\"""")
                _page.append(str(request.base+'/'+request.path+'?'+urllib.urlencode(request.paramMap)))
                _page.append("""\">""")
            _page.append(str('%s-%s'%(i*5+1, i*5+5)))
            if i!=page:
                _page.append("""</a>""")
            _page.append("""
      &nbsp;
    """)
        _index=_index8
        _end=_end8
        _page.append("""
    """)
        if len(stationList)%5:
            _page.append("""
      """)
            request.paramMap['page']=str(len(stationList)/5)
            _page.append("""
      """)
            if page!=len(stationList)/5:
                _page.append("""<a href=\"""")
                _page.append(str(request.base+'/'+request.path+'?'+urllib.urlencode(request.paramMap)))
                _page.append("""\">""")
            _page.append(str('%s-%s'%((len(stationList)/5)*5+1, len(stationList))))
            if page!=len(stationList)/5:
                _page.append("""</a>""")
            _page.append("""
    """)
        _page.append("""
  </small></small></td></tr></table>
  <hr size=4>
  <table align=center width="90%">
  """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(stationList[page*5:page*5+5])-1
        except TypeError: _end=-1
        for station in stationList[page*5:page*5+5]:
            _index+=1
            _page.append("""
    """)
            debug('station:%s'%station)
            _page.append("""
    <tr>
      <td width="100%">""")
            _page.append(str(self.viewStation(station)))
            _page.append("""
    """)
            if station==stationList[page*5:page*5+5][-1]:
                _page.append("""
      </td></tr>
    """)
            else:
                _page.append("""
      <hr></td></tr>
    """)
            _page.append("""
  """)
        _index=_index8
        _end=_end8
        _page.append("""
  </table>
  <hr size=4>
  <table width="100%"><tr><td align=left>
    """)
        if page!=0:
            _page.append("""
      """)
            request.paramMap['page']=str(page-1)
            _page.append("""
      <small><a href=\"""")
            _page.append(str(request.base+'/'+request.path+'?'+urllib.urlencode(request.paramMap)))
            _page.append("""\">&lt;&lt; stations precedentes</a></small>
    """)
        _page.append("""
  </td><td align=right>
    """)
        if page!=len(stationList)/5:
            _page.append("""
      """)
            request.paramMap['page']=str(page+1)
            _page.append("""
      <small><a href=\"""")
            _page.append(str(request.base+'/'+request.path+'?'+urllib.urlencode(request.paramMap)))
            _page.append("""\">stations suivantes &gt;&gt;</a></small>
    """)
        _page.append("""
  </td></tr></table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def viewStation(self, station):
        _page=[]
        _page.append("""<table width=100% cellspacing=0>
<tr>
<td width="40%">
  <a class="updateLink" href=\"""")
        _page.append(str(self.getPath()+'/updatePrice?station='+urllib.quote_plus(`station`)))
        _page.append("""\">
  &nbsp;Mettre a jour les prix""")
        if station.gerant!='':
            _page.append(""" (gerant)""")
        _page.append("""&nbsp;</a>
</td><td width="10%"></td>
<td width="50%">
  <a class="updateLink" href=\"""")
        _page.append(str(self.getPath()+'/updateInfo?station='+urllib.quote_plus(`station`)))
        _page.append("""\">
  &nbsp;Mettre a jour les infos""")
        if station.gerant!='':
            _page.append(""" (gerant)""")
        _page.append("""&nbsp;</a>
</td>
</tr>
<tr><td>
<table>
  <tr><td class="gasType">
    <b>SUPER</b>
  </td><td width=42 height=18>""")
        _page.append(str(self.viewPrice(station.super)))
        _page.append("""</td></tr>
  <tr><td class="gasType">
    <b>SP 95</b>
  </td><td>""")
        _page.append(str(self.viewPrice(station.sp95)))
        _page.append("""</td></tr>
  <tr><td class="gasType">
    <b>SP 98</b>
  </td><td>""")
        _page.append(str(self.viewPrice(station.sp98)))
        _page.append("""</td></tr>
  <tr><td class="gasType">
    <b>GAZOLE</b>
  </td><td>""")
        _page.append(str(self.viewPrice(station.gazole)))
        _page.append("""</td></tr>
  <tr><td colspan=2>
    <small><small>
      """)
        if station.super+station.sp95+station.sp98+station.gazole==0:
            _page.append("""
        Prix inconnus
      """)
        else:
            _page.append("""
        Mis a jour le
        """)
            _page.append(str(self.formatDateForDay(station.lastUpdateTime)))
            _page.append("""
      """)
        _page.append("""
    </small></small>
  </td></tr>
</table>
</td><td></td>
<td>
<table><tr><td align=center width=190>
  """)
        if station.type!='Autre':
            _page.append("""
    <img src=\"""")
            _page.append(str(request.base+'/static/%s.gif'%(station.type.replace('e','e'))))
            _page.append("""\">
  """)
        _page.append("""
</td>
<td align=right>
<a href="javascript:openUrl('http://www.maporama.com/share/Map.asp?PDT=maposearch?language=fr&_XgoGCAdrCommand=run&_XgoGCAddress=""")
        _page.append(str(urllib.quote_plus(station.address)))
        _page.append("""&Zip=""")
        _page.append(str(urllib.quote_plus(station.zipCode)))
        _page.append("""&_XgoGCTownName=""")
        _page.append(str(urllib.quote_plus(station.city)))
        _page.append("""&COUNTRYCODE=FR')"><img src=\"""")
        _page.append(str(request.base+'/static/map.gif'))
        _page.append("""\" border=0 alt="Plan"></a>
</td></tr></table>
<b>""")
        _page.append(str(station.zipCode+' '+station.city))
        _page.append("""</b><br>
<b><small>""")
        _page.append(str(station.name))
        _page.append("""</small></b><br>
<small>""")
        _page.append(str(station.address))
        _page.append("""</small><br>
<small><img src=\"""")
        _page.append(str(request.base+'/static/phone.gif'))
        _page.append("""\">""")
        _page.append(str('&nbsp;'+station.phone))
        _page.append("""</small><br>
""")
        if open!='':
            _page.append("""
  <small><b>""")
            _page.append(str('Ouverture '+station.open+'<br>'))
            _page.append("""</b></small>
""")
        _page.append("""
</td>
</tr>
<tr><td>
  <a class=commentLink href=\"""")
        _page.append(str(self.getPath()+'/addComment?station='+urllib.quote_plus(`station`)))
        _page.append("""\">
   Donner mon avis sur cette station</a>
</td><td></td><td>
  """)
        numberOfComments=len(commentTable.getItem('item.station==%s and item.checked==1'%station))
        _page.append("""
  """)
        if numberOfComments!=0:
            _page.append("""
    <a class=commentLink href=\"""")
            _page.append(str(self.getPath()+'/viewComment?station='+urllib.quote_plus(`station`)))
            _page.append("""\">
     Lire les commentaires sur cette station (""")
            _page.append(str(numberOfComments))
            _page.append(""")</a>
  """)
        else:
            _page.append("""
    <small>Aucun commentaire pour l'instant</small>
  """)
        _page.append("""
</td></tr>
</table>
""")
        return "".join(_page)
    def viewPrice(self, price):
        _page=[]
        if price==0:
            _page.append("""
  <img src=\"""")
            _page.append(str(request.base+'/static/unknownPrice.gif'))
            _page.append("""\" width=42 height=18>
""")
        else:
            _page.append("""
  """)
            price='%01.02f'%price
            _page.append("""
  <table cellspacing=0 cellpadding=0 border=0><tr>
    """)
            _index12=locals().get("_index", -1)
            _end12=locals().get("_end", -1)
            _index=-1
            try: _end=len(range(4))-1
            except TypeError: _end=-1
            for i in range(4):
                _index+=1
                _page.append("""
      """)
                if i==1:
                    _page.append("""
        <td width=6>
        <img src=\"""")
                    _page.append(str(request.base+'/static/dot.gif'))
                    _page.append("""\" width=6 height=18>
      """)
                else:
                    _page.append("""
        <td width=12>
        <img src=\"""")
                    _page.append(str(request.base+'/static/%s.gif'%price[i]))
                    _page.append("""\" width=12 height=18>
      """)
                _page.append("""
      </td>
    """)
            _index=_index12
            _end=_end12
            _page.append("""
  </tr></table>
""")
        _page.append("""
""")
        return "".join(_page)
    def searchStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<script TYPE="text/javascript">
function checkZipCode(zc){
 if (isNaN(zc) || zc.length!=5 || zc<'01000' || zc>'95999') {
    alert("Le code postal n'est pas valide")
    return false
 } else return true
}
function checkKeyWord(kw) {
 if (kw.length<3) {
    alert("Le mot clef doit avoir au moins 3 caracteres !")
    return false
 } else return true
}
function checkCity(city) {
 if (city.length<3) {
    alert("La ville doit avoir au moins 3 caracteres !")
    return false
 } else return true
}
function checkDepartment(id) {
   if (isNaN(id) || id.length!=2 || id<'01' || id>'95') {
      alert("Le departement n'est pas valide")
      return false
   } else return true
}
function checkValues(){
  // Check that not all values are empty and that they are correct
  allEmpty=true
  f=document.stationForm
  zc=f.zipCode.value
  if (zc!='') {
    if (!checkZipCode(zc)) return false
    allEmpty=false
  }
  kw=f.keyWord.value
  if (kw!='') {
    if (!checkKeyWord(kw)) return false
    allEmpty=false
  }
  city=f.city.value
  if (city!='') {
    if (!checkCity(city)) return false
    allEmpty=false
  }
  id=f.department.value
  if (id!='') {
    if (id=='2a' || id=='2A' || id=='2b' || id=='2B') id='20'
    if (id.length==1) id='0'+id
    if (!checkDepartment(id)) return false
    f.department.value=id
    allEmpty=false
  }
  if (f.type.selectedIndex!=0) {
    allEmpty=false
  }
  if (allEmpty) {
    alert("Vous devez preciser au moins un critere de recherche")
    return false
  }
  return true
}
</script>
<center><b>Entrez un ou plusieurs criteres pour la station.</b></center>
<br><br><br>
<FORM name=stationForm method="GET" action=\"""")
        _page.append(str(self.getPath()+'/resultStation'))
        _page.append("""\" onSubmit="return checkValues()">
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<TR>
<TD align=left><B>Code postal:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="zipCode" size=5 maxlength=5></TD>
</TR>
<TR>
<TD align=left><B>Ville:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="city"></TD>
</TR>
<TR>
<TD align=left><B>Mot clef:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="keyWord"></TD>
</TR>
<TR>
<TD align=left><B>Departement:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="department" size=3 maxlength=3></TD>
</TR>
<TR>
<TD align=left><B>Type de station:</B></TD>
<TD align=left><SELECT name=type>
<OPTION></OPTION>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(stationTable.getAllTypes())-1
        except TypeError: _end=-1
        for type in stationTable.getAllTypes():
            _index+=1
            _page.append("""
  """)
            if type!='Autre':
                _page.append("""
    <OPTION>""")
                _page.append(str(type))
                _page.append("""</OPTION>
  """)
            _page.append("""
""")
        _index=_index8
        _end=_end8
        _page.append("""
</SELECT></TD>
</TR>
<tr><td colspan=2><hr>Classer les stations par
  <select name=sortBy>
  <option value=super>Prix du super</option>
  <option value=sp95>Prix du sp95</option>
  <option value=sp98>Prix du sp98</option>
  <option value=gazole>Prix du gazole</option>
  <option value=zipCode>Code postal</option>
  </select>
  dans l'ordre
  <select name=order>
  <option value=asc>Croissant</option>
  <option value=desc>Decroissant</option>
  </select>
</td></tr>
</TABLE></td></tr></table>
<BR>
<TABLE align=center>
<TR><TD>
<INPUT TYPE=submit VALUE="Lancer la recherche">
</td></tr></table>
</form>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def addStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<script TYPE="text/javascript">
function checkZipCode(zc){
   if (isNaN(zc) || zc.length!=5 || zc<'01000' || zc>'95999') {
      alert("Le code postal n'est pas valide")
      return false
   }
   return true
}
function checkPrice(str, type) {
   if (str=='') return false
   if (isNaN(str)) return false
   nb=parseFloat(str)
   if (nb==0) return true
   if (nb<0.5 || nb>2) return false
   return true;
}
function checkValues(){
  f=document.addStationForm;
  if (f.myName.value.length<3) {alert("Vous devez entrer le nom de la station"); return false;}
  if (!checkZipCode(f.zipCode.value)) return false
  if (f.city.value.length<3) {alert("Vous devez entrer une ville"); return false;}
  if (f.address.value.length<3) {alert("Vous devez entrer une adresse"); return false;}
  if (f.type.selectedIndex==0) {alert("Vous devez entrer le type de la station"); return false;}
  if (checkPrice(f.mySupper.value,'super')!=true) {alert("Le prix du super est invalide"); return false;}
  if (checkPrice(f.sp95.value,'sp95')!=true) {alert("Le prix du sans plomb 95 est invalide"); return false;}
  if (checkPrice(f.sp98.value,'sp98')!=true) {alert("Le prix du sans plomb 98 est invalide"); return false;}
  if (checkPrice(f.gazole.value,'gazole')!=true) {alert("Le prix du gazole est invalide"); return false;}
  return true;
}
</script>
<center>
<b>Si vous connaissez une station qui n'est pas dans notre liste, vous pouvez
l'ajouter grace a la forme ci-dessous</b><br><br>
Les autres utilisateurs vous en seront reconnaissant<br>
</center>
<FORM name=addStationForm method=get action=\"""")
        _page.append(str(self.getPath()+'/addStationAction'))
        _page.append("""\" onSubmit="return checkValues();">
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<TR>
<TD align=left><B>* Nom de la station:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="myName" size=35></TD>
</TR>
<TR>
<TD align=left><B>* Code postal:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="zipCode" maxlength=5></TD>
</TR>
<TR>
<TD align=left><B>* Ville:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="city"></TD>
</TR>
<TR>
<TD align=left><B>* Adresse:</B></TD>
<TD align=left><TEXTAREA NAME="address" COLS=30 ROWS=3 wrap=soft>
</TEXTAREA></TD>
</TR>
<TR><TD align=left><B>Telephone:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="phone" maxlength=14></TD>
</TR>
<TR>
<TD align=left><B>Horaires d'ouverture:</B></TD>
<TD align=left><TEXTAREA NAME="open" COLS=30 ROWS="2" wrap=soft>
</TEXTAREA></TD>
</TR>
<TR>
<TD align=left><B>* Type de station:</B></TD>
<TD align=left><SELECT name=type>
<OPTION></OPTION>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(stationTable.getAllTypes())-1
        except TypeError: _end=-1
        for type in stationTable.getAllTypes():
            _index+=1
            _page.append("""
  <OPTION>""")
            _page.append(str(type))
            _page.append("""</OPTION>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</SELECT></TD>
</TR>
<tr><td colspan=2><hr></td></tr>
<tr>
<td align=left><B>Votre nom ou e-mail (facultatif):</b></td>
<TD align=left><INPUT TYPE="TEXT" NAME="nameOrEmail" maxlength=40></TD>
</TR>
</TABLE></td></tr></table>
<br><br><center><b>Si vous avez connaissez aussi le prix des carburants, vous pouvez le
donner grace a la forme ci-dessous</b></center><br><br>
<table border=2 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><tr><td>
<TABLE cellspacing=10>
<tr><td colspan=2><br></td></tr>
<TR>
<TD align=left><B>* Prix du super:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="mySupper" value="0.00" size=4 maxlength=4></TD>
</TR>
<TR>
<TD align=left><B>* Prix du sans plomb 95:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="sp95" value="0.00" size=4 maxlength=4></TD>
</TR>
<TR>
<TD align=left><B>* Prix du sans plomb 98:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="sp98" value="0.00" size=4 maxlength=4></TD>
</TR>
<TR>
<TD align=left><B>* Prix du gazole:</B></TD>
<TD align=left><INPUT TYPE="TEXT" NAME="gazole" value="0.00" size=4 maxlength=4></TD>
</TR>
</TABLE></td></tr></table>
<BR><br>
<center>
<INPUT TYPE=submit VALUE="Ajouter la station">
&nbsp;&nbsp;
<input type=button value=Annuler onclick="history.back();">
</center>
</form>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def headerColumn(self):
        _page=[]
        _page.append("""<table align=center>
    <tr><td align=center><br><br>
    """)
        if self==prestationFrench:
            _page.append("""
        <a href=\"""")
            _page.append(str(request.base+'/prestationEnglish/index'))
            _page.append("""\"><img src=\"""")
            _page.append(str(request.base+'/static/englishFlag.jpg'))
            _page.append("""\" border=0></a>
    """)
        else:
            _page.append("""
        <a href=\"""")
            _page.append(str(request.base+'/prestationFrench/index'))
            _page.append("""\"><img src=\"""")
            _page.append(str(request.base+'/static/frenchFlag.jpg'))
            _page.append("""\" border=0></a>
    """)
        _page.append("""
<br><br>
<font color=white>""")
        _page.append(str(self.getDate()))
        _page.append("""</font>
<br><br></td></tr>
    <tr><td>
      <form method="GET" name="fastSearchForm" action=\"""")
        _page.append(str(self.getPath()+'/resultStation'))
        _page.append("""\">
        <table border=0 cellspacing=0 cellpadding=0>
          <tr><th colspan=3 bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\" align=center>""")
        _page.append(str(self.localString('Recherche rapide')))
        _page.append("""</th></tr>
          <tr><td width=1 rowspan=3>""")
        _page.append(str(self.x(1, 110)))
        _page.append("""</td>
            <td class=leftHeaderLink>""")
        _page.append(str('&nbsp;'+self.localString('Code postal')+':'))
        _page.append("""</td>
            <td align=right><input type=text name=zipCode size=8 maxLength=5 value="88000" onfocus="value=''">&nbsp;
              <a href="javascript:document.fastSearchForm.submit()"
              onClick="return checkFastZipCode()">""")
        _page.append(str(self.go()))
        _page.append("""</a></td></tr>
          <tr><td class=leftHeaderLink>""")
        _page.append(str('&nbsp;'+self.localString('Departement')+':'))
        _page.append("""</td>
            <td align=right><input type=text name=department size=3 maxLength=2 value="54" onfocus="value=''">&nbsp;
              <a href="javascript:document.fastSearchForm.submit()"
              onClick="return checkFastDepartment()" >""")
        _page.append(str(self.go()))
        _page.append("""</a></td></tr>
          <tr><td class=leftHeaderLink>""")
        _page.append(str('&nbsp;'+self.localString('Mot clef')+':'))
        _page.append("""</td>
            <td align=right><input type=text name=keyWord size=8 value="A 40" onFocus="value=''">&nbsp;
              <a href="javascript:document.fastSearchForm.submit()"
              onClick="return checkFastKeyWord()" >""")
        _page.append(str(self.go()))
        _page.append("""</a></td></tr>
          <tr><td colspan=3>""")
        _page.append(str(self.x(190, 1)))
        _page.append("""</td></tr>
        </table>
        <input name=city type=hidden value="">
        <input name=type type=hidden value="">
        <input name=sortBy type=hidden value="super">
        <input name=order type=hidden value="asc">
      </form>
   </td></tr>
    <tr><td><br>
      <table border=0 cellspacing=0 cellpadding=0>
        <tr><th colspan=2 bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\" align=center>""")
        _page.append(str(self.localString('Stations')))
        _page.append("""</th></tr>
        <tr><td width=1 rowspan=3>""")
        _page.append(str(self.x(1, 90)))
        _page.append("""</td>
          <td align=center><a class=leftHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/searchStation'))
        _page.append("""\">""")
        _page.append(str(self.localString('Recherche avancee')))
        _page.append("""</a></td></tr>
        <tr><td align=center><a class=leftHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/addStation'))
        _page.append("""\">""")
        _page.append(str(self.localString('Ajouter une station')))
        _page.append("""</a></td></tr>
        <tr><td align=center><a class=leftHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/manageStation'))
        _page.append("""\">""")
        _page.append(str(self.localString('Gerer une station')))
        _page.append("""</a></td></tr>
        <tr><td colspan=3>""")
        _page.append(str(self.x(190, 1)))
        _page.append("""</td></tr>
      </table>
    </td></tr>
    <tr><td><br>
      <table border=0 cellspacing=0 cellpadding=0 width=190>
        <tr><th colspan=2 width=190 bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\" align=center>""")
        _page.append(str(self.localString('Partenaire')))
        _page.append("""</th></tr>
        <tr>
          <td width=1 bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\">""")
        _page.append(str(self.x(1)))
        _page.append("""</td>
          <td width=189 align=center bgcolor=white>
            """)
        _page.append(str(self.partnerModule()))
        _page.append("""
          </td>
        </tr>
        <tr><td colspan=2 width=190>""")
        _page.append(str(self.x(190, 1)))
        _page.append("""</td></tr>
      </table>
    </td></tr>
    <tr><td><br>
      <table border=0 cellspacing=0 cellpadding=0>
        <tr><th colspan=2 bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\" align=center>""")
        _page.append(str(self.localString('Liens')))
        _page.append("""</th></tr>
        <tr><td width=1 rowspan=4>""")
        _page.append(str(self.x(1, 200)))
        _page.append("""</td>
          <td align=center><a class=leftHeaderLink href="http://stations.gpl.online.fr">
            GPL Online</a><br><small><small><font color=white>(Site sur les stations GPL)</font></small></small></td></tr>
        <tr><td align=center><a class=leftHeaderLink href="http://www.carburant.org">
          Carburant.org</a><br><small><small><font color=white>(Site de la baisse de prix du carburant)</font></small></small></td></tr>
        <tr><td align=center><a class=leftHeaderLink href="http://www.jamanga.com">
          Jamanga.com</a><br><small><small><font color=white>(Le CyberVillage de la route)</font></small></small></td></tr>
        <tr><td align=center><a class=leftHeaderLink href="http://www.argenil.fr.st">
          Argenil</a><br><small><small><font color=white>(Reduisez vos factures de telephone et les autres)</font></small></small><br></td></tr>
        <tr><td colspan=3>""")
        _page.append(str(self.x(190, 1)))
        _page.append("""</td></tr>
      </table>
    </td></tr>
  </table>
""")
        return "".join(_page)
    def headerMask(self, description, keywords):
        _page=[]
        _page.append("""<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<HTML>
<HEAD>
  <meta http-equiv="robots" content="all">
  <meta name="description" content=\"""")
        _page.append(str(description))
        _page.append("""\">
  <meta name="keywords" content=\"""")
        _page.append(str(keywords))
        _page.append("""\">
  <TITLE>""")
        _page.append(str(self.localString('Trouvez la station d\'essence la moins chere pres de chez vous')))
        _page.append("""</TITLE>
""")
        if self==prestationFrench:
            _page.append("""
    <link rel="stylesheet" href=\"""")
            _page.append(str(request.base+'/static/styleSheetFrench.css'))
            _page.append("""\" type="text/css">
""")
        else:
            _page.append("""
    <link rel="stylesheet" href=\"""")
            _page.append(str(request.base+'/static/styleSheetEnglish.css'))
            _page.append("""\" type="text/css">
""")
        _page.append("""
</HEAD>
""")
        if self==prestationFrench:
            _page.append("""
    <BODY background=\"""")
            _page.append(str(request.base+'/static/backgroundFrench.gif'))
            _page.append("""\">
""")
        else:
            _page.append("""
    <BODY background=\"""")
            _page.append(str(request.base+'/static/backgroundEnglish.gif'))
            _page.append("""\">
""")
        _page.append("""
<script TYPE="text/javascript">
function checkFastZipCode(){
   zc=document.fastSearchForm.zipCode.value
   if (isNaN(zc) || zc.length!=5 || zc<'01000' || zc>'95999') {
      alert(\"""")
        _page.append(str(self.localString('Le code postal n\'est pas valide')))
        _page.append("""\")
      return false
   }
   document.fastSearchForm.department.value=''
   document.fastSearchForm.keyWord.value=''
   return true
}
function checkFastKeyWord() {
   kw=document.fastSearchForm.keyWord.value
   if (kw.length<3) {
      alert(\"""")
        _page.append(str(self.localString('Le mot clef doit avoir au moins 3 caracteres')))
        _page.append("""\")
      return false
   }
   document.fastSearchForm.zipCode.value=''
   document.fastSearchForm.department.value=''
   return true
}
function checkFastDepartment() {
   id=document.fastSearchForm.department.value
   if (id=='2a' || id=='2A' || id=='2b' || id=='2B') id='20'
   if (id.length==1) id='0'+id
   if (isNaN(id) || id.length!=2 || id<'01' || id>'95') {
      alert(\"""")
        _page.append(str(self.localString('Le departement n\'est pas valide')))
        _page.append("""\")
      return false
   }
   document.fastSearchForm.department.value=id
   document.fastSearchForm.zipCode.value=''
   document.fastSearchForm.keyWord.value=''
   return true
}
</script>
<table cellspacing=0 width=840>
<tr>
""")
        if self==prestationEnglish:
            _page.append("""
    <td width=200 class="leftcolumn" valign=top align=left>
        """)
            _page.append(str(self.headerColumn()))
            _page.append("""
    </td>
    <td width=60></td>
""")
        _page.append("""
<td width=550 valign=top align=center>
    <table width="100%" align=center>
      <tr><td align=center>
          """)
        if self==prestationFrench:
            _page.append("""
          <img src=\"""")
            _page.append(str(request.base+'/static/logoFrench.gif'))
            _page.append("""\">
          """)
        else:
            _page.append("""
          <img src=\"""")
            _page.append(str(request.base+'/static/logoEnglish.gif'))
            _page.append("""\">
          """)
        _page.append("""
      </td></tr>
      <tr><td align=center width="100%"><br>
      <table width="100%" cellspacing=1 cellpadding=2><tr>
        <td class=topHeaderLink align=center><a class=topHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/index'))
        _page.append("""\">""")
        _page.append(str(self.localString('Accueil')))
        _page.append("""</a></td>
        <td class=topHeaderLink align=center><a class=topHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/firstVisit'))
        _page.append("""\">""")
        _page.append(str(self.localString('Premiere visite')))
        _page.append("""</a></td>
        <td class=topHeaderLink align=center><a class=topHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/manager'))
        _page.append("""\">""")
        _page.append(str(self.localString('Vous etes gerant')))
        _page.append("""</a></td>
        <td class=topHeaderLink align=center><a class=topHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/contactUs'))
        _page.append("""\">""")
        _page.append(str(self.localString('Ecrivez-nous')))
        _page.append("""</a></td>
        <td class=topHeaderLink align=center><a class=topHeaderLink href=\"""")
        _page.append(str(self.getPath()+'/wapZone'))
        _page.append("""\">""")
        _page.append(str(self.localString('WAP zone')))
        _page.append("""</a></td>
     </tr></table></td></tr>
     <tr><td><br><br>
""")
        return "".join(_page)
    def partnerModule(self):
        _page=[]
        _page.append("""<table border=0 cellpadding=0 cellspacing=0 width=150>
  <tr>
    <td align=center bgcolor=#ffffff><small>
      <a href="http://www.urbishop.com"><img src=\"""")
        _page.append(str(request.base+'/static/urbishopLogo.gif'))
        _page.append("""\" border=0></a><br><br>
      """)
        _page.append(str(self.localString('Retrouvez les meilleurs offres des magasins pres de chez vous')))
        _page.append("""<br>
      <a class=blackSmallText href=\"""")
        _page.append(str('http://www.urbishop.com'))
        _page.append("""\">UrbiShop.com</a><br><br>
    </small></td>
  </tr>
  <tr>
    <td height=1 align=center bgcolor=white><table border=0 cellspacing=0 cellpadding=0><tr>
      <td height=1 width=90 bgcolor=#aabbdd>""")
        _page.append(str(self.x(1, 1)))
        _page.append("""</td>
    </tr></table></td>
  </tr>
  <tr>
    <td align=left bgcolor=#ffffff class=blackSmallText>
      <form name=partnerForm action="http://www.urbishop.com/dmChangeCity">
      <table border=0 cellspacing=0 cellpadding=0>
        <tr>
          <td width=5></td>
          <td width=134 colspan=2 class=blackSmallText><small><br>""")
        _page.append(str(self.localString('Vous cherchez')))
        _page.append(""":<br><br></small></td>
        </tr>
        <tr>
          <td width=5></td>
          <td class=blackSmallText><small>""")
        _page.append(str(self.localString('Quoi')))
        _page.append("""</small></td>
          <td><input type=text name=keyWord size=10 value="portable" onFocus="this.value=''"></td>
        </tr>
        <tr>
          <td width=5></td>
          <td class=blackSmallText><small>""")
        _page.append(str(self.localString('Ou')))
        _page.append("""</small></td>
          <td><input type=text name=city size=10 value="75005" onFocus="this.value=''"></td>
        </tr>
        <tr>
          <td width=5></td>
          <td class=blackSmallText><small>""")
        _page.append(str(self.localString('Radius')))
        _page.append("""</small></td>
          <td><select name=sniffRadius>
            """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len([0,5,10,30,50,80])-1
        except TypeError: _end=-1
        for radius in [0,5,10,30,50,80]:
            _index+=1
            _page.append("""
              <option value=\"""")
            _page.append(str(radius))
            _page.append("""\" """)
            if radius==30:
                _page.append("""selected""")
            _page.append(""">
              """)
            if radius!=0:
                _page.append(str(radius))
                _page.append(""" km
              """)
            else:
                _page.append("""illimite
              """)
            _page.append("""
              </option>
            """)
        _index=_index8
        _end=_end8
        _page.append("""
          </select></td>
        </tr>
        <tr>
          <td width=5></td>
          <td colspan=2 align=center><br><input type=submit value=\"""")
        _page.append(str(self.localString('Rechercher')))
        _page.append("""\"><br><br></td>
        </tr>
      </table>
      <input type=hidden name=fromPage value="partnerFormPrestation">
      </form>
    </td>
  </tr>
</table>
""")
        return "".join(_page)
    def footer(self):
        _page=[]
        _page.append("""        </td></tr></table>
    </td>
    """)
        if self==prestationFrench:
            _page.append("""
        <td width=60>&nbsp;</td>
        <td width=200 class="leftcolumn" valign=top align=left>
            """)
            _page.append(str(self.headerColumn()))
            _page.append("""
        </td>
    """)
        _page.append("""
    </tr>
    <tr><td align=center>
      <a href=\"""")
        _page.append(str(self.getPath()+'/disclaimer'))
        _page.append("""\"><small><small>""")
        _page.append(str(self.localString('Mentions legales')))
        _page.append("""</small></small></a>
    </td></tr>
  </table>
</body></html>
""")
        return "".join(_page)
    def firstVisit(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="80%" align=center>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Qu'est-ce que prestation.net ?</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Prestation.net est un site entierement gere par des benevoles dont le but est simple: vous
permettre de trouver la station d'essence la moins chere pres de l'endroit ou vous vous trouvez.<br>&nbsp;
Nous disposons d'une base de donnees de stations avec leurs prix. Pour que ces donnees soient
fiables, nous comptons sur <b>vous</b>, les internautes pour rendre services aux autres en participant.
Pour cela, vous pouvez relever les prix dans les stations et mettre a jour le site. Vous pouvez
egalement ajouter de nouvelles stations, ou modifier les coordonnees d'une station.<br>&nbsp;
De plus, d'autres services sont disponibles ou le seront prochainement comme les
commentaires sur les stations, plan pour acceder a la station,
fiches stations detaillees avec photos et ensemble des
services disponibles dans la station, le portail WAP, etc ...<br><br>
</small></td></tr>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Comment trouver la station la moins chere pres de chez moi ?</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Le moyen le plus rapide est d'utiliser la recherche rapide disponible dans le menu
de gauche. Il vous suffit d'entrer votre code postal, ou votre departement. Vous pouvez
aussi faire une recherche par mot clef ("PARIS" par exemple).<br>&nbsp;
Si vous voulez faire une recherche plus precise (par exemple, vous voulez un
type de station bien precis), vous pouvez utiliser la
<a href=\"""")
        _page.append(str(self.getPath()+'/searchStation'))
        _page.append("""\">recherche avancee</a>,
egalement disponible dans le menu de gauche.<br>&nbsp;
Lorsque la liste de stations est affichee, vous pouvez la classer par ordre
de prix du carburant de votre choix. (par defaut, la liste est classee par prix du
super, du moins cher au plus cher)
</small></td></tr>
<tr><td><br><br></td></tr>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Quelles sont les infos disponibles sur les stations ?</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Chaque station est presentee de la facon suivante:<br><br>
<center><img src=\"""")
        _page.append(str(request.base+'/static/stationGraph.gif'))
        _page.append("""\"</center><br>
</small></td></tr>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Que faire si je vois des informations qui ne sont pas a jour ?</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Vous pouvez mettre a jour un ou plusieurs prix pour une station donnee en cliquant
sur <b>Mettre a jour les prix</b><br>&nbsp;
Vous pouvez mettre a jour les informations (par exemple, si le numero de
telephone change) pour une station donnee en cliquant
sur <b>Mettre a jour les infos</b><br>&nbsp;
<u>Pour rendre service aux autres utilisateurs, essayez de mettre a jour les prix
le plus souvent possible.</u><br><br>
</small></td></tr>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Pourquoi ce site ?</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Nous sommes un groupe de benevoles ayant constate qu'un site similaire aux
Etats-unis avait permis a des millions d'Americains de faire des economies.<br>&nbsp;
Nous avons alors eu l'idee de creer un site similaire en France pour rendre
service aux consomateurs.
</small></td></tr>
</table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def disclaimer(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="70%" align=center>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Mentions legales</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Le site prestation.net est un site entierement gere par des benevoles, dans le but
de rendre service aux consommateurs.<br>&nbsp;
Toutes les informations sur les stations (prix, adresses, horaires, etc ...) sont
mises a jours par les utilisateurs. L'exactitude de ces informations n'est aucunement
garantie.<br>&nbsp;
De meme, les commentaires sur les stations sont donnes par les utilisateurs. Nous n'en
sommes pas responsables et ils ne reflettent en aucun cas notre avis sur les stations.<br>&nbsp;
Les noms et logos de marques utilises sur ce site appartiennent aux marques en question.
Ils sont utilises uniquement afin d'ameliorer la lisibilite et
la presentation graphique du site.<br>&nbsp;
Ce site comporte des liens vers d'autres sites. Nous ne sommes absolument pas
responsable du contenu de ces autres sites.
</small></td></tr>
</table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def contactUs(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="70%" align=center>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Votre avis nous interesse</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
- Vous trouvez que l'idee de ce site est geniale ? nulle ?<br>&nbsp;
- Vous trouvez que le site est bien fait ? pourrait etre nettement mieux ?<br>&nbsp;
- Vous avez des idees pour ameliorer le site ? Vous aimeriez bien d'autres fonctionalites ?<br>&nbsp;
<center><b>Faites le nous savoir en envoyant un mail a<br><br>
  <a href="mailto:commentaire@prestation.net">commentaire@prestation.net</a></b></center>
</small></td></tr>
<tr><td><br><br></td></tr>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Participez au developpement du site</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
- Vous voulez participer au developpement de ce site, que ce soit sur l'aspect programmation,
graphisme/design ou contenu ?<br>&nbsp;
- Vous avez bien note que toutes les personnes travaillant sur ce site sont entierement
benevoles ?<br>&nbsp;
<center><b>Ecrivez-nous a l'adresse suivante en vous presentant et en nous disant sur quelle partie vous voulez
travailler<br><br>
  <a href="mailto:participer@prestation.net">participer@prestation.net</a></b></center>
</small></td></tr>
</table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def manager(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="70%" align=center>
<tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Votre etes gerant d'une station</small></b></td>
</tr><tr><td valign=top><small>&nbsp;
Si vous etes gerant d'une station dans la vie et que vous aimez internet,
vous avez la possibilite de "gerer votre station" sur
notre site.<br>&nbsp;
Cela signifie que les informations sur votre stations seront bloquees dans
notre base de donnees et que vous serez le seul a pouvoir changer les prix
et le reste (grace a un mot de passe).<br>&nbsp;
De plus, nous vous proposons de creer une fiche individuelle pour votre station
avec des informations supplementaires et une photo de votre station. Tout cela vous
est bien sur propose entierement gratuitement.
Pour en savoir plus, cliquez sur
<a href=\"""")
        _page.append(str(self.getPath()+'/manageStation'))
        _page.append("""\">gerer une station</a>
dans le menu de gauche ou envoyez nous un mail a<br><br>
<center><a href="mailto:gerer@prestation.net"><b>gerer@prestation.net</b></a></center>
</small></td></tr>
</table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def wapZone(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="70%" align=center>
<tr><td colspan=3 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Prestation.net enfin disponible sur le WAP !</small></b></td>
</tr><tr><td valign=top><img src=\"""")
        _page.append(str(request.base+'/static/wap1.jpg'))
        _page.append("""\"><br><br></td><td width=10></td>
<td><small>&nbsp;
Si vous possedez un telephone WAP, vous avez desormais la possibilite
de trouver la station la moins chere <b>ou que vous soyez</b>. Pour cela,
il vous suffit de vous connecter sur <b>www.prestation.net/wap</b>
</small></td></tr>
<tr><td colspan=3 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Demonstration du service</small></b></td>
</tr><tr><td valign=top><img src=\"""")
        _page.append(str(request.base+'/static/wap2.jpg'))
        _page.append("""\"></td><td width=10></td>
<td><img src=\"""")
        _page.append(str(request.base+'/static/wap3.jpg'))
        _page.append("""\"></td></tr>
<tr><td colspan=3 align=center><small>&nbsp;
Sur l'ecran d'accueil, vous choisissez d'abord un code postal ou un
numero de departement. Puis vous choisissez le type de carburant que
vous utilisez, puis vous cliquer sur "Lancer la recherche".<br><br>
</small></td></tr>
<tr><td valign=top><img src=\"""")
        _page.append(str(request.base+'/static/wap4.jpg'))
        _page.append("""\"></td><td width=10></td>
<td><img src=\"""")
        _page.append(str(request.base+'/static/wap5.jpg'))
        _page.append("""\"></td></tr>
<tr><td valign=top><img src=\"""")
        _page.append(str(request.base+'/static/wap6.jpg'))
        _page.append("""\"><br><br></td><td width=10></td>
<td><small>&nbsp;Vous visualisez ensuite les 5 stations les
moins cheres pour vos criteres. Vous pouvez cliquer sur une station
pour voir la fiche station.<br><br>
</small></td></tr>
<tr><td valign=top><img src=\"""")
        _page.append(str(request.base+'/static/wap7.jpg'))
        _page.append("""\"></td><td width=10></td>
<td><img src=\"""")
        _page.append(str(request.base+'/static/wap8.jpg'))
        _page.append("""\"></td></tr>
<tr><td colspan=3 align=center><small>&nbsp;
Sur la fiche station, vous obtenez l'adresse de la station, le numero
de telephone, les horaires d'ouverture. Vous obtenez aussi le prix
des carburants dans cette station, ainsi que la date de la derniere
mise a jour de ces prix. Vous avez la possibilite de mettre les prix a jour en
cliquant sur <b>Mettre a jour les prix</b><br><br>
</small></td></tr>
<tr><td valign=top><img src=\"""")
        _page.append(str(request.base+'/static/wap9.jpg'))
        _page.append("""\"></td><td width=10></td>
<td><img src=\"""")
        _page.append(str(request.base+'/static/wap10.jpg'))
        _page.append("""\"></td></tr>
<tr><td colspan=3 align=center><small>&nbsp;
Il vous suffit ensuite d'entrer les nouveaux prix et de cliquer sur
<b>Mettre a jour les prix</b>
</small></td></tr>
</table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
global CheckNew
class CheckNew(HttpAuthenticate):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/checkNew"
        else:
            return "/checkNew"
    def __init__(self):
        self.domain="checkNew"
    def getPasswordForLogin(self, login):
        if login==configFile.get('restrictedArea', 'login'): return configFile.get('restrictedArea', 'password')
    def checkNewValidate(self, **kw):
        return self.checkNewAction('validate', kw)
    def checkNewErase(self, **kw):
        return self.checkNewAction('erase', kw)
    def checkNewAction(self, action, kw):
        res='<html><body>'
        requestTable.deleteItem()
        if kw.has_key('newPrice'):
            newPrice=kw['newPrice']
            if type(newPrice)!=types.ListType: newPrice=[newPrice]
            for item in newPrice:
                res+="%s %s<br>"%(action,item)
                if action=='validate': stationTable.updateItem([item.station], super=item.super, sp95=item.sp95, sp98=item.sp98, gazole=item.gazole, lastUpdateTime=item.lastUpdateTime)
                newPriceTable.deleteItem([item])
        if kw.has_key('newInfo'):
            newInfo=kw['newInfo']
            if type(newInfo)!=types.ListType: newInfo=[newInfo]
            for item in newInfo:
                res+="%s %s<br>"%(action,item)
                if action=='validate': stationTable.updateItem([item.station], name=item.name, zipCode=item.zipCode, city=item.city, address=item.address, phone=item.phone, open=item.open, type=item.type, lastUpdateTime=item.lastUpdateTime)
                newInfoTable.deleteItem([item])
        if kw.has_key('newComment'):
            newComment=kw['newComment']
            if type(newComment)!=types.ListType: newComment=[newComment]
            for item in newComment:
                res+="%s %s<br>"%(action,item)
                if action=='validate': commentTable.updateItem([item], checked=1)
                else: commentTable.deleteItem([item])
        if kw.has_key('newStation'):
            newStation=kw['newStation']
            if type(newStation)!=types.ListType: newStation=[newStation]
            for item in newStation:
                res+="%s %s<br>"%(action,item)
                if action=='validate':
                    stationTable.addItem(name=item.name, zipCode=item.zipCode, city=item.city, address=item.address, phone=item.phone, open=item.open, type=item.type, lastUpdateTime=item.lastUpdateTime, super=item.super, sp95=item.sp95, sp98=item.sp98, gazole=item.gazole)
                newStationTable.deleteItem([item])
        res+="</body></html>"
        return res
    def index(self):
        _page=[]
        if self.getPasswordListForLogin("")!=1:
            _authorized=0
            if request.headerMap.has_key('authorization'):
                _sp=request.headerMap['authorization'].split()
                if _sp and _sp[0].lower()=='basic':
                    _str=base64.decodestring(_sp[1])
                    _login, _password=_str.split(':')
                    _realPasswordList=self.getPasswordListForLogin(_login)
                    if _realPasswordList==1 or _password in _realPasswordList:
                        _authorized=1
                        self.login=_login
            if not _authorized:
                self.login=""
                response.headerMap['status']=401
                response.headerMap['WWW-Authenticate']='Basic realm="%s"'%self.domain
                return self.unauthorized()
        
        _page.append("""<html><body>
<form name=form method=get>
<center><b>Nouveaux prix</b></center>
<table align=center border=1>
<tr><td colspan=2></td>
<th>stationId</th>
<th>super</th>
<th>sp95</th>
<th>sp98</th>
<th>gazole</th>
<th>nom</th>
<th>date</th>
<th>Ville, Zip, Nom</th>
</tr>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(newPriceTable.getItem())-1
        except TypeError: _end=-1
        for newPrice in newPriceTable.getItem():
            _index+=1
            _page.append("""
  <tr><td><INPUT TYPE=CHECKBOX name="newPrice" value='""")
            _page.append(str(newPrice))
            _page.append("""' checked></td>
  <td>Old<br><b>New</b></td>
  <td>""")
            _page.append(str(newPrice.station))
            _page.append("""</td>
  <td>""")
            _page.append(str(newPrice.station.super))
            _page.append("""<br><b>""")
            _page.append(str(newPrice.super))
            _page.append("""</b></td>
  <td>""")
            _page.append(str(newPrice.station.sp95))
            _page.append("""<br><b>""")
            _page.append(str(newPrice.sp95))
            _page.append("""</b></td>
  <td>""")
            _page.append(str(newPrice.station.sp98))
            _page.append("""<br><b>""")
            _page.append(str(newPrice.sp98))
            _page.append("""</b></td>
  <td>""")
            _page.append(str(newPrice.station.gazole))
            _page.append("""<br><b>""")
            _page.append(str(newPrice.gazole))
            _page.append("""</b></td>
  <td>""")
            _page.append(str(newPrice.nameOrEmail))
            _page.append("""</td>
  <td>""")
            _page.append(str(newPrice.lastUpdateTime))
            _page.append("""</td>
  <td>""")
            _page.append(str(newPrice.station.city+','+newPrice.station.zipCode+','+newPrice.station.name))
            _page.append("""</td>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</table><br><br>
<center><b>Nouvelles infos</b></center>
<table align=center border=1>
<tr><td colspan=2></td>
<th>stationId</th>
<th>nom</th>
<th>zip</th>
<th>ville</th>
<th>adresse</th>
<th>phone</th>
<th>ouvert</th>
<th>type</th>
<th>nom</th>
<th>date</th>
</tr>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(newInfoTable.getItem())-1
        except TypeError: _end=-1
        for newInfo in newInfoTable.getItem():
            _index+=1
            _page.append("""
  <tr><td><INPUT TYPE=CHECKBOX name="newInfo" value='""")
            _page.append(str(newInfo))
            _page.append("""' checked></td>
  <td>Old<br><b>New</b></td>
  <td>""")
            _page.append(str(newInfo.station))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.name+'<br><b>'+newInfo.name+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.zipCode+'<br><b>'+newInfo.zipCode+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.city+'<br><b>'+newInfo.city+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.address+'<br><b>'+newInfo.address+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.phone+'<br><b>'+newInfo.phone+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.open+'<br><b>'+newInfo.open+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.station.type+'<br><b>'+newInfo.type+'</b>'))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.nameOrEmail))
            _page.append("""</td>
  <td>""")
            _page.append(str(newInfo.lastUpdateTime))
            _page.append("""</td>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</table><br><br>
<center><b>Nouveaux commentaires</b></center>
<table align=center border=1>
<tr><td></td>
<th>stationId</th>
<th>commentaire</th>
<th>nom</th>
<th>date</th>
<th>Ville, Zip, Nom</th>
</tr>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(commentTable.getItem('item.checked==0'))-1
        except TypeError: _end=-1
        for newComment in commentTable.getItem('item.checked==0'):
            _index+=1
            _page.append("""
  <tr><td><INPUT TYPE=CHECKBOX name="newComment" value='""")
            _page.append(str(newComment))
            _page.append("""' checked></td>
  <td>""")
            _page.append(str(newComment.station))
            _page.append("""</td>
  <td>""")
            _page.append(str(newComment.comment))
            _page.append("""</td>
  <td>""")
            _page.append(str(newComment.nameOrEmail))
            _page.append("""</td>
  <td>""")
            _page.append(str(newComment.lastUpdateTime))
            _page.append("""</td>
  <td>""")
            _page.append(str(newComment.station.city+','+newComment.station.zipCode+','+newComment.station.name))
            _page.append("""</td>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</table><br><br>
<center><b>Nouvelles stations</b></center>
<table align=center border=1>
<tr><td></td>
<th>nom</th>
<th>zip</th>
<th>ville</th>
<th>adresse</th>
<th>phone</th>
<th>ouvert</th>
<th>type</th>
<th>super</th>
<th>sp95</th>
<th>sp98</th>
<th>gazole</th>
<th>nom</th>
<th>date</th>
</tr>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(newStationTable.getItem())-1
        except TypeError: _end=-1
        for newStation in newStationTable.getItem():
            _index+=1
            _page.append("""
  <tr><td><INPUT TYPE=CHECKBOX name="newStation" value='""")
            _page.append(str(newStation))
            _page.append("""' checked></td>
  <td>""")
            _page.append(str(newStation.name))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.zipCode))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.city))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.address))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.phone))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.open))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.type))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.super))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.sp95))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.sp98))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.gazole))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.nameOrEmail))
            _page.append("""</td>
  <td>""")
            _page.append(str(newStation.lastUpdateTime))
            _page.append("""</td>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</table>
<br><br>
<center><b>Nouvelles requetes</b></center>
<table align=center border=1>
<tr>
<th>Requete</th>
<th>Date</th>
</tr>
""")
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(requestTable.getItem())-1
        except TypeError: _end=-1
        for myRequest in requestTable.getItem():
            _index+=1
            _page.append("""
  <tr>
  <td>""")
            _page.append(str(myRequest.name))
            _page.append("""</td>
  <td>""")
            _page.append(str(myRequest.lastUpdateTime))
            _page.append("""</td>
""")
        _index=_index8
        _end=_end8
        _page.append("""
</table>
<br><br>
<center><input type=submit value="Valider les infos"
  onClick="javascript:document.form.action='""")
        _page.append(str(self.getPath()+'/checkNew/checkNewValidate'))
        _page.append("""'">&nbsp;&nbsp;
<input type=submit value="Effacer les infos"
  onClick="javascript:document.form.action='""")
        _page.append(str(self.getPath()+'/checkNew/checkNewErase'))
        _page.append("""'">&nbsp;&nbsp;
</form>
</body></html>
""")
        return "".join(_page)
global PrestationMail
class PrestationMail(Mail):
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/prestationMail"
        else:
            return "/prestationMail"
    def __init__(self):
        self.smtpServer=configFile.get('mail', 'mailServer')
global PrestationFrench
class PrestationFrench(Prestation):
    color1="#FF4040"
    color2="#FF9900"
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/prestationFrench"
        else:
            return "/prestationFrench"
    def getDate(self):
        dayMap={
            '0': 'dimanche',
            '1': 'lundi',
            '2': 'mardi',
            '3': 'mercredi',
            '4': 'jeudi',
            '5': 'vendredi',
            '6': 'samedi'
        }
        monthMap={
            '01': 'janvier',
            '02': 'fevrier',
            '03': 'mars',
            '04': 'avril',
            '05': 'mai',
            '06': 'juin',
            '07': 'juillet',
            '08': 'aout',
            '09': 'septembre',
            '10': 'octobre',
            '11': 'novembre',
            '12': 'decembre'
        }
        tuple=time.gmtime(time.time()+3600) # Local time in France
        dayOfWeekNb=time.strftime("%w", tuple)
        monthNb=time.strftime("%m", tuple)
        dayNb=int(time.strftime("%d", tuple))
        res="%s %s %s"%(dayMap[dayOfWeekNb], dayNb, monthMap[monthNb])
        return res
    def formatDateForDay(self, date):
        year=date[:4]
        month=date[5:7]
        day=date[8:10]
        return day+'/'+month+'/'+year
    def go(self):
        return '<img src="%s/static/goFrench.gif" border=0 align=absmiddle>'%request.base
    def noStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
  <center><B>Aucune station n'a ete trouvee pour ces criteres</b><br><br>
    Essayez d'elargir vos criteres de recherche<br><br>
    <form><input type=button value=Retour onClick="javascript:history.back()"></form>
  </center>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def tooManyStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
  <center><h3>
    Plus de 50 stations correspondent a ces criteres</h3>
    Vous devez preciser votre recherche
    <br><br>
    <form><input type=button value=Retour onClick="javascript:history.back()"></form>
  </center>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def index(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="100%" align=center><tr>
<td width="50%" align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Bienvenue</small></b></td>
<td width=10></td>
<td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Mettez les prix a jour</small></b></td>
</tr><tr><td valign=top align=left><small>&nbsp;
Prestation.net a pour but de permettre aux consommateurs de trouver
la station d'essence la moins chere pres de chez eux.<br>
&nbsp;Le site est
gere entierement par des benevoles, dans un esprit communautaire.
Ce sont les internautes eux-memes qui se rendent service
mutuellement en venant mettre a jour les prix des stations.<br>
&nbsp;Plusieurs services sont disponibles, comme les commentaires sur
les stations, les plans d'acces aux stations, le portail WAP, et
d'autres services sont en preparation, comme la presentation
detaillee des stations services avec photos, horaires d'ouverture,
services disponibles, etc ...
</small></td>
<td width=10></td>
<td valign=top align=left><small>&nbsp;
  Ce site est gere entierement par des benevoles, et nous comptons sur
  <b>vous</b> pour rendre service aux autres utilisateurs en mettant les prix
  a jour.<br>&nbsp;
  <u>Certaines regions ne sont que rarement mises a jour, mais nous
  comptons sur votre aide pour changer cela.</u><br>
  </small><br>
  <table width=100%>
    <tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Donnez votre avis</small></b></td></tr>
    <tr><td valign=top align=left><small>&nbsp;
      Chaque station possede son mini forum ou vous pouvez donner votre avis ou faire
      partager vos remarques sur cette station. Tous les internautes (y compris les
      gerants de la stations) peuvent alors lire vos commentaires.
    </small></td></tr>
  </table>
</td></tr></table>
<br>
<table><tr>
<td colspan=3 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Il y a du nouveau sur prestation.net</small></b></td>
</tr><tr><td colspan=3 valign=top align=left><small>&nbsp;
Tout d'abord, nous tenons a remercier toutes les personnes qui viennent
mettre a jour les prix ou qui ajoutent de nouvelles stations. Meme si
nous sommes encore loin d'avoir tous les prix de toutes les stations
regulierement a jour, nous avons certaines regions ou les informations
que vous nous envoyez sont suffisament nombreuses et regulieres pour
etre pertinentes.<br>&nbsp;
Plusieurs personnes se sont egalement portees volontaires pour "gerer"
une station sur le site. Merci beaucoup.<br>&nbsp;
Nous avons decide de creer une nouvelle rubrique intitulee <b>Station
de la semaine</b>. Le principe est simple: chaque semaine, nous
presenterons en page d'accueil une station avec photo, services,
presentation du personnel, etc...  (messieurs les gerants, contactez
nous si vous souhaitez voir votre station sur notre site - ce service
est bien sur entierement gratuit).<br>&nbsp;
Vous avez ete nombreux a nous feliciter et nous encourager pour ce
site. <b>Merci
pour votre soutien.</b> Nous allons prochainement publier quelques-uns des
mails de felicitations que nous avons recus.
<br><br>
</small></td>
</tr></table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
global PrestationEnglish
class PrestationEnglish(Prestation):
    stringMap={
        "Prestation.net - Mentions legales": "Prestation.net - Disclaimer",
        "loi, essence": "law, gas",
        "Prestation.net - Wap": "Prestation.net - Wap",
        "wap, prix": "wap, price",
        "Prestation.net - Contactez nous": "Prestation.net - Contact us",
        "contact, mail": "contact, mail",
        "Prestation.net - Devenir gerant": "Prestation.net - Become a manager",
        "gerer, gerant": "manager",
        "Prestation.net - Premiere visite": "Prestation.net - First visit",
        "premier, visite": "first, visite",
        "Prestation.net - Gerer une station": "Prestation.net - Manage a gas station",
        "gerer, station": "manage, station",
        "Prestation.net - Ajouter une station": "Prestation.net - Add a new gas station",
        "ajouter, station": "add, station",
        "Prestation.net - Chercher une station": "Prestation.net - Find a gas station",
        "chercher, recherche": "find, search",
        "Trouvez la station d'essence la moins chere pres de chez vous": "Find the cheapest gas station near you",
        "essence, super, gasole, gazoil, sans plomb, 95, 98, prix, carburant, pompe, station, pas cher, pas chere": "gas, price, station",
        "Votre demande a ete envoyee": "Your request has been sent",
        "Nous vous contacterons d'ici 24 a 72 heures": "We will contact you within 24 hours",
        "Nom": "Name",
        "Email": "Email:",
        "Station": "Gas station",
        "Stations": "Gas stations",
        "Raison": "Reason",
        "Autre raison": "Other reason",
        "Mot de passe": "Password",
        "Vous devez entrer vos commentaires": "You must enter your comment",
        "Entrez vos commentaires sur la station": "Please enter your comment on the gas station",
        "Commentaire": "Comment",
        "Votre nom ou e-mail (facultatif)": "Your name or e-mail (optional)",
        "Valider": "OK",
        "Annuler": "Cancel",
        "Le code postal n'est pas valide": "Non valid zipCode",
        "Le mot clef doit avoir au moins 3 caracteres": "Keyword is not long enough",
        "Le departement n'est pas valide": "Non valid department code",
        "Recherche rapide": "Fast search",
        "Code postal": "Zip code",
        "Departement": "Department",
        "Mot clef": "Keyword",
        "Partenaire": "Partner",
        "Liens": "Links",
        "Accueil": "Home",
        "Premiere visite": "First visit",
        "Vous etes gerant": "Manager zone",
        "Ecrivez-nous": "Contact us",
        "Recherche avancee": "Advanced search",
        "Ajouter une station": "Add a new station",
        "Gerer une station": "Manage a station",
        "Retrouvez les meilleurs offres des magasins pres de chez vous": "Find the best deals in stores near you",
        "Vous cherchez": "You want",
        "Quoi": "What",
        "Ou": "Where",
        "Rayon": "Radius",
        "Rechercher": "Find",
        "Mentions legales": "Disclaimer",
    }
    color1="#0060CE"
    color2="#BDCEDE"
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/prestationEnglish"
        else:
            return "/prestationEnglish"
    def getDate(self):
        tuple=time.gmtime(time.time())
        res=time.strftime("%Y/%m/%d", tuple)
        return res
    def formatDateForDay(self, date):
        year=date[:4]
        month=date[5:7]
        day=date[8:10]
        return year+'/'+month+'/'+day
    def go(self):
        return '<img src="%s/static/goEnglish.gif" border=0 align=absmiddle>'%request.base
    def noStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
  <center><B>No gas station was found for these criteria</b><br><br>
    Try using less restrictive criteria<br><br>
    <form><input type=button value=Back onClick="javascript:history.back()"></form>
  </center>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def tooManyStation(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
  <center><h3>
    More than 50 gas stations match these criteria</h3>
    Please narrow your search
    <br><br>
    <form><input type=button value=Back onClick="javascript:history.back()"></form>
  </center>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
    def index(self):
        _page=[]
        _page.append(str(self.header()))
        _page.append("""
<table width="100%" align=center><tr>
<td width="50%" align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Welcome</small></b></td>
<td width=10></td>
<td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Update prices</small></b></td>
</tr><tr><td valign=top align=left><small>&nbsp;
Prestation.net's goal is to allow consumers to find the cheapest gas station near them.<br>
&nbsp;This website is a non-profit website based on a community spirit.
Users help each other by updating prices for gas stations.<br>
&nbsp;Several services are already available. Among them are comments, maps, wap, ...
Other services are coming up soon. Among them are gas stations photos, opening hours and available
services.
</small></td>
<td width=10></td>
<td valign=top align=left><small>&nbsp;
  This website is a non-profit website, and we're counting on <b>you</b>
  to help other users by updating gas prices.<br>
  &nbsp;<u>For some regions, the prices are only rarely updated. But we are counting
  on your help to change that.</u><br>
  </small><br>
  <table width=100%>
    <tr><td align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>Tell us what you think</small></b></td></tr>
    <tr><td valign=top align=left><small>&nbsp;
      For each gas station, you can post messages to let other people know what you think
      about this station. Who knows, maybe the manager of the station will hear you ...
    </small></td></tr>
  </table>
</td></tr></table>
<br>
<table><tr>
<td colspan=3 align=center bgcolor=\"""")
        _page.append(str(self.color2))
        _page.append("""\"><b><small>English version's not finished yet</small></b></td>
</tr><tr><td colspan=3 valign=top align=left><small>&nbsp;
As you will notice, some parts of the website haven't been translated into English yet.
We'll try to do it when we have time.
<br><br>
</small></td>
</tr></table>
""")
        _page.append(str(self.footer()))
        _page.append("""
""")
        return "".join(_page)
global MySqlAspect
class MySqlAspect:
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/mySqlAspect"
        else:
            return "/mySqlAspect"
global ThirdParty
class ThirdParty(MySqlAspect):
    title = 'Third-Party Module'
    searchTitle = 'Search a module'
    foundTitle = 'Search results'
    browseTitle = 'Browse module catalog'
    createTitle = 'Create a new module'
    moduleTitle = 'Module presentation'
    firstStableReleaseTitle = 'Latest stable release: '
    firstUnstableReleaseTitle = 'Latest development release: '
    stableReleaseTitle = 'Older stable release: '
    unstableReleaseTitle = 'Older development release: '
    addReleaseTitle = 'Add a release'
    changeModuleTitle = 'Modify this module'
    deleteModuleTitle = 'Delete this module'
    changeReleaseTitle = 'Modify this release'
    deleteReleaseTitle = 'Delete this release'
    resultTitle = 'Query result'
    wrongForm = 'Wrong form values'
    wrongEmail = '<font color="red">Wrong email</font>'
    wrongUnix = '<font color="red">Wrong name</font>'
    wrongBoth = '<font color="red">Upload and URL fields both filled</font>'
    wrongTarball = '<font color="red">Not a Tarball ( \'*.tgz\' or \'*.tar.gz\' )</font>'
    wrongNotFilled = '<font color="red">You must fill this field</font>'
    notifyReceiver = 'rdelon@netcourrier.com'
    notifyBcc = ''
    notifyCreate = 'New Module Query'
    notifyAddRelease = 'New Release Query'
    notifyChange = 'Change Module Query'
    notifyChangeRelease = 'Change Release Query'
    notifyDelete = 'Deletion Module Query'
    notifyDeleteRelease = 'Deletion Release Query'
    checkValue = {'stable': 'y'}
    evenColor = '#FFCCCC'
    headerColor = '#BD1E26'
    oddColor = 'white'
    def getPath(self, includeRequestBase = 1):
        if includeRequestBase:
            return request.base + "/thirdParty"
        else:
            return "/thirdParty"
    def createTables(self):
        try:
            sql.query("""
                CREATE TABLE Module(
                    id            INT(9)         AUTO_INCREMENT PRIMARY KEY,
                    name        VARCHAR(50)     NOT NULL,
                    email        VARCHAR(50)     NOT NULL,
                    unix        VARCHAR(50)     NOT NULL,
                    generic        VARCHAR(50)     NOT NULL,
                    description VARCHAR(100) NOT NULL,
                    content        TEXT,
                    deleted        CHAR(1) DEFAULT 'N'
                )
            """)
            sql.query("""
                CREATE TABLE Release(
                    id          INT(9) AUTO_INCREMENT PRIMARY KEY,
                    module      INT(9) NOT NULL REFERENCES Module(id),
                    version      VARCHAR(50),
                    changelog TEXT,
                    download  VARCHAR(100),
                    tarball      VARCHAR(100),
                    date      TIMESTAMP(14),
                    stable      CHAR(1),
                    deleted      CHAR(1) DEFAULT 'N',
                    hit       INT(9) DEFAULT 0
                )
            """)
        except 'TBC': return 'FAILURE'
        return 'SUCCESS'
    def getValue(self, returnValue, name):
        if returnValue: return request.paramMap[name]
        return ''
    def getChecked(self, returnValue, name, map):
        if returnValue and map[name]==self.checkValue[name]: return 'checked'
        return ''
    def getModuleList(self):
        return sql.query("""
            SELECT *
            FROM Module
            WHERE deleted='N'
            ORDER BY unix
        """)
    def getReleaseList(self, modId):
        return sql.query("""
            SELECT *
            FROM Release
            WHERE module=%s
            AND deleted='N'
            ORDER BY date DESC
        """ %(modId))
    def getLastRelease(self, modId):
        last = sql.query("""
            SELECT *
            FROM Release
            WHERE module=%s
            AND deleted='N'
            ORDER BY date DESC
        """ %(modId))
        if last == None or len(last) < 1: return None
        return last[0]
    def getModuleTuple(self, modId):
        return sql.query("""
            SELECT *
            FROM Module
            WHERE id=%s
        """ %(modId))[0]
    def getReleaseTuple(self, relId):
        return sql.query("""
            SELECT *
            FROM Release
            WHERE id=%s
        """ %(relId))[0]
    def incHit(self, relId):
        sql.query("""
            UPDATE Release
            SET hit=hit+1
            WHERE id=%s
        """ %(relId))
    def isOdd(self, n):
        return n % 2
    def hex(self, bin):
        buf = []
        for i in map(hex, map(ord, bin)):
            buf.append(i[-2:])
        return string.join(buf, '').replace('x', '0')
    def index(self, result=0, createTables=0):
        if createTables: self.createTables()
        page = root.header(self.title)
        page += '<td width="80%" valign="top" align="center">'
        if result:
            page += self.resultMask()
        page += root.square("Bakery", self.bakeryContent())
        page += '<br />'
        page += root.square(self.browseTitle, self.browseMask(self.getModuleList()))
        page += '<br />'
        page += """<div align=right><a class=moduleLink href="/thirdParty/addModule"><small>Add a new module</small></a></div>"""
        page += '</td>'
        page += root.footer()
        return page
    def addModule(self):
        page = root.header(self.title)
        page += '<td width="80%" valign="top" align="center">'
        page += root.square(self.createTitle, self.createMask())
        page += '</td>'
        page += root.footer()
        return page
    def create(self, name='', email='', unix='', generic='', description=''):
        msgName = ''
        msgEmail = ''
        msgUnix = ''
        msgGeneric = ''
        msgDescription = ''
        if name=='': msgName=self.wrongNotFilled
        if generic=='': msgGeneric=self.wrongNotFilled
        if description=='': msgDescription=self.wrongNotFilled
        if email=='': msgEmail=self.wrongNotFilled
        else:
            try:
                if email.find(' ') != -1 or email.find("'") != -1: raise Error
                a,b=email.split('@')
                c,d=b.split('.')
            except: msgMail = self.wrongEmail
        if unix=='': msgUnix=self.wrongNotFilled
        elif unix.find(' ') != -1 or unix.find('\t') != -1 or unix.find('\n') != -1 or unix.find("'") != -1:
            msgUnix = self.wrongUnix
        if msgName or msgEmail or msgUnix or msgGeneric or msgDescription:
            page = root.header(self.title) + '<td width="80%" valign="top" align="center">'
            page += root.square(self.wrongForm, self.createMask(1, msgName, msgEmail, msgUnix, msgGeneric, msgDescription))
            page += '</td>' + root.footer()
            return page
        try:
            dname = name.replace('\\', '\\\\').replace("'", "\\'")
            dgeneric = generic.replace('\\', '\\\\').replace("'", "\\'")
            ddescription = description.replace('\\', '\\\\').replace("'", "\\'")
            sql.query("""
                INSERT INTO Module
                VALUES(NULL, '%s', '%s', '%s', '%s', '%s', NULL, 'N')
            """ %(dname, email, unix, dgeneric, ddescription))
            cherryPyMail.sendMail("third_party@cherrypy.org", self.notifyReceiver, self.notifyBcc, "text/plain", "%s (%s)" %(self.notifyCreate, unix),
                "NAME=%s\nEMAIL=%s\nUNIX=%s\nGENERIC=%s\nDESCRIPTION=%s\n\n%s\n"
                                  %(name, email, unix, generic, description, self.getNotifyMessage())                                                  )
        except:
                    return 'FAILURE - Please reload previous page'
        response.headerMap['status']=302
        response.headerMap['location']=request.base+'/thirdParty/index?result=1'
        return 'SUCCESS'
    def search(self, keywords):
        page = root.header(self.title) + '<td width="80%" valign="top" align="center">'
        page += root.square(self.foundTitle, self.foundMask())
        page += '</td>' + root.footer()
        return page
    def viewModule(self, id, result=0):
        page = root.header(self.title) + '<td width="80%" valign="top" align="center">'
        if result:
            page += self.resultMask()
        page += root.square(self.moduleTitle, self.moduleMask(self.getModuleTuple(id)))
        releaseList = self.getReleaseList(id)
        firstStable = 1
        firstUnstable = 1
        for rel in releaseList:
            print "rel:", rel
            rel2 = rel[2]
            if rel2 == None: rel2 = ''
            page += '<br />'
            if rel[7]=='y':
                if firstStable:
                    page += root.square(self.firstStableReleaseTitle+rel2, self.releaseMask(rel))
                    firstStable = 0
                else:
                    page += root.square(self.stableReleaseTitle+rel2, self.releaseMask(rel))
            else :
                if firstUnstable:
                    page += root.square(self.firstUnstableReleaseTitle+rel2, self.releaseMask(rel))
                    firstUnstable = 0
                else:
                    page += root.square(self.unstableReleaseTitle+rel2, self.releaseMask(rel))
        page += '<br />'
        page += """<div align=right><a class=moduleLink href="/thirdParty/addNewRelease?id=%s"><small>Add a new release</small></a></div>""" % id
        return page
    def addNewRelease(self, id):
        page = root.header(self.title)
        page += '<td width="80%" valign="top" align="center">'
        page += root.square(self.addReleaseTitle, self.addReleaseMask(id))
        page += '</td>'
        page += root.footer()
        return page
    def download(self, id):
        mod = self.getReleaseTuple(id)[1]
        filename = "%s-%s.tgz" %(self.getModuleTuple(mod)[3],self.getReleaseTuple(id)[2])
        response.headerMap['content-type'] = 'application/x-gzip-compressed'
        response.headerMap['content-disposition'] = 'inline; filename="%s"' %filename
        f = open(self.getReleaseTuple(id)[5], 'rb')
        buffer = f.read()
        f.close()
        self.incHit(id)
        return buffer
    def goTo(self, id, url):
        self.incHit(id)
        response.headerMap['status']=302
        response.headerMap['location']=url
        return "FORWARDING"
    def addRelease(self, module, version, changelog, tarball=None, download='', stable='no'):
        msgTarball = ''
        msgDownload = ''
        mailTarball = 'None'
        tarball = request.paramMap.get('tarball', None)
        if tarball!=None and tarball!='':
            mailTarball = ' (%.2f kB)' %((len(tarball)/1024.0))
            if download != '':
                msgTarball = self.wrongBoth
                msgDownload = self.wrongBoth
            if request.filenameMap['tarball'][-4:]!='.tgz' and request.filenameMap['tarball'][-7:]!='.tar.gz':
                msgTarball = self.wrongTarball
        if msgTarball or msgDownload:
            page = root.header(self.title) + '<td width="80%" valign="top" align="center">'
            page += root.square(self.wrongForm, self.addReleaseMask(module, 1, '', msgTarball, msgDownload))
            page += '</td>' + root.footer()
            return page
        dbversion = "NULL"
        dbchangelog = "NULL"
        dbdownload = "NULL"
        dbtarball = "NULL"
        if version != None and version != '': dbversion = "'"+version.replace('\\', '\\\\').replace("'", "\\'")+"'"
        if changelog != None and changelog != '': dbchangelog = "'"+changelog.replace('\\', '\\\\').replace("'", "\\'")+"'"
        if download != None and download != '': dbdownload = "'"+download.replace('\\', '\\\\').replace("'", "\\'")+"'"
        unixname = self.getModuleTuple(module)[3]
        if tarball != None and tarball != '':
            filename = os.path.join("third_party", "%s%s.tgz" %(unixname, time.strftime('%Y%m%d%H%M%S')))
            f = open(filename, 'wb')
            f.write(tarball)
            f.close()
            dbtarball = "'%s'" %filename.replace('\\', '\\\\')
            mailTarball = filename + mailTarball
        try:
            sql.query("""
                INSERT INTO Release
                VALUES(NULL, '%s', %s, %s, %s, %s, NULL, '%s', 'N', 0)
            """ %(module, dbversion, dbchangelog, dbdownload, dbtarball, stable))
            cherryPyMail.sendMail("third_party@cherrypy.org", self.notifyReceiver, self.notifyBcc, "text/plain", "%s (%s)" %(self.notifyAddRelease,     unixname),
                "MODULE=%s\nVERSION=%s\nSTABLE?=%s\nTARBALL=%s\nDOWNLOAD=%s\nCHANGELOG=\n%s\n\n%s\n"
                %(self.getModuleTuple(module)[1], version, stable, mailTarball, download, changelog, self.getNotifyMessage())           )
        except: return 'FAILURE - Please reload previous page'
        response.headerMap['status']=302
        response.headerMap['location']=request.base+'/thirdParty/viewModule?id=%s&result=1' %module
        return 'SUCCESS'
    def changeContent(self, id):
        page = root.header(self.title, robots='none') + '<td width="80%" valign="top" align="center">'
        page += root.square(self.changeModuleTitle, self.changeModuleMask(self.getModuleTuple(id)))
        page += '<br />'
        page += root.square(self.deleteModuleTitle, self.deleteModuleMask(id))
        page += '</td>' + root.footer()
        return page
    def changeLog(self, id):
        page = root.header(self.title, robots='none') + '<td width="80%" valign="top" align="center">'
        page += root.square(self.changeReleaseTitle, self.changeReleaseMask(self.getReleaseTuple(id)))
        page += '<br />'
        page += root.square(self.deleteReleaseTitle, self.deleteReleaseMask(id))
        page += '</td>' + root.footer()
        return page
    def changeModule(self, module, name, email, unix, generic, description, content=''):
        msgEmail = ''
        msgUnix = ''
        try:
            if email.find(' ') != -1 or email.find("'") != -1: raise Error
            a,b=email.split('@')
            c,d=b.split('.')
        except: msgMail = self.wrongEmail
        if unix.find(' ') != -1 or unix.find('\t') != -1 or unix.find('\n') != -1 or unix.find("'") != -1:
            msgUnix = self.wrongUnix
        if msgEmail or msgUnix:
            page = root.header(self.title) + '<td width="80%" valign="top" align="center">'
            page += root.square(self.wrongForm, self.changeModuleMask(msgEmail=msgEmail, msgUnix=msgUnix))
            page += '</td>' + root.footer()
            return page
        try:
            dname = name.replace('\\', '\\\\').replace("'", "\\'")
            dgeneric = generic.replace('\\', '\\\\').replace("'", "\\'")
            ddescription = description.replace('\\', '\\\\').replace("'", "\\'")
            if content != None and content != '':
                dbcontent = "'"+content.replace('\\', '\\\\').replace("'", "\\'")+"'"
            else: dbcontent = "NULL"
            preModule, preName, preEmail, preUnix, preGeneric, preDescription, preContent, preDeleted = self.getModuleTuple(module)
            sql.query("""
                REPLACE INTO Module
                VALUES('%s', '%s', '%s', '%s', '%s', '%s', %s, 'N')
            """ %(module, dname, email, unix, dgeneric, ddescription, dbcontent))
            if unix == preUnix: modname = "(%s)" %unix
            else: modname = "(%s) -> (%s)" %(preUnix, unix)
            cherryPyMail.sendMail("third_party@cherrypy.org", self.notifyReceiver, self.notifyBcc, "text/plain", "%s %s" %(self.notifyChange, modname),
                """NAME=%s\nEMAIL=%s\nUNIX=%s\nGENERIC=%s\nDESCRIPTION=%s\nCONTENT=\n%s\n---------------\nBEFORE CHANGE :\n---------------\nNAME=%s\nEMAIL=%s\nUNIX=%s\nGENERIC=%s\nDESCRIPTION=%s\nCONTENT=\n%s\n\n\n%s"""
                                  %(name, email, unix, generic, description, content, preName, preEmail, preUnix, preGeneric, preDescription, preContent, self.getNotifyMessage()))
        except:
            return 'FAILURE - Please reload previous page'
        response.headerMap['status']=302
        response.headerMap['location']=request.base+'/thirdParty/viewModule?id=%s&result=1' %module
        return 'SUCCESS'
    def changeRelease(self, release, module, version, changelog, tarball=None, download='', stable='no'):
        msgTarball = ''
        msgDownload = ''
        mailTarball = 'None'
        tarball = request.paramMap.get('tarball', None)
        if tarball!=None and tarball!='':
            mailTarball = ' (%.2f kB)' %((len(tarball)/1024.0))
            if download != '':
                msgTarball = self.wrongBoth
                msgDownload = self.wrongBoth
            if request.filenameMap['tarball'][-4:]!='.tgz' and request.filenameMap['tarball'][-7:]!='.tar.gz':
                msgTarball = self.wrongTarball
        if msgTarball or msgDownload:
            page = root.header(self.title) + '<td width="80%" valign="top" align="center">'
            page += root.square(self.wrongForm, self.changeReleaseMask(msgTarball=msgTarball, msgDownload=msgDownload))
            page += '</td>' + root.footer()
            return page
        dbversion = "NULL"
        dbchangelog = "NULL"
        dbdownload = "NULL"
        dbtarball = "NULL"
        if version != None and version != '': dbversion = "'"+version.replace('\\', '\\\\').replace("'", "\\'")+"'"
        if changelog != None and changelog != '': dbchangelog = "'"+changelog.replace('\\', '\\\\').replace("'", "\\'")+"'"
        if download != None and download != '': dbdownload = "'"+download.replace('\\', '\\\\').replace("'", "\\'")+"'"
        unixname = self.getModuleTuple(module)[3]
        if tarball != None and tarball != '':
            filename = os.path.join("third_party", "%s%s.tgz" %(unixname, time.strftime('%Y%m%d%H%M%S')))
            f = open(filename, 'wb')
            f.write(tarball)
            f.close()
            dbtarball = "'%s'" %filename.replace('\\', '\\\\')
            mailTarball = filename + mailTarball
        preRelease, preModule, preVersion, preChangelog, preDownload, preTarball, preDate, preStable, preDeleted, preHit = self.getReleaseTuple(release)
        if (tarball in (None, '') and download in (None, '')):
            if preTarball != None:
                dbtarball = "'%s'" %preTarball.replace('\\', '\\\\')
                mailTarball = preTarball
        try:
            sql.query("""
                REPLACE INTO Release
                VALUES(%s, %s, %s, %s, %s, %s, '%s', '%s', 'N', %s)
            """ %(release, module, dbversion, dbchangelog, dbdownload, dbtarball, self.getReleaseTuple(release)[6],stable,self.getReleaseTuple(release)[9]))
            cherryPyMail.sendMail("third_party@cherrypy.org", self.notifyReceiver, self.notifyBcc, "text/plain", "%s (%s)" %(self.notifyChangeRelease, unixname),
                "MODULE=%s\nVERSION=%s\nSTABLE?=%s\nTARBALL=%s\nDOWNLOAD=%s\nCHANGELOG=\n%s\n---------------\nBEFORE CHANGE :\n---------------\nVERSION=%s\nSTABLE?=%s\nTARBALL=%s\nDOWNLOAD=%s\nCHANGELOG=\n%s\n\n%s"
                %(self.getModuleTuple(module)[1], version, stable, mailTarball, download, changelog, preVersion, preStable, preTarball, preDownload, preChangelog, self.getNotifyMessage()))
        except: return 'FAILURE - Please reload previous page'
        response.headerMap['status']=302
        response.headerMap['location']=request.base+'/thirdParty/viewModule?id=%s&result=1' %module
        return 'SUCCESS'
    def deleteModule(self, module, why) :
        try:
            mod = self.getModuleTuple(module)
            sql.query("""
                UPDATE Module
                                SET deleted='Y'
                WHERE id=%s
            """ %(module))
            cherryPyMail.sendMail("third_party@cherrypy.org", self.notifyReceiver, self.notifyBcc, "text/plain", "%s (%s)" %(self.notifyDelete, mod[3]),
                "NAME=%s\nEMAIL=%s\nUNIX=%s\nGENERIC=%s\nDESCRIPTION=%s\nWHY?=\n%s\n\n%s\n"
                %(mod[1], mod[2], mod[3], mod[4], mod[5], why, self.getNotifyMessage())                                                    )
        except: return 'FAILURE - Please reload previous page'
        response.headerMap['status']=302
        response.headerMap['location']=request.base+'/thirdParty/index?result=1'
        return 'SUCCESS'
    def deleteRelease(self, release, why) :
        rel = self.getReleaseTuple(release)
        mod = self.getModuleTuple(rel[1])
        try:
            sql.query("""
                UPDATE Release
                                SET deleted='Y'
                WHERE id=%s
            """ %(release))
            cherryPyMail.sendMail("third_party@cherrypy.org", self.notifyReceiver, self.notifyBcc, "text/plain", "%s (%s)" %(self.notifyDeleteRelease, mod[3]),
                "MODULE=%s\nVERSION=%s\nTARBALL=%s\nDOWNLOAD=%s\nCHANGELOG=\n%s\nWHY?=\n%s\n\n%s\n"
                %(mod[1], rel[2], rel[5], rel[4], rel[3], why, self.getNotifyMessage())                     )
        except: return 'FAILURE - Please reload previous page'
        response.headerMap['status']=302
        response.headerMap['location']=request.base+'/thirdParty/viewModule?id=%s&result=1' %rel[1]
        return 'SUCCESS'
    def bakeryContent(self):
        _page=[]
        _page.append("""Welcome to the bakery :-)<br><br>
The bakery is a repository of third-party modules for CherryPy.
It is still very young so it doesn't have many modules yet.<br><br>
If you're developing a website and are looking for a given functionality you can check here to
see if there is already a module for it.<br><br>
On the other hand, if you've developed a module that you think could be useful to other people
feel free to upload it here.
""")
        return "".join(_page)
    def getNotifyMessage(self) :
        _page=[]
        _page.append("""Please check this query by going to """)
        _page.append(str(request.base))
        _page.append("""/thirdParty/index
""")
        return "".join(_page)
    def searchMask(self) :
        _page=[]
        _page.append("""<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/search'))
        _page.append("""\">
  Enter some keywords :
  <input name="keywords" type="text" value="" size="50">
  <input type="submit" value="        Find      ">
</form>
""")
        return "".join(_page)
    def browseMask(self, moduleList) :
        _page=[]
        _page.append("""<table cellpadding="3" width="100%">
    <tr>
      <th align="center" class="moduleTitle" bgcolor=\"""")
        _page.append(str(self.headerColor))
        _page.append("""\">Module name</th>
      <th align="center" class="moduleTitle" bgcolor=\"""")
        _page.append(str(self.headerColor))
        _page.append("""\">Description</th>
      <th align="center" class="moduleTitle" bgcolor=\"""")
        _page.append(str(self.headerColor))
        _page.append("""\">Last version</th>
      <th align="center" class="moduleTitle" bgcolor=\"""")
        _page.append(str(self.headerColor))
        _page.append("""\">Maintainer</th>
      <th align="center" class="moduleTitle" bgcolor=\"""")
        _page.append(str(self.headerColor))
        _page.append("""\">Modification date</th>
    </tr>
  """)
        _index8=locals().get("_index", -1)
        _end8=locals().get("_end", -1)
        _index=-1
        try: _end=len(moduleList)-1
        except TypeError: _end=-1
        for mod in moduleList:
            _index+=1
            _page.append("""
    """)
            if self.isOdd(_index): color = self.oddColor
            else: color = self.evenColor
            lastRel = self.getLastRelease(mod[0])
            if lastRel == None:
                version = None
                date = None
            else:
                version = lastRel[2]
                date = lastRel[6]
            _page.append("""
    <tr>
      <td class="moduleText" align="center" bgcolor=\"""")
            _page.append(str(color))
            _page.append("""\">
        <a href=\"""")
            _page.append(str(request.base+'/thirdParty/viewModule?id=%s' %mod[0]))
            _page.append("""\" class="moduleLink">""")
            _page.append(str(mod[4]))
            _page.append("""</a>
      </td>
      <td class="moduleText" align="center" bgcolor=\"""")
            _page.append(str(color))
            _page.append("""\">""")
            _page.append(str(mod[5]))
            _page.append("""</td>
      <td class="moduleText" align="center" bgcolor=\"""")
            _page.append(str(color))
            _page.append("""\">""")
            _page.append(str(version))
            _page.append("""</td>
      <td class="moduleText" align="center" bgcolor=\"""")
            _page.append(str(color))
            _page.append("""\">
        """)
            _page.append(str(mod[1]))
            _page.append(""" (""")
            _page.append(str(mod[2].replace('@', ' at ')))
            _page.append(""")
      </td>
      <td class="moduleText" align="center" bgcolor=\"""")
            _page.append(str(color))
            _page.append("""\">""")
            _page.append(str(date))
            _page.append("""</td>
    </tr>
  """)
        _index=_index8
        _end=_end8
        _page.append("""
</table>
""")
        return "".join(_page)
    def createMask(self, value=0, msgName="For instance, 'Remi Delon'", msgEmail="For instance, 'remi@cherrypy.org'", msgUnix="For instance, 'cherrypy'", msgGeneric="For instance, 'CherryPy'", msgDescription="For instance, 'Python application server'") :
        _page=[]
        _page.append("""<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/create'))
        _page.append("""\">
  <table>
    <tr>
      <td valign="top" class="moduleText">Author name :</td>
      <td><input name="name" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'name')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgName))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">E-mail address :</td>
      <td><input name="email" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'email')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgEmail))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">UNIX-friendly module name :</td>
      <td><input name="unix" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'unix')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgUnix))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Generic module name :</td>
      <td><input name="generic" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'generic')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgGeneric))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Short module description :</td>
      <td><input name="description" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'description')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgDescription))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top"><input type="submit" value="         Submit         " size="25"></td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </table>
</form>
""")
        return "".join(_page)
    def foundMask(self) :
        _page=[]
        _page.append("""This feature is not yet implemented. Sorry.
""")
        return "".join(_page)
    def moduleMask(self, mod) :
        _page=[]
        print 'tuple:', mod
        _page.append("""
<table width="100%" cellpadding="0" border="0" cellspacing="0">
  <tr>
    <td class="moduleText">
      <p>""")
        _page.append(str(mod[6]))
        _page.append("""</p>
    </td>
  </tr>
    <td align="right">
      <hr />
      <a href=\"""")
        _page.append(str(request.base+'/thirdParty/changeContent?id=%s' %mod[0]))
        _page.append("""\" class="moduleLink"><small>Modify / Delete</small></a>
    </td>
  </tr>
</table>
""")
        return "".join(_page)
    def releaseMask(self, rel) :
        _page=[]
        _page.append("""<table width="100%" cellpadding="0" border="0" cellspacing="0">
  <tr>
    <td class="moduleText">
      """)
        if rel[5] != None:
            link = request.base+'/thirdParty/download?id=%s' %rel[0]
        elif rel[4] != None:
            link = request.base+'/thirdParty/goTo?id=%s&url=%s' %(rel[0],rel[4])
        else:
            link = ""
        _page.append("""
      """)
        if link!='':
            _page.append("""<a href=\"""")
            _page.append(str(link))
            _page.append("""\" class="moduleLink">Download it !</a> (""")
            _page.append(str(rel[9]))
            _page.append(""" hit""")
            if rel[9]>1: _page.append('s')
            _page.append(""")""")
        else:
            _page.append("""<em>No download available</em>""")
        _page.append("""
      <hr />
      <p>""")
        _page.append(str(rel[3]))
        _page.append("""</p>
    </td>
  </tr>
    <td align="right">
      <hr />
      <a href=\"""")
        _page.append(str(request.base+'/thirdParty/changeLog?id=%s' %rel[0]))
        _page.append("""\" class="moduleLink"><small>Modify / Delete</small></a>
    </td>
  </tr>
</table>
""")
        return "".join(_page)
    def addReleaseMask(self, modId, value=0, msgVersion="For instance, '0.9-gamma'", msgTarball="Must end by '.tgz' or '.tar.gz'", msgDownload="Effective if no upload ONLY", msgChangelog="Enter changes since last release<br />HTML can be used") :
        _page=[]
        _page.append("""<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/addRelease'))
        _page.append("""\"    enctype="multipart/form-data">
  <input name="module" type="hidden" value=\"""")
        _page.append(str(modId))
        _page.append("""\">
  <table>
    <tr>
      <td valign="top" class="moduleText">Version number :</td>
      <td><input name="version" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'version')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgVersion))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Stable version ?</td>
      <td><input name="stable" type="checkbox" """)
        _page.append(str(self.getChecked(value, 'version', request.paramMap)))
        _page.append(""" value=\"""")
        _page.append(str(self.checkValue['stable']))
        _page.append("""\" size="50"></td>
      <td>&nbsp</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Upload TARBALL :</td>
      <td><input name="tarball" type="file" size="34"></td>
      <td class="moduleText">""")
        _page.append(str(msgTarball))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Download URL :</td>
      <td><input name="download" type="text" value=\"""")
        _page.append(str(self.getValue(value, 'download')))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgDownload))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">ChangeLog :</td>
      <td><textarea name="changelog" cols="38" rows="10">""")
        _page.append(str(self.getValue(value, 'changelog')))
        _page.append("""</textarea></td>
      <td class="moduleText" valign="top">""")
        _page.append(str(msgChangelog))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top"><input type="submit" value="         Submit         " size="25"></td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </table>
</form>
""")
        return "".join(_page)
    def changeModuleMask(self, mod=[], msgName="", msgEmail="", msgUnix="", msgGeneric="", msgDescription="", msgContent="(HTML can be used)") :
        _page=[]
        if mod != []:
            val = {}
            val['module'], val['name'], val['email'], val['unix'], val['generic'], val['description'], val['content'], val['deleted'] = mod
        else:
            val = request.paramMap
        _page.append("""
<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/changeModule'))
        _page.append("""\">
  <input name="module" type="hidden" value=\"""")
        _page.append(str(val['module']))
        _page.append("""\">
  <table>
    <tr>
      <td valign="top" class="moduleText">Maintainer name :</td>
      <td><input name="name" type="text" value=\"""")
        _page.append(str(val['name']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgName))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">E-mail address :</td>
      <td><input name="email" type="text" value=\"""")
        _page.append(str(val['email']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgEmail))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">UNIX-friendly module name :</td>
      <td><input name="unix" type="text" value=\"""")
        _page.append(str(val['unix']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgUnix))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Generic module name :</td>
      <td><input name="generic" type="text" value=\"""")
        _page.append(str(val['generic']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgGeneric))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Short module description :</td>
      <td><input name="description" type="text" value=\"""")
        _page.append(str(val['description']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgDescription))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Module presentation :<br />""")
        _page.append(str(msgContent))
        _page.append("""</td>
      <td colspan="2"><textarea name="content" cols="69" rows="20">""")
        _page.append(str(val['content']))
        _page.append("""</textarea></td>
    </tr>
    <tr>
    <tr>
      <td valign="top"><input type="submit" value="         Submit         " size="25"></td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </table>
</form>
""")
        return "".join(_page)
    def changeReleaseMask(self, rel=[], msgVersion="", msgTarball="REMEMBER: '*.tgz' or '*.tar.gz'", msgDownload="If no upload ONLY", msgChangelog="(HTML can be used)") :
        _page=[]
        if rel != []:
            val = {}
            val['release'], val['module'], val['version'], val['changelog'], val['download'], dummy, dummy, val['stable'], val['deleted'], val['hit'] = rel
        else:
            val = request.paramMap
        if val['download'] == None or val['download'] == 'None': val['download'] = ''
        _page.append("""
<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/changeRelease'))
        _page.append("""\"  enctype="multipart/form-data">
  <input name="release" type="hidden" value=\"""")
        _page.append(str(val['release']))
        _page.append("""\">
  <input name="module" type="hidden" value=\"""")
        _page.append(str(val['module']))
        _page.append("""\">
  <table>
    <colgroup>
      <col width="*">
      <col width="333">
      <col width="*">
    </colgroup>
    <tr>
      <td valign="top" class="moduleText">Version number :</td>
      <td><input name="version" type="text" value=\"""")
        _page.append(str(val['version']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgVersion))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Stable version ?</td>
      <td><input name="stable" type="checkbox" """)
        _page.append(str(self.getChecked(1, 'stable', val)))
        _page.append(""" value=\"""")
        _page.append(str(self.checkValue['stable']))
        _page.append("""\" size="50"></td>
      <td>&nbsp</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Upload TARBALL :</td>
      <td><input name="tarball" type="file" size="34"></td>
      <td class="moduleText">""")
        _page.append(str(msgTarball))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">Download URL :</td>
      <td><input name="download" type="text" value=\"""")
        _page.append(str(val['download']))
        _page.append("""\" size="50"></td>
      <td class="moduleText">""")
        _page.append(str(msgDownload))
        _page.append("""</td>
    </tr>
    <tr>
      <td valign="top" class="moduleText">ChangeLog :<br />""")
        _page.append(str(msgChangelog))
        _page.append("""</td>
      <td colspan="2"><textarea name="changelog" cols="69" rows="25">""")
        _page.append(str(val['changelog']))
        _page.append("""</textarea></td>
    </tr>
    <tr>
      <td valign="top"><input type="submit" value="         Submit         " size="25"></td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </table>
</form>
""")
        return "".join(_page)
    def resultMask(self) :
        _page=[]
        _page.append("""<p style="color: #BD1E26; font-size: small;">
  Your query has successfully  been taken in account.
</p>
""")
        return "".join(_page)
    def deleteModuleMask(self, modId) :
        _page=[]
        _page.append("""<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/deleteModule'))
        _page.append("""\" onSubmit="return (confirm('Are you sure you really want to delete this module ?'))">
  <input name="module" type="hidden" value=\"""")
        _page.append(str(modId))
        _page.append("""\">
  <p>Please specify why you want to delete this module.</p>
  <textarea name="why" cols="69" rows="5"></textarea><br />
  <input type="submit" value="Delete this module">
</form>
""")
        return "".join(_page)
    def deleteReleaseMask(self, modId) :
        _page=[]
        _page.append("""<form method="post"     action=\"""")
        _page.append(str(request.base+'/thirdParty/deleteRelease'))
        _page.append("""\" onSubmit="return (confirm('Are you sure you really want to delete this release ?'))">
  <input name="release" type="hidden" value=\"""")
        _page.append(str(modId))
        _page.append("""\">
  <p>Please specify why you want to delete this module.</p>
  <textarea name="why" cols="69" rows="5"></textarea><br />
  <input type="submit" value="Delete this release">
</form>
""")
        return "".join(_page)

import string, time, urllib, sys, getopt, cgi, socket, os, ConfigParser, cStringIO, binascii, md5

_lastCacheFlushTime=time.time()
_lastSessionCleanUpTime=time.time()

def debug(debugStr):
    if _debug:
        f=open(_debugFile, 'a')
        f.write(debugStr+'\n')
        f.close

def printUsageAndExit():
    print "Usage: server [-C configFile]"
    sys.exit(-1)

def mainInit(argv):
    global configFile, configFileName
    if not globals().has_key('hotReload'):
        if not (len(argv)==1 or (len(argv)==3 and argv[1]=="-C")): printUsageAndExit()
        if len(argv)==3: configFileName=argv[2]

    configFile=ConfigParser.ConfigParser()
    configFile.read(configFileName)
    if not globals().has_key('hotReload'):
        
        
        
        global _logToScreen, _logFile, _socketHost, _socketPort, _socketFile, _protocolVersion, _reverseDNS, _socketQueueSize
        global _processPool, _threading, _forking, _threadPool, _sslKeyFile, _sslCertificateFile
        global _typeOfRequests, _staticContentList, _flushCacheDelay, _sessionStorageType
        global _sessionTimeout, _sessionCookieName, _sessionStorageFileDir, _sessionCleanUpDelay
        global _sslClientCertificateVerification, _sslCACertificateFile, _sslVerifyDepth
        
        _logToScreen=1 # Should logs be output to screen or not
        _logFile="" # Default log file
        
        _socketHost=''
        _socketPort=0
        _socketFile='' # Used if server should listen on AF_UNIX socket
        _reverseDNS=0
        _socketQueueSize=5 # Size of the socket queue
        _protocolVersion="HTTP/1.0"
        
        _processPool=1 # Used if we want to fork n processes at the beginning. In this case, all processes will listen on the same socket (this only works on unix)
        _threading=0 # Used if we want to create a new thread for each request
        _forking=0 # Used if we want to create a new process for each request
        _threadPool=1 # Used if we want to create a pool of threads at the beginning
        
        _sslKeyFile=""
        _sslCertificateFile=""
        
        _sslClientCertificateVerification=0
        _sslCACertificateFile=""
        _sslVerifyDepth=1
        
        _typeOfRequests=('web', )
        
        _staticContentList=[]
        
        _flushCacheDelay=0
        
        _sessionStorageType=""
        _sessionTimeout=60 # In minutes
        _sessionCleanUpDelay=60 # In minutes
        _sessionCookieName="CherryPySession"
        _sessionStorageFileDir=""
        
        try: _logToScreen=int(configFile.get('server', 'logToScreen'))
        except: pass
        try: _logFile=configFile.get('server', 'logFile')
        except: pass
        try: _socketHost=configFile.get('server', 'socketHost')
        except: pass
        try: _protocolVersion=configFile.get('server', 'protocolVersion')
        except: pass
        try: _socketPort=int(configFile.get('server', 'socketPort'))
        except:pass
        try: _socketFile=configFile.get('server', 'socketFile')
        except: pass
        try: _reverseDNS=int(configFile.get('server', 'reverseDNS'))
        except: pass
        try: _socketQueueSize=int(configFile.get('server', 'socketQueueSize'))
        except: pass
        try: _processPool=int(configFile.get('server', 'processPool'))
        except: pass
        try: _threadPool=int(configFile.get('server', 'threadPool'))
        except: pass
        try: _threading=int(configFile.get('server', 'threading'))
        except: pass
        try: _forking=int(configFile.get('server', 'forking'))
        except: pass
        try: _sslKeyFile=configFile.get('server', 'sslKeyFile')
        except: pass
        try: _sslCertificateFile=configFile.get('server', 'sslCertificateFile')
        except: pass
        try: _sslClientCertificateVerification=int(configFile.get('server', 'sslClientCertificateVerification'))
        except: pass
        try: _sslCACertificateFile=configFile.get('server', 'sslCACertificateFile')
        except: pass
        try: _sslVerifyDepth=int(configFile.get('server', 'sslVerifyDepth'))
        except: pass
        try: _typeOfRequests=configFile.get('server', 'typeOfRequests').split(',')
        except: pass
        try: _sessionStorageType=configFile.get('session', 'storageType')
        except: pass
        try: _sessionTimeout=float(configFile.get('session', 'timeout'))
        except: pass
        try: _sessionCleanUpDelay=float(configFile.get('session', 'cleanUpDelay'))
        except: pass
        try: _sessionCookieName=configFile.get('session', 'cookieName')
        except: pass
        try: _sessionStorageFileDir=configFile.get('session', 'storageFileDir')
        except: pass
        try:
            staticDirList=configFile.options('staticContent')
            for staticDir in staticDirList:
                staticDirTarget=configFile.get('staticContent', staticDir)
                _staticContentList.append((staticDir, staticDirTarget))
        except: pass
        try: _flushCacheDelay=float(configFile.get('cache', 'flushCacheDelay'))
        except: pass
        
        logMessage("Reading parameters from %s ..."%configFileName)
        logMessage("Server parameters:")
        logMessage("  logToScreen: %s"%_logToScreen)
        logMessage("  logFile: %s"%_logFile)
        logMessage("  protocolVersion: %s"%_protocolVersion)
        logMessage("  socketHost: %s"%_socketHost)
        logMessage("  socketPort: %s"%_socketPort)
        logMessage("  socketFile: %s"%_socketFile)
        logMessage("  reverseDNS: %s"%_reverseDNS)
        logMessage("  socketQueueSize: %s"%_socketQueueSize)
        if _processPool!=1: _processPoolStr=_processPool
        else: _processPoolStr='0'
        logMessage("  processPool: %s"%_processPoolStr)
        if _threadPool!=1: _threadPoolStr=_threadPool
        else: _threadPoolStr='0'
        logMessage("  threadPool: %s"%_threadPoolStr)
        logMessage("  threading: %s"%_threading)
        logMessage("  forking: %s"%_forking)
        logMessage("  sslKeyFile: %s"%_sslKeyFile)
        if _sslKeyFile:
            logMessage("  sslCertificateFile: %s"%_sslCertificateFile)
            logMessage("  sslClientCertificateVerification: %s"%_sslClientCertificateVerification)
            logMessage("  sslCACertificateFile: %s"%_sslCACertificateFile)
            logMessage("  sslVerifyDepth: %s"%_sslVerifyDepth)
            logMessage("  typeOfRequests: %s"%str(_typeOfRequests))
            logMessage("  flushCacheDelay: %s min"%_flushCacheDelay)
        logMessage("  sessionStorageType: %s"%_sessionStorageType)
        if _sessionStorageType:
            logMessage("  sessionTimeout: %s min"%_sessionTimeout)
            logMessage("  cleanUpDelay: %s min"%_sessionCleanUpDelay)
            logMessage("  sessionCookieName: %s"%_sessionCookieName)
            logMessage("  sessionStorageFileDir: %s"%_sessionStorageFileDir)
        logMessage("  staticContent: %s"%_staticContentList)
        
        if _protocolVersion not in ("HTTP/1.1", "HTTP/1.0"):
            raise "CherryError: protocolVersion must be 'HTTP/1.1' or 'HTTP/1.0'"
        if _reverseDNS not in (0,1): raise "CherryError: reverseDNS must be '0' or '1'"
        if _socketFile and not hasattr(socket, 'AF_UNIX'): raise "CherryError: Configuration file has socketFile, but this is only available on Unix machines"
        if _processPool!=1 and not hasattr(os, 'fork'): raise "CherryError: Configuration file has processPool, but forking is not available on this operating system"
        if _forking and not hasattr(os, 'fork'): raise "CherryError: Configuration file has forking, but forking is not available on this operating system"
        if _sslKeyFile:
            try:
                global SSL
                from OpenSSL import SSL
            except: raise "CherryError: PyOpenSSL 0.5.1 or later must be installed to use SSL. You can get it from http://pyopenssl.sourceforge.net"
        if 'xmlRpc' in _typeOfRequests:
            try:
                global xmlrpclib
                import xmlrpclib
            except: raise "CherryError: xmlrpclib must be installed to use XML-RPC. It is included in Python-2.2 and higher, or else you can get it from http://www.pythonware.com"
        if _socketPort and _socketFile: raise "CherryError: In configuration file: socketPort and socketFile conflict with each other"
        if not _socketFile and not _socketPort: _socketPort=8000 # Default port
        if _processPool==1: severalProcs=0
        else: severalProcs=1
        if _threadPool==1: severalThreads=0
        else: severalThreads=1
        if severalThreads+severalProcs+_threading+_forking>1: raise "CherryError: In configuration file: threadPool, processPool, threading and forking conflict with each other"
        if _sslKeyFile and not _sslCertificateFile: raise "CherryError: Configuration file has sslKeyFile but no sslCertificateFile"
        if _sslCertificateFile and not _sslKeyFile: raise "CherryError: Configuration file has sslCertificateFile but no sslKeyFile"
        try: sys.stdout.flush()
        except: pass
        
        for typeOfRequest in _typeOfRequests:
            if typeOfRequest not in ('xmlRpc', 'web'): raise "CherryError: Configuration file an invalid typeOfRequest: '%s'"%typeOfRequest
        
        if _sessionStorageType not in ('', 'custom', 'ram', 'file', 'cookie'): raise "CherryError: Configuration file an invalid sessionStorageType: '%s'"%_sessionStorageType
        if _sessionStorageType in ('custom', 'ram', 'cookie') and _sessionStorageFileDir!='': raise "CherryError: Configuration file has sessionStorageType set to 'custom, 'ram' or 'cookie' but a sessionStorageFileDir is specified"
        if _sessionStorageType=='file' and _sessionStorageFileDir=='': raise "CherryError: Configuration file has sessionStorageType set to 'file' but no sessionStorageFileDir"
        if _sessionStorageType=='ram' and (_forking or severalProcs):
            print "CherryWarning: 'ram' sessions might be buggy when using several processes"
        
    global tools
    tools = Tools()
    global defaultFormMask
    defaultFormMask = DefaultFormMask()
    global maskTools
    maskTools = MaskTools()
    global myMail
    myMail = MyMail()
    global cherryPyForumDesign
    cherryPyForumDesign = CherryPyForumDesign()
    global frenchTools
    frenchTools = FrenchTools()
    global cherryPyMail
    cherryPyMail = CherryPyMail()
    global root
    root = Root()
    global sql
    sql = Sql()
    global viewStat
    viewStat = ViewStat()
    global xslTransform
    xslTransform = XslTransform()
    global demo
    demo = Demo()
    global genericStore
    genericStore = GenericStore()
    global bookStore
    bookStore = BookStore()
    global dvdStore
    dvdStore = DvdStore()
    global videoGameStore
    videoGameStore = VideoGameStore()
    global httpProtected
    httpProtected = HttpProtected()
    global cookieProtected
    cookieProtected = CookieProtected()
    global testForm
    testForm = TestForm()
    global cherryPyOrgForumDesign
    cherryPyOrgForumDesign = CherryPyOrgForumDesign()
    global myForum
    myForum = MyForum()
    global myForumAdmin
    myForumAdmin = MyForumAdmin()
    global cherryDb
    cherryDb = CherryDb()
    global stationTable
    stationTable = StationTable()
    global newInfoTable
    newInfoTable = NewInfoTable()
    global newPriceTable
    newPriceTable = NewPriceTable()
    global commentTable
    commentTable = CommentTable()
    global newStationTable
    newStationTable = NewStationTable()
    global requestTable
    requestTable = RequestTable()
    global viewTables
    viewTables = ViewTables()
    global checkNew
    checkNew = CheckNew()
    global prestationMail
    prestationMail = PrestationMail()
    global prestationFrench
    prestationFrench = PrestationFrench()
    global prestationEnglish
    prestationEnglish = PrestationEnglish()
    global thirdParty
    thirdParty = ThirdParty()

    if not globals().has_key('hotReload'):
        # Call initServer function
        # logMessage("Calling initServer() ...")
        initServer()
    else:
        # Call hotReloadInitServer function
        # logMessage("Calling hotReloadInitServer() ...")
        hotReloadInitServer()
        logMessage("Hot reload finished")

    # Create request and response instances (the same will be used all the time)
    global request, response
    if not _threading and _threadPool==1:
        # If we don't use threading, we don't care about concurrency issues among different requests
        class _emptyClass: pass
        request=_emptyClass()
        response=_emptyClass()
    else:
        # If we use threading, we have to store request informations in thread-aware classes
        global _myThread
        import thread as _myThread # Ugly hack because CherryForum uses the keyword "thread" ... TBC
        class _threadAwareClass:
            def __init__(self, name):
                self.__dict__['threadMap']={} # Used to store variables. Keys are thread identifier
                self.__dict__['name']=name
            def __setattr__(self, name, value):
                if self.__dict__['name'] == 'request' and name == 'sessionMap' and not _sessionStorageType:
                    raise "You are trying to use sessions but sessions are not enabled in the config file. Check out the HowTo about sessions on the cherrypy.org website to learn how to use sessions."
                _myId=_myThread.get_ident()
                if not self.__dict__['threadMap'].has_key(_myId): self.__dict__['threadMap'][_myId]={}
                self.threadMap[_myId][name]=value
            def __getattr__(self, name):
                if self.__dict__['name'] == 'request' and name == 'sessionMap' and not _sessionStorageType:
                    raise "You are trying to use sessions but sessions are not enabled in the config file. Check out the HowTo about sessions on the cherrypy.org website to learn how to use sessions."
                _myId=_myThread.get_ident()
                return self.__dict__['threadMap'][_myId][name]
        request=_threadAwareClass('request')
        response=_threadAwareClass('response')

    # Create sessionMap if needed
    if _sessionStorageType=="ram":
        global _sessionMap
        _sessionMap={} # Map of "cookie" -> ("session object", "expiration time")

    global _weekdayname, _monthname
    _weekdayname=['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
    _monthname=[None, 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

    sys.stdout.flush()

global initRequestBeforeParse
def initRequestBeforeParse():
    pass
global initRequest
def initRequest():
    pass
    if request.browserUrl.find('static')==-1 and request.browserUrl.find('viewStat')==-1 and request.browserUrl.find('maskTools')==-1:
        sql.logPageStat()
global initNonStaticRequest
def initNonStaticRequest():
    pass
global initResponse
def initResponse():
    pass
global initNonStaticResponse
def initNonStaticResponse():
    pass
global initServer
def initServer():
    pass
    objectsTypeMap={
        "forum":  {
            "name": "string",
            "description": "text",
            "order": "float",
            "threadList": "list of links to thread.forum linkBack"
        },
        "thread": {
            "subject": "string",
            "forum": "link to forum.threadList",
            "messageList": "list of links to message.thread linkBack",
            "views": "float",
            "creationDate": "string"
        },
        "message": {
            "name": "string",
            "email": "string",
            "sendNotice": "boolean",
            "date": "string",
            "dummySubject": "string",
            "text": "text",
            "thread": "link to thread.messageList"
        }
    }
    objectsTuneMap={
        "thread": {
            "global": {"label": "object.subject"}
        },
        "message": {
            "name": {"validate": CherryObjects.notEmpty},
            "text": {"validate": CherryObjects.notEmpty}
        }
    }
    fname=configFile.get("forum", "dbFile")
    CherryObjects.initWeb(fname, objectsTypeMap, objectsTuneMap)
    print "All messages:", message.getObjects()
    for m in message.getObjects():
        message.saveObject(m)
    sys.path.append("/home/rdelon/PythonModules")
    keyWordMapFile=configFile.get("keyWordMap", "file")
    f=open(keyWordMapFile,"r")
    global keyWordMap
    keyWordMap=cPickle.load(f)
    f.close()
    global hasXslt, Processor, InputSource
    hasXslt=1
    try:
        from Ft.Xml.Xslt import Processor
        from Ft.Xml import InputSource
    except: hasXslt=0
    genericStore.itemList=[bookStore, dvdStore, videoGameStore]
    cherryDb.databaseRead()
global initThread
def initThread(threadIndex):
    pass
    time.sleep(threadIndex * 0.1) # Sleep 0.1 second between each new database connection to make sure MySql an keep up
    request.hasDatabase = 1
    try:
        global MySQLdb
        import MySQLdb
        request.connection = MySQLdb.connect(
            configFile.get('database', 'host'),
            configFile.get('database', 'user'),
            configFile.get('database', 'password'),
            configFile.get('database', 'name')
        )
    except: request.hasDatabase=0
    print "hasDatabase:", request.hasDatabase
    if configFile.get('restrictedArea', 'login') != 'login':
        os.setegid(2524)
        os.seteuid(2524)
global initProcess
def initProcess(processIndex):
    pass
global initAfterBind
def initAfterBind():
    pass
    if configFile.get('restrictedArea', 'login') != 'login':
        os.setegid(2524)
        os.seteuid(2524)
global hotReloadInitServer
def hotReloadInitServer():
    pass
global onError
def onError():
    import traceback, StringIO
    bodyFile=StringIO.StringIO()
    traceback.print_exc(file=bodyFile)
    errorBody=bodyFile.getvalue()
    bodyFile.close()
    try: errorBody+="\nUrl was: "+request.browserUrl+"\n"
    except: pass
    if request.base.find('cherrypy.org')!=-1:
        if request.path.find('robots.txt')==-1:
            cherryPyMail.sendMail("erreur@cherrypy.org", "rdelon@netcourrier.com", "", "text/plain", "Erreur CherryPy", errorBody)
        response.body="<html><body><center><br><br><br>Oops, an internal error occured.<br><br>We've been notified of this and we'll try to fix it as soon as possible</body></html><!-- %s -->"%errorBody
    else:
        response.body=errorBody
        response.headerMap['content-type']='text/plain'
global logMessage

def logMessage(message, level=0):
    if level: return
    if _logToScreen: print message
    if _logFile:
        f=open(_logFile, "a")
        f.write(message+"\n")
        f.close()
global saveSessionData
def saveSessionData(sessionId, sessionData, expirationTime):
    pass
global loadSessionData
def loadSessionData(sessionId):
    pass
global cleanUpOldSessions
def cleanUpOldSessions():
    pass
global maskAndViewMap
global xmlrpcMaskAndViewMap

def ramOrFileOrCookieOrCustomSaveSessionData(sessionId, sessionData, expirationTime):
    # Save session to file if needed
    t = time.localtime(expirationTime)
    if _sessionStorageType=='file':
        fname=os.path.join(_sessionStorageFileDir,sessionId)
        if _threadPool>1 or _threading:
            _sessionFileLock.acquire()
        f=open(fname,"wb")
        cPickle.dump((sessionData, expirationTime), f)
        f.close()
        if _threadPool>1 or _threading:
            _sessionFileLock.release()

    elif _sessionStorageType=="ram":
        # Update expiration time
        _sessionMap[sessionId]=(sessionData, expirationTime)

    elif _sessionStorageType == "cookie":
        global _SITE_KEY_
        if not globals().has_key('_SITE_KEY_'):
            # Get site key from config file or compute it
            try: _SITE_KEY_ = configFile.get('server','siteKey')
            except:
                _SITE_KEY_ = ''
                for i in range(30):
                    _SITE_KEY_ += whrandom.choice(string.letters)
        # Update expiration time
        _sessionData = (sessionData, expirationTime)
        _dumpStr = cPickle.dumps(_sessionData)
        try: _dumpStr = zlib.compress(_dumpStr)
        except: pass # zlib is not available in all python distros
        _dumpStr = binascii.hexlify(_dumpStr) # Need to hexlify it because it will be stored in a cookie
        response.simpleCookie['CSession']=_dumpStr
        response.simpleCookie['CSession-sig']=md5.md5(_dumpStr+_SITE_KEY_).hexdigest()
        response.simpleCookie['CSession']['path']='/'
        response.simpleCookie['CSession']['max-age']=_sessionTimeout*60
        response.simpleCookie['CSession-sig']['path']='/'
        response.simpleCookie['CSession-sig']['max-age']=_sessionTimeout*60

    else:
        # custom
        saveSessionData(sessionId, sessionData, expirationTime)

def ramOrFileOrCookieOrCustomLoadSessionData(sessionId):
    # Return the session data for a given sessionId. the _expirationTime will be checked by the caller of this function
    if _sessionStorageType=="ram":
        if _sessionMap.has_key(sessionId): return _sessionMap[sessionId]
        else: return None

    elif _sessionStorageType=="file":
        _fname=os.path.join(_sessionStorageFileDir,sessionId)
        if os.path.exists(_fname):
            if _threadPool>1 or _threading:
                _sessionFileLock.acquire()
            _f=open(_fname,"rb")
            _sessionData = cPickle.load(_f)
            _f.close()
            if _threadPool>1 or _threading:
                _sessionFileLock.release()
            return _sessionData
        else: return None

    elif _sessionStorageType == "cookie":
        global _SITE_KEY_
        if not globals().has_key('_SITE_KEY_'):
            try: _SITE_KEY_ = configFile.get('server','siteKey')
            except:
                return None
        if request.simpleCookie.has_key('CSession') and request.simpleCookie.has_key('CSession-sig'):
            _data = request.simpleCookie['CSession'].value
            _sig  = request.simpleCookie['CSession-sig'].value
            if md5.md5(_data + _SITE_KEY_).hexdigest() == _sig:
                try:
                    _dumpStr = binascii.unhexlify(_data)
                    try: _dumpStr = zlib.decompress(_dumpStr)
                    except: pass # zlib is not available in all python distros
                    _dumpStr = cPickle.loads(_dumpStr)
                    return _dumpStr
                except: pass
        return None

    else:
        # custom
        return loadSessionData(sessionId)

def ramOrFileOrCookieOrCustomCleanUpOldSessions():
    # Clean up old session data
    _now = time.time()
    if _sessionStorageType=="ram":
        _sessionIdToDeleteList = []
        for _sessionId, (_dummy, _expirationTime) in _sessionMap.items():
            if _expirationTime < _now: _sessionIdToDeleteList.append(_sessionId)
        for _sessionId in _sessionIdToDeleteList: del _sessionMap[_sessionId]

    elif _sessionStorageType=="file":
        # This process is *very* expensive because we go through all files, parse them and them delete them if the session is expired
        # One optimization would be to just store a list of (sessionId, expirationTime) in *one* file
        _sessionFileList = os.listdir(_sessionStorageFileDir)
        for _sessionId in _sessionFileList:
            try:
                _dummy, _expirationTime = ramOrFileOrCookieOrCustomLoadSessionData(_sessionId)
                if _expirationTime < _now:
                    os.remove(os.path.join(_sessionStorageFileDir, _sessionId))
            except: pass

    elif _sessionStorageType == "cookie":
        # Nothing to do in this case: the session data is stored on the client
        pass

    else:
        # custom
        cleanUpOldSessions()

maskAndViewMap={'cherryPyMail': {}, 'genericStore': {'viewList': 1, 'viewItem': 1, 'index': 1}, 'myForum': {'forumListMask': 1, 'viewThread': 1, 'viewForum': 1, 'messageListMask': 1, 'threadListMask': 1, 'newThread': 1, 'search': 1, 'index': 1}, 'root': {'talk': 1, 'latestReleaseContent': 1, 'downloadableDocContent': 1, 'licenseContent': 1, 'cherrypy_0_9_gammaContent': 1, 'cherrypy_0_9_beta': 1, 'showMe': 1, 'hosting': 1, 'cvs': 1, 'documentation': 1, 'footer': 1, 'license': 1, 'aboutSiteContent': 1, 'hostingContent': 1, 'search': 1, 'articles': 1, 'compiler': 1, 'europython2003Content': 1, 'peopleContent': 1, 'talkContent': 1, 'cvsContent': 1, 'howToContent': 1, 'searchResultContent': 1, 'mailingListsContent': 1, 'introductionContent': 1, 'currentDevelopment': 1, 'mainFeatures': 1, 'cherrypy_0_9_betaContent': 1, 'libContent': 1, 'square': 1, 'downloadableDoc': 1, 'previewMessage': 1, 'cherrypy_0_9_gamma': 1, 'cherryForumContent': 1, 'hostContent': 1, 'index': 1, 'leftColumn': 1, 'europython2003': 1, 'tutorialContent': 1, 'newsContent': 1, 'welcome': 1, 'currentDevelopmentContent': 1, 'mailingLists': 1, 'header': 1, 'comingSoonContent': 1, 'download': 1, 'leftSquare': 1, 'articlesContent': 1, 'downloadContent': 1, 'people': 1, 'cherryForum': 1, 'feedback': 1, 'aboutSite': 1}, 'newInfoTable': {}, 'newPriceTable': {}, 'bookStore': {'viewList': 1, 'viewItem': 1, 'index': 1}, 'videoGameStore': {'viewList': 1, 'viewItem': 1, 'index': 1}, 'testForm': {'index': 1, 'postForm': 1}, 'newStationTable': {}, 'viewStat': {'viewPage': 1, 'index': 1, 'unauthorized': 1, 'viewStat': 1}, 'commentTable': {}, 'requestTable': {}, 'thirdParty': {'changeModule': 1, 'index': 1, 'addNewRelease': 1, 'create': 1, 'search': 1, 'addRelease': 1, 'viewModule': 1, 'download': 1, 'deleteRelease': 1, 'changeContent': 1, 'deleteModule': 1, 'bakeryContent': 1, 'addModule': 1, 'changeRelease': 1, 'changeLog': 1, 'goTo': 1}, 'myForumAdmin': {'unauthorized': 1, 'index': 1, 'action': 1}, 'dvdStore': {'viewList': 1, 'viewItem': 1, 'index': 1}, 'checkNew': {'unauthorized': 1, 'index': 1}, 'httpProtected': {'unauthorized': 1, 'index': 1}, 'prestationFrench': {'partnerModule': 1, 'updateInfo': 1, 'addComment': 1, 'wapZone': 1, 'tooManyStation': 1, 'searchStation': 1, 'index': 1, 'viewPrice': 1, 'headerColumn': 1, 'addStationAction': 1, 'footer': 1, 'viewStation': 1, 'contactUs': 1, 'headerMask': 1, 'manageStation': 1, 'updatePrice': 1, 'stationList': 1, 'firstVisit': 1, 'manager': 1, 'header': 1, 'disclaimer': 1, 'viewComment': 1, 'addStation': 1, 'resultStation': 1, 'manageStationAction': 1, 'updatePriceAction': 1, 'noStation': 1, 'addCommentAction': 1, 'updateInfoAction': 1}, 'cookieProtected': {'doLogout': 1, 'doLogin': 1, 'logoutScreen': 1, 'index': 1, 'loginScreen': 1}, 'viewTables': {'testForMask': 1, 'viewTables': 1, 'viewTable': 1, 'viewTableMask': 1}, 'stationTable': {}, 'demo': {'footerTemplateCode': 1, 'webColorCode': 1, 'include': 1, 'formCode': 1, 'xmlXslOnline': 1, 'indexTemplateCode': 1, 'xmlXsl': 1, 'template': 1, 'indexCherryTemplateCode': 1, 'streamingResult': 1, 'cookieCode': 1, 'xmlInput': 1, 'postFormCode': 1, 'postFormActionCode': 1, 'testHttpAuthenticate': 1, 'maskTools': 1, 'index': 1, 'streamingCode': 1, 'post': 1, 'xmlXslOnlineViewCode': 1, 'xmlXslSample': 1, 'oop': 1, 'cookie': 1, 'maskToolsCode': 1, 'ssl': 1, 'httpAuthenticateCode': 1, 'streaming': 1, 'cookieAuthenticateCode': 1, 'xmlXslOnlineCode': 1, 'xslStylesheet': 1, 'sessionsCode': 1, 'sessions': 1, 'postFile': 1, 'headerTemplateCode': 1, 'testCookieAuthenticate': 1, 'oopCode': 1, 'xmlXslSampleCode': 1, 'viewCode': 1}, 'maskTools': {'textInBox': 1, 'xData': 1, 'prettyMap': 1}, 'prestationEnglish': {'partnerModule': 1, 'updateInfo': 1, 'addComment': 1, 'wapZone': 1, 'tooManyStation': 1, 'searchStation': 1, 'index': 1, 'viewPrice': 1, 'headerColumn': 1, 'addStationAction': 1, 'footer': 1, 'viewStation': 1, 'contactUs': 1, 'headerMask': 1, 'manageStation': 1, 'updatePrice': 1, 'stationList': 1, 'firstVisit': 1, 'manager': 1, 'header': 1, 'disclaimer': 1, 'viewComment': 1, 'addStation': 1, 'resultStation': 1, 'manageStationAction': 1, 'updatePriceAction': 1, 'noStation': 1, 'addCommentAction': 1, 'updateInfoAction': 1}, 'prestationMail': {}, 'myMail': {}}
xmlrpcMaskAndViewMap={}
if not globals().has_key('hotReload'):
    
    import mimetypes, sha
    mimetypes.types_map['.dwg']='image/x-dwg'
    mimetypes.types_map['.ico']='image/x-icon'
    
    def _parseFirstLine(data):
        data = str(data) # Get rid of unicode
        request.path=data.split()[1]
        if request.path and request.path[0]=='/': request.path=request.path[1:] # Remove starting '/' if any
        request.path=request.path.replace('&amp;', '&') # This case happens for some reason ...
        request.browserUrl=request.path
        request.paramMap={}
        request.filenameMap={}
        request.fileTypeMap={}
        request.paramTuple=()
        request.isXmlRpc=0
        i=request.path.find('?')
        if i!=-1:
            if request.path[i+1:]:
                k=request.path[i+1:].find('?')
                if k!=-1:
                    j=request.path[:k].rfind('=')
                    if j!=-1: request.path=request.path[:j+1] + urllib.quote_plus(request.path[j+1:])
                for _paramStr in request.path[i+1:].split('&'):
                    _sp=_paramStr.split('=')
                    if len(_sp) > 2:
                        j=_paramStr.find('=')
                        _sp=(_paramStr[:j],_paramStr[j+1:])
                    if len(_sp)==2:
                        _key, _value=_sp
                        _value=urllib.unquote_plus(_value)
                        if request.paramMap.has_key(_key):
                            # Already has a value: make a list out of it
                            if type(request.paramMap[_key])==type([]):
                                # Already is a list: append the new value to it
                                request.paramMap[_key].append(_value)
                            else:
                                # Only had one value so far: start a list
                                request.paramMap[_key]=[request.paramMap[_key], _value]
                        else:
                            request.paramMap[_key]=_value
            request.path=request.path[:i]
    
        if request.path and request.path[-1]=='/': request.path=request.path[:-1] # Remove trailing '/' if any
        
    def _parsePostData(_rfile):
        # Read request body and put it in _data
        _len = int(request.headerMap.get("content-length","0"))
        if _len: _data=_rfile.read(_len)
        else: _data=""
    
        request.isXmlRpc=0
        # Try to parse request body as an XML-RPC call
        if 'xmlRpc' in _typeOfRequests and _data and request.headerMap.get("content-type","") == "text/xml":
            _xmlRpcPathList = []
            if request.path == 'RPC2': pass
            elif request.path.find('/') > -1: _xmlRpcPathList = request.path.split('/')
            elif not request.path: pass
            else: _xmlRpcPathList = [request.path]
            try:
                try: request.paramTuple,_thisXmlRpcMethod=xmlrpclib.loads(_data)
                except: raise "XML-RPC ERROR"
                _thisXmlRpcMethod = str(_thisXmlRpcMethod) # Get rid of unicode
                request.isXmlRpc=1 # If parsing worked, it is an XML-RPC request
                _xmlRpcPathList += _thisXmlRpcMethod.split('.')
            except "XML-RPC ERROR":
                # error reading data; must not have been an xmlrpc file
                pass
    
        if request.isXmlRpc:
            request.path = '/'.join(_xmlRpcPathList)
        else:
            # It's a normal browser call
            # Put _data in a StringIO so FieldStorage can read it
            _newRfile=cStringIO.StringIO(_data)
            _forms=cgi.FieldStorage(fp=_newRfile, headers=request.headerMap, environ={'REQUEST_METHOD':'POST'}, keep_blank_values=1)
            for _key in _forms.keys():
                # Check if it's a list or not
                _valueList=_forms[_key]
                if type(_valueList)==type([]):
                    # It's a list of values
                    request.paramMap[_key] = []
                    request.filenameMap[_key] = []
                    request.fileTypeMap[_key] = []
                    for item in _valueList:
                        request.paramMap[_key].append(item.value)
                        request.filenameMap[_key].append(item.filename)
                        request.fileTypeMap[_key].append(item.type)
                else:
                    # It's a single value
                    # In case it's a file being uploaded, we save the filename in a map (user might need it)
                    request.paramMap[_key]=_valueList.value
                    request.filenameMap[_key]=_valueList.filename
                    request.fileTypeMap[_key]=_valueList.type
    
    def _insertIntoHeaderMap(key,value):
        request.headerMap[key.lower()]=value
    
    def _doRequest(_wfile):
        try:
            _handleRequest(_wfile)
        except:
            _err=""
            _exc_info_1=sys.exc_info()[1]
            if hasattr(_exc_info_1,'args') and len(_exc_info_1.args)>=1:
                _err=_exc_info_1.args[0]
            if _err=='global name \'sessionMap\' is not defined':
                _error="CherryError:\n"
                _error+="    Session data is now manipulated through \"request.sessionMap\" instead of just \"sessionMap\".\n"
                _error+="    Check out the HowTo about sessions on the cherrypy.org website to learn how to use sessions.\n"
                _wfile.write('%s 200 OK\r\n' % _protocolVersion)
                _wfile.write('Content-Type: text/plain\r\n')
                _wfile.write('Content-Length: %s\r\n'%len(_error))
                _wfile.write('\r\n')
                _wfile.write(_error)
                return
            elif _err=="_emptyClass instance has no attribute 'sessionMap'":
                _error="CherryError:\n"
                _error+="    You are trying to use sessions but sessions are not enabled in the config file.\n"
                _error+="    Check out the HowTo about sessions on the cherrypy.org website to learn how to use sessions.\n"
                _wfile.write('%s 200 OK\r\n' % _protocolVersion)
                _wfile.write('Content-Type: text/plain\r\n')
                _wfile.write('Content-Length: %s\r\n'%len(_error))
                _wfile.write('\r\n')
                _wfile.write(_error)
                return
    
            try:
                onError()
                _wfile.write('%s %s\r\n' % (response.headerMap['protocolVersion'], response.headerMap['status']))
                if response.headerMap.has_key('content-length') and response.headerMap['content-length']==0:
                    response.headerMap['content-length']=len(response.body)
                for _key, _valueList in response.headerMap.items():
                    if _key not in ('status', 'protocolVersion'):
                        if type(_valueList)!=type([]): _valueList=[_valueList]
                        for _value in _valueList:
                            _wfile.write('%s: %s\r\n'%(_key, _value))
                _wfile.write('\r\n')
                _wfile.write(response.body)
            except:
                import traceback, StringIO
                _bodyFile=StringIO.StringIO()
                traceback.print_exc(file=_bodyFile)
                _body=_bodyFile.getvalue()
                _bodyFile.close()
                _wfile.write('%s 200 OK\r\n' % _protocolVersion)
                _wfile.write('Content-Type: text/plain\r\n')
                _wfile.write('Content-Length: %s\r\n'%len(_body))
                _wfile.write('\r\n')
                _wfile.write(_body)
    
    def _sendResponse(_wfile):
        # Save page in the cache if needed
        _cacheKey=""
        try: _cacheKey=request.cacheKey # Cannot use "hasattr", because it fails under jython when threading is turned on
        except: pass
        if _cacheKey:
            _cacheMap[request.cacheKey]=(request.cacheExpire, response.headerMap, response.body)
    
        # Save session data
        if _sessionStorageType and not request.isStaticFile:
            _sessionId=response.simpleCookie[_sessionCookieName].value
            _expirationTime=time.time()+_sessionTimeout*60
            ramOrFileOrCookieOrCustomSaveSessionData(_sessionId, request.sessionMap, _expirationTime)
    
        _wfile.write('%s %s\r\n' % (response.headerMap['protocolVersion'], response.headerMap['status']))
        for _key, _valueList in response.headerMap.items():
            if _key not in ('status', 'protocolVersion'):
                if type(_valueList)!=type([]): _valueList=[_valueList]
                for _value in _valueList:
                    _wfile.write('%s: %s\r\n'%(_key, _value))
        # Send response cookies
        _cookie=response.simpleCookie.output()
        # print "Sending back cookie:", _cookie
        if _cookie:
            _wfile.write(_cookie+'\r\n')
        _wfile.write('\r\n')
        _wfile.write(response.body)
    
    def _sendCachedPageIfPossible(_now,_wfile):
        _cacheKey=""
        try: _cacheKey=request.cacheKey # Cannot use "hasattr", because it fails under jython when threading is turned on
        except: pass
        if _cacheKey:
            # Use caching for this page
            if _cacheMap.has_key(request.cacheKey) and _cacheMap[request.cacheKey][0]>=_now:
                # This page is already in the cache and it hasn't expired yet: use the cached version
                dummy, response.headerMap, response.body=_cacheMap[request.cacheKey]
                initResponse()
                request.cacheKey='' # No need to save the page in the cache again
                _sendResponse(_wfile)
                return 1
            # else:
            #     Either the page has never been cached, or the cached version expired
            #     In the case, we build the page normally and it will be saved in the cache
            #    in the _sendResponse function
        return 0
    
    def _handleRequest(_wfile):
        _now = time.time()
        _year, _month, _day, _hh, _mm, _ss, _wd, _y, _z = time.gmtime(_now)
        _date="%s, %02d %3s %4d %02d:%02d:%02d GMT"%(_weekdayname[_wd],_day,_monthname[_month],_year,_hh,_mm,_ss)
        response.headerMap={"status": "200 OK", "protocolVersion": _protocolVersion, "content-type": "text/html", "server": "CherryPy/0.10-rc1", "date": _date, "set-cookie": [], "content-length": 0}
    
        # Two variables used for streaming
        response.wfile = _wfile
        response.sendResponse = 1
    
        if _sslKeyFile:
            request.base="https://"+request.headerMap['host']
        else:
            request.base="http://"+request.headerMap['host']
        request.browserUrl=request.base+'/'+request.browserUrl
        request.isStaticFile = 0
    
        # Flush the cache if needed:
        global _lastCacheFlushTime
        if _flushCacheDelay and _cacheMap and _lastCacheFlushTime+_flushCacheDelay*60<=_now:
            _lastCacheFlushTime=_now
            for key, (expire, dummy, dummy) in _cacheMap.items():
                if expire<=_now:
                    del _cacheMap[key]
    
        # Clean up expired sessions if needed:
        global _lastSessionCleanUpTime
        if _sessionStorageType and _sessionCleanUpDelay and _lastSessionCleanUpTime+_sessionCleanUpDelay*60<=_now:
            _lastSessionCleanUpTime=_now
            ramOrFileOrCookieOrCustomCleanUpOldSessions()
    
        # Perform some initial operations (such as rewriting url ...)
        request.originalPath=request.path
        request.originalParamMap=request.paramMap
        request.originalParamTuple=request.paramTuple
    
        initRequest()
    
        _path=request.path
    
        # Handle static directories
        for urlDir, fsDir in _staticContentList:
            if _path == urlDir or _path[:len(urlDir)+1]==urlDir+'/':
    
                request.isStaticFile = 1
    
                if _sendCachedPageIfPossible(_now, _wfile): return
    
                _fname = fsDir+_path[len(urlDir):] 
                _stat = os.stat(_fname)
                if type(_stat) == type(()): # Python2.1
                    _modifTime = _stat[9]
                else:
                    _modifTime = _stat.st_mtime
                    
                _strModifTime = time.strftime("%a, %d %b %Y %H:%M:%S GMT", time.gmtime(_modifTime))
    
                # Check if browser sent "if-modified-since" in request header
                if request.headerMap.has_key('if-modified-since'):
                    # Check if if-modified-since date is the same as _strModifTime
                    if request.headerMap['if-modified-since'] == _strModifTime:
                        response.headerMap = {'status': 304, 'protocolVersion': _protocolVersion, 'date': _date}
                        response.body = ''
                        initResponse()
                        _sendResponse(_wfile)
                        return
    
                response.headerMap['last-modified'] = _strModifTime
                _f=open(_fname, 'rb')
                response.body=_f.read()
                response.headerMap['content-length']=len(response.body)
                _f.close()
                # Set content-type based on filename extension
                _i=_path.rfind('.')
                if _i!=-1: _ext=_path[_i:]
                else: _ext=""
                _contentType=mimetypes.types_map.get(_ext, "text/plain")
                response.headerMap['content-type']=_contentType
                initResponse()
                _sendResponse(_wfile)
                return
    
        # Get session data
        if _sessionStorageType and not request.isStaticFile:
            _now=time.time()
            # First, get sessionId from cookie
            try: _sessionId=request.simpleCookie[_sessionCookieName].value
            except: _sessionId=None
            if _sessionId:
                # Load session data from wherever it was stored
                _sessionData = ramOrFileOrCookieOrCustomLoadSessionData(_sessionId)
                if _sessionData == None:
                    _sessionId = None
                else:
                    request.sessionMap, _expirationTime = _sessionData
                    # Check that is hasn't expired
                    if _now > _expirationTime:
                        # Session expired
                        _sessionId = None
    
            # Create a new sessionId if needed
            if not _sessionId:
                request.sessionMap={}
                _sessionId=_generateSessionId()
                request.sessionMap['_sessionId'] = _sessionId
    
            response.simpleCookie[_sessionCookieName]=_sessionId
            response.simpleCookie[_sessionCookieName]['path']='/'
            response.simpleCookie[_sessionCookieName]['version']=1
    
        initNonStaticRequest()
    
        if _sendCachedPageIfPossible(_now, _wfile): return
    
        _path=request.path
        # Special case when url is just the host name
        if not _path: _path='index'
    
        # Work on path:
        # a/b/c/d -> a_b_c.d()
        # c -> root.c()
    
        #if request.isXmlRpc: _pathList=_path.split('.')
        #else:
        _pathList=_path.split('/')
        #print "_path:", _path
        if len(_pathList)==1: _pathList=['root']+_pathList
        _function=None
        _myClass='_'.join(_pathList)
        if _myClass[:5] == 'root_': _myClass = _myClass[5:]
        _myClass2='_'.join(_pathList[:-1])
        _function=_pathList[-1]
        _originalFunction = _function
        # If both mask/view and class have same name, make the mask/view default.
        if maskAndViewMap.has_key(_myClass2) and maskAndViewMap[_myClass2].has_key(_function): _myClass = _myClass2
        # If the path leads to a class, call index by default.
        elif maskAndViewMap.has_key(_myClass): _function = 'index'
    
        _myClass=str(_myClass) # For some reason, _myClass was sometimes unicode (when using XML-RPC)
        # print "_myClass:", `_myClass`, "__function:", _function
    
        # Check that class/method exist
        try: maskAndViewMap[_myClass][_function]
        except KeyError:
            tried = 'tried "%s.%s"' % (_myClass2, _originalFunction)
            if request.path != "":
                tried +=  ' and "%s.index"' % _myClass
            raise str("CherryError: couldn't map URL to an existing non-hidden mask or view (%s)" % tried)
        #if not maskAndViewMap.has_key(_myClass): raise str('CherryError: CherryClass "%s" doesn\'t exist'%_myClass)
        #elif not maskAndViewMap[_myClass].has_key(_function): raise str('CherryError: CherryClass "%s" doesn\'t have any view or mask method called "%s"'%(_myClass, _function))
    
        # Check that it is not a browser call to an XML-RPC method:
        if xmlrpcMaskAndViewMap and not request.isXmlRpc and xmlrpcMaskAndViewMap.has_key(_myClass) and xmlrpcMaskAndViewMap[_myClass].has_key(_function):
            raise str('CherryError: Method "%s" of CherryClass "%s" is an XML-RPC method'%(_function, _myClass))
    
        # Check that it is not an XML-RPC call to a regular metohd:
        if request.isXmlRpc and (not xmlrpcMaskAndViewMap.has_key(_myClass) or not xmlrpcMaskAndViewMap[_myClass].has_key(_function)):
            raise str('CherryError: method "%s" of CherryClass "%s" is not an xmlrpc method'%(_function, _myClass))
    
        # Get result by calling class method
        _theObj=globals()[_myClass]
        _theMethod=getattr(_theObj,_function)
        if request.isXmlRpc:
            response.body=_theMethod(*(request.paramTuple))
        else:
            response.body=_theMethod(**(request.paramMap))
    
        initResponse()
        initNonStaticResponse()
    
        if request.isXmlRpc:
            # Marshall the result if it's an XML-RPC call
            # Wrap the response into a singleton tuple
            response.body=(response.body,)
            response.body=xmlrpclib.dumps(response.body, methodresponse=1)
            # Response type is text/xml for an XML-RPC call
            response.headerMap["content-type"]="text/xml"
    
        # Check response.body and set content-length if needed
        if type(response.body) != type(""):
            if type(response.body) == type(u""): # Potential gotcha: on jython, type("") == type(u"") !!
                raise "CherryError: The mask or view returned a unicode string instead of a regular string !"
            else:
                raise "CherryError: The mask or view didn't return a string !"
        if response.headerMap.has_key('content-length') and response.headerMap['content-length']==0:
            response.headerMap['content-length']=len(response.body)
    
        if response.sendResponse: _sendResponse(_wfile)
    
    def _generateSessionId():
        s=''
        for i in range(50):
            s+=whrandom.choice(string.letters+string.digits)
        s+='%s'%time.time()
        return sha.sha(s).hexdigest()
    
    
    
    import SocketServer
    import socket
    import threading
    import Queue
    import sys
    import threading
    
    _SHUTDOWNREQUEST = (0,0)
    
    class ServerThread(threading.Thread):
        def __init__(self, RequestHandlerClass, requestQueue, threadIndex):
            threading.Thread.__init__(self)
            self._RequestHandlerClass = RequestHandlerClass
            self._requestQueue = requestQueue
            self._threadIndex = threadIndex
            self.setName("RUNNING")
            
        def run(self):
            initThread(self._threadIndex)
            #print "ServerThread %s running..." % threading.currentThread()
            while 1:
                request, client_address = self._requestQueue.get()
                if (request, client_address) == _SHUTDOWNREQUEST:
                    #print "ServerThread %s got SHUTDOWN token" % threading.currentThread()
                    return
                # print "ServerThread %s got request from %s" % (threading.currentThread(), client_address )
                if self.verify_request(request, client_address):            
                    try:
                        self.process_request(request, client_address)
                    except:
                        self.handle_error(request, client_address)
                        self.close_request(request)
                else:
                    self.close_request(request)
    
        def verify_request(self, request, client_address):
            """Verify the request.  May be overridden.
            Return 1 if we should proceed with this request."""
            return 1
    
        def process_request(self, request, client_address):
            self._RequestHandlerClass(request, client_address, self)        
            self.close_request(request)
    
        def close_request(self, request):
            """Called to clean up an individual request."""
            request.close()
    
        def handle_error(self, request, client_address):
            """Handle an error gracefully.  May be overridden.
            The default is to print a traceback and continue.
            """
            import traceback, StringIO
            bodyFile=StringIO.StringIO()
            traceback.print_exc(file=bodyFile)
            errorBody=bodyFile.getvalue()
            bodyFile.close()
            logMessage(errorBody)
            
    
    class PooledThreadServer(SocketServer.TCPServer):
    
        allow_reuse_address = 1
    
        """A TCP Server using a pool of worker threads. This is superior to the
           alternatives provided by the Python standard library, which only offer
           (1) handling a single request at a time, (2) handling each request in
           a separate thread (via ThreadingMixIn), or (3) handling each request in
           a separate process (via ForkingMixIn). It's also superior in some ways
           to the pure async approach used by Twisted because it allows a more
           straightforward and simple programming model in the face of blocking
           requests (i.e. you don't have to bother with Deferreds).""" 
        def __init__(self, serverAddress, numThreads, RequestHandlerClass, ThreadClass=ServerThread):
            assert(numThreads > 0)
    
            # I know it says "do not override", but I have to in order to implement SSL support !
            SocketServer.BaseServer.__init__(self, serverAddress, RequestHandlerClass)
            if _sslKeyFile:
                self.socket=SSL.Connection(_sslCtx, socket.socket(self.address_family, self.socket_type))
            else:
                self.socket=socket.socket(self.address_family, self.socket_type)
            self.server_bind()
            self.server_activate()
            initAfterBind()
    
            self._numThreads = numThreads        
            self._RequestHandlerClass = RequestHandlerClass
            self._ThreadClass = ThreadClass
            self._requestQueue = Queue.Queue()
            self._workerThreads = []
    
        def createThread(self, threadIndex):
            return self._ThreadClass(self._RequestHandlerClass, self._requestQueue, threadIndex)
                
        def start(self):
            if self._workerThreads != []:
                return
            for i in xrange(self._numThreads):
                self._workerThreads.append(self.createThread(i))        
            for worker in self._workerThreads:
                worker.start()
                
        def server_close(self):
            """Override server_close to shutdown thread pool"""
            #print "%s shutting down..." % str(self)
            SocketServer.TCPServer.server_close(self)
            for worker in self._workerThreads:
                self._requestQueue.put(_SHUTDOWNREQUEST)
            for worker in self._workerThreads:
                #print "waiting for %s to exit..." % str(worker)
                worker.join()
            self._workerThreads = []
            #print "%s was shutdown gracefully" % str(self)
    
        def server_activate(self):
            """Override server_activate to set timeout on our listener socket"""
            if hasattr(self.socket, 'settimeout'): self.socket.settimeout(2)
            elif hasattr(self.socket, 'set_timeout'): self.socket.set_timeout(2)
            SocketServer.TCPServer.server_activate(self)
    
        def server_bind(self):
            """Override server_bind to store the server name."""
            #SocketServer.TCPServer.server_bind(self)
            #host, port = self.socket.getsockname()
            #if _reverseDNS: self._serverName = socket.getfqdn(host)
            #else: self._serverName = host
            #self._serverPort = port
            #print "PooledThreadServer bound to %s:%s" % (self._serverName, self._serverPort)
    
            self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    
            self.socket.bind(self.server_address)
    
        def shutdown(self):
            """Gracefully shutdown a server that is serve_forever()ing."""
            self.__running = 0
    
        def shutdownCtrlC(self):
            self.server_close()
    
        def serve_forever(self):
            """Handle one request at a time until doomsday (or shutdown is called)."""
            if self._workerThreads == []:
                self.start()
            self.__running = 1
            while self.__running:
                if not self.handle_request():
                    break
            self.server_close()            
            
        def handle_request(self):
            """Override handle_request to enqueue requests rather than handle
               them synchronously. Return 1 by default, 0 to shutdown the
               server."""
            try:
                if _debug:
                    for t in threading.enumerate():
                        if t.getName()=="NOT RUNNING": return 0
                request, client_address = self.get_request()
                #if hasattr(request,'setblocking'): # Jython doesn't have setblocking
                #    request.setblocking(1)
            except _timeoutError:
                # The only reason for the timeout is so we can notice keyboard
                # interrupts on Win32, which don't interrupt accept() by default
                return 1
            except KeyboardInterrupt:
                print "<Ctrl-C> hit: shutting down"
                return 0
            except socket.error, e:
                return 1
            self._requestQueue.put((request, client_address))
            return 1
    
        def get_request(self):
            # With Python 2.3 it seems that an accept socket in timeout (nonblocking) mode
            #  results in request sockets that are also set in nonblocking mode. Since that doesn't play
            #  well with makefile() (where wfile and rfile are set in SocketServer.py) we explicitly set
            #  the request socket to blocking
    
            request, client_address = self.socket.accept()
            # logMessage("Accepted: %s" % repr(client_address), 9)
            if hasattr(request,'setblocking'): # Jython doesn't have setblocking
                request.setblocking(1)
            return request, client_address
    
    """CherryPy HTTP Server.
    
    This module builds on BaseHTTPServer in a fashion similar to SimpleHTTPServer 
    by implementing the standard GET and HEAD requests in a fairly straightforward manner.
    
    """
    
    try:
        import timeoutsocket
        _timeoutError = timeoutsocket.Timeout
    except:
        _timeoutError = ''
    
    __all__ = ["CherryHTTPRequestHandler"]
    
    import BaseHTTPServer, mimetypes, Cookie, whrandom, os.path, cPickle
    
    
    class CherryHTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):
    
        """CherryPy HTTP request handler with the following commands:
    
            o  GET
            o  HEAD
            o  POST
            o  HOTRELOAD
    
        """
    
        def address_string(self):
            """ Try to do a reverse DNS based on [server]reverseDNS in the config file """
            if _reverseDNS: return BaseHTTPServer.BaseHTTPRequestHandler.address_string(self)
            else: return self.client_address[0]
    
        def cook_headers(self):
            """Process the headers in self.headers into the request.headerMap"""
            request.headerMap={}
            request.simpleCookie=Cookie.SimpleCookie()
            response.simpleCookie=Cookie.SimpleCookie()
    
            # Build headerMap
            for item in self.headers.items():
                # Warning: if there is more than one header entry for cookies (AFAIK, only Konqueror does that)
                # only the last one will remain in headerMap (but they will be correctly stored in request.simpleCookie)
                _insertIntoHeaderMap(item[0],item[1])
    
            # Handle cookies differently because on Konqueror, multiple cookies come on different lines with the same key
            cookieList = self.headers.getallmatchingheaders('cookie')
            for cookie in cookieList:
                request.simpleCookie.load(cookie)
    
            if not request.headerMap.has_key('remote-addr'):
                try:
                    request.headerMap['remote-addr']=self.client_address[0]
                    request.headerMap['remote-host']=self.address_string()
                except: pass
    
            # Set peer_certificate (in SSL mode) so the web app can examinate the client certificate
            try: request.peerCertificate = self.request.get_peer_certificate()
            except: pass
    
            logMessage("[%s] %s - %s"%((time.strftime("%Y/%m/%d %H:%M:%S")), request.headerMap.get('remote-addr', ''), self.raw_requestline[:-2]))
    
        def do_GET(self):
            """Serve a GET request."""
            request.method = 'GET'
            _parseFirstLine(self.raw_requestline)
            self.cook_headers()
            _doRequest(self.wfile)
    
        def do_HEAD(self): # Head is not implemented
            """Serve a HEAD request."""
            request.method = 'HEAD'
            _parseFirstLine(self.raw_requestline)
            self.cook_headers()
            _doRequest(self.wfile)
    
        def do_POST(self):
            """Serve a POST request."""
            request.method = 'POST'
            _parseFirstLine(self.raw_requestline)
            self.cook_headers()
            _parseIt = 1
            request.parsePostData = 1
            initRequestBeforeParse()
            if request.parsePostData: _parsePostData(self.rfile)
            request.rfile = self.rfile
            _doRequest(self.wfile)
    
        def do_HOTRELOAD(self):
            """Serve a HOTRELOAD request."""
            if _debug:
                logMessage("Starting hot reload ...")
                sys.stdout.flush()
                global hotReload
                hotReload=1
                try: execfile(_outputFile)
                except SystemExit, e: pass
            else:
                logMessage("Hot reload disabled when not in debug mode ...")
    
        if sys.platform[:4]!="java":
             # Don't use this for jython
             def setup(self):
                 """ We have to override this to handle SSL (socket object from the OpenSSL package don't have the makefile method) """
                 self.connection=self.request
                 #self.rfile=self.connection.makefile('rb', self.rbufsize)
                 #self.wfile=self.connection.makefile('wb', self.wbufsize)
                 self.rfile=CherryFileObject(self.connection, 'rb', self.rbufsize)
                 self.wfile=CherryFileObject(self.connection, 'wb', self.wbufsize)
    
        def log_message(self, format, *args):
            """ We have to override this to use our own logging mechanism """
            logMessage("%s - - [%s] %s\n" %
                             (self.address_string(),
                                self.log_date_time_string(),
                                format%args))
    
    
    if sys.platform[:4]!="java":
        # Don't use this for jython
        class CherryFileObject(socket._fileobject):
            def flush(self):
                if self._wbuf:
                    if hasattr(self._sock, "sendall"):
                        if type(self._wbuf)==type([]): # python2.3
                            self._sock.sendall("".join(self._wbuf))
                            self._wbuf=[]
                        else:
                            self._sock.sendall(self._wbuf)
                            self._wbuf=""
                    else:
                        while self._wbuf:
                            _sentChar=self._sock.send(self._wbuf)
                            self._wbuf=self._wbuf[_sentChar:]
            def __del__(self):
                try: self.close()
                except: pass
    
    class CherryThreadingMixIn(SocketServer.ThreadingMixIn):
        def process_request_thread(self, request, client_address):
            """Same as in BaseServer but as a thread.
            In addition, exception handling is done here.
            """
            try:
                self.finish_request(request, client_address)
                self.close_request(request)
            except:
                self.handle_error(request, client_address)
                self.close_request(request)
    
        def process_request(self, request, client_address):
            """Start a new thread to process the request."""
            if _debug:
                for t in threading.enumerate():
                    if t.getName() == "NOT RUNNING":
                        os._exit(-1)
            t = threading.Thread(target = self.process_request_thread, args = (request, client_address))
            if _debug: t.setName("RUNNING")
            t.start()
    
    class CherryHTTPServer(BaseHTTPServer.HTTPServer):
        def __init__(self, server_address, RequestHandlerClass):
            # I know it says "do not override", but I have to in order to implement SSL support !
            SocketServer.BaseServer.__init__(self, server_address, RequestHandlerClass)
            if _sslKeyFile:
                self.socket=SSL.Connection(_sslCtx, socket.socket(self.address_family, self.socket_type))
            else:
                self.socket=socket.socket(self.address_family, self.socket_type)
            self.server_bind()
            self.server_activate()
            initAfterBind()
    
        def server_activate(self):
            """Override server_activate to set timeout on our listener socket"""
            if hasattr(self.socket, 'settimeout'): self.socket.settimeout(2)
            elif hasattr(self.socket, 'set_timeout'): self.socket.set_timeout(2)
            BaseHTTPServer.HTTPServer.server_activate(self)
    
        def server_bind(self):
            # Removed getfqdn call because it was timing out on localhost when calling gethostbyaddr
            self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
            self.socket.bind(self.server_address)
    
        def get_request(self):
            # With Python 2.3 it seems that an accept socket in timeout (nonblocking) mode
            #  results in request sockets that are also set in nonblocking mode. Since that doesn't play
            #  well with makefile() (where wfile and rfile are set in SocketServer.py) we explicitly set
            #  the request socket to blocking
    
            request, client_address = self.socket.accept()
            if hasattr(request,'setblocking'): # Jython doesn't have setblocking
                request.setblocking(1)
            return request, client_address
    
        def handle_request(self):
            """Override handle_request to trap timeout exception."""
            try:
                BaseHTTPServer.HTTPServer.handle_request(self)
            except _timeoutError:
                # The only reason for the timeout is so we can notice keyboard
                # interrupts on Win32, which don't interrupt accept() by default
                return 1
            except KeyboardInterrupt:
                print "<Ctrl-C> hit: shutting down"
                sys.exit(0)
    
        def shutdownCtrlC(self):
            self.shutdown()
    
    def run_server(HandlerClass, ServerClass, server_address, _socketFile):
        """Run the HTTP request handler class."""
        global __myCherryHTTPServer
        if _socketFile:
            try: os.unlink(_socketFile) # So we can reuse the socket
            except: pass
            server_address=_socketFile
        if _threadPool>1:
            __myCherryHTTPServer = ServerClass(server_address, _threadPool, HandlerClass)
        else:
            __myCherryHTTPServer = ServerClass(server_address, HandlerClass)
        if _socketFile:
            try: os.chmod(_socketFile, 0777) # So everyone can access the socket
            except: pass
    
        if _sslKeyFile: servingWhat="HTTPS"
        else: servingWhat="HTTP"
        if _socketPort: onWhat="socket: ('%s', %s)" % (_socketHost, _socketPort)
        else: onWhat="socket file: %s"%_socketFile
        logMessage("Serving %s on %s"%(servingWhat, onWhat))
    
        # If _processPool is more than one, create new processes
        if _processPool>1:
            for i in range(_processPool):
                logMessage("Forking a kid")
                if not os.fork():
                    # Kid
                    initProcess(i)
                    try: __myCherryHTTPServer.serve_forever()
                    except KeyboardInterrupt:
                        print "<Ctrl-C> hit: shutting down"
                        __myCherryHTTPServer.shutdownCtrlC()
        else:
            try: __myCherryHTTPServer.serve_forever()
            except KeyboardInterrupt:
                print "<Ctrl-C> hit: shutting down"
                __myCherryHTTPServer.shutdownCtrlC()
    
    def run(argv):
        mainInit(argv)
        if not globals().has_key('hotReload'):
            # If SSL is used, perform some initialization
            if _sslKeyFile:
                # Setup SSL mode
                global _sslCtx
                _sslCtx=SSL.Context(SSL.SSLv23_METHOD)
                # _sslCtx.set_options(SSL.OP_NO_SSLv2) # Doesn't work on Windows
                _sslCtx.use_privatekey_file(_sslKeyFile)
                _sslCtx.use_certificate_file(_sslCertificateFile)
                if _sslClientCertificateVerification:
                    _sslCtx.set_verify_depth(_sslVerifyDepth)
                    _sslCtx.load_verify_locations(_sslCACertificateFile)
                    _sslCtx.set_timeout(5)
                    def _sslContextCallback(conn, x509, error_num, error_depth, return_val):
                        if error_num == 0: return 1
                        else: return 0
                    _sslCtx.set_verify(SSL.VERIFY_PEER | SSL.VERIFY_FAIL_IF_NO_PEER_CERT, _sslContextCallback)
            
            # If sessions are stored in files and we use threading, we need a lock on the file
            if (_threadPool>1 or _threading) and _sessionStorageType == 'file':
                global _sessionFileLock
                import threading
                _sessionFileLock = threading.RLock()
            
            import SocketServer
            if _socketFile:
                # AF_UNIX socket
                if _forking:
                    class MyCherryHTTPServer(SocketServer.ForkingMixIn,CherryHTTPServer): address_family=socket.AF_UNIX
                elif _threading:
                    import threading
                    class MyCherryHTTPServer(CherryThreadingMixIn,CherryHTTPServer): address_family=socket.AF_UNIX
                else:
                    class MyCherryHTTPServer(CherryHTTPServer): address_family=socket.AF_UNIX
            else:
                # AF_INET socket
                if _forking:
                    class MyCherryHTTPServer(SocketServer.ForkingMixIn,CherryHTTPServer): pass
                elif _threading:
                    class MyCherryHTTPServer(CherryThreadingMixIn,CherryHTTPServer):pass
                elif _threadPool>1:
                    MyCherryHTTPServer=PooledThreadServer
                else:
                    MyCherryHTTPServer=CherryHTTPServer
        
            MyCherryHTTPServer.request_queue_size = _socketQueueSize
    
            # Set protocol_version
            CherryHTTPRequestHandler.protocol_version = _protocolVersion
    
            run_server(CherryHTTPRequestHandler, MyCherryHTTPServer, (_socketHost, _socketPort), _socketFile)
    
    def shutdown():
        __myCherryHTTPServer.shutdown()
    
    

if __name__ == '__main__':
    import sys
    run(sys.argv)
