/* scr.h
 * 
 * This program is distributed under the GNU General Public License.
 * Copyright (C) 2000 Eugene Osintsev <gene@linuxave.net>
 */

#ifndef _SCR_H_
#define _SCR_H_

/* Custom colors */
int C_BITS, C_INFO, C_PANEL, C_MSG, C_ERR;

/* Line drawing symbols */
chtype ULCORNER, URCORNER, LLCORNER, LRCORNER, HLINE, VLINE, LTEE, RTEE;
chtype LARROW, RARROW, DARROW, UARROW;

/* Macro for Ctrl-c where `c' is some letter */
#define C(c)		(0x1f & (c))

/* CFE screen initialization.
 * is_ascii  - is ASCII line drawing?
 * is_bw     - is black and white display?
 */
void cfe_init_scr(int is_ascii, int is_bw);

/* Show alert message */
void alert(const char *str);

/* Show normal message */
void message(const char *str);

/* Show resize message with suggested cols and lines.
 * WARNING: not redrawed by draw_message() !
 */
void resize_message(int cols, int lines);

/* Draw either of above-mentioned messages */
void draw_message();

/* Frame drawing.
 * Includes glyph drawing function. */
void draw_frame();

/* Glyph drawing function */
void draw_glyph();

/* Checks if window size is valid.
 *  chk = 1 -- forces check and prints error message if check failed
 *  chk = 0 -- returns previous check result
 */
int chk_win_size(int chk);

#endif  /* _SCR_H_ */


/* EOF */
