/* PSSettings.m
 * settings panel for project settings
 *
 * Copyright 1996-2003 by vhf interservice GmbH
 * Author: Georg Fleischmann
 *
 * Created:  2000-06-26
 * Modified: 2003-04-25
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include "ProjectSettings.h"
#include "PSSettings.h"
#include "../App.h"
#include "../Document.h"


@interface PSSettings(PrivateMethods)
@end

@implementation PSSettings

- (id)init
{
    [super init];

    if ( ![NSBundle loadNibNamed:@"PSSettings" owner:self] )
    {   NSLog(@"Cannot load 'PSSettings' interface file");
        return nil;
    }

    [unitPopup setAction:@selector(setUnit:)];

    [self update:self];

    return self;
}

/* the sender is out document or nil
 */
- (void)update:sender
{   id	doc = ([sender isKindOfClass:[Document class]]) ? sender : [(App*)NSApp currentDocument];

    docView = [doc documentView];

    /* set index of unit popup */
    //[unitPopup selectItemAtIndex:[docView unit]];
}

- (NSString*)name	{ return @"Settings"; }
- (NSView*)view		{ return view; }

- (void)set:sender
{
}

/* set unit
 */
/*- (void)setUnit:sender
{   int	unit = [sender indexOfSelectedItem];

    [docView setUnit:unit];
}*/

@end
