/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <ncurses.h>
#include <fcntl.h>
#include <nl_types.h>
#include <linux/cdrom.h>
#include "options.h"
#include "gettext.h"
#include "config.h"
#include "zlib.h"


struct conf config;
WINDOW *logwin, *logmain;

int dialogbox(char *message, char *title, int type)
{
	WINDOW *dialog;
	int line=3, n, i, c, button=0, bg_color, maxline=0, maxwidth=30;
	char temp[50];
	
	temp[0]='\0'; n=0;
	for (i=0; i<strlen(message); i++){
		if ( message[i]!='\n' ) 
			temp[n++]=message[i];
		if ( ( message[i]=='\n' ) || ( i==strlen(message)-1 ) || ((n>30) && message[i]==' ')){
			temp[n]='\0';
			if ( maxwidth<strlen(temp)+8 ) maxwidth=strlen(temp)+8;
			temp[0]='\0';
			n=0;
			if ( message[i]=='\n' ) maxline++;
		}
	}

	switch (type){
		case 0:
		  bg_color=2;
		  break;
		case 3:
		  bg_color=10;
		  break;
	}
	dialog=newwin(9+maxline,maxwidth,(LINES-(9+maxline))/2,(COLS-maxwidth)/2);
	wbkgd(dialog, COLOR_PAIR(bg_color));
	werase(dialog);
	box(dialog,0,0);
	keypad(dialog, TRUE);
	mvwaddch(dialog, 0, 2, ACS_RTEE);
	mvwprintw(dialog, 0, 3, " %s ", title);
        waddch(dialog, ACS_LTEE);
	
	temp[0]='\0'; n=0;
	for (i=0; i<strlen(message); i++){
		if ( message[i]!='\n' ) 
			temp[n++]=message[i];
		if ( ( message[i]=='\n' ) || ( i==strlen(message)-1 ) || ((n>30) && message[i]==' ')){
			temp[n]='\0';
			mvwprintw(dialog, line++, (maxwidth-strlen(temp))/2, temp);
			temp[0]='\0';
			n=0;
		}
	}
	if (type==0) {
		wattrset(dialog, COLOR_PAIR(6));	
		mvwprintw(dialog, 6+maxline, (getmaxx(dialog)-strlen(_("Ok")))/2, "[ %s ]", _("Ok"));
	}
	if (type==3) {
		wattrset(dialog, COLOR_PAIR(6));	
		mvwprintw(dialog, 6+maxline, 8, "[ %s ]", _("Ok"));
		wattrset(dialog, COLOR_PAIR(bg_color));	
		mvwprintw(dialog, 6+maxline, (maxwidth-12)-strlen(_("Cancel")), "[ %s ]", _("Cancel"));
	}
	wrefresh(dialog);
	while ( ((c=mvwgetch(dialog, 8+maxline, maxwidth-1))!=27) && ( c!=10) ){
	    if (type==3) {
	    switch(c){
		case KEY_RIGHT:
		    if ( button == 0 ){
			wattrset(dialog, COLOR_PAIR(bg_color));	
			mvwprintw(dialog, 6+maxline, 8, "[ %s ]", _("Ok"));
			wattrset(dialog, COLOR_PAIR(6));	
			mvwprintw(dialog, 6+maxline, (maxwidth-12)-strlen(_("Cancel")), "[ %s ]", _("Cancel"));
			button=1;
		    }
		    break;
		case KEY_LEFT:
		    if ( button == 1 ){
			wattrset(dialog, COLOR_PAIR(6));	
			mvwprintw(dialog, 6+maxline, 8, "[ %s ]", _("Ok"));
			wattrset(dialog, COLOR_PAIR(bg_color));	
			mvwprintw(dialog, 6+maxline, (maxwidth-12)-strlen(_("Cancel")), "[ %s ]", _("Cancel"));
			button=0;
		    }
		    break;
	    }
	    }
	    wrefresh(dialog);
	}
	if ( c==27 ) button=1;
	delwin(dialog);
	return button;
}


void eject_tray(char *device)
{
    int cddev;
    
    if ( (cddev=open(device, O_RDONLY | O_NONBLOCK)) != -1 ){
	ioctl(cddev, CDROMEJECT);
	close(cddev);
    }
}

void read_lines(int pos, int left, char *infile)
{
    int linenum=0, x=0, fill;
    char *line, *oldline;
    FILE *log;
    
    if ( (log=fopen(infile,"r") )==NULL ) {
	endwin();
	fprintf(stderr, _("Cannot open file..."));
	exit(-1);
    }
    line=(char *)malloc(1024);
    oldline=(char *)malloc(1024);

    while ( (linenum <= pos+18) && ((line=fgets(line, 256, log))!=NULL) ){
	    if (linenum>=pos) {
		    for (fill=0; fill<strlen(line); fill++)
			    if ( line[fill]=='\t' ) {
				    line[fill]=' ';
				    strcpy(oldline, line);
				    oldline[fill]='\0';
				    sprintf(line, "%s", line+fill);
				    sprintf(oldline, "%s        %s", oldline, line);
				    sprintf(line, "%s", oldline);
			    }
		    if ( strlen(line)>=left ) 
			    mvwprintw(logmain, x++, 0, "%s", (char *)line+left);
		    else 
			    mvwprintw(logmain, x++, 0, " ");
	    }
	    linenum++;
    }
    fclose(log);
    free(line);
}

void log_window(char *title, char *infile, int is_zipped)
{
    int c, pos=0, left=0, maxline=0;
    char *line;
    FILE *log;
    int spos;
    
    if ( (log=fopen(infile, "r"))!=NULL ) {
	line=(char *)malloc(256);
	while ( (fgets(line, 250, log)!=NULL) ){
		maxline++;
	}
	fclose(log);
	logwin=newwin(20,76,(LINES-20)/2,(COLS-76)/2);
	wbkgd(logwin, COLOR_PAIR(2));
	werase(logwin);
	box(logwin,0,0);
	keypad(logwin, TRUE);
	logmain=newwin(18,72,(LINES-18)/2,((COLS-72)/2)-1);
	wbkgd(logmain, COLOR_PAIR(6));
	werase(logmain);
	keypad(logmain, TRUE);
	mvwaddch(logwin, 0, 2, ACS_RTEE);
	mvwprintw(logwin, 0, 3, " %s ", title);
        waddch(logwin, ACS_LTEE);

	read_lines(pos, left, infile);    
	wrefresh(logwin);    
	wrefresh(logmain);    

	while ( (c=wgetch(logmain))!=27 ){
	    switch(c){
		case KEY_DOWN:
		    if ( pos+18<maxline) {
			werase(logmain);
			read_lines(++pos, left, infile);
		    }
		    break;
		case KEY_UP:
		    if ( pos>0 ) {
			werase(logmain);
			read_lines(--pos, left, infile);
		    }
		    break;
		case KEY_RIGHT:
		    werase(logmain);
		    read_lines(pos, ++left, infile);
		    break;
		case KEY_LEFT:
		    if ( left>0 ) {
			werase(logmain);
			read_lines(pos, --left, infile);
		    }
		    break;
	    }
	    wrefresh(logmain);
	}
	delwin(logmain);
	delwin(logwin);
    }
}
