
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

//#define DEBUG

#include "bristol.h"

static float *tmpbuf1 = (float *) NULL;

#define VOX_VIBRA 0x01

extern int bristolGlobalController(struct BAudio *, u_char, u_char, float);

int
voxGlobalController(Baudio *baudio, u_char controller,
u_char operator, float value)
{
	/*
	 * Vox global controller code.
	 */
	printf("voxGlobalController(%x, %i, %i, %f)\n",
		baudio, controller, operator, value);

	if (controller == 126)
	{
		switch (operator) {
			case 0:
				if (value == 0)
					baudio->mixflags &= ~VOX_VIBRA;
				else
					baudio->mixflags |= VOX_VIBRA;
				break;
		}
	}
}

operateVoxPostops(audioMain *audiomain, Baudio *baudio,
bristolVoice *voice, register float *startbuf)
{
	int i, flags, samplecount = audiomain->samplecount;
	float *bufptr = baudio->rightbuf;

#ifdef DEBUG
	printf("operateVoxPostops(%x, %x, %x) %i\n",
		baudio, voice, startbuf, baudio->cvoices);
#endif

	if (baudio->mixlocals == NULL)
		((void *) baudio->mixlocals) = voice->locals[voice->index];

	/*
	 * Run the ADSR for the percussives. We have to play about a little, since
	 * this envelope should be keyed on when a single voice activates, and then
	 * remain on until the last key is released, ie, there should be no 
	 * retriggers for each key.
	if ((*baudio->sound[4]).param->param[2].float_val != 0)
		return;
	 */

/*
	flags = voice->flags;
	if (baudio->lvoices != 0)
	{
		if (flags & BRISTOL_KEYON)
			voice->flags &= ~BRISTOL_KEYON;
		if (flags & BRISTOL_KEYREON)
			voice->flags &= ~BRISTOL_KEYREON;
		if (flags & BRISTOL_KEYOFF)
			voice->flags &= ~BRISTOL_KEYOFF;
	}
	if (flags & (BRISTOL_KEYON|BRISTOL_KEYREON))
	{
		if (baudio->lvoices != 0)
			voice->flags &= ~(BRISTOL_KEYON|BRISTOL_KEYREON);
	} else if (flags & BRISTOL_KEYOFF) {
		if (baudio->lvoices != 1)
			voice->flags &= ~BRISTOL_KEYOFF;
	}
*/

	if (baudio->mixflags & VOX_VIBRA)
	{
		audiomain->palette[(*baudio->sound[1]).index]->specs->io[0].buf =
			baudio->leftbuf;
		audiomain->palette[(*baudio->sound[1]).index]->specs->io[1].buf =
			baudio->leftbuf;
		(*baudio->sound[1]).operate(
			(audiomain->palette)[13],
			voice,
			(*baudio->sound[1]).param,
			((void **) baudio->mixlocals)[1]);
	}

	bristolbzero(baudio->rightbuf, audiomain->segmentsize);
}

/*
 * Operate one vox voice.
 */
operateOneVoxVoice(audioMain *audiomain, Baudio *baudio,
bristolVoice *voice, register float *startbuf)
{
	int i, samplecount = audiomain->samplecount;
	float *bufptr = tmpbuf1;

#ifdef DEBUG
	printf("operateOneVoxVoice(%x, %x, %x)\n",
		baudio, voice, startbuf);
#endif

	bristolbzero(startbuf, audiomain->segmentsize);

	bufptr = tmpbuf1;

	/*
	 * Fill the wavetable with the correct note value
	 */
	fillFreqTable(baudio, voice, tmpbuf1, samplecount, 0);

	/*
	 * Run the oscillator
	 */
	audiomain->palette[(*baudio->sound[0]).index]->specs->io[0].buf = tmpbuf1;
	audiomain->palette[(*baudio->sound[0]).index]->specs->io[1].buf = 
		baudio->leftbuf;

	(*baudio->sound[0]).operate(
		(audiomain->palette)[17],
		voice,
		(*baudio->sound[0]).param,
		voice->locals[voice->index][0]);

	if (voice->flags & BRISTOL_KEYOFF)
		voice->flags |= BRISTOL_KEYDONE;
}

destroyOneVoxVoice(audioMain *audiomain, Baudio *baudio)
{
	bristolfree(tmpbuf1);

	baudio->mixlocals = NULL;
}

bristolVoxInit(audioMain *audiomain, Baudio *baudio)
{
printf("initialising one vox sound\n");

	baudio->soundCount = 2; /* Number of operators in this vox voice */

	/*
	 * Assign an array of sound pointers.
	 */
	baudio->sound = (bristolSound **)
		bristolmalloc0(sizeof(bristolOP *) * baudio->soundCount);
	baudio->effect = (bristolSound **)
		bristolmalloc0(sizeof(bristolOP *) * baudio->soundCount);

	if ((audiomain->debuglevel & BRISTOL_DEBUG_MASK) > BRISTOL_DEBUG3)
		printf("malloced sound: %x\n", baudio->sound);
	/*
	 * Vox oscillator
	 */
	initSoundAlgo(17, 0, baudio, audiomain, baudio->sound);
	/*
	 * Add in a vibrachorus - it will be configured to provide only vibra
	 */
	initSoundAlgo(13, 1, baudio, audiomain, baudio->sound);

	baudio->param = voxGlobalController;
	baudio->destroy = destroyOneVoxVoice;
	baudio->operate = operateOneVoxVoice;
	//baudio->preops = operateVoxPreops;
	baudio->postops = operateVoxPostops;

	/*
	 * Get some workspace
	 */
	if (tmpbuf1 == (float *) NULL)
	{
		tmpbuf1 = (float *) bristolmalloc0(audiomain->segmentsize);
	}
}

