
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#define KEY_COUNT 61
#define KEY_COUNT_3OCTAVE 44
#define VKEY_COUNT 48
#define KEY_COUNT_5OCTAVE KEY_COUNT
#define KEY_COUNT_6OCTAVE 73

/*
 * This whole definition should be moved into a separate routine, and called
 * for a given keyboard size - 37 note (three oct), 61 note (5 oct) or a full
 * 88 keys. Should also consider 73 note for a Rhodes....
 */
#define KW 1000 / 36
#define FKW 995 - 35 * KW

#define KMW 14
#define KIW 28
#define KIH 600
#define KIL 410
#define KIS 0

static brightonLocations keys[KEY_COUNT_5OCTAVE] = {
	{"", 2, 0 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 0 * KW, 0, KIW + 7, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 1 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 1 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 2 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 3 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 3 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 4 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 4 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 5 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 5 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 6 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 7 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 7 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 8 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 8 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 9 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 10 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 10 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 11 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 11 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 12 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 12 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 13 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 14 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 14 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 15 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 15 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 16 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 17 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 17 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 18 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 18 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 19 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 19 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 20 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 21 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 21 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 22 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 22 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 23 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 24 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 24 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 25 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 25 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 26 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 26 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 27 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 28 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 28 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 29 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 29 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 30 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 31 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 31 * KW, 0, KIW + 10, KIH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 32 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 32 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 33 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 33 * KW + 25, 0, KMW, KIH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 34 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 35 * KW, 0, FKW, 1000, 0, 1, 0,
		"bitmaps/keys/whitelup.xpm", "bitmaps/keys/whiteldown.xpm", 0},
};

#define K6W 1000 / 43
#define F6KW 995 - 42 * KW

#define K6MW 13
#define K6IW 22
#define K6IH 600
#define K6IL 410
#define K6IS 20

static brightonLocations keys6octave[KEY_COUNT_6OCTAVE] = {
	{"", 2, 0 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 0 * K6W, 0, K6IW + 7, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 1 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 1 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 2 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 3 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 3 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 4 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 4 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 5 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 5 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 6 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 7 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 7 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 8 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 8 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 9 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 10 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 10 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 11 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 11 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 12 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 12 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 13 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 14 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 14 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 15 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 15 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 16 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 17 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 17 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 18 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 18 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 19 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 19 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 20 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 21 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 21 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 22 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 22 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 23 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 24 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 24 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 25 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 25 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 26 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 26 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 27 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 28 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 28 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 29 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 29 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 30 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 31 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 31 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 32 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 32 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 33 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 33 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 34 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 35 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 35 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 36 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 36 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 37 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 38 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 38 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 39 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 39 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 40 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 40 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 41 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 42 * K6W, 0, 22, 1000, 0, 1, 0,
		"bitmaps/keys/whitelup.xpm", "bitmaps/keys/whiteldown.xpm", 0},
};

static brightonLocations keys6hammond[KEY_COUNT_6OCTAVE] = {
	{"", 2, 0 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 0 * K6W, 0, K6IW + 7, K6IH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 1 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 1 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 2 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 3 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 3 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 4 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 4 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 5 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 5 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 6 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},

	{"", 2, 7 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 7 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 8 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 8 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 9 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 10 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 10 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 11 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 11 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 12 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 12 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 13 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 14 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 14 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 15 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 15 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 16 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 17 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 17 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 18 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 18 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 19 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 19 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 20 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 21 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 21 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 22 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 22 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 23 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 24 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 24 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 25 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 25 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 26 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 26 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 27 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 28 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 28 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 29 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 29 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 30 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 31 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 31 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 32 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 32 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 33 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 33 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 34 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 35 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 35 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 36 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 36 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 37 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 38 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 38 * K6W, 0, K6IW + 10, K6IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 39 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 39 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 40 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 40 * K6W + K6IS, 0, K6MW, K6IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 41 * K6W, K6IH, K6W, K6IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 42 * K6W, 0, 22, 1000, 0, 1, 0,
		"bitmaps/keys/whitelup.xpm", "bitmaps/keys/whiteldown.xpm", 0},
};

#define K3W 1000 / 26

#define K3MW 18
#define K3IW 40
#define K3IH 600
#define K3IL 410
#define K3IS 33

#define K2S 35

static brightonLocations keys3octave[KEY_COUNT_3OCTAVE] = {
	{"", 2, 0 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 0 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 1 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 1 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 2 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 2 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 3 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 4 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 4 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 5 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 5 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 6 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 7 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 7 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 8 * K3W, KIH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 8 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 9 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 9 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 10 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 11 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 11 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 12 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 12 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 13 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 14 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 14 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 15 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 15 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 16 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 16 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 17 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 18 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 18 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 19 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 19 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 20 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},

	{"", 2, 21 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 21 * K3W, 0, K3IW + 10, K3IH, 0, 1, 0,
		"bitmaps/keys/blackup.xpm", "bitmaps/keys/blackdown.xpm", 0},
	{"", 2, 22 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 22 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 23 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 23 * K3W + K3IS, 0, K3MW, K3IH, 0, 1, 0,
		"bitmaps/keys/blackmup.xpm", "bitmaps/keys/blackmdown.xpm", 0},
	{"", 2, 24 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/keys/whiteup.xpm", "bitmaps/keys/whitedown.xpm", 0},
	{"", 2, 25 * K3W, 0, K3W - 4, 1000, 0, 1, 0,
		"bitmaps/keys/whitelup.xpm", "bitmaps/keys/whiteldown.xpm", 0},
};

#define KVW 1000 / 28

#define KVMW 18
#define KVIW 40
#define KVIH 600
#define KVIL 410
#define KVIS 33

#define K2S 35

static brightonLocations vkeys[VKEY_COUNT] = {
	{"", 2, 0 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 0 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 1 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 1 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 2 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 3 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 3 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 4 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 4 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 5 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 5 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 6 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},

	{"", 2, 7 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 7 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 8 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 8 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 9 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 10 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 10 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 11 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 11 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 12 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 12 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 13 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},

	{"", 2, 14 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 14 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 15 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 15 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 16 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 17 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 17 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 18 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 18 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 19 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 19 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 20 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},

	{"", 2, 21 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 21 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 22 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 22 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 23 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 24 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 24 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", 0},
	{"", 2, 25 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 25 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 26 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
	{"", 2, 26 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", 0},
	{"", 2, 27 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", 0},
};

static brightonLocations mods[2] = {
	{"", 1, 285, 180, 90, 640, 0, 1, 0, 0, 0, BRIGHTON_CENTER|BRIGHTON_NOSHADOW},
	{"", 1, 650, 180, 90, 640, 0, 1, 0, 0, 0, BRIGHTON_NOSHADOW},
};

static int
modCallback(void *cid, int panel, int index, float value)
{
	guiSynth *synth = findSynth(global.synths, (int) cid);

//	printf("modCallback(%x, %i, %i, %f)\n", synth, panel, index, value);

	/*
	 * If this is controller 0 it is the frequency control, otherwise a 
	 * generic controller 1.
	 */
	if (index == 0)
		bristolMidiSendMsg(global.controlfd, synth->midichannel,
			BRISTOL_EVENT_PITCH, 0, (int) (value * C_RANGE_MIN_1));
	else {
		bristolMidiControl(global.controlfd, synth->midichannel,
			0, 1, ((int) (value * C_RANGE_MIN_1)) >> 7);
	}
}

static int
keyCallback(void *cid, int panel, int index, float value)
{
	guiSynth *synth = findSynth(global.synths, (int) cid);

//	printf("keycallback(%x, %i, %i, %f): %i %i\n", synth, panel, index, value,
//		synth->transpose, global.controlfd);

	/*
	 * Want to send a note event, on or off, for this index + transpose.
	 */
	if (value)
		bristolMidiSendMsg(global.controlfd, synth->midichannel,
			BRISTOL_EVENT_KEYON, 0, index + synth->transpose);
	else
		bristolMidiSendMsg(global.controlfd, synth->midichannel,
			BRISTOL_EVENT_KEYOFF, 0, index + synth->transpose);
}

