#ifndef _SONGITERATOR_H_
#define _SONGITERATOR_H_

#include "compound.h"
#include "position.h"

class Song;
class Track;
class Part;
class Event;
class Note;
class PrPartEditor;

#define MAXEVENTS 128

class SongIterator {
 private:
  Song    * _song;
  Track  ** _track; 
  Part   ** _part;
  Part   ** _new_part;
  Event  ** _event;
  Position  _left;
  Position  _right;
  int       _tracks;

  Note * _mem[MAXEVENTS];
  long   _offset[MAXEVENTS];
  int    _chan[MAXEVENTS];
  int    _num[MAXEVENTS];
  int    _memref;
  int    _memtop;

 public:
  SongIterator(const SongIterator& i);
  
  SongIterator(Song * song, Position left = 0, Position right = 0);

  void init(Position left = 0, Position right = 0);

  bool operator!=(const SongIterator& i) const;
  
  bool operator==(const SongIterator& i) const;
  
  bool done(int i=-1);
  
  Position start(int);
  
  bool startsAt(int i, long p);
  
  Element * operator[](int n);
  
  void increment(int);

  Part * change(int);
  
  Track * track(int);

  int channel(int);

  int program(int);

  bool mute(int);


  void activate(int i);

  bool activeEndsAt(long p);

  Note * activeNote();
  
  int activeChannel();

  int activeTrack();

  void cutActive();
  
};

#endif
