#ifndef _TRACKLABEL_CPP_
#define _TRACKLABEL_CPP_

#include <iostream.h>

#include <klocale.h>

#include <qpopupmenu.h>
#include <qlineedit.h>
#include <qcolor.h>

#include "trackLabel.h"
#include "kdeTrack.h"
#include "kdeMainEditor.h"

#include "song.h"
#include "part.h"
#include "track.h"
#include "str.h"
#include "removeElement.h"
#include "prMainEditor.h"
#include "addElement.h"
#include "addon.h"
#include "reference.h"
#include "newSelection.h"
#include "addToSelection.h"
#include "removeFromSelection.h"
#include "table.h"

extern Table * selectioN;
extern Song * sonG;
extern PrMainEditor * mainEditor;
#define ME ((KdeMainEditor*)mainEditor)


TrackLabel::TrackLabel( QWidget * parent , const char * name  )
  : QLabel(parent,name), _track((KdeTrack*)parent)
{
  _rbmenu = new QPopupMenu;
  buildMenu();
}

void TrackLabel::buildMenu() {
  _rbmenu->clear();
  _rbmenu->setMouseTracking( TRUE );
  _rbmenu->connectItem( _rbmenu->insertItem(i18n("Change Trackname")), this, SLOT(changeName()) );
  _rbmenu->connectItem( _rbmenu->insertItem(i18n("Add Part")), this, SLOT(addPart()) );
  _rbmenu->insertSeparator();
  char ** alist = ME->actionList();
  char ** clist = ME->categories();
  for (int i=0;clist[i]!=0;i++) {
    int * nlist = ME->actionListByCategory(clist[i]);
    QPopupMenu * catMenu = new QPopupMenu();
    for (int k=0;nlist[k]!=-1;k++) {
      if (ME->actionContext(nlist[k])&Addon::TREAT_TRACK) catMenu->insertItem(alist[nlist[k]],nlist[k]);
    }
    if (catMenu->count()>0) {
      _rbmenu->insertItem(clist[i],catMenu,i);
      connect(catMenu,SIGNAL(activated(int)),SLOT(slotAddon(int)));
    }
  }

  _rbmenu->insertSeparator();
  _rbmenu->connectItem( _rbmenu->insertItem(i18n("Delete Track")), this, SLOT(delTrack()) );
  
  setBackgroundMode(QWidget::PaletteBackground);
}

void TrackLabel::slotAddon(int i) {
  if (ME->actionList()[0] != 0) {
    ME->performAction( i, _track->track() );
  }
}

void TrackLabel::mousePressEvent ( QMouseEvent * mouse ) {
  if (mouse->button()==LeftButton) {
    Track * tr = _track->track();
    if (ME->selectArea()!=TRACKS) {
      //
      // new selection:
      //
      sonG->doo(new NewSelection(new Reference(tr)));
      ME->selectArea(TRACKS);
    } else {
      //
      // add / remove to / from selection:
      //
      if (mouse->state() & ShiftButton) {
	if (selectioN->hasEntry(tr)) sonG->doo(new RemoveFromSelection(new Reference(tr)));
	else                         sonG->doo(new AddToSelection(new Reference(tr)));
      } else {
	sonG->doo(new NewSelection(new Reference(tr)));
      }
    }
    ME->update();
  } else if (mouse->button()==RightButton) {
    _rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
  }
}

void TrackLabel::changeName() { 
  _le = new QLineEdit(this,_track->track()->name()->getValue());
  _le->setText((char*)_track->track()->name()->getValue());
  _le->setFixedHeight(height()-2); _le->setFixedWidth(width()-8);
  _le->show();
  _le->setActiveWindow();
  _le->selectAll();
  _le->setFocus();
  connect(_le,SIGNAL(returnPressed()),SLOT(setName()));
}

void TrackLabel::addPart() {
  Part * pt = new Part(_track->track());
  sonG->doo(new AddElement(pt,_track->track()));
  pt->reorder();
  ME->update();
}

void TrackLabel::setName() {
  _track->track()->setName((char*)_le->text().ascii());
  _track->update();
  delete _le;
}

void TrackLabel::delTrack() {
  sonG->doo(new RemoveElement(_track->track(),sonG));
  ME->update();
}



#endif
#include "trackLabel.moc"
