#ifndef _KDEEDITINFO_CPP_
#define _KDEEDITINFO_CPP_

#include <iostream.h>

#include <qpixmap.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qcombobox.h>

#include <song.h>

#include "kdeEditInfo.h"

#include "prPartEditor.h"
#include "prScoreEditor.h"
#include "note.h"
#include "part.h"
#include "track.h"
#include "iterator.h"
#include "scoreBar.h"
#include "prMainEditor.h"

#include "kdeScoreEditor2.h"
#include "kdeScoreContent2.h"

extern PrMainEditor * mainEditor;
extern Song * sonG;

const char * STR_VOLUME = "volume";

KdeEditInfo::KdeEditInfo( QWidget * parent, PrPartEditor * ed )
  : QFrame(parent,"info",QFrame::Raised), _editor(ed), _xoffset(80), _pressX(0), _pressY(0), _moveX(0), _moveY(0), _grabX(-1), _mode(EDIT_VOLUME)
{
    setCursor(QCursor(2));
    setMouseTracking(TRUE);
    
    ctrl = new QComboBox(FALSE,this,"control");
    ctrl->insertItem(STR_VOLUME);
    char * nam = 0;
    for (int i=0; (nam = mainEditor->description(i))!=0; i++) {
      if (mainEditor->actionTrack(i)!=0) ctrl->insertItem(nam);
    }
    connect(ctrl, SIGNAL(activated(int)), SLOT(update(int)));
    ctrl->setGeometry(20,40,_xoffset-24,24);
    ctrl->show();
    ctrl->clearFocus();
}

void KdeEditInfo::paintEvent( QPaintEvent * ) {
  QPixmap pix( width(), height() );
  pix.fill( this, 10,10 );
  QPainter painter;
  painter.begin( &pix );
  
  int ht = height();
  scl = (ht-10.0)/128;

  Part * _part = _editor->part();

  int vel = 0;
  int xx = 0;
  int xxx = width()-20;
  Position pos;
  long _leftPos = _editor->left().ticks();
  long _rightPos = _editor->right().ticks();


  const char * select = ctrl->currentText();
  if (strcmp(select,STR_VOLUME)==0) {
    _mode = EDIT_VOLUME;
  } else {
    _mode = USER_TRACK;
  }

  if (_editor->isScoreEditor()) {
    Note * note;
    
    if (_mode == EDIT_VOLUME) {
      for (Iterator i = Iterator(_part); !i.done(); i++) {
	if ((*i)->isA() == NOTE) {
	  note = (Note*) *i;
	  xx = ((PrScoreEditor*)_editor)->xposition( _part->start(note).ticks() );
	  if (xx>=_xoffset && xx<xxx) {
	    vel = note->vel();
	    if (note==_grab && _grabX2-_grabX<17) { vel = 128 - int(_moveY/scl); painter.setPen(Qt::red); }
	    // xx = long((pos-_leftPos)*pixPerTick + _xoffset);
	    painter.drawRect(3+xx, ht-10, 3, -int(vel*scl));
	    if (note==_grab && _grabX2-_grabX<17) painter.setPen(Qt::black);
	  }
	}
      }
    } else {
      //
      // find addon track
      //
      Track * tr = sonG->getTrack(select);
      if (tr!=0) {
	Part * pt = 0;
	Event * ev = 0;
	for (Iterator i = Iterator(tr, _leftPos, _rightPos); !i.done(); i++) {
	  pt = i.part();
	  ev = (Event*) *i;
	  xx = ((PrScoreEditor*)_editor)->xposition( pt->start(ev).ticks() );
	  const char * txt = ev->value();
	  if (txt!=0) painter.drawText(xx, ht-30, txt);
	}
      }
    }



  } else {

    double pixPerTick = (xxx-_xoffset-4.0)/(_rightPos-_leftPos);
    Note * note;
    
    bool loop = true;
    for (Iterator i = Iterator(_part); !i.done() && loop; i++) {
      if ((*i)->isA() == NOTE) {
	note = (Note*) *i;
	pos = _part->start(note);
	vel = note->vel();
	if (note==_grab && _grabX2-_grabX<17) { vel = 128 - int(_moveY/scl); painter.setPen(Qt::red); }
	xx = long((pos-_leftPos)*pixPerTick + _xoffset);
	painter.drawRect(xx+1,ht-10,3,-int(vel*scl));
	if (note==_grab && _grabX2-_grabX<17) painter.setPen(Qt::black);
      }
    }
  }

  if (_grabX>-1 && _grabX2-_grabX>16) {
    painter.setPen(Qt::DashLine);
    painter.drawLine(_pressX,_pressY,_moveX,_moveY);
    painter.setPen(Qt::SolidLine);
  }

  painter.end();
  bitBlt( this, 0, 0, &pix );

}

void KdeEditInfo::mousePressEvent( QMouseEvent * me ) {
  _pressX = me->x();
  _pressY = me->y();
  
  if (_mode==EDIT_VOLUME) {
    //
    // EDIT VOLUME
    //
    if (_editor->isScoreEditor()) {
      ScoreArea area;
      _grabX = ((PrScoreEditor*)_editor)->ticks(_pressX, area);
    } else {
      double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
      _grabX = int((_pressX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
    }
    if (_grabX<0) _grabX = 0;
    _grabX2 = _grabX;
    _grab = _editor->getGrabEvent(_grabX);
    if (_grab && _grab->isA()==NOTE)
      _oldVel = ((Note*)_grab)->vel();
    else
      _oldVel = 0;
  }
}

void KdeEditInfo::mouseMoveEvent( QMouseEvent * me ) {
  _moveX = me->x();
  _moveY = me->y();
  if (_moveX < _xoffset) setCursor(QCursor(0));
  else                   setCursor(QCursor(2));

  if (_mode==EDIT_VOLUME) {
    //
    // EDIT VOLUME
    //
    if (_grabX != -1) {
      if (_editor->isScoreEditor()) {
	ScoreArea area;
	_grabX2 = ((PrScoreEditor*)_editor)->ticks(_moveX, area);
      } else {
	double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
	_grabX2 = int((_moveX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
      }
      if (_grabX2<0) _grabX2 = 0;
      repaint(FALSE);
    }
  }
}

void KdeEditInfo::mouseReleaseEvent( QMouseEvent * me ) {
  if (_mode==EDIT_VOLUME) {
    //
    // EDIT VOLUME
    //
    if (_grabX2-_grabX<17) {
      if (_grab && _grab->isA()==NOTE) ((Note*)_grab)->setVel(128 - int(_moveY/scl));
    } else {
      if (_editor->isScoreEditor()) {
	ScoreArea area;
	_grabX2 = ((PrScoreEditor*)_editor)->ticks(_moveX, area);
      } else {
	double pixPerTick = (width()-_xoffset-24.0)/(_editor->right().ticks()-_editor->left().ticks());
	_grabX2 = long((_moveX-_xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
      }
      int value1 = 128 - int(_pressY/scl);
      int value2 = 128 - int(me->y()/scl);
      // cout << _grabX << ", " << value1 << ", " << _grabX2 << ", " << value2 << endl;
      double coeff = (value2-value1)*1.0/(_grabX2-_grabX);
      Part * _part = _editor->part();
      
      Note * note;
      bool ok = true;
      for (Iterator i = Iterator(_part,_grabX,_grabX2); !i.done() && ok; i++) {
	if ((*i)->isA() == NOTE) {
	  note = (Note*) *i;
	  long x = _part->start(note).ticks();
	  if (x > _grabX2) ok = false;
	  int newval = value1 + int(coeff*(x - _grabX));
	  note->setVel(newval);
	}
      }
    }
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeEditInfo::update(int) {
  repaint(FALSE);
}

#endif
#include "kdeEditInfo.moc"
