#ifndef _POSITION_C_
#define _POSITION_C_

#include <stdlib.h>
#include <iostream.h>
#include <string.h>
#include "position.h"

#include "track.h"
#include "part.h"
#include "song.h"
#include "masterEvent.h"
#include "tuplet.h"


extern Song * sonG;


Position::Position() : totalTicks(0) { _type = POSITION; }

Position::Position(long p) : totalTicks(p) {
  _type = POSITION;
}

Position::Position(int p, int b, int t) {
  set(p,b,t,sonG->master(),sonG->meter0(),sonG->meter1(),0);
  _type = POSITION;
}

Position::Position(char * line,int) {
  _type = POSITION;
  int a = 1;
  int b = 1;
  int c = 0;
  if (line!=0) {
    a = atoi(line);
    int len = strlen(line);
    int dots = 0;
    for (int i=0; i<len; i++) if (line[i]=='.') dots++;
    if (dots>0) {
      char * ptrB = line;
      char * ptrC = line;
      while (ptrB[0]!='.') ptrB++;
      ptrB++;
      b = atoi(ptrB);
      if (dots>1) {
	ptrC = ptrB;
	while (ptrC[0]!='.') ptrC++;
	ptrC++;
	c = atoi(ptrC);
      }
    }
  }
  set(a,b,c,sonG->master(),sonG->meter0(),sonG->meter1(),0);
}

/*
Position::Position(int p, int b, int t, Part * master,int m0, int m1) {
  set(p,b,t,master,m0,m1,0);
  _type = POSITION;
}

Position::Position(int p, int b, int t, int m0, int m1) {
  set(p,b,t,0,m0,m1,0);
  _type = POSITION;
}

Position::Position(char * line, Part * master,int m0, int m1) {
  _type = POSITION;
  int a = 1;
  int b = 1;
  int c = 0;
  if (line!=0) {
    a = atoi(line);
    int len = strlen(line);
    int dots = 0;
    for (int i=0; i<len; i++) if (line[i]=='.') dots++;
    if (dots>0) {
      char * ptrB = line;
      char * ptrC = line;
      while (ptrB[0]!='.') ptrB++;
      ptrB++;
      b = atoi(ptrB);
      if (dots>1) {
	ptrC = ptrB;
	while (ptrC[0]!='.') ptrC++;
	ptrC++;
	c = atoi(ptrC);
      }
    }
  }
  set(a,b,c,master,m0,m1,0);
}

*/

Position::Position(const Position & p) : Atoma(p, POSITION) {
  totalTicks = p.totalTicks;
}


int Position::bar() const {
  int tick=0;
  int beat=0;
  int bar=0;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bar,beat,tick,sonG->master(),m0,m1);
  return bar;
}

int Position::beat() const {
  int tick=0;
  int beat=0;
  int bar=0;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bar,beat,tick,sonG->master(),m0,m1);
  return beat;
}

int Position::tick() const {
  int tick=0;
  int beat=0;
  int bar=0;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bar,beat,tick,sonG->master(),m0,m1);
  return tick;
}


bool Position::sameBar(Position & p) const {
  if (bar()==p.bar()) return true;
  else return false;
}

bool Position::sameBarOrGreater(Position & p) const {
  if (bar()>=p.bar()) return true;
  else return false;
}

bool Position::sameBeat(Position & p) const {
  if (bar()==p.bar() && beat()==p.beat()) return true;
  else return false;
}



/*
int Position::gBar(Part * master) {
  int ticks;
  int beats;
  int bars;
  int m0; int m1;
  gBBT(bars,beats,ticks,master,m0,m1);

  return bars;
}

int Position::gBeat(Part * master) {
  int ticks;
  int beats;
  int bars;
  int m0; int m1;
  gBBT(bars,beats,ticks,master,m0,m1);
  return beats;
}

int Position::gTicks(Part * master) {
  int ticks;
  int beats;
  int bars;
  int m0; int m1;
  gBBT(bars,beats,ticks,master,m0,m1);
  return ticks;
}

int Position::gBar(int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,0,m0,m1);
  return bars;
}

int Position::gBeat(int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,0,m0,m1);
  return beats;
}

int Position::gTicks(int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,0,m0,m1);
  return ticks;
}

int Position::gBar(Part * master, int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,master,m0,m1);
  return bars;
}

int Position::gBeat(Part * master, int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,master,m0,m1);
  return beats;
}

int Position::gTicks(Part * master, int m0, int m1) {
  int ticks;
  int beats;
  int bars;
  gBBT(bars,beats,ticks,master,m0,m1);
  return ticks;
  }*/

void Position::gBBT(int & bars, int & beats, int & ticks) const {
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bars, beats, ticks, sonG->master(), m0, m1);
}

void Position::gBBT(int & bars, int & beats, int & ticks, Part * master, int & mm0, int & mm1, bool returnMeter) const {
  int m0 = mm0;
  int m1 = mm1;
  double timeF;
  int ticksPerBar;
  int ticksPerBeat;
  int timeWI;
  if (master) {
    m0 = Meter(0,master);
    m1 = Meter(1,master);
    Position mOff = master->start();
    Position pPos = (long) 0;
    Position deltaPos = (long) 0;
    Position mePos = (long) 0;
    ticks = 0;
    beats = 0;
    bars = 0;
    MasterEvent * me = 0;
    me = (MasterEvent*) master->content();
    while ((me != 0) && (master->start(me) < totalTicks)) {
      if (me->tempo()==0) {
	mePos = master->start(me);
	if (mePos==mOff) {
	} else {
	  deltaPos = mePos-pPos;
	  timeF = 1.0*m0/m1;
	  ticksPerBar = int(timeF*1536);
	  ticksPerBeat = ticksPerBar/m0;
	  timeWI = deltaPos.modulo(ticksPerBar);
	  ticks += deltaPos.modulo(ticksPerBeat);
	  beats += (timeWI-(deltaPos.modulo(ticksPerBeat)))/ticksPerBeat;
	  bars += (deltaPos-timeWI)/ticksPerBar;
	}
	m0 = me->meter0();
	m1 = me->meter1();
	pPos = mePos;
      }
      me = (MasterEvent*) next(me);
    }

    deltaPos = totalTicks-pPos;
    timeF = 1.0*m0/m1;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    timeWI = deltaPos.modulo(ticksPerBar);
    ticks += deltaPos.modulo(ticksPerBeat);
    beats += (timeWI-(deltaPos.modulo(ticksPerBeat)))/ticksPerBeat;
    bars += (deltaPos-timeWI)/ticksPerBar;
    bars++; beats++;
    if (returnMeter) {
      mm0 = m0;
      mm1 = m1;
    }
  } else {
    timeF = 1.0*m0/m1;
    if (timeF==0) cerr << "PANIC: BBT" << endl;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    timeWI = totalTicks%ticksPerBar;
    ticks = totalTicks%ticksPerBeat;
    beats = (timeWI-ticks)/ticksPerBeat+1;
    bars = (totalTicks-timeWI)/ticksPerBar+1;
  }
}

void Position::nextBar() {
  int tick=0;
  int beat=0;
  int bar=0;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bar,beat,tick,sonG->master(),m0,m1);
  bar++; beat = 1; tick = 0;
  set(bar,beat,tick,sonG->master(),m0,m1,0);
}

void Position::nextBeat() {
  int tick=0;
  int beat=0;
  int bar=0;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bar,beat,tick,sonG->master(),m0,m1);
  beat++; tick = 0;
  set(bar,beat,tick,sonG->master(),m0,m1,0);
}


void Position::prevBar() {
  int tick=0;
  int beat=0;
  int bar=0;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  gBBT(bar,beat,tick,sonG->master(),m0,m1);
  bar--; beat = 1; tick = 0;
  if (bar<1) bar = 1;
  set(bar,beat,tick,sonG->master(),m0,m1,0);
}


void Position::snap(int res, Tuplet * t) {
  if (t!=0) {
    // TODO
  } else {
    totalTicks += int(res*0.49);
    totalTicks = totalTicks - (totalTicks%res);
  }
}

Position & Position::operator=(const Position & p) {
  totalTicks = p.totalTicks;
  return *this;
}

Position & Position::operator=(long i) {
  totalTicks = i;
  return *this;
}

Position & Position::set(int p, int b, int t, Part * master, int mm0, int mm1, int snap) {
  totalTicks = 0;
  int m0 = mm0;
  int m1 = mm1;
  double timeF;
  int ticksPerBar;
  int ticksPerBeat;
  // int timeWI;
  p--; b--;
  if (master!=0) {
    m0 = Meter(0,master);
    m1 = Meter(1,master);
    Position mOff = master->start();
    Position mePos = mOff;
    Position pPos = mOff;
    MasterEvent * me =(MasterEvent*)  master->content();
    int meBars;
    int meBeats;
    int meTicks;

    bool loop = true;
    while (me!=0 && loop) {
      if ( me->tempo() == 0 ) {
	mePos = master->start(me);
	mePos.gBBT(meBars,meBeats,meTicks,master,m0,m1); // m0 und m1 added 15.8.99
	meBars--; meBeats--;
	if ( ( p <  meBars) ||
	       ((p == meBars) && (b <  meBeats)) ||
	       ((p == meBars) && (b == meBeats) && (t < meTicks))) { // ARG < mePos
	  loop = false;
	} else {
	  m0 = me->meter0();
	  m1 = me->meter1();
	  pPos = mePos;
	}
      }
      me = (MasterEvent*) next(me);
    }
    timeF = 1.0*m0/m1;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    totalTicks = pPos.ticks();
    t = t - pPos.tick(); if (t < 0) { b--; t += ticksPerBeat; }
    b = b - (pPos.beat()-1);  if (b < 0) { p--; b += m0; } // m0 = beats per Bar
    p = p - (pPos.bar()-1);
    totalTicks += (p*ticksPerBar + b*ticksPerBeat + t);
  } else {
    timeF = 1.0*m0/m1;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    totalTicks += (p*ticksPerBar + b*ticksPerBeat + t);
  }
  if (snap!=0) totalTicks = totalTicks - (totalTicks%snap);
  return *this;
}

Position & Position::operator+=(Position p) {
  totalTicks += p.totalTicks;
  return *this;
}

Position & Position::operator-=(Position p) {
 totalTicks -= p.totalTicks;
 return *this;
}

double Position::operator*(double d) {
  return totalTicks*1.0*d;
}

Position operator+(Position p1,Position p2) {
  return Position(p1.totalTicks+p2.totalTicks);
}

Position operator-(Position p1,Position p2) {
  return Position(p1.totalTicks-p2.totalTicks);
}

long operator+(Position p,long i) {
  return p.totalTicks+i;
}

long operator-(Position p,long i) {
  return p.totalTicks-i;
}

bool operator==(Position p1,Position p2) {
  if (p1.totalTicks==p2.totalTicks) return true;
  else return false;
}

bool operator==(Position p1,long lp2) {
  if (p1.totalTicks==lp2) return true;
  else return false;
}

bool operator!=(Position p1,Position p2) {
  if (p1.totalTicks!=p2.totalTicks) return true;
  else return false;
}

bool operator!=(Position p1,long lp2) {
  if (p1.totalTicks!=lp2) return true;
  else return false;
}

bool operator<(Position p1,Position p2) {
  if (p1.totalTicks<p2.totalTicks) return true;
  else return false;
}

bool operator>(Position p1,Position p2) {
  if (p1.totalTicks>p2.totalTicks) return true;
  else return false;
}

bool operator<=(Position p1,Position p2) {
  if (p1.totalTicks<=p2.totalTicks) return true;
  else return false;
}

bool operator>=(Position p1,Position p2) {
  if (p1.totalTicks>=p2.totalTicks) return true;
  else return false;
}


Position & operator++(Position & p,int) { p.totalTicks++; return p; }

ostream & operator<<(ostream & s,const Position & p) {
  // s << p.totalTicks;
  int tick=0;
  int beat;
  int bar;
  int m0 = sonG->meter0();
  int m1 = sonG->meter1();
  p.gBBT(bar,beat,tick,sonG->master(),m0,m1);
  s << bar << "." << beat << "." << tick;
  return s;
}



int Position::Meter(int m,Part * master) const {
  // This returns the numerator for m=0 and the nominator for m=1 (already powered!)
  // return master->gTrack()->gMain()->gMeter(m);
  switch (m) {
  case 0: return master->meter0(); break;
  case 1: return master->meter1(); break;
  default: cout << "don't do this (Position::Meter(m,part))" << endl;
  }
  return 0;
}


ostream & Position::print(int dep, ostream& s) const {
  s << spc(dep) << "<POSITION>" << totalTicks << "</POSITION>" << endl;
  return s;
}

void Position::flush(const char * c) const {
  cout << c << "POSITION " << totalTicks << endl;
}

Element * Position::copy() const {
  return new Position(totalTicks);
}


#endif
