#ifndef _PASTESELECTION_H_
#define _PASTESELECTION_H_

#include "operation.h"

class Element;
class Compound;
class Table;
class Reference;
class Part;

/** This operation copies the selection to an internal memory
 */
class PasteSelection : public Operation
{
 private:
  Table * _ins;
  Compound * _comp;
  long   _pos;

 public:
  PasteSelection(Compound * pt, long pos);
  PasteSelection(const PasteSelection&);
  ~PasteSelection();

  void undo();
  void redo();

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
