#ifndef _PART_CPP_
#define _PART_CPP_

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "part.h"
#include "loader.h"
#include "table.h"
#include "str.h"
#include "track.h"
#include "masterTrack.h"
#include "event.h"
#include "note.h"
#include "audioEvent.h"
#include "masterEvent.h"
#include "midiEvent.h"
#include "song.h"
#include "reference.h"
#include "event.h"
#include "prFactory.h"
#include "prPart.h"
#include "element.h"
#include "symbol.h"
#include "addSymbol.h"
#include "iterator.h"

extern Song * sonG;
extern PrFactory * factory;

extern char * getcmd(char*);

void swap(int & a, int & b) {
  int foo = a;
  a = b;
  b = foo;
}

void swap(long & a, long & b) {
  long foo = a;
  a = b;
  b = foo;
}

Part::Part() : _pos(0), _key(0), _clef(0), _meter0(sonG->meter0()), _meter1(sonG->meter1()), _program(0), _ghost_of(0), _ghosts(0), _track(0) {
  _type = PART;
  _pr = factory->createPart(this);
}

Part::Part(const Part& e) : Compound(e,PART) {
    _pos = e.start();
    _key = e.key();
    _clef = e.clef();
    _meter0 = e._meter0;
    _meter1 = e._meter1;
    _program = e.program();
    _ghost_of = e.ghostOf();
    _ghosts = 0;
    if (e.ghostOf()!=0) e.ghostOf()->incGhosts();
    _track = e.track();
    _pr = factory->createPart(this);
}

Part::Part(Track * tr) : _pos(0), _key(0), _clef(0), _meter0(sonG->meter0()), _meter1(sonG->meter1()), _program(0), _ghost_of(0), _ghosts(0), _track(tr) {
  _type = PART;
  _pr = factory->createPart(this);
  if (tr->isA()==MASTERTRACK) sonG->setMaster(this);
}


Part::~Part() {
  if (_pr!=0) _pr->erase();
  if (_track->isA()==MASTERTRACK) sonG->setMaster(0);
  if (_ghost_of!=0) setContent(0);
}

Position Part::start(Event * ev) const { return _pos + (ev==0?0:ev->internalStart()); }

long Part::end(Event * ev) const { return _pos + (ev==0?0:ev->internalEnd()); }

void Part::setStart(Position pos) { _pos = pos; reorder(); }

void Part::setStart(Event * ev, Position pos) { ev->setInternalStart(pos-_pos); reorder(); }

void Part::setKey(int k) { _key = k; }

void Part::setClef(int c) { _clef = c; }

void Part::setMeter(int m0, int m1) { setMeter0(m0); setMeter1(m1); }

void Part::setMeter0(int m0) { _meter0 = m0; }

void Part::setMeter1(int m1) { _meter1 = m1; }

void Part::setProgram(int p) { _program = p; }

void Part::setTrack(Track * tr) {
  _track = tr;
  if (tr->isA()==MASTERTRACK) sonG->setMaster(this);
}



bool Part::eventEndsAt(Event * ev, long p) {
  return (ev->internalEnd() + _pos.ticks() == p);
}

bool Part::eventStartsAt(Event * ev, long p) {
  return (ev->internalStart() + _pos.ticks() == p);
}

bool Part::eventStartsAfter(Event * ev, long p) {
  return (ev->internalStart() + _pos.ticks() > p);
}


Event * Part::grabEvent(Position mpos) {
  Event * ret = 0;
  Event * ev = 0;
  long pos = 0;
  int len = 0;
  bool loop = true;
  for (Iterator i = Iterator(this); !i.done() && loop; i++) {
    if ((*i)->isEvent()) {
      ev = (Event*) *i;
      pos = this->start(ev).ticks();
      len = ev->duration();
      // check:
      if ((pos <= mpos) && (mpos <= pos+len)) {
	ret = ev;
	loop = false;
      }
    }
  }
  return ret;
}

Reference * Part::makeRefs(int p1, int p2, long left, long right) {
  Reference * ret = 0;
  Note * n = 0;
  bool add = false;
  if (p1 > p2) swap(p1,p2);
  if (left > right) swap(left,right);
  for (Event * e = (Event*) content(); e != 0; e = (Event*) next(e)) {
    add = false;
    if ((start(e).ticks() >= left) && (end(e) <= right)) {
      if (e->isA()==NOTE) {
	n = (Note*) e;
	if ((n->pitch()>=p1) && (n->pitch()<=p2)) add = true;
      } else {
	add = true;
      }
    }
    if (add) {
      if (ret==0) ret = new Reference(e);
      else        Element::append(new Reference(e),ret);
    }
  }
  return ret;
}

void Part::reorder() {
  bool exit = false;
  Part * succ = 0;
  while (!exit) {
    exit = true;
    for (Part * pt = (Part*) _track->first(); (pt!=0) && exit; pt = (Part*) _track->next(pt)) {
      // cout << "\nloop: " << _track->first() << ", " << pt << ", " << pt->start().ticks() << " - ";
      succ = (Part*) _track->next(pt);
      // cout << succ << endl;
      // if (succ!=0) cout << succ << ", " << succ->start().ticks();
      // cout << endl;
      if (succ!=0)
	if (succ->start() < pt->start()) {
	  // cout << "repl. ";
	  _track->replace(pt,succ);
	  // cout << "ok " << endl;
	  // cout << "  : " << _track->first() << ", " << pt << ", " << pt->start().ticks() << " - ";
	  // if (_track->next(pt)!=0) cout << _track->next(pt) << ", " << ((Part*) _track->next(pt))->start().ticks();
	  // cout << endl;
	  exit = false;
	}
    }
  }
}

void Part::partCopy() {

}

Part * Part::partGlue() {
  Part * pt2 = (Part*) next(this);
  if (pt2 != 0) {
    Event * glue1 = (Event*) last();
    Event * glue2 = (Event*) pt2->first();
    if ((glue1!=0) && (glue2!=0)) {
      long offset = pt2->start() - start().ticks();
      for (Event * ev = glue2; ev != 0; ev = (Event*) next(ev))
	ev->setInternalStart(ev->internalStart() + offset);
      // ((Compound*)this)->add(glue2);
      Compound::add(glue2);
      pt2->setContent(0);
      pt2->track()->remove(pt2);
      // never delete: may cause trouble with movePart->undo(), instead it is hidden within operation: delete pt2;
    }
  }
  return pt2;
}

Event * Part::partSplit(Position p) { // the position p is relative to the start position of the part
  Event * ev = 0;
  for (Event * a = (Event*) first(); (a!=0) && (ev==0); a = (Event*) next(a)) {
    if (a->internalStart() >= p) ev = a;
  }
  if (ev!=0) {
    if ((prev(ev)==0) || (next(ev)==0)) ev = 0; // no split if split is at beginning or end
    else {
      splitBefore(ev);
    }
  }
  return ev;
}



void Part::add(Element * el) {
  if (el!=0) {
    if (content()==0) {
      setContent(el);
    } else {
      Event * ev = 0;
      // Event * succ = 0;
      long pos = 0;
      int pitch = 0;
      long newpos = ((Event*)el)->internalStart().ticks();
      int newpitch = 0;
      bool done = false;
      // long deltapos = 0; // diff in position of the current event compared to the following event.
      if (el->isA()==NOTE) newpitch = ((Note*)el)->pitch(); else newpitch = 0;
      for (Element * cur = first(); ((cur != 0) && (!done)); cur = Element::next(cur)) {
	ev  = (Event*) cur;
	pos = ev->internalStart().ticks();
	if (cur->isA()==NOTE) pitch = ((Note*)cur)->pitch(); else pitch = 0;
	if (pos > newpos) {
	  insertBefore(el,cur);
	  done = true;
	} else if (pos==newpos) {
	  // succ = (Event*) Element::next(cur);
	  // if (succ != 0) deltapos = succ->start()-pos; else deltapos = 0;
	  if (pitch >= newpitch) {
	    insertBefore(el,cur);
	    done = true;
	  }
	}
      }
      if (!done) { Element::append(el,content()); }
    }
  }
}

void Part::hide() {
  if (_pr!=0) _pr->hide();
}

void Part::show() {
  if (_pr!=0) _pr->show();
  reorder();
}

int Part::meter0() { return sonG->meter0(); }

int Part::meter1() { return sonG->meter1(); }


ostream & Part::print(int dep, ostream & s) const {
  s << spc(dep) << "<PART offset=\"" << _pos.ticks() << "\" >" << endl;
  s << spc(dep) << "<OPTIONS clef=\"" << _clef << "\"";
  s << " meter0=\"" << _meter0 << "\"";
  s << " meter1=\"" << _meter1 << "\"";
  s << " key=\"" << _key << "\"";
  s << " program=\"" << _program << "\"";
  s << " />" << endl;
  printContent(dep,s);
  s << spc(dep) << "</PART>" << endl;
  return s;
}

void Part::flush(const char * c) const {
  cout << c << "PART" << endl;
}

Element * Part::copy() const {
  Part * pt = new Part(*this);
  return pt;
}

Element * Part::ghostcopy() {
  Part * pt = new Part(_track);
  pt->_pos = start();
  pt->_key = key();
  pt->_clef = clef();
  pt->_meter0 = meter0();
  pt->_meter1 = meter1();
  pt->_program = program();
  pt->_ghost_of = this;
  pt->setContent(content());
  incGhosts();
  return pt;
}

void Part::incGhosts() { _ghosts++; }

void Part::decGhosts() {
  _ghosts--;
  if (_ghosts<0) { cout << "PANIC: ghosts<0" << endl; _ghosts = 0; }
}


Element * Part::load(char * aline, ifstream *& inPtr, Element * parent) {
  Part * part = 0;
  Table * attr = Loader::getAttributes("PART",aline);
  if ((attr!=0) && (attr->getEntry("offset"))) {
    part = new Part((Track*)parent);
    part->setStart(Position(atol(((String*) attr->getEntry("offset"))->getValue())));

    if (parent->isA()==SCORETRACK || parent->isA()==DRUMTRACK) {
      Table * opt = Loader::getAttributes("OPTIONS",inPtr);
      int clef = 0;
      int meter0 = 0;
      int meter1 = 0;
      int key = 0;
      int program = 0;
      if (opt->getEntry("clef")) clef = atoi(((String*) opt->getEntry("clef"))->getValue());
      if (opt->getEntry("meter0")) meter0 = atoi(((String*) opt->getEntry("meter0"))->getValue());
      if (opt->getEntry("meter1")) meter1 = atoi(((String*) opt->getEntry("meter1"))->getValue());
      if (opt->getEntry("key")) key = atoi(((String*) opt->getEntry("key"))->getValue());
      if (opt->getEntry("program")) program = atoi(((String*) opt->getEntry("program"))->getValue());

      part->setClef(clef);
      part->setMeter0(meter0);
      part->setMeter1(meter1);
      part->setKey(key);
      part->setProgram(program);

      const char * evnts[] = { "NOTE", "SYMBOL", "MIDIEVENT" };
      Element*(*funPtr[])(char*,ifstream*&,Element*) = { &Note::load, &Symbol::load, &MidiEvent::load };
      // Element::loadContent(part,"/PART","NOTE",&Note::load,inPtr);

      Element::loadContent(part,"/PART", 3, evnts, funPtr, inPtr);


      opt->scratch();
      delete opt;
    } else if (parent->isA()==AUDIOTRACK) {

      Element::loadContent(part,"/PART","AUDIOEVENT",&AudioEvent::load,inPtr);

    } else if (parent->isA()==MASTERTRACK) {

      Element::loadContent(part,"/PART","MASTEREVENT",&MasterEvent::load,inPtr);

    } else if (parent->isA()==COMMENTTRACK) {

    } else if (parent->isTrack()) { // used defined track type !
      const char * eventtype = ((Track*)parent)->eventType();
      Element* (*eventload)(char*,ifstream*&,Element*); eventload = ((Track*)parent)->eventLoad();
      Element::loadContent(part,"/PART",eventtype,eventload,inPtr);
    }


    attr->scratch();
    delete attr;
  }
  return part;
}

Symbol * Part::setSymbol(Position p, int sym, int off, int par) {
  Symbol * nae = 0;

  for (Event * a = (Event*) first(); a!=0; a = (Event*) next(a)) {
    if ((a->isA()==SYMBOL) && (a->internalStart()==p)) {
      if  (((Symbol*)a)->symbol()==sym) nae = (Symbol*) a;
    }
  }
  if (nae==0) {
    if (par==-2)      { char * txt = new char[1]; txt[0] = 0; nae = new Symbol(p,txt,off); } // text
    else if (par==-1) nae = new Symbol(p,sym,off); // symbol
    else              nae = new Symbol(p,sym,off,par); // parameterized symbol

    sonG->doo(new AddSymbol(nae,this));
  }
  return nae;
}



#endif
