#ifndef _NEWSELECTION_H_
#define _NEWSELECTION_H_

#include "operation.h"

class Element;
class Compound;
class Table;
class Reference;

/** This operation adds an element to a compound. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class NewSelection : public Operation
{
 private:
  Reference * _ref;
  Table * _oldTable;
  Table * _delete;

 public:
  NewSelection(Reference * ref);
  NewSelection(const NewSelection&);
  ~NewSelection();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
