#ifndef _HARMONYTRACK_H_
#define _HARMONYTRACK_H_

#include <track.h>

#include "riemann.h"


extern "C" {
  const char  * riemann_name();
}


class HarmonyTrack : public Track
{
 private:
  Key _key;
  Genus _genus;

 public:
  HarmonyTrack();
  HarmonyTrack(const HarmonyTrack&);
  ~HarmonyTrack();

  Key key();
  Genus genus();

  /** sets the key to k */
  void setKey(Key k);

  /** sets the key to k only if the key is currently set to UNDEFKEY */
  bool suggestKey(Key k);

  /** sets the genus to g */
  void setGenus(Genus g);

  /** sets the genus to g only if the genus is currently set to UNDEFGEN */
  bool suggestGenus(Genus g);

  virtual ostream & printOptions(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

  void loadOpt(ifstream*&);

  virtual const char * ctype() const { return riemann_name(); }
  virtual const char * eventType();
  virtual EVENTLOAD eventLoad();

};

#endif
