[-- template default.template --]
[-- define title=BookmarkBridge Settings --]
[-- define chapter_title=3. Using BookmarkBridge --]
[-- define prev_link=the_main_window.html --]
[-- define prev_title=The Main Window --]
[-- define next_link=viewing_your_bookmarks.html --]
[-- define next_title=Viewing Your Bookmarks --]

<p>
In order for BookmarkBridge to view and merge bookmarks in your browsers, it must
know where each of browser's bookmark databases are located.  The first time you
open the settings window it will likely have at least one browser listed.  This being
the result of BookmarkBridge's attempt to detect installed browsers on your computer.
</p>

<p>
The screenshot below, taken from the Linux version of BookmarkBridge running on
KDE 3 with RedHat Linux 8, shows the settings window of BookmarkBridge.
</p>

<img src="settings_screen.png" border="0" width="585" height="483">

<p>
To reach the settings window, click the <b>Settings</b> button on the main window.
The main part of the window consists of a list of browsers currently configured in
BookmarkBridge.  By clicking on one of the browsers in the list, you can make changes
to the configuration for that browser.
BookmarkBridge supports the notion of a browser being installed in multiple locations
on your computer.  Each location would have a separate configuration entry in the list.
</p>

<h3>Description</h3>
<p>
Each browser needs a description.  This description is shown on the main screen in the
list of source and destination browsers.  For multiple installations of a particular
type of browser, the description serves to distinguish between the installations.
</p>

<h3>Location</h3>
<p>
The location refers to the browser's bookmark database.  With most browsers, this is a
single file, with the notable exception of Internet Explorer which stores each bookmark
in a separate file.  In this case, the location refers to the Favorites folder.  Click
the <b>Browse</b> button to change the location.  The browse window that opens knows
whether to ask for a single file or a folder.  When you select a location, BookmarkBridge
attempts to determine if the location represents a valid bookmark database for that type
of browser.
</p>

<h3>Read-only Browsers</h3>
<p>
If you do not want a browser to be a destination, click the checkbox labeled
<b>Never change this browser's bookmarks</b>.
</p>

<h3>Add a new Browser</h3>
<p>
To add a new browser configuration to the list, click the <b>Add</b> button.  You are
presented with a list of browsers supported by BookmarkBridge.  Select the type of
browser you want to add and click the <b>Ok</b> button.  BookmarkBridge adds the browser
to the list and provides a default description.  You then must click the <b>Browse</b>
button to configure the location of the bookmark database.
</p>

<h3>Deleting a Browser</h3>
<p>
To delete a browser from BookmarkBridge, click the <b>Delete</b> button.  You are asked
to confirm your choice.
</p>
