/* xmalloc.c -- allocate-or-die routine
 * Written by Charles Briscoe-Smith; refer to the file LEGAL for details.
 */

#include <stdlib.h>

/* Interface definition */

/* Simple allocate-or-die function */
extern void *xmalloc(size_t);


#ifndef SEEN_xmalloc_h

/* Implementation */

#include <stdio.h>
#include "error.h"

#ifdef HAVE_LIBGC
# ifdef HAVE_GC_GC_H
#  include <gc/gc.h>
# else
#  ifdef HAVE_GC_H
#   include <gc.h>
#  else
extern void *GC_malloc(size_t);
#  endif
# endif
#else
# define NO_GC
#endif

void *
xmalloc(size_t s)
{
#ifndef NO_GC
	void *new=GC_malloc(s);
#else
	static int warned=0;
	void *new=malloc(s);
	if (warned==0) {
		fprintf(stderr,
		        "Warning: BOCK built without a garbage collector.\n");
		warned=1;
	}
#endif
	if (new==0) {
		error("Memory exhausted; bailing out.");
	}
	return new;
}

#endif /* SEEN_xmalloc_h */
