#include "includes.h"
#if __GLIBC__ < 2
#error "This GLIBC version is not supported"
#elif __GLIBC_MINOR__ == 0
#define GLIBCOLD
#else
#define GLIBCNEW
#endif
#ifdef GLIBCOLD
typedef loff_t off64_t;
off64_t llseek (int, loff_t, int);
#define lseek64 llseek
#endif

void freetable(struct struc_table **table)
{
    struct struc_table *act;
    
    while (*table)
    {
	act=(*table)->next;
	free(*table);
	*table=act;
    }
}

void copytable(struct struc_ownpartition *dest, struct struc_partition src, int number, int fatheraddr, int fd)
{
    off64_t oldoffset;
    word bootable;
        
    oldoffset=lseek64(fd, 0, SEEK_CUR);
    dest->number=number;
    dest->fathers_addr=fatheraddr;
    dest->absolute_addr=src.relative_addr+fatheraddr;
    dest->type=src.type;
    dest->sectors=src.sectors;
    lseek64(fd, dest->absolute_addr*BLOCK_SIZE+BR_FLAG_OFF, SEEK_SET);
    read(fd, &bootable, sizeof(bootable));
    if (bootable==BR_GOOD_FLAG)
    {
	dest->bootable=1;
    }
    else
    {
	dest->bootable=0;
    }
    lseek64(fd, oldoffset, SEEK_SET);
}

int readtable(struct struc_table ** table, char * drive)
{
    int fd;
    int l=1;
    
    *table=NULL;    
    fd=open(drive, O_RDONLY);
    if (fd>=0)
    {
	struct struc_table * last = *table;
	int i;
	int actnumber=1;
	
	lseek64(fd, PART_TBL_OFF, SEEK_SET);
	for (i=0;(i<4) && (l);i++)
	{
	    struct struc_partition readpart;
	    
	    if (read(fd, &readpart, sizeof(readpart))!=sizeof(readpart))
	    {
		freetable(table);
		l=0;
	    }
	    else if (readpart.type)
	    {
		if (last)
		{
		    last->next=malloc(sizeof(struct struc_table));
		    last=last->next;
		}
		else
		{
		    *table=malloc(sizeof(struct struc_table));
		    last=*table;
		}
		copytable(&(last->partition),readpart,actnumber,0, fd);
		actnumber++;
		last->next=NULL;
		if ((readpart.type==0x05) || (readpart.type==0x0f) || (readpart.type==0x85))
		{
		    int lognumber=5;
		    int extoffset;
		    int actextoffset;
		    struct struc_partition logical, nextextended;
		    int i, havextended=0;
		    off64_t oldoffset;
		    
		    oldoffset=lseek64(fd, 0, SEEK_CUR);
		    extoffset=last->partition.absolute_addr;
		    lseek64(fd, extoffset*BLOCK_SIZE+PART_TBL_OFF, SEEK_SET);
		    for (i=0;i<4; i++)
		    {
			read(fd, &readpart, sizeof(readpart));
			if ((readpart.type==0x05) || (readpart.type==0x0f) || (readpart.type==0x85))
			{
			    nextextended=readpart;
			    havextended=1;
			}
			else if (readpart.type)
			{
			    logical=readpart;
			}
		    }
		    last->next=malloc(sizeof(struct struc_table));
		    last=last->next;
		    copytable(&(last->partition), logical, lognumber, extoffset, fd);
		    lognumber++;
		    last->next=NULL;
		    while (havextended)
		    {
			havextended=0;
			actextoffset=nextextended.relative_addr+extoffset;
			lseek64(fd, (unsigned int) actextoffset*BLOCK_SIZE+PART_TBL_OFF, SEEK_SET);
			for (i=0;i<4; i++)
			{
			    read(fd, &readpart, sizeof(readpart));
			    if ((readpart.type==0x05) || (readpart.type==0x0f) || (readpart.type==0x85))
			    {
			        nextextended=readpart;
				havextended=1;
			    }
			    else if (readpart.type>0)
			    {
				logical=readpart;
			    }
		        }
			last->next=malloc(sizeof(struct struc_table));
			last=last->next;
		        copytable(&(last->partition), logical, lognumber, actextoffset, fd);
			lognumber++;
		        last->next=NULL;
		    }
		    lseek64(fd, oldoffset, SEEK_SET);
		}
	    }
	}
	close(fd);
    }
    else
    {
	l=0;
    }
    
    return l;
}

void partprint(struct struc_table *table)
{
    int i=0;
    
    while (table)
    {
	i++;
	printf("%u. absaddr: %u, fathersaddr: %u, sectors: %u, type: %u%s\n", table->partition.number, 
		table->partition.absolute_addr,
		table->partition.fathers_addr,
		table->partition.sectors,
		table->partition.type,
		(table->partition.bootable) ? " LOADER" : " ");
	table=table->next;
    }
}
