#include "includes.h"

int bmread(char * device, struct struc_bootmanager * btmgr)
{
    int fd;
    
    fd=open(device, O_RDONLY);
    if (fd!=-1)
    {
	if (sizeof(btmgr->sbmlheader)!=read(fd,&(btmgr->sbmlheader),
	    sizeof(btmgr->sbmlheader)))
	{
	    perror("read");
	    abort();
	}
	
	if (SECTOR_SIZE*btmgr->sbmlheader.kernel_addr1!=
	    lseek(fd,SECTOR_SIZE*btmgr->sbmlheader.kernel_addr1,SEEK_SET))
	{
	    perror("lseek");
	    abort();
	}
	if (sizeof(btmgr->sbmkheader)!=read(fd, &(btmgr->sbmkheader),
	    sizeof(btmgr->sbmkheader)))
	{
	    perror("read");
	    abort();
	}
	if (sizeof(btmgr->sbmkdata)!=read(fd,&(btmgr->sbmkdata),
	    sizeof(btmgr->sbmkdata)))
	{
	    perror("read");
	    abort();
	}
	if (SECTOR_SIZE*btmgr->sbmlheader.kernel_addr1!=
	    lseek(fd,SECTOR_SIZE*btmgr->sbmlheader.kernel_addr1,SEEK_SET))
	{
	    perror("lseek");
	    abort();
	}
	btmgr->datalen=btmgr->sbmkheader.checksum_size;
	btmgr->data=malloc(sizeof(char)*btmgr->datalen);
	if (btmgr->datalen!=read(fd,btmgr->data,btmgr->datalen))
	{
	    perror("read");
	    abort();
	}
        close(fd);
    }
    else
    {
	perror("open");
	abort();
    }
    
    return 1;    
}

int bmwrite(char * device, struct struc_bootmanager * btmgr)
{
    int fd;
    
    fd=open(device,O_RDWR);
    if (fd==-1)
    {
	perror("open");
	abort();
    }
    if (btmgr->sbmlheader.kernel_addr1*SECTOR_SIZE!=
	lseek(fd, btmgr->sbmlheader.kernel_addr1*SECTOR_SIZE, SEEK_SET))
    {
	perror("lseek");
	abort();
    }
    btmgr->sbmkheader.checksum=0;
    btmgr->sbmkheader.checksum_size=btmgr->datalen;
    memcpy(btmgr->data, &(btmgr->sbmkheader), sizeof(btmgr->sbmkheader));
    memcpy(((byte *)btmgr->data)+sizeof(btmgr->sbmkheader), &(btmgr->sbmkdata),
           sizeof(btmgr->sbmkdata));
    btmgr->data->checksum=calc_checksum((byte *)btmgr->data, btmgr->datalen);
    if (btmgr->datalen!=write(fd, btmgr->data, btmgr->datalen))
    {
	perror("write");
	abort();
    }
    close(fd);
    return 1;
}

dword checksumcalc(struct struc_bootmanager *btmgr)
{
    btmgr->sbmkheader.checksum=0;
    btmgr->sbmkheader.checksum_size=btmgr->datalen;
    memcpy(btmgr->data, &(btmgr->sbmkheader), sizeof(btmgr->sbmkheader));
    memcpy(((byte *)btmgr->data)+sizeof(btmgr->sbmkheader), &(btmgr->sbmkdata),
           sizeof(btmgr->sbmkdata));
    btmgr->data->checksum=calc_checksum((byte *)btmgr->data, btmgr->datalen);
    
    return btmgr->data->checksum;
}
