#!/usr/bin/env python

# 0.9 - This code has been sent by Michael Twomey <mick@enginesofcreation.ie> and adds support for basic HTTP proxies in BloGTK.

from xmlrpclib import Transport, Server

class ProxyTransport(Transport):
	"""Handles an HTTP transaction to an XML-RPC server, through an HTTP proxy."""

	def __init__(self, host, port):
		self.proxyHost = host
		self.proxyPort = port

	def request(self, host, handler, request_body, verbose=0):
		return Transport.request(self, host, "http://"+host+handler, request_body, verbose)

	def make_connection(self, host):
		import httplib
		return httplib.HTTP(self.proxyHost, self.proxyPort)
import os
import urlparse
import xmlrpclib
import ConfigParser

def get_xmlrpc_server(url, server=xmlrpclib.Server):

        # 0.9 - Here's where we pull our config values for determining what post method to use.
	option = ""
        homeDir = os.path.expanduser('~')
	proxyConfig = homeDir + "/.BloGTK/proxies.conf"
	proxyParser = ConfigParser.ConfigParser()
	# 0.9-1 - Apparently this will die if there's no proxies.conf - which is not what we want.
	# Therefore, we'll create a new file should one not exist.
	try:
	   proxyFile = open(proxyConfig, "rw")
	   proxyParser.readfp(proxyFile)
	except:
	   proxyFile = open(proxyConfig, "w")
	   proxyParser.add_section("Proxy")

	   proxyParser.set("Proxy", "port", "80")
	   proxyParser.set("Proxy", "server", "proxy.yourserver.com")
	   proxyParser.set("Proxy", "option", "none")
	   proxyParser.write(proxyFile)
           proxyFile.close()

	try:
	   custom_port = proxyParser.get("Proxy", "port")
           custom_host = proxyParser.get("Proxy", "server")
           option = proxyParser.get("Proxy", "option")
	except:
	   pass

	if option == "system":
	   try:
	      (scheme, host, path, parameters, query, frag) = urlparse.urlparse(os.environ["http_proxy"])
              (hostname, port) = host.split(":", 1)

	      return server(url, transport=ProxyTransport(hostname, int(port)))
	   except:
	      print "PROXY ERROR: Could not retrieve system value http_proxy."
	      # 0.9 - TODO - Better error handling including a dialog would be nice here.
	if option == "custom":
	   return server(url, transport=ProxyTransport(custom_host, int(custom_port)))
	else:
	   return server(url)

	proxyFile.close()

# 0.9 - This code can be scrapped
if "__main__" == __name__:

	print "Without proxy: ",
	try:
		betty = Server("http://betty.userland.com")
		print betty.examples.getStateName(41)
	except Exception, e:
		print "Oops, %s: %s" % (e.__class__.__name__, e)

	print "With proxy: ",
	try:
		betty = Server("http://betty.userland.com", transport=ProxyTransport("webcache.uk.sun.com", 8080))
		print betty.examples.getStateName(41)
	except Exception, e:
		print "Oops, %s: %s" % (e.__class__.__name__, e)
