/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LINKLABEL_H
#define LINKLABEL_H

class QString;
class KURL;
class QColor;
class QLabel;
class QBoxLayout;
class QSpacerItem;
class QPushButton;
class QCheckBox;
class QComboBox;
class KColorButton;

class IconSizeCombo;

#include <qframe.h>
#include <kapplication.h>

/** Store the style of links
  * @author Sbastien Laot
  */
class LinkLook
{
  public:
	LinkLook( bool underline = true, bool italic = false, bool bold = false, bool hoverUnder = true,
	          QColor color = QColor("blue"), QColor hoverColor = QColor("red"),
	          bool showIcon = true, int iconSize = 16, bool onTopIcon = false );
	LinkLook(const LinkLook &other);
	void setLook( bool underline = true, bool italic = false, bool bold = false, bool hoverUnder = true,
	              QColor color = QColor("blue"), QColor hoverColor = QColor("red"),
	              bool showIcon = true, int iconSize = 16, bool onTopIcon = false );
	inline bool   underline()  const { return m_underline;  }
	inline bool   italic()     const { return m_italic;     }
	inline bool   bold()       const { return m_bold;       }
	inline bool   hoverUnder() const { return m_hoverUnder; }
	inline QColor color()      const { return m_color;      }
	inline QColor hoverColor() const { return m_hoverColor; }
	inline bool   showIcon()   const { return m_showIcon;   }
	inline int    iconSize()   const { return m_iconSize;   }
	inline bool   onTopIcon()  const { return m_onTopIcon;  }
	QString toCSS(const QString &cssClass);
  private:
	bool   m_underline;
	bool   m_italic;
	bool   m_bold;
	bool   m_hoverUnder;
	QColor m_color;
	QColor m_hoverColor;
	bool   m_showIcon;
	int    m_iconSize;
	bool   m_onTopIcon;
  public:
	/* Global Looks */
	static LinkLook *soundLook;
	static LinkLook *fileLook;
	static LinkLook *localLook;
	static LinkLook *urlLook;   // FIXME: Rename to networkLook
	static LinkLook *noUrlLook; // FIXME: Rename to launcherLook
	/* Static method to get a LinkLook from an URL */
	static LinkLook* lookForURL(const KURL &url);
};

/** Used to represent links with icon and specific look
  * Note : This label will appear blank while LinkLook willn't be set
  * @author Sbastien Laot
  */
class LinkLabel : public QFrame
{
  Q_OBJECT
  public:
	LinkLabel(int hAlign, int vAlign, QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	LinkLabel(const QString &title, const QString &icon, LinkLook *look, int hAlign, int vAlign,
	          QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~LinkLabel();
  public:
	void setLink(const QString &title, const QString &icon, LinkLook *look = 0);
	void setLook(LinkLook *look);
	void setAlign(int hAlign, int vAlign);
	void setSelected(bool selected);
	void setPaletteBackgroundColor(const QColor &color);
	int  heightForWidth(int w = -1) const;
	QString toHtml(const QString &imageName);
  protected:
	void initLabel(int hAlign, int vAlign);
	void enterEvent(QEvent*);
	void leaveEvent(QEvent*);
  private:
	QBoxLayout  *m_layout;
	QLabel      *m_icon;
	QLabel      *m_title;
	QSpacerItem *m_spacer1;
	QSpacerItem *m_spacer2;

	bool         m_isSelected;
	bool         m_isHovered;

	LinkLook    *m_look;
	int          m_hAlign;
	int          m_vAlign;
};

/** A widget to edit a LinkLook, showing a live example to the user.
  * @author Sbastien Laot
  */
class LinkLookEditWidget : public QWidget
{
  Q_OBJECT
  public:
	LinkLookEditWidget(LinkLook *look, const QString exTitle, const QString exIcon,
	                   QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
	~LinkLookEditWidget();
	void saveChanges();
	void saveToLook(LinkLook *look);
  private slots:
	void slotShowIcon(bool show);
	void slotChangeLook(const QColor&);
	void slotChangeLook();
	void slotChangeLook(int);
  protected:
	LinkLook      *m_look;
	QComboBox     *m_underline;
	QCheckBox     *m_italic;
	QCheckBox     *m_bold;
	KColorButton  *m_color;
	KColorButton  *m_hoverColor;
	QWidget       *m_iconProperties;
	QComboBox     *m_onTopIcon;
	IconSizeCombo *m_iconSize;
	LinkLook      *m_exLook;
	LinkLabel     *m_example;
	QString        m_exTitle;
	QString        m_exIcon;
};

#endif // LINKLABEL_H
