/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <kurlrequester.h>
#include <kurl.h>
#include <klineedit.h>
#include <qradiobutton.h>
#include <kcolorbutton.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>
#include <qlineedit.h>
#include <klocale.h>
#include <kicondialog.h>
#include <kiconloader.h>
#include <qiconset.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <ktoolbarradiogroup.h>
#include <kapplication.h>
#include <qvbox.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <kcolordialog.h>

#include "item.h"
#include "itemedit.h"
#include "itemfactory.h"
#include "basket.h"
#include "linklabel.h"
#include "global.h"
#include "container.h"
#include "variouswidgets.h"
#include "settings.h"

#include <qmessagebox.h>

ColorIconSet::ColorIconSet(const QColor &color)
 : QIconSet()
{
	installIconFactory(ColorIconFactory::globalColorIconFactory);
	setColor(color);
}

ColorIconSet::~ColorIconSet()
{
}

QColor ColorIconSet::color() const
{
	return m_color;
}

void ColorIconSet::setColor(const QColor &color)
{
	m_color = color;
	QPixmap *pixmap = new QPixmap(10, 10);
	pixmap->fill(color);
	setPixmap(*pixmap, Automatic);
}

ColorIconFactory::ColorIconFactory()
 : QIconFactory()
{
	setAutoDelete(true);
}

/** ColorIconFactory */

ColorIconFactory *ColorIconFactory::globalColorIconFactory = new ColorIconFactory();

ColorIconFactory::~ColorIconFactory()
{
}

//#include <iostream.h>
QPixmap* ColorIconFactory::createPixmap(const QIconSet &iconSet, QIconSet::Size size,
                                        QIconSet::Mode mode, QIconSet::State state)
{
	return QIconFactory::createPixmap(iconSet, size, mode, state);


	/*int height = QIconSet::iconSize(size).height();
	int width  = QIconSet::iconSize(size).width();

	QPixmap *pixmap = new QPixmap(width, height);
	pixmap->fill(set->color());
	return pixmap;*/

/*	QColor c(paletteBackgroundColor());
	QColor b(isAlternate() ? m_parentBasket->altColor() : m_parentBasket->color());
	// Draw the 4 pixel coreners with background color
	paint.setPen(b);
	paint.drawPoint( 0,         0          );
	paint.drawPoint( 0,         height()-1 );
	paint.drawPoint( width()-1, height()-1 );
	paint.drawPoint( width()-1, 0          );
	// Draw 2 pixels rounded (mid of background color and parent background color)
	c.setRgb( (c.red()+b.red())/2, (c.green()+b.green())/2, (c.blue()+b.blue())/2 );
	paint.setPen(c);
	paint.drawPoint( 1,         0          );
	paint.drawPoint( 0,         1          );
	paint.drawPoint( 0,         height()-2 );
	paint.drawPoint( 1,         height()-1 );
	paint.drawPoint( width()-2, 0          );
	paint.drawPoint( width()-1, 1          );
	paint.drawPoint( width()-2, height()-1 );
	paint.drawPoint( width()-1, height()-2 );*/


/*	const ColorIconSet * set = static_cast<const ColorIconSet*>(&iconSet);
std::cout << "PIXXXXXMMMMMMMMAAAAAAPPPPPPPP" << (int)set << "!!!!!!!!!!!!" << QIconSet::iconSize(size).height() << std::endl;
	if (set) {
std::cout << "PIXXXXXMMMMMMMMAAAAAAPPPPPPPP" << set->color().name() << ";" << QIconSet::iconSize(size).height() << std::endl;
		QPixmap *pixmap = new QPixmap(QIconSet::iconSize(size).width(), QIconSet::iconSize(size).height());
		pixmap->fill(set->color());
		return pixmap;
	} else
		return QIconFactory::createPixmap(iconSet, size, mode, state);*/
}

/** ColorAction */

// Doesn't work:

ColorAction::ColorAction(const QColor &color, const QString &text, const KShortcut &cut,
                         KActionCollection *parent, const char *name)
 : KAction(text, "", cut, 0L, 0L, parent, name)
{
	m_color = color;
//	QPixmap pixmap(20, 20);
//	pixmap.fill(m_color);
//	setIconSet(pixmap);

	setIconSet(ColorIconSet(m_color));

// 		QIconSet *iconSet = new QIconSet();
// 		ColorIconFactory *factory = new ColorIconFactory();
// 		iconSet->setName(color.name());
// 		iconSet->installIconFactory()
// 		setIconSet(*iconSet);

	connect( this, SIGNAL(activated()), this, SLOT(selectColor()) );
}

ColorAction::~ColorAction()
{
}

/*#include <iostream.h>
QIconSet ColorAction::iconSet(KIcon::Group / *group* /, int size)/ * const* /
{
	std::cout << "ICON SET CALLLLLLLEEEEEEEDDDDDDDD ====================" << size << std::endl;
	QPixmap pixmap(size, size);
	pixmap.fill(m_color);
	setIconSet(pixmap);
	return KAction::iconSet();
}*/

void ColorAction::selectColor()
{
	QColor color = m_color;
	int ret = KColorDialog::getColor(color, 0L);
	if (ret == QDialog::Accepted) {
		m_color = color;
	setIconSet(ColorIconSet(m_color));
/*		QIconSet *iconSet = new QIconSet();
		ColorIconFactory *factory = new ColorIconFactory();
		iconSet->setName(color.name());
		iconSet->installIconFactory()
		setIconSet(*iconSet);*/
		emit colorChanged(color);
	}
}

/** ItemEditWidgetBase */

ItemEditWidgetBase::ItemEditWidgetBase(Item *item, QWidget *parent, const char *name, WFlags fl)
 : QWidget(parent, name, fl)
{
	m_item = item;
	m_isAlreadyFirstFocused = false;
}

ItemEditWidgetBase::~ItemEditWidgetBase()
{
}

void ItemEditWidgetBase::show()
{
	QWidget::show();

	if ( ! m_isAlreadyFirstFocused ) {
		goFirstFocus();
		m_isAlreadyFirstFocused = true;
	}
}

/** ItemEditorBase */

ItemEditorBase::ItemEditorBase(Item *item)
{
	m_item = item;
}

/** ItemTextEditor */

ItemTextEditor::ItemTextEditor(Item *item, QWidget *toolbarParent, QWidget *widgetsParent, QKeyEvent *ke)
 : ItemEditorBase(item)
{
	m_toolbar = new KToolBar(toolbarParent);

	QWidget      *topWid    = new QWidget(m_toolbar);
	QHBoxLayout  *topLayout = new QHBoxLayout(topWid, 0, 6);
	m_font                  = new FocusedComboBox(topWid);
	m_color                 = new FocusedColorCombo(topWid);
	QLabel       *topLbl    = new QLabel(m_font, i18n("A&ppearance:"), topWid);
	m_font->insertItem(i18n("Default"));
	m_font->insertItem(i18n("Sans serif"));
	m_font->insertItem(i18n("Serif"));
	m_font->insertItem(i18n("Monospace"));
	m_font->setCurrentItem(item->textFontType());
	m_color->setColor(m_item->textColor());
	topLayout->addWidget(topLbl);
	topLayout->addWidget(m_font);
	topLayout->addWidget(m_color);
	topLbl->setSizePolicy( QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, false) );

	if (toolbarParent != widgetsParent) {
		m_toolbar->insertButton("button_ok", 11, SIGNAL(clicked()), this, SLOT(slotEscapePressed()), true, i18n("OK"));
		m_toolbar->insertLineSeparator();
	}

	m_toolbar->insertWidget(0, 0, topWid);

	m_editorWidget = m_text = new FocusedTextEdit(Settings::enterValidateInline(),
	                                              widgetsParent != toolbarParent, widgetsParent);
	m_text->setTextFormat(Qt::PlainText);
	m_text->setText(m_item->text());
	changeFont(item->textFontType());
	changeColor(m_item->textColor());
	m_text->moveCursor(KTextEdit::MoveEnd, false);

	m_extraWidget = 0L;

	connect( m_font,  SIGNAL(activated(int)),           this, SLOT(changeFont(int))            );
	connect( m_color, SIGNAL(activated(const QColor&)), this, SLOT(changeColor(const QColor&)) );

	connect( m_text,  SIGNAL(escapePressed()),          this, SLOT(slotEscapePressed())        );
	connect( m_text,  SIGNAL(focusOut()),               this, SLOT(slotFocusOut())             );
	connect( m_font,  SIGNAL(focusOut()),               this, SLOT(slotFocusOut())             );
	connect( m_color, SIGNAL(focusOut()),               this, SLOT(slotFocusOut())             );

	if (ke)
		kapp->postEvent(m_editorWidget, ke);
}

ItemTextEditor::~ItemTextEditor()
{
	delete m_toolbar;
	delete m_editorWidget;
}

void ItemTextEditor::changeFont(int fontType)
{
	m_text->selectAll(true);
	m_text->setFont(ItemFactory::fontForFontType(fontType));
	m_text->selectAll(false);
}

void ItemTextEditor::changeColor(const QColor &color)
{
	m_text->selectAll(true);
	m_text->setColor(color);
	m_text->selectAll(false);
}

void ItemTextEditor::slotFocusOut()
{
	QWidget *focusWidget = kapp->focusWidget();
	QObject *focusParent = (focusWidget != 0L ? focusWidget->parent() : 0L);
	if ( focusWidget == m_editorWidget || focusWidget == m_font || focusWidget == m_color ||
	     focusParent != 0L && (focusParent == m_font || focusParent == m_color ||
	                           focusParent == m_editorWidget) ) // Popup menu of the KTextEdit
		return;

	if (focusWidget != 0L) // When color dialog is called, focusWidget == 0L
		emit focusOut();
}

void ItemTextEditor::slotEscapePressed()
{
	emit focusOut();
}

void ItemTextEditor::goFirstFocus()
{
	m_text->setFocus();
}

void ItemTextEditor::saveChanges()
{
	m_item->setText(m_text->text(), m_font->currentItem(), m_color->color());
}

/** ItemTextEditWidget */

// TODO: A _unique_ ItemEditWidget and transform all widgets to Item*Editor

ItemTextEditWidget::ItemTextEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl, QKeyEvent *ke)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QVBoxLayout *vLayout = new QVBoxLayout(this, 0, 6);

	m_editor = new ItemTextEditor(item, this, this, ke);
//	m_editor->toolbar()->setFrameShape(QFrame::NoFrame); // Remove the top and bottom lines of the toolbar
//	m_editor->toolbar()->setMargin(1); // Because otherwise, toolbar has one pixel less than it should have in height
//	m_editor->toolbar()->setFixedHeight(m_editor->toolbar()->height()+1); // Doesn't work !

	vLayout->addWidget(m_editor->toolbar());
	vLayout->addWidget(m_editor->editorWidget());
}

ItemTextEditWidget::~ItemTextEditWidget()
{
}

void ItemTextEditWidget::goFirstFocus()
{
	m_editor->goFirstFocus();
}

void ItemTextEditWidget::saveChanges()
{
	m_editor->saveChanges();
}

/** ItemHtmlEditor */


/* Thank you to Cdric Pasteur, for an enhanced version of the editor
 * with standard KToolBar (in WidgetFactory of Kexi project (KOffice).
 */

ItemHtmlEditor::ItemHtmlEditor(Item *item, QWidget *toolbarParent, QWidget *widgetsParent, QKeyEvent *ke)
 : ItemEditorBase(item)
{
	m_editorWidget = m_text = new FocusedTextEdit(Settings::enterValidateInline(),
	                                              widgetsParent != toolbarParent, widgetsParent);
	m_text->setTextFormat( /*item->showSource() ? Qt::PlainText :*/ Qt::RichText );
	m_text->setText(item->html());

	m_toolbar = new KToolBar(toolbarParent);
	m_toolbar->setFlat(true);

	if (toolbarParent != widgetsParent) {
		m_toolbar->insertButton("button_ok", 11, SIGNAL(clicked()), this, SLOT(slotEscapePressed()), true, i18n("OK"));
		m_toolbar->insertLineSeparator();
	}

	m_font = new FocusedFontCombo(m_toolbar);
	m_toolbar->insertWidget(101, 0, m_font);
	connect( m_font, SIGNAL(textChanged(const QString&)), m_text, SLOT(setFamily(const QString&)) );

	m_color = new FocusedColorCombo(m_toolbar);
//	m_color->hide();
	m_toolbar->insertWidget(102, 0, m_color);
	connect( m_color, SIGNAL(activated(const QColor&)), m_text, SLOT(setColor(const QColor&)) );

/*	ColorAction *colorAct = new ColorAction(item->textColor(), i18n("Color"), "", 0L, "");
	connect( colorAct, SIGNAL(colorChanged(const QColor&)), m_text, SLOT(setColor(const QColor&)) );
	colorAct->plug(m_toolbar);
*/
	m_toolbar->insertLineSeparator();

	m_toolbar->insertButton("text_bold",   103, true, i18n("Bold")       );
	m_toolbar->insertButton("text_italic", 104, true, i18n("Italic")     );
	m_toolbar->insertButton("text_under",  105, true, i18n("Underline")  );
	m_toolbar->getButton(103)->setAccel( QKeySequence(/*i18n("Bold",      */"Ctrl+B"/*)*/) );
	m_toolbar->getButton(104)->setAccel( QKeySequence(/*i18n("Italic",    */"Ctrl+I"/*)*/) );
	m_toolbar->getButton(105)->setAccel( QKeySequence(/*i18n("Underline", */"Ctrl+U"/*)*/) );
	m_toolbar->setToggle(103, true);
	m_toolbar->setToggle(104, true);
	m_toolbar->setToggle(105, true);
	m_toolbar->insertLineSeparator();

	m_toolbar->insertButton("text_super",  106, true, i18n("Superscript"));
	m_toolbar->insertButton("text_sub",    107, true, i18n("Subscript")  );
	m_toolbar->setToggle(106, true);
	m_toolbar->setToggle(107, true);
	m_toolbar->insertLineSeparator();

	KToolBarRadioGroup *group = new KToolBarRadioGroup(m_toolbar);
	m_toolbar->insertButton("text_left",   201, true, i18n("Left Align") );
	m_toolbar->insertButton("text_center", 202, true, i18n("Centered")   );
	m_toolbar->insertButton("text_right",  203, true, i18n("Right Align"));
	m_toolbar->insertButton("text_block",  204, true, i18n("Justified")  );
	m_toolbar->setToggle(201, true);
	m_toolbar->setToggle(202, true);
	m_toolbar->setToggle(203, true);
	m_toolbar->setToggle(204, true);
	group->addButton(201);
	group->addButton(202);
	group->addButton(203);
	group->addButton(204);

/*
	"text_strike"
	"indent"
	"unindent"
*/

	m_extraWidget = 0L;
//	m_extraWidget = m_showHtmlSource = new QCheckBox(i18n("&Show HTML source"), widgetsParent);
//	connect( m_showHtmlSource, SIGNAL(toggled(bool)), this, SLOT(slotShowSource(bool)) );
//	m_showHtmlSource->setChecked(m_text->textFormat() == Qt::PlainText); // After connection, to apply it

	connect( m_text,  SIGNAL(cursorPositionChanged(int, int)), this, SLOT(cursorPositionChanged(int, int)) );
	connect( m_text,  SIGNAL(clicked(int, int)),               this, SLOT(cursorPositionChanged(int, int)) );
	connect( m_text,  SIGNAL(currentVerticalAlignmentChanged(QTextEdit::VerticalAlignment)),
	         this,    SLOT(slotVerticalAlignmentChanged(QTextEdit::VerticalAlignment))                     );

	connect( m_text,  SIGNAL(escapePressed()),                 this, SLOT(slotEscapePressed())             );
	connect( m_text,  SIGNAL(focusOut()),                      this, SLOT(slotFocusOut())                  );
	connect( m_font,  SIGNAL(focusOut()),                      this, SLOT(slotFocusOut())                  );
	connect( m_color, SIGNAL(focusOut()),                      this, SLOT(slotFocusOut())                  );

	connect(m_toolbar, SIGNAL(toggled(int)), this, SLOT(buttonToggled(int)));

	m_text->moveCursor(KTextEdit::MoveEnd, false);
	cursorPositionChanged(0, 0);

	if (ke)
		kapp->postEvent(m_editorWidget, ke);
}

ItemHtmlEditor::~ ItemHtmlEditor()
{
}

/*void ItemHtmlEditor::slotShowSource(bool on)
{
	QString str = m_text->text();
	m_text->setTextFormat( on ? Qt::PlainText : Qt::RichText );
	m_text->setText(str);

	m_toolbar->setItemEnabled(101, !on);
	m_toolbar->setItemEnabled(102, !on);
	m_toolbar->setItemEnabled(103, !on);
	m_toolbar->setItemEnabled(104, !on);
	m_toolbar->setItemEnabled(105, !on);
	m_toolbar->setItemEnabled(106, !on);
	m_toolbar->setItemEnabled(107, !on);
	m_toolbar->setItemEnabled(201, !on);
	m_toolbar->setItemEnabled(202, !on);
	m_toolbar->setItemEnabled(203, !on);
	m_toolbar->setItemEnabled(204, !on);
}*/

void ItemHtmlEditor::buttonToggled(int id)
{
	bool isOn = m_toolbar->isButtonOn(id);

	switch (id) {
		case 103: m_text->setBold(isOn);      break;
		case 104: m_text->setItalic(isOn);    break;
		case 105: m_text->setUnderline(isOn); break;
		case 106:
			if (isOn && m_toolbar->isButtonOn(107))
				m_toolbar->setButton(107, false);
			m_text->setVerticalAlignment(isOn ? KTextEdit::AlignSuperScript : KTextEdit::AlignNormal);
			break;
		case 107:
			if (isOn && m_toolbar->isButtonOn(106))
				m_toolbar->setButton(106, false);
			m_text->setVerticalAlignment(isOn ? KTextEdit::AlignSubScript   : KTextEdit::AlignNormal);
			break;
		case 201:
		case 202:
		case 203:
		case 204:
			if ( ! isOn )
				break;
			switch (id) {
				case 201:  m_text->setAlignment(Qt::AlignLeft);    break;
				case 202:  m_text->setAlignment(Qt::AlignCenter);  break;
				case 203:  m_text->setAlignment(Qt::AlignRight);   break;
				case 204:  m_text->setAlignment(Qt::AlignJustify); break;
			}
	}
}

void ItemHtmlEditor::cursorPositionChanged(int /*para*/, int /*pos*/)
{
//	if (m_text->hasSelectedText())
//		return;

	m_font->setCurrentFont(m_text->currentFont().family());
	m_color->setColor(m_text->color());
	m_toolbar->setButton(103, m_text->bold()     );
	m_toolbar->setButton(104, m_text->italic()   );
	m_toolbar->setButton(105, m_text->underline());

	switch (m_text->alignment()) {
		case Qt::AlignLeft:    m_toolbar->setButton(201, true); break;
		case Qt::AlignCenter:  m_toolbar->setButton(202, true); break;
		case Qt::AlignRight:   m_toolbar->setButton(203, true); break;
		case Qt::AlignJustify: m_toolbar->setButton(204, true); break;
		default:               m_toolbar->setButton(201, true); break;
	}
}

void ItemHtmlEditor::slotVerticalAlignmentChanged(QTextEdit::VerticalAlignment align)
{
	switch (align) {
		case KTextEdit::AlignSuperScript:
			m_toolbar->setButton(106, true);
			m_toolbar->setButton(107, false);
			break;
		case KTextEdit::AlignSubScript:
			m_toolbar->setButton(107, true);
			m_toolbar->setButton(106, false);
			break;
		default:
			m_toolbar->setButton(106, false);
			m_toolbar->setButton(107, false);
	}
}

void ItemHtmlEditor::goFirstFocus()
{
	m_text->setFocus();
}

void ItemHtmlEditor::saveChanges()
{
	m_item->setHtml(m_text->text() );//, m_showHtmlSource->isChecked());
}

void ItemHtmlEditor::slotFocusOut()
{
	QWidget *focusWidget = kapp->focusWidget();
	QObject *focusParent = (focusWidget != 0L ? focusWidget->parent() : 0L);
	if ( focusWidget == m_editorWidget || focusWidget == m_font ||
	     focusWidget == m_color || focusWidget == m_toolbar ||
	     focusParent != 0L && (focusParent == m_font || focusParent == m_color ||
	                           focusParent == m_editorWidget || focusParent == m_toolbar) ) // Popup menus
		return;

	if (focusWidget != 0L) // When color dialog is called, focusWidget == 0L
		emit focusOut();
}

void ItemHtmlEditor::slotEscapePressed()
{
	emit focusOut();
}

/** ItemHtmlEditWidget */

ItemHtmlEditWidget::ItemHtmlEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl, QKeyEvent *ke)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QVBoxLayout *vLayout = new QVBoxLayout(this, 0, 6);

	m_editor = new ItemHtmlEditor(item, this, this, ke);
//	m_editor->toolbar()->setFrameShape(QFrame::NoFrame); // Remove the top and bottom lines of the toolbar
//	m_editor->toolbar()->setMargin(1); // Because otherwise, toolbar has one pixel less than it should have in height
//	m_editor->toolbar()->setMinimumHeight(m_editor->toolbar()->minimumHeight()+60); // Doesn't work !

	vLayout->addWidget(m_editor->toolbar()     );
	vLayout->addWidget(m_editor->editorWidget());
//	vLayout->addWidget(m_editor->extraWidget() );
}

ItemHtmlEditWidget::~ItemHtmlEditWidget()
{
}

void ItemHtmlEditWidget::goFirstFocus()
{
	m_editor->goFirstFocus();
}

void ItemHtmlEditWidget::saveChanges()
{
	m_editor->saveChanges();
}

/** ItemLinkEditWidget */

ItemLinkEditWidget::ItemLinkEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl, QKeyEvent *ke)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QGridLayout *layout = new QGridLayout(this, 3, 2, 0, 6);

	m_url = new KURLRequester(m_item->url().url(), this);

	QWidget *wid1 = new QWidget(this);
	QHBoxLayout *titleLay = new QHBoxLayout(wid1, 0, 6);
	m_title = new QLineEdit(m_item->title(), wid1);
	m_autoTitle = new QPushButton(i18n("Auto"), wid1);
	m_autoTitle->setToggleButton(true);
	m_autoTitle->setOn(item->autoTitle());
	titleLay->addWidget(m_title);
	titleLay->addWidget(m_autoTitle);

	QWidget *wid = new QWidget(this);
	QHBoxLayout *hLay = new QHBoxLayout(wid, 0, 6);
	m_icon = new KIconButton(wid);
	QLabel *label3 = new QLabel(m_icon, i18n("&Icon:"), this);
	m_icon->setIconType ( KIcon::NoGroup, KIcon::MimeType );
	m_icon->setIconSize( LinkLook::lookForURL( KURL(m_url->lineEdit()->text()) )->iconSize() );
	QPushButton *button2 = new QPushButton(i18n("Cl&ear"),  wid); // Create before to know size here:
	/* Icon button: */
	m_icon->setIcon(item->icon());
	int minSize = button2->sizeHint().height();
	// Make the icon button at least the same heigh than the other buttons for a better alignment (nicer to the eyes):
	if (m_icon->sizeHint().height() < minSize)
		m_icon->setFixedSize(minSize, minSize);
	else
		m_icon->setFixedSize(m_icon->sizeHint().height(), m_icon->sizeHint().height()); // Make it square
	if ( item->icon().isEmpty() )
		m_icon->resetIcon();
	/* Auto button: */
	m_autoIcon = new QPushButton(i18n("Auto"), wid);
	m_autoIcon->setToggleButton(true);
	m_autoIcon->setOn(item->autoIcon());
	hLay->addWidget(m_icon);
	hLay->addWidget(button2);
	hLay->addWidget(m_autoIcon);
	hLay->addStretch();

	//m_url->setShowLocalProtocol(true);
	QLabel      *label1 = new QLabel(m_url,   i18n("&URL:"),    this);
	QLabel      *label2 = new QLabel(m_title, i18n("&Title:"),  this);
	layout->addWidget(label1,  0, 0, Qt::AlignVCenter);
	layout->addWidget(label2,  1, 0, Qt::AlignVCenter);
	layout->addWidget(label3,  2, 0, Qt::AlignVCenter);
	layout->addWidget(m_url,   0, 1, Qt::AlignVCenter);
	layout->addWidget(wid1,    1, 1, Qt::AlignVCenter);
	layout->addWidget(wid,     2, 1, Qt::AlignVCenter);

	m_isAutoModified = false;
	connect( m_url,   SIGNAL(textChanged(const QString&)), this, SLOT(urlChanged(const QString&))     );
	connect( m_title, SIGNAL(textChanged(const QString&)), this, SLOT(doNotAutoTitle(const QString&)) );
	connect( m_icon,  SIGNAL(iconChanged(QString))       , this, SLOT(doNotAutoIcon(QString))         );
	connect( m_autoTitle, SIGNAL(clicked()), this, SLOT(guessTitle()) );
	connect( m_autoIcon,  SIGNAL(clicked()), this, SLOT(guessIcon())  );
	connect( button2,     SIGNAL(pressed()), this, SLOT(emptyIcon())  );

	urlChanged("");

	if (ke)
		kapp->postEvent(m_url->lineEdit(), ke);
}

ItemLinkEditWidget::~ItemLinkEditWidget()
{
}

void ItemLinkEditWidget::goFirstFocus()
{
	if (m_url->lineEdit()->text().isEmpty()) {
		m_url->setFocus();
		m_url->lineEdit()->end(false);
	} else {
		m_title->setFocus();
		m_title->end(false);
	}
}

void ItemLinkEditWidget::emptyIcon()
{
	m_autoIcon->setOn(false);
	m_icon->resetIcon();
}

void ItemLinkEditWidget::urlChanged(const QString&)
{
	m_isAutoModified = true;
	guessTitle();
	guessIcon();
}

void ItemLinkEditWidget::doNotAutoTitle(const QString&)
{
	if (m_isAutoModified)
		m_isAutoModified = false;
	else
		m_autoTitle->setOn(false);
}

void ItemLinkEditWidget::doNotAutoIcon(QString)
{
	m_autoIcon->setOn(false);
}

void ItemLinkEditWidget::guessIcon()
{
	if (m_autoIcon->isOn())
		m_icon->setIcon( ItemFactory::iconForURL( KURL(m_url->url()) ) );
}

void ItemLinkEditWidget::guessTitle()
{
	if (m_autoTitle->isOn()) {
		m_title->setText( ItemFactory::titleForURL( KURL(m_url->url()) ) );
		m_autoTitle->setOn(true); // Because the setText() will disable it!
	}
}

void ItemLinkEditWidget::saveChanges()
{
	m_item->setUrl(  KURL(m_url->url()), m_title->text(), m_icon->icon() );
	m_item->setAuto( m_autoTitle->isOn(), m_autoIcon->isOn() );

	/* Change icon size if link look have changed */
	LinkLook *linkLook = LinkLook::lookForURL( KURL(m_url->url()) );
	QString icon = m_icon->icon();             // When we change size, icon isn't changed and keep it's old size
	m_icon->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum); // Reset size policy
	m_icon->setIconSize(linkLook->iconSize()); //  So I store it's name and reload it after size change !
	m_icon->setIcon(icon);
	int minSize = m_autoIcon->sizeHint().height();
	// Make the icon button at least the same heigh than the other buttons for a better alignment (nicer to the eyes):
	if (m_icon->sizeHint().height() < minSize)
		m_icon->setFixedSize(minSize, minSize);
	else
		m_icon->setFixedSize(m_icon->sizeHint().height(), m_icon->sizeHint().height()); // Make it square
	if ( icon.isEmpty() )
		m_icon->resetIcon();
}

/** ItemLauncherEditWidget */

ItemLauncherEditWidget::ItemLauncherEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QGridLayout *layout = new QGridLayout(this, 3, 2, 0, 6);

	KService service(item->fullPath());
	m_command = new RunCommandRequester(service.exec(), i18n("Choose a command to run:"), this);

	m_name = new QLineEdit(service.name(), this);

	QWidget *wid = new QWidget(this);
	QHBoxLayout *hLay = new QHBoxLayout(wid, 0, 6);
	m_icon = new KIconButton(wid);
	QLabel *label3 = new QLabel(m_icon, i18n("&Icon:"), this);
	m_icon->setIconType ( KIcon::NoGroup, KIcon::Application );
	m_icon->setIconSize( LinkLook::noUrlLook->iconSize() );
	QPushButton *button2 = new QPushButton(i18n("Cl&ear"),  wid); // Create before to know size here:
	/* Icon button: */
	m_icon->setIcon(service.icon());
	int minSize = button2->sizeHint().height();
	// Make the icon button at least the same heigh than the other buttons for a better alignment (nicer to the eyes):
	if (m_icon->sizeHint().height() < minSize)
		m_icon->setFixedSize(minSize, minSize);
	else
		m_icon->setFixedSize(m_icon->sizeHint().height(), m_icon->sizeHint().height()); // Make it square
	if ( service.icon().isEmpty() )
		m_icon->resetIcon();
	/* Auto button: */
	QPushButton *guessButton = new QPushButton(i18n("&Guess"), wid);
	hLay->addWidget(m_icon);
	hLay->addWidget(button2);
	hLay->addWidget(guessButton);
	hLay->addStretch();

	QLabel *label1 = new QLabel(m_command, i18n("Comman&d:"), this);
	QLabel *label2 = new QLabel(m_name,    i18n("&Name:"),    this);
	layout->addWidget(label1,    0, 0, Qt::AlignVCenter);
	layout->addWidget(label2,    1, 0, Qt::AlignVCenter);
	layout->addWidget(label3,    2, 0, Qt::AlignVCenter);
	layout->addWidget(m_command, 0, 1, Qt::AlignVCenter);
	layout->addWidget(m_name,    1, 1, Qt::AlignVCenter);
	layout->addWidget(wid,       2, 1, Qt::AlignVCenter);

	m_isAutoModified = false;
	connect( guessButton, SIGNAL(clicked()), this, SLOT(guessIcon()) );
	connect( button2,     SIGNAL(pressed()), this, SLOT(emptyIcon()) );
}

ItemLauncherEditWidget::~ItemLauncherEditWidget()
{
}

void ItemLauncherEditWidget::goFirstFocus()
{
	if (m_command->runCommand().isEmpty()) {
		m_command->lineEdit()->setFocus();
		m_command->lineEdit()->end(false);
	} else {
		m_name->setFocus();
		m_name->end(false);
	}
}

void ItemLauncherEditWidget::saveChanges()
{
	KConfig conf(m_item->fullPath());
	conf.setGroup("Desktop Entry");
	conf.writeEntry("Exec", m_command->runCommand());
	conf.writeEntry("Name", m_name->text());
	conf.writeEntry("Icon", m_icon->icon());

	// Just for faster feedback: conf object will save to disk (and then m_item->loadContent() called)
	m_item->setLauncher(m_name->text(), m_icon->icon());
}

void ItemLauncherEditWidget::guessIcon()
{
	m_icon->setIcon( ItemFactory::iconForCommand(m_command->runCommand()) );
}

void ItemLauncherEditWidget::emptyIcon()
{
	m_icon->resetIcon();
}

/** ItemImageEditWidget */

ItemImageEditWidget::ItemImageEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QVBoxLayout *vLayout = new QVBoxLayout(this, 0, 6);

	if (item->type() != Item::Unknow) {
		QLabel *label = new QLabel(i18n("<center>No editor yet for this type of item.<br>"
			"Use \"Open\" or \"Open with...\" action to open<br>"         //"<center>No image editor yet.<br>"
			"the file in your preffered editor.<br>" // "the image in your preffered image editor.<br>"
			"Item will be automatically updated.</center>").replace(" ", "&nbsp;"), this);
		m_open = new QPushButton(SmallIconSet("fileopen"), i18n("O&pen"), this);
		connect( m_open, SIGNAL(clicked()), m_item, SLOT(slotOpen()) );
		vLayout->addWidget(label);
		vLayout->addWidget(m_open);
	} else {
		QLabel *label = new QLabel(i18n("<center>No editor for this unknown item type.<br>"
			"You however can drag or copy the item into an application that understand it.</center>")
				.replace(" ", "&nbsp;"), this);
		vLayout->addWidget(label);
		m_open = 0L;
	}
}

ItemImageEditWidget::~ItemImageEditWidget()
{
}

void  ItemImageEditWidget::goFirstFocus()
{
	if (m_open)
		m_open->setFocus();
}

void ItemImageEditWidget::saveChanges()
{
}

/** ItemColorEditWidget */

ItemColorEditWidget::ItemColorEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QHBoxLayout *layout = new QHBoxLayout(this, 0, 6);

/*
	m_button[0]          = new QRadioButton(i18n("Hex (#RRVVBB)"), group);
	m_button[1]          = new QRadioButton(i18n("RVB (R,V,B)"),   group);
	m_button[2]          = new QRadioButton(i18n("HSV (H,S,V)"),   group);
	m_button[3]          = new QRadioButton(i18n("Name (blue)"),   group);
*/
	m_color = new KColorButton(this);
	m_color->setColor(item->color());
	layout->addWidget(m_color);
}

ItemColorEditWidget::~ItemColorEditWidget()
{
}

void ItemColorEditWidget::goFirstFocus()
{
	m_color->setFocus();
}

void ItemColorEditWidget::saveChanges()
{
	m_item->setColor( m_color->color() );
}

/** ItemEditWidget */

ItemEditWidget::ItemEditWidget(Item *item, QWidget *parent, const char *name, WFlags fl)
 : ItemEditWidgetBase(item, parent, name, fl)
{
	QVBoxLayout *layout = new QVBoxLayout(this, 0, 6);

	m_annotations = new KTextEdit(this);
	QLabel *lbl   = new QLabel(m_annotations, i18n("Anno&tations:"), this);
	m_annotations->setTextFormat(Qt::PlainText);
	m_annotations->setText(m_item->annotations());
	layout->addWidget(lbl);
	layout->addWidget(m_annotations);

	if (item->useFile()) {
		QHBoxLayout *hLay = new QHBoxLayout(0, 0, 6);
		m_fileName = new QLineEdit(item->fileName(), this);
		m_fileLabel = new QLabel(m_fileName, (item->isAMirror() ? /*i18n*/QString("Mirrored file:") : i18n("&File name:")), this);
		hLay->addWidget(m_fileLabel);
		hLay->addWidget(m_fileName);
		if (item->isAMirror()) {
			m_fileName->setEnabled(false);
			m_unmirror = new QPushButton(/*i18n*/QString("&Unmirror"), this);
			hLay->addWidget(m_unmirror);
			connect( m_unmirror, SIGNAL(clicked()), this, SLOT(slotUnmirror()) );
		}
		layout->addLayout(hLay);
	}
}

ItemEditWidget::~ItemEditWidget()
{
}

void ItemEditWidget::goFirstFocus()
{
	m_annotations->setFocus();
	m_annotations->moveCursor(KTextEdit::MoveEnd, false);
}

void ItemEditWidget::slotUnmirror()
{
	QString oldFile = m_item->fileName();

	m_item->unmirror();
	m_unmirror->hide();
	m_fileLabel->setText(i18n("&File name:"));
	m_fileName->setText(m_item->fileName());
	m_fileName->setEnabled(true);

	KMessageBox::information(this, /*i18n*/QString("This item was mirroring the content of the file %1. "
		"This file has been copied in the basket folder. You can edit or delete the item as you want: %2 "
		"willn't be altered.").arg(oldFile).arg(oldFile),
		/*i18n*/QString("Unmirror a File"), "unmirrorFileInfo");
}

void ItemEditWidget::saveChanges()
{
	m_item->setAnnotations(m_annotations->text());
	if ( m_item->useFile() && m_fileName->text() != m_item->fileName() ) // Rename only if name has changed !
		if ( ! m_item->setFileName(m_fileName->text()) )                 // Rename item file name
			m_fileName->setText(m_item->fileName());                     // Reload file name if failed
}

/** ItemEditDialog */

ItemEditDialog::ItemEditDialog(Item *item, bool editAnnotations, QWidget *parent, QKeyEvent *ke)
 : KDialogBase(KDialogBase::Tabbed, i18n("Edit Item and Properties"),
               KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel, KDialogBase::Ok, parent)
{
	QVBox *page;

	page = addVBoxPage( i18n("Co&ntent: %1").arg(item->typeName()) );
	switch (item->type()) {
		case Item::Text:     m_editContent = new ItemTextEditWidget(    item, page, "", 0, ke); break;
		case Item::Html:     m_editContent = new ItemHtmlEditWidget(    item, page, "", 0, ke); break;
		case Item::Animation:
		case Item::Sound:
		case Item::File:
		case Item::Unknow:
		case Item::Image:    m_editContent = new ItemImageEditWidget(   item, page);            break;
		case Item::Link:     m_editContent = new ItemLinkEditWidget(    item, page, "", 0, ke); break;
		case Item::Launcher: m_editContent = new ItemLauncherEditWidget(item, page);            break;
		case Item::Color:    m_editContent = new ItemColorEditWidget(   item, page);            break;
	}

	page = addVBoxPage( i18n("&Meta-data") );
	m_itemEdit = new ItemEditWidget(item, page);

	m_item = item;

	// Double the width, because the URL/title/runCommand should be visible
	if (item->type() == Item::Link || item->type() == Item::Launcher) {
		QSize size(sizeHint());
		resize(QSize(size.width() * 2, size.height()));
	}

	if (editAnnotations)
		showPage(1);
}

ItemEditDialog::~ItemEditDialog()
{
}

void ItemEditDialog::slotApply()
{
	// Save m_itemEdit BEFORE m_editContent to be able to set the run command
	//  BEFORE reloading the icon in ItemLinkEditWidget, with a size according
	//  to the link look, which is dependant of the URL and the run command:
	m_itemEdit->saveChanges();
	m_editContent->saveChanges();

	// m_item->saveContent();
	m_item->saveProperties();

	if (Global::tray)
		Global::tray->updateToolTip();

	KDialogBase::slotApply();
}

void ItemEditDialog::slotOk()
{
	slotApply();
	KDialogBase::slotOk();
}

#include "itemedit.moc"
