<?php

class SqliteIndexStore extends IndexStore {

var $dbpath;
var $db = null;
var $hack = false; // true if we have a bad version of the sqlite library.

################################
### QUERIES 

var $sql_create = '
CREATE TABLE pages(id INTEGER PRIMARY KEY, path UNIQUE, itime, mtime);<ret>
CREATE TABLE keywords(pageid, word);<ret>
CREATE TABLE content(pageid, word);<ret>
CREATE INDEX pages_index ON pages (mtime);<ret>
CREATE INDEX keyword_index ON keywords (pageid,word);<ret>
CREATE INDEX content_index ON content (pageid,word);<ret>
';

#CREATE TRIGGER DELETE ON pages
#BEGIN
#	DELETE FROM keywords WHERE keywords.pageid = OLD.id;
#	DELETE FROM content WHERE content.pageid = OLD.id;
#END;<ret>

##############################
### FUNCTIONS

function SqliteIndexStore($configstr) {
	if ('/' != $configstr{0})  // if not absolute, make relative to site's docroot.
		$this->dbpath = $GLOBALS['docroot'] . '/' . $configstr;
	else
		$this->dbpath = $configstr;
		
	if (version_compare(PHP_VERSION,"5.0.0") == -1) {
		$this->hack = true;
	}
}

// will create database if it doesn't exist
// return true if successful.
function init() {
	$err = '';
	if (!function_exists('sqlite_open'))
		die('SQLite extension is not available. Choose another index backend');
		
	// temporary hack while we still need sqlite command line tool:
	if ($this->hack && strlen(trim(`echo .show | sqlite | grep separator`)) == 0) {
		die("sqlite not found:<p>You are running a buggy version of php-sqlite. Because of this, we also need the sqlite command line tool installed (or choose another index backend).<p>for debian:<br>&nbsp;&nbsp;# apt-get install sqlite");
	}
	
	if (!is_file($this->dbpath)) {
		if (!is_dir(dirname($this->dbpath)))
			mkdir(dirname($this->dbpath));
		if($db = sqlite_open($this->dbpath,0666,$err)) {
			// multiple queries per call don't seem to work in the version i have. grr. we split instead.
			$sql = split('<ret>',$this->sql_create);
			foreach($sql as $line) {
				$r = sqlite_query($db,$line);
			}
			sqlite_close($db);
		}
	}	
	return true;
}

function open($mode='r') {
	if ($this->db == null) {
		$this->db = sqlite_open($this->dbpath,0666,$err);
		if ($err) {
			d::log($err);
		}
	}
}

function close() {
	// closing the index is not really needed for sqlite.
	#if ($this->db) {
	#	sqlite_close($this->db);
	#	$this->db = null;
	#}
}

// deletes all data
function clear() {
	$this->open();
	sqlite_query($this->db, "DELETE FROM keywords");
	sqlite_query($this->db, "DELETE FROM content");
	sqlite_query($this->db, "DELETE FROM pages");
}

function getByKeyword($keywords) {
	if (!is_array($keywords)) $keywords = array($keywords);
	
	foreach($keywords as $word)
		$in_clause = "'" . sqlite_escape_string($word) . "', ";
	$in_clause .= "''";
	$sql = "SELECT path FROM pages, keywords WHERE id=pageid AND word IN ($in_clause)";
	$result = sqlite_single_query($this->db, $sql);
	if (!is_array($result)) $result = array($result);
	return $result;
}

function getByContent($words) {
	if (!is_array($words)) $words = array($words);

	foreach($words as $word)
		$in_clause = "'" . sqlite_escape_string($word) . "', ";
	$in_clause .= "''";
	$sql = "SELECT path FROM pages, content WHERE id=pageid AND word IN ($in_clause)";
	$result = sqlite_single_query($this->db, $sql);
	if (!is_array($result)) $result = array($result);
	return $result;
}

function getByModTime($timestamp, $offset=-1, $limit=-1, $path='') {
	assert(is_integer($offset));
	assert(is_integer($limit));
	assert(is_integer($timestamp));
	if ($path) {
		$path = sqlite_escape_string($path);
		$sql = "SELECT path FROM pages WHERE mtime >= '$timestamp' AND path LIKE '$path%' ORDER BY mtime DESC LIMIT $limit OFFSET $offset";
	}
	else
		$sql = "SELECT path FROM pages WHERE mtime >= '$timestamp' ORDER BY mtime DESC LIMIT $limit OFFSET $offset";
	$result = sqlite_single_query($this->db, $sql);
	if (!is_array($result)) $result = array($result);
	return $result;
}

function setContent($path, &$newwords, $database='content') {
	if ($newwords == '') return;
	if (!is_array($newwords)) $newwords = array($newwords);
	
	$sql = "BEGIN;\n";	
	$path = sqlite_escape_string($path);
	$id = sqlite_single_query($this->db, "SELECT id FROM pages WHERE path = '$path'");
	if ($id == '') {
		sqlite_query($this->db,"INSERT INTO pages (path) VALUES ('$path');");
		$id = sqlite_last_insert_rowid($this->db);
		$insertwords = &$newwords;
	}
	else {
		$sql .= "DELETE FROM $database WHERE pageid = '$id';\n";
		$insertwords = &$newwords;
	}
/*
	else {
		$oldwords = sqlite_single_query($this->db, "SELECT word FROM $database WHERE pageid = '$id'");
		if ($oldwords=='') $oldwords = array();
		elseif (!is_array($oldwords)) $oldwords = array($oldwords);
		$insertwords = array_diff($newwords,$oldwords);
		$deletewords = array_diff($oldwords,$newwords);
		foreach($deletewords as $word) {
			$word = sqlite_escape_string($word);
			$sql .= "DELETE FROM $database WHERE pageid = '$id' AND word = '$word';\n";
		}
	}
*/
	foreach($insertwords as $word) {
		$word = sqlite_escape_string($word);
		$sql .= "INSERT INTO $database VALUES('$id','$word');\n";
	}
	$sql .= "COMMIT;\n";
	if ($this->hack)
		$this->exec($sql);
	else {
		$ok = sqlite_query($this->db,$sql);
		if ($ok == false) {
			trigger_error(sqlite_error_string(sqlite_last_error($this->db)));
		}
	}
}

function setKeywords($path,$newwords) {
	$this->setContent($path,$newwords,'keywords');
}

function setTime($path,$timestamp,$field) {
	$path = sqlite_escape_string($path);
	$timestamp = intval($timestamp);
	$id = sqlite_single_query($this->db, "SELECT id FROM pages WHERE path = '$path'");
	if ($id == '') {
		sqlite_query($this->db,"INSERT INTO pages (path,$field) VALUES ('$path','$timestamp');");
	}
	else {
		$sql = "UPDATE pages SET $field = '$timestamp' WHERE id = '$id';";
		$ok = sqlite_query($this->db, $sql);
		if ($ok == false) {
			trigger_error(sqlite_error_string(sqlite_last_error($this->db)));
		}
	}
}

function setIndexedTime($path,$timestamp) {
	$this->setTime($path, $timestamp, 'itime');
}

function setModTime($path,$timestamp) {
	$this->setTime($path, $timestamp, 'mtime');
}

function getIndexedTime($path) {
	$path = sqlite_escape_string($path);
	return sqlite_single_query($this->db, "SELECT itime FROM pages WHERE path = '$path'");
}

function remove($path) {
	$path = sqlite_escape_string($path);
	
	$id = sqlite_single_query($this->db, "SELECT id FROM pages WHERE path = '$path'");
	$sql = "DELETE FROM pages WHERE path = '$path';";
	sqlite_query($this->db, $sql);
	$sql = "DELETE FROM content WHERE pageid = '$id';";
	sqlite_query($this->db, $sql);
	$sql = "DELETE FROM keywords WHERE pageid = '$id';";
	sqlite_query($this->db, $sql);
}

function rename($pathold, $pathnew) {
	$pathold = sqlite_escape_string($pathold);
	$pathnew = sqlite_escape_string($pathnew);
	$oldlength = strlen($pathold);
	$sql = "UPDATE pages SET path = '$pathnew' || substr(path,$oldlength+1,length(path)-$oldlength) WHERE path == '$pathold' OR path LIKE '$pathold/%'";
	$ok = sqlite_query($this->db, $sql);
	if ($ok == false) {
		trigger_error(sqlite_error_string(sqlite_last_error($this->db)));
	}
}

function exec($sql) {
	#$this->close();
	$rc = popen("sqlite $this->dbpath",'w');
	fwrite($rc,$sql);
	pclose($rc);
}

// debug function
function dump() {
}

} // end class

return;
?>

