<?php

/****
 *
 * Renderer Class
 * Controls rendering of a page, static or dynamic.
 * 
 ****/	

require_once('Properties.php');
require_once('Page.php');

class Renderer {

var $prop; # the default decorator for the site.

# predefined types and filters: the order matters.
var $filters = array(
	'txt' => array('text2html','symbols'),
	'raw' => array('pre'),
	'html' => array('symbols'),
	'mod' => '',
);

function Renderer(&$prop) {
	$this->prop = &$prop;
}

function displayError($title, $contents) {
	$content = "<font color=red>Error:</font><br>$contents";
	$this->display($title, $content);
}

function display($title, &$content) {
	global $root, $decoratorurl, $nav, $ps, $robot, $static, $page;
	
	require_once(dirname(__FILE__) . '/decorators/common.php');
	$title = $this->prop->getGlobal('title-prefix') . $title;
	
	$decor = $this->getDecorator();
	$decoratorurl = $decor->url;
	if (is_file($decor->template)) {
		$nav_hide = true;
		include($decor->template);
	}
	else {
		echo $content;
	}
}

function renderPage(&$page,$printable=false,$content='',$skipfilters=false) {
	global $root, $decoratorurl, $nav, $ps, $robot, $static;
	
	require_once(dirname(__FILE__) . '/decorators/common.php');

	$decor = $this->getDecorator($page->get('decorator'));
	if ($content == '') {
		$content = & $this->getRenderedContent($page);
		if ($page->type == 'php') {
			$content = & $this->exec_php_file($page->phpfile);
		}
		
		# if content empty, return default index.
		if ($content == '') {
			if (is_file($decor->index))
				$content = $this->exec_php_file($decor->index);
			else
				$content = $this->indexinfo($page);
		}
	}

	$title   = $page->get('title');
	$title   = $this->prop->getGlobal('title-prefix') . $title;

	if ($page->fnf) {
		$this->displayError("File not found", "That file does not exist.");
		return;	
	}

	$allowed = explode(' ',$this->prop->getGlobal('allowed-types'));
	if (!in_array($page->type,$allowed)) {
		$this->displayError(_("Not allowed"), _("Cannot display page. The following type is not allowed: ") . $page->type);
		return;	
	}
	
	$decoratorurl = $decor->url;
			
	if (!$printable && is_file($decor->template)) {
		# standard template
		header("Last-Modified: " . gmdate("D, d M Y H:i:s", $page->get('mtime')) . " GMT");
		include($decor->template);
	}
	else {
		# page without any template
		echo "<html>\n<head>\n<title>$title</title>\n</head>\n<body>\n";
		echo $content;
		echo "\n</body>\n</html>";
	}
}

function &exec_php_file($phpfile) {
	if ($phpfile == '') return;

	ob_start();
	include($phpfile);
  	$data = &ob_get_contents();
	ob_end_clean();
	return $data;
}

function &getRenderedContent(&$page) {
	$content = $page->get('content');
	$type = $page->get('type');
	ob_start();
	if (isset($this->filters[$type])) {
		foreach($this->filters[$type] as $f) {
			$this->applyFilter($f, $content, $page);
		}	
	}
	echo $content;
	$data = &ob_get_contents();
	ob_end_clean();
	return $data;
}

/**
 style handler
 This function is called on ?action=style requests.
 it dumps the correct css file, setting the headers correctly
 for content type and caching. with d=<decoratorname> in the url,
 you can override the decorator property of the given page.
 **/
function style(&$page) {
	global $root, $decoratorurl, $nav, $ps, $robot, $static;

	// send mime type, this is a css file.
	header('Content-type: text/css');
	
	// send cache headers. we want the style page cached.
	$offset = 60*60*3; // 3 hours
	$expires = "Expires: " . gmdate("D, d M Y H:i:s", time() + $offset) . " GMT";
	header("Cache-Control: public");
	header($expires);
	
	// load the decorator
	require_once(dirname(__FILE__) . '/decorators/common.php');
	$decorator_name = get('d',$page->get('decorator'));
	$decor = $this->getDecorator($decorator_name);
	$decoratorurl = $decor->url;

	// set last modified
	$lastmod = "Last-Modified: " . gmdate("D, d M Y H:i:s", filemtime($decor->style)) . " GMT";
	header($lastmod);

	// run style.php
	include($decor->style);
}

function applyFilter($filter, &$content, &$page) {
	require_once("filters/$filter.php");
	$filter_object = new $filter();
	$filter_object->apply($content,$page);
}

function getDecorator($name = '') {
	$d = new Decorator();
	if ($name == '')
		$d->name = $this->prop->getGlobal('decorator');
	else
		$d->name = $name;
		
	// try possible dirs, until we find a decorator
	// this is kinda silly, we should just decide
	// where it must go.
	
	// map url => directory
	$docroot = $this->prop->getGlobal('sitedocroot');
	$urlroot = $this->prop->getGlobal('siteroot');
	$libfile = dirname(__FILE__);
	$liburl  = $this->prop->getGlobal('liburl');
	$candidates = array(
		"$urlroot/.decorators/$d->name"  => "$docroot/.decorators/$d->name",
		"$urlroot/$d->name"  => "$docroot/$d->name",
		"$liburl/decorators/$d->name"  => "$libfile/decorators/$d->name",
	);
	foreach($candidates as $url => $dir) {
		if (is_dir($dir)) break;
	}
		 
	$d->url = $url;
	$d->template = "$dir/template.php";
	$d->style = "$dir/style.php";
	if (file_exists("$dir/index.php"))
		$d->index = "$dir/index.php";
	$d->error = "$dir/error.php";
	
	return $d;
}

function displayFnf(&$page) {
	$d = $this->getDecorator();
	
	$fnfpath = $page->path;

	while($page->fnf) {
		$page = $page->parent();
	}
	$path = $page->path ? $page->path : '/';
	$newpagelink = alink($path . "?a=edit&ea=newedit&path=" . urlencode($fnfpath), _("Create this page"));
	
	if (is_file($d->error)) {
		ob_start();
		include($d->error);
		$content = &ob_get_contents();
		ob_end_clean();
	}
	else {
		$content = "<p>404 Page not found</p><p>The web page you seek<br />Cannot be located, but<br />Countless more exist.</p>";
		$content .= $newpagelink;
	}
	$this->display("File not found", $content);
}

function indexinfo(&$page) {
	$children = $page->children();
	foreach($children as $child) {
		$ret .= "<dl class=index>\n";
		$ret .= "<dt>" . alink($child->path .'/',$child->get('title')) . "</dt>\n";
		$ret .= "<dd>" . $child->get('description') . "</dd>\n";
		$ret .= "</dl>\n";
	}
	return $ret;
}


} // end class

class Decorator {
	var $index;
	var $style;
	var $template;
	var $name;
	var $url;	
}

return;
?>
