<? 

/****
 * 
 * Page.php
 *
 * An abstract web page, either dynamic or static.
 * Page knows nothing about how it is stored. It might be a file
 * or it might be in a database. 
 *
 ****/

class Page {
	
var $path;          # always absolute, in relation to siteroot.
var $absolutepath;  # real absolute path, including siteroot.
var $dirpath;       # path to the nearest directory, may be self or our parent.
var $ps;            # the page store
var $type;          # the page type. ie: raw, txt, html, mod. 
var $static;        # true or false
var $dir;           # true or false, does this page contain other pages.
var $prop;          # pointer to global Properties object. used to resolved properties.
var $dirty=array(); # array of flags of dirty properties (changed this request)
var $messages=array(); # array of strings for error messages.
var $ok=true;       # true or false, is this file ok? (ie no errors occured).
var $fnf=false;     # file not found: true if we determine this page does not refer to real content

## basic properties ##

var $name;          # page name 
var $title;         # page title
var $content;       # the content of the page
var $mtime;         # modification time of this data
var $locked;        # false if unlocked. 

function Page(&$pagestore, $path=' none ') {
	$this->init($pagestore, $path);
}

function init(&$pagestore, $path) {
	$this->ps   = &$pagestore;
	$this->prop = &$pagestore->prop;

	if ($path == ' none ') {
		$path = $_SERVER['REQUEST_URI'];
	}

	$path = urldecode($path);
	$path = stripslashes($path);
		
	# start with /
	if (!preg_match("|^/|", $path))
		$path = "/$path";

	# remove:
	#  1. query string
	#  2. site root from url
	#  3. multiple '/'
	#  4. index.php 
	#  5. trailing /
	$root = $this->ps->urlRoot;
	$path = preg_replace(
		array("'(\?.*)'", "'^$root'", "'/{2,}'", "'index.php'", "'/$'"),
		array('', '', '/', '', ''),
		$path
	);
	
	$this->path = $path;
	$this->absolutepath = "$root$path";
	$this->ps->init($this); // required
	if ($this->fnf) return;
	
	// get some basic props as references to the
	// real storage for convenience (ie laziness)
	
	$this->name     = &$this->get('name');
	$this->title    = &$this->get('title');
	$this->navtitle = &$this->get('nav-title');
	$this->static   = &$this->get('static');
	$this->dir      = &$this->get('dir');
	$this->mtime    = &$this->get('mtime');
	$this->locked   = &$this->get('locked');
	$this->type     = &$this->get('type');

	# set dirpath to be the closest directory
	if($this->dir)
		$this->dirpath = $this->path;
	else
		$this->dirpath = dirname($this->path);
}

function &get($property, $default=null) {
	if ($property == 'order') {
		$ret = $this->ps->getOrder($this);
		return $ret; 
	}
	elseif ($property=='content') {
		if (!isset($this->content))
			$this->ps->fetch($this);
		return $this->content;
	}
	elseif ($property=='size') {
		return $this->ps->getContentSize($this);
	}
	else {
		$value = &$this->prop->get($property,$this);
		if ($value == null)
			return $default;
		else
			return $value;
	}
}

function set($property,$data) {
	if ($property == 'order') {
		$this->ps->setOrder($this,$data); 
	}
	else {
		$this->dirty[$property] = true;
		if ($property=='name') {
			$data = urlize($data);
			$this->name = $data;
		}
		$this->prop->set($property,$data,$this);
	}
}

function setContent(&$data) {
	$this->dirty['content'] = true;
	$this->content = &$data;
}

/**
 *
 * pagestore is in charge of writing changes to name and content
 * properties is in charge of writing changes to all other properties
 *
 **/
function commit() {
	global $search; //hackish
	
	$pathold = $this->path;
	
	if (!$this->dirty())
		return; // no props changed.
	
	// we must save the properties first, because a name change
	// will force a reloading of the properties.
	
	// if there are other properties besides name and content
	// which are dirty, then commit the changes.
	$tmparray = $this->dirty;
	unset($tmparray['name']); unset($tmparray['content']);
	if (count($tmparray)) {
		$this->set('mtime',time());
	    $err = $this->prop->commit($this);
	}
		
	if ($this->isdirty('name') || $this->isdirty('content')) {
		$ok = $this->ps->commit($this); 
		if ($ok) {
			$this->set('mtime',time());
			$this->prop->commit($this); // update mtime
		}
	}
	
	// update the index
	if ($search != null) {
		$search->indexPage($this);
		if ($pathold != $this->path)
			$search->replacePath($pathold,$this->path);
	}
}

/////////////////////
// dirty functions

function isdirty($prop) {
	return isset($this->dirty[$prop]);
}

function undirty($prop) {
	unset($this->dirty[$prop]);
}

function dirty() {
	return count($this->dirty);
}

function getDirty() {
	return array_keys($this->dirty);
}

//
// gets data from page storage
// our strategy for fetching data is this:
// - on a fetch(), we grab the body and as much data
//   as comes free with this request.
// - later, when resolving properties, we might grab
//   data again if we did not get enough the in the fetch
//   
function fetch() {
	if (!isset($this->content))
		$this->ps->fetch($this);
}

// returns array of languages which have content.
function availableContent() {
	return $this->ps->availableContent($this);
}

function lock() {

}


function unlock() {

}


function &children() {
	return $this->ps->getChildren($this);
}

function &child($name) {
	return $this->ps->getPage($this->path . '/' . $name);
}

// make this more efficient
function childCount() {
	return count($this->ps->getChildren($this));
}

function &parent() {
	return $this->ps->getPage(dirname($this->path));
}

// return the next peer page, if it exists. null otherwise.
function &next() {
	return $this->ps->getNext($this);
}

// return the next peer page, if it exists. null otherwise.
function &prev() {
	return $this->ps->getPrev($this);
}

/*
 * returns an array of attachment info:
 */
 
function attachments() {
	$ps = &$this->ps;
	return $ps->getAttachments($this);
}

function attach($filedata) {
	$ps = &$this->ps;
	$ps->addAttachment($this,$filedata);
}

function removeAttachment($name) {
	$ps = &$this->ps;
	$ps->removeAttachment($this,$name);
}

/*
 * returns true if the user is allowed to preform the
 * action on this page.
 */	
function may($username, $action) {
	if ($action == 'edit')
		$users = $this->get("access-edit");
	else
		$users = $this->get("access-view");

	## CHANGE ME CHANGE ME -- we need some groups

	$users = split(' ', $users);
	foreach($users as $user) {	
		if ($user == $username)
			return true;
		elseif ($user == 'anonymous' || $user == '')
			return true;
		elseif ($user == 'authenticated' && $username != 'anonymous' && $username != '')
			return true;
	} 
	return false;
}


function destroy() {
	global $search; //hackish
	if ($this->path == '/')
		$this->error('You cannot delete the root page');
	elseif ($this->fnf)
		$this->error('That file does not exist');
	else {
		if ($search != null) $search->deindexPage($this);
		$this->ps->destroyPage($this);
	}
}

/*
 * copies this page to the path specified
 */
function duplicate($copypath) {
	$this->ps->duplicatePage($this,$copypath);
}

/*
 * moves this page to the path specified
 */
function move($newpath) {
	global $search;
	
	while($this->ps->exists($newpath)) {
		$newpath .= '-copy';
	}
	if ($search) {
		$search->replacePath($this->path,$newpath);
	}
	$this->ps->movePage($this,$newpath);	
}

/*
 * moves this page to be under the page
 * specified by $parentpath
 */
function setParent($parentpath) {
	global $search;
	$oldpath = $this->path;
	$newpath = "$parentpath/".basename($this->path);
	$ok = $this->ps->movePage($this,$newpath);
	if ($ok && $search!=null)
		$search->replacePath($oldpath,$newpath);
	if (!$ok) $this->ok = false;
}

// error and message handling

function error($str = '') {
	if ($str) {
		$this->messages[] = "<font color=red>$str</font>";
		$this->ok = false;
	}
	return join('<br>',$this->messages) . '<br>';
}

function msg($str = '') {
	if ($str)
		$this->messages[] = "<font color=green>$str</font>";
	return join('<br>',$this->messages) . '<br>';
}

// search

function search($tokens) {
	$content = $this->get('content');
	$ret = array();
	for($i=0;$i<count($tokens);$i++) {
		$token = "/^.*$tokens[$i].*$/im";
		preg_match_all($token,$content,$matches);
		$ret = array_merge($ret, $matches[0]);
	}
	$ret = array_slice($ret,0,5); // limit to 5 lines;
	$ret = array_unique($ret);
	return $ret;
}


}

return;
?>
