#!/usr/bin/perl
#
#   Add navigation buttons to a list of files.
#      By Kern Sibbald
#
#   This is a very simplistic program. You call it
#      ./add-nav.pl 
#   It assumes:
#      - perl is in /usr/bin/perl (if not, set a link)
#      - there is a file named add-nav.list in the current directory
#      - This list supplies the names of all the html files to which
#        you wish to add buttons.  
#      - The buttons are named back.gif, next.gif and home.gif
#        or <page_next ... or <page_prev
#      - The new navigation buttons are added to the end of
#        the file as <page_next ... and <page_prev.  The titles
#        are found in the previous and next page and stuffed into
#        the page_next and page_prev calls.
#      - The first file is ASSUMED to be index.html and is not included
#        in the add-nav.list file
#
#   Whew!  There are a lot of assumptions.  In addition, the output
#          when running ./add-nav.pl is not very pretty, but so what,
#          it gets the job done.
#
#   This program needs to be run only once. There after, you run it 
#     only if you add a new file (be sure to add it to add-nav.list),
#     or if you want to re-order the files.
#

#
# check that the file exists and is a normal file
sub chkfile {
   if ( ! -e @_[0] ) {
      die ("File ".@_[0]." does not exist.\n");
   }
   if ( ! -f @_[0] ) {
      die ( "File ".@_[0]." must be a normal file.\n");
   }
}


#
# get rid of any line containing <img src="back.gif"
#                                <img src="next.gif"
#                                <img src="home.gif"
sub clean_file {
   @outf = ();
   chkfile(@_[0]);
   open(HTML, @_[0]);
   while (<HTML>) {
      # strip any old navigation buttons.
      if (! /\<page_prev/ &&
          ! /\<page_next/) {
         push @outf, $_;
      }
   }
   close(HTML);
   printf("Cleaned @_[0]\n");
}

sub get_title {
   $title = "";
   chkfile(@_[0]);
   open(HTML, @_[0]);
   while (<HTML>) {
      # find title
      if (/\<title\>/) {
         $title = $_;
         chomp($title);
         $title =~ s/.*\<title\>(.*)\<\/title\>/$1/;
         break;
      }
      if (/#include \"bacula_template.* title\=/) {         
         $title = $_;
         chomp($title);
         $title =~ s/#include.* title\=\"(.*)\"/$1/;
         break;
      }
   }
   close(HTML);
}




# ======= begin main program ========

    @navfiles = ();
    open(NAV, "add-nav.list") or die("add-nav.list could not be opened");
    @navfiles = <NAV>;
    close(NAV);

    $n = $#navfiles;
    printf("Number of files is $n\n");
    for ($i=0; $i<=$n; $i++) {
       $f = @navfiles[$i];
       chomp($f);
       printf("\nProcessing $f\n");
       clean_file($f);
       $l = $#outf;
       if ($i == 0) {
          $next = @navfiles[$i+1];
          chomp($next);
          get_title($next);
          printf("Title of $next is $title\n"); 
          $next =~ s/(.*)\.wml/$1\.html/;
          push @outf, "<page_next name=\"$title\" url=\"$next\">\n"; 
          printf("i is zero\n");
       } else {
          if ($i == $n) {
             $prev = @navfiles[$i-1];
             chomp($prev);
             get_title($next);
             printf("Title of $prev is $title\n"); 
             push @outf, "<page_prev name=\"$title\" url=\"$prev\">\n"; 
             printf("i is last $n\n");
          } else {
             $next = @navfiles[$i+1];
             chomp($next);
             get_title($next);
             printf("Title of $next is $title\n"); 
             $ntitle = $title;
             $prev = @navfiles[$i-1];
             chomp($prev);
             get_title($prev);
             printf("Title of $prev is $title\n"); 
             $next =~ s/(.*)\.wml/$1\.html/;
             $prev =~ s/(.*)\.wml/$1\.html/;
             push @outf, 
"<page_prev name=\"$title\" url=\"$prev\">\n" .
"<page_next name=\"$ntitle\" url=\"$next\">\n"; 
          }
       }
#      $next = @navfiles[$i];
#      chomp($next);
#      get_title($next);
#      unshift @outf, "#include \"bacula_template.inc\" title=\"$title\"";
#      printf("$f\n");

       open OUTF, ">$f";
       foreach $f (@outf) {
           print OUTF $f;
       }
       close OUTF;

    }
exit 0;   
