/*
 * oh323.h
 *
 * Header file for OpenH323 Channel Driver for ASTERISK PBX.
 *  
 * Copyright (C) 2002-2005 Inaccess Networks.
 * Michael Manousos <manousos@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: oh323.h,v 1.39.2.3 2005/01/17 18:07:39 manousos Exp $
 *
 */

#ifndef _ASTERISK_OH323_H
#define _ASTERISK_OH323_H

#define AST_OH323_MAX_CALLS			100
#define	AST_OH323_FIFO_PREFIX		"audiosocket:"
#define	AST_OH323_MAX_CALLED_ADDR	256
#define	AST_OH323_MAX_CALL_TOK		128
#define	AST_OH323_MAX_CALL_ADDR		128

#define	MAX_FIFO_NAME		30
#define	MAX_EXCEPTION_DATA	256
#define	OH323_CAPABILITY_FULLBANDWIDTH	0x7fffffff
#define	RTPSTATS_MAX_NUM	5
#define	OH323_MAX_BUF		2048
#define	OH323_MAX_QBUF		2048
#define	OH323_MAX_EXTNAME	64

/* OpenH323 channel clearing conditions (internal) */
#define	OH323_CLEAR_NULL	0
#define	OH323_CLEAR_LOC		1
#define	OH323_CLEAR_REM		2

/* OpenH323 channel events (internal usage) */
#define	OH323_EVENT_NULL		0
#define	OH323_EVENT_TERM		1
#define	OH323_EVENT_EXCE		2	
#define	OH323_EVENT_NTFY		3
#define	OH323_EVENT_FDUPDATE	4

/* Version stuff */
#define	OH323_VERSION_MAJOR		0
#define	OH323_VERSION_MINOR		6
#define	OH323_VERSION_BUILD		6

/* OpenH323 channel signaling states (internal usage) */
#define	OH323_STATE_NULL		1
#define	OH323_STATE_INIT		2
#define	OH323_STATE_RING		3
#define	OH323_STATE_RINGING		4	
#define	OH323_STATE_ESTABLISHED	5
#define	OH323_STATE_CLEARED		6

/* Debug stuff */
#define	MARK_IN()		if (option_debug) \
							ast_log(LOG_DEBUG, "ENTER %s.\n", __FUNCTION__)
#define	MARK_OUT()		if (option_debug) \
							ast_log(LOG_DEBUG, "LEAVE %s.\n", __FUNCTION__)
#define	MARK_BODY()		if (option_debug) \
							ast_log(LOG_DEBUG, "  INSIDE %s.\n", __FUNCTION__)
#define	ISTATE_LOG(olds, news)	if (option_debug) \
									ast_log(LOG_DEBUG, "NEW STATE: %s --> %s\n",\
											oh323_state2str(olds), \
											oh323_state2str(news))

#endif
